/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.freetier.endpoints.internal;

import java.net.URI;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.endpoints.AwsEndpointAttribute;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4AuthScheme;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.freetier.endpoints.FreeTierEndpointParams;
import software.amazon.awssdk.services.freetier.endpoints.FreeTierEndpointProvider;
import software.amazon.awssdk.services.freetier.endpoints.internal.RulePartition;
import software.amazon.awssdk.services.freetier.endpoints.internal.RuleResult;
import software.amazon.awssdk.services.freetier.endpoints.internal.RulesFunctions;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultFreeTierEndpointProvider
implements FreeTierEndpointProvider {
    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(FreeTierEndpointParams params) {
        Validate.notNull((Object)params.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        try {
            RuleResult result = DefaultFreeTierEndpointProvider.endpointRule0(params, new LocalState(params.region()));
            if (result.canContinue()) {
                throw SdkClientException.create((String)"Rule engine did not reach an error or endpoint result");
            }
            if (result.isError()) {
                String errorMsg = result.error();
                if (errorMsg.contains("Invalid ARN") && errorMsg.contains(":s3:::")) {
                    errorMsg = errorMsg + ". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest.";
                }
                throw SdkClientException.create((String)errorMsg);
            }
            return CompletableFuture.completedFuture(result.endpoint());
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static RuleResult endpointRule0(FreeTierEndpointParams params, LocalState locals) {
        RuleResult result = DefaultFreeTierEndpointProvider.endpointRule1(params, locals);
        if (result.isResolved()) {
            return result;
        }
        result = DefaultFreeTierEndpointProvider.endpointRule4(params, locals);
        if (result.isResolved()) {
            return result;
        }
        return DefaultFreeTierEndpointProvider.endpointRule25(params, locals);
    }

    private static RuleResult endpointRule1(FreeTierEndpointParams params, LocalState locals) {
        if (params.endpoint() != null) {
            RuleResult result = DefaultFreeTierEndpointProvider.endpointRule2(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultFreeTierEndpointProvider.endpointRule3(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule2(FreeTierEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue()) {
            return RuleResult.error("Invalid Configuration: FIPS and custom endpoint are not supported");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule3(FreeTierEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create(params.endpoint())).build());
    }

    private static RuleResult endpointRule4(FreeTierEndpointParams params, LocalState locals) {
        if (locals.region() != null) {
            return DefaultFreeTierEndpointProvider.endpointRule5(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule5(FreeTierEndpointParams params, LocalState locals) {
        RulePartition partitionResult = null;
        partitionResult = RulesFunctions.awsPartition(locals.region());
        if (partitionResult != null) {
            RuleResult result = DefaultFreeTierEndpointProvider.endpointRule6(params, locals = locals.toBuilder().partitionResult(partitionResult).build());
            if (result.isResolved()) {
                return result;
            }
            result = DefaultFreeTierEndpointProvider.endpointRule12(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultFreeTierEndpointProvider.endpointRule19(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultFreeTierEndpointProvider.endpointRule23(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultFreeTierEndpointProvider.endpointRule24(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule6(FreeTierEndpointParams params, LocalState locals) {
        if ("aws".equals(locals.partitionResult().name())) {
            RuleResult result = DefaultFreeTierEndpointProvider.endpointRule7(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultFreeTierEndpointProvider.endpointRule11(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule7(FreeTierEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue()) {
            RuleResult result = DefaultFreeTierEndpointProvider.endpointRule8(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultFreeTierEndpointProvider.endpointRule10(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule8(FreeTierEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsFIPS()) {
            return DefaultFreeTierEndpointProvider.endpointRule9(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule9(FreeTierEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://freetier-fips." + locals.region() + ".api.aws")).build());
    }

    private static RuleResult endpointRule10(FreeTierEndpointParams params, LocalState locals) {
        return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
    }

    private static RuleResult endpointRule11(FreeTierEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://freetier.us-east-1.api.aws")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("freetier").signingRegion("us-east-1").build())).build());
    }

    private static RuleResult endpointRule12(FreeTierEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsDualStack()) {
            RuleResult result = DefaultFreeTierEndpointProvider.endpointRule13(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultFreeTierEndpointProvider.endpointRule17(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultFreeTierEndpointProvider.endpointRule18(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule13(FreeTierEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue()) {
            RuleResult result = DefaultFreeTierEndpointProvider.endpointRule14(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultFreeTierEndpointProvider.endpointRule16(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule14(FreeTierEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsFIPS()) {
            return DefaultFreeTierEndpointProvider.endpointRule15(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule15(FreeTierEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://freetier-fips." + locals.region() + "." + locals.partitionResult().dualStackDnsSuffix())).build());
    }

    private static RuleResult endpointRule16(FreeTierEndpointParams params, LocalState locals) {
        return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
    }

    private static RuleResult endpointRule17(FreeTierEndpointParams params, LocalState locals) {
        if ("aws-cn-global".equals(locals.region())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://freetier.cn-northwest-1.api.amazonwebservices.com.cn")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("freetier").signingRegion("cn-northwest-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule18(FreeTierEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://freetier." + locals.region() + "." + locals.partitionResult().dualStackDnsSuffix())).build());
    }

    private static RuleResult endpointRule19(FreeTierEndpointParams params, LocalState locals) {
        if (params.useFips().booleanValue()) {
            RuleResult result = DefaultFreeTierEndpointProvider.endpointRule20(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultFreeTierEndpointProvider.endpointRule22(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule20(FreeTierEndpointParams params, LocalState locals) {
        if (locals.partitionResult().supportsFIPS()) {
            return DefaultFreeTierEndpointProvider.endpointRule21(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule21(FreeTierEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://freetier-fips." + locals.region() + "." + locals.partitionResult().dnsSuffix())).build());
    }

    private static RuleResult endpointRule22(FreeTierEndpointParams params, LocalState locals) {
        return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
    }

    private static RuleResult endpointRule23(FreeTierEndpointParams params, LocalState locals) {
        if ("aws-cn-global".equals(locals.region())) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://freetier.cn-northwest-1.api.amazonwebservices.com.cn")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("freetier").signingRegion("cn-northwest-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule24(FreeTierEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://freetier." + locals.region() + "." + locals.partitionResult().dnsSuffix())).build());
    }

    private static RuleResult endpointRule25(FreeTierEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid Configuration: Missing Region");
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    private static final class LocalStateBuilder {
        private String region;
        private RulePartition partitionResult;

        LocalStateBuilder() {
            this.region = null;
            this.partitionResult = null;
        }

        LocalStateBuilder(LocalState locals) {
            this.region = locals.region;
            this.partitionResult = locals.partitionResult;
        }

        public LocalStateBuilder region(String value) {
            this.region = value;
            return this;
        }

        public LocalStateBuilder partitionResult(RulePartition value) {
            this.partitionResult = value;
            return this;
        }

        LocalState build() {
            return new LocalState(this);
        }
    }

    private static final class LocalState {
        private final String region;
        private final RulePartition partitionResult;

        LocalState() {
            this.region = null;
            this.partitionResult = null;
        }

        LocalState(Region region) {
            this.region = region != null ? region.id() : null;
            this.partitionResult = null;
        }

        LocalState(LocalStateBuilder builder) {
            this.region = builder.region;
            this.partitionResult = builder.partitionResult;
        }

        public String region() {
            return this.region;
        }

        public RulePartition partitionResult() {
            return this.partitionResult;
        }

        public LocalStateBuilder toBuilder() {
            return new LocalStateBuilder(this);
        }
    }
}

