/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.frauddetector.FraudDetectorAsyncClient;
import software.amazon.awssdk.services.frauddetector.internal.UserAgentUtils;
import software.amazon.awssdk.services.frauddetector.model.DescribeModelVersionsRequest;
import software.amazon.awssdk.services.frauddetector.model.DescribeModelVersionsResponse;

public class DescribeModelVersionsPublisher
implements SdkPublisher<DescribeModelVersionsResponse> {
    private final FraudDetectorAsyncClient client;
    private final DescribeModelVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeModelVersionsPublisher(FraudDetectorAsyncClient client, DescribeModelVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeModelVersionsPublisher(FraudDetectorAsyncClient client, DescribeModelVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeModelVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeModelVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeModelVersionsResponseFetcher
    implements AsyncPageFetcher<DescribeModelVersionsResponse> {
        private DescribeModelVersionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeModelVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeModelVersionsResponse> nextPage(DescribeModelVersionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeModelVersionsPublisher.this.client.describeModelVersions(DescribeModelVersionsPublisher.this.firstRequest);
            }
            return DescribeModelVersionsPublisher.this.client.describeModelVersions((DescribeModelVersionsRequest)((Object)DescribeModelVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

