/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDeleteEventsByEventTypeStatusResponse extends FraudDetectorResponse implements
        ToCopyableBuilder<GetDeleteEventsByEventTypeStatusResponse.Builder, GetDeleteEventsByEventTypeStatusResponse> {
    private static final SdkField<String> EVENT_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventTypeName").getter(getter(GetDeleteEventsByEventTypeStatusResponse::eventTypeName))
            .setter(setter(Builder::eventTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTypeName").build()).build();

    private static final SdkField<String> EVENTS_DELETION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventsDeletionStatus")
            .getter(getter(GetDeleteEventsByEventTypeStatusResponse::eventsDeletionStatusAsString))
            .setter(setter(Builder::eventsDeletionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventsDeletionStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_TYPE_NAME_FIELD,
            EVENTS_DELETION_STATUS_FIELD));

    private final String eventTypeName;

    private final String eventsDeletionStatus;

    private GetDeleteEventsByEventTypeStatusResponse(BuilderImpl builder) {
        super(builder);
        this.eventTypeName = builder.eventTypeName;
        this.eventsDeletionStatus = builder.eventsDeletionStatus;
    }

    /**
     * <p>
     * The event type name.
     * </p>
     * 
     * @return The event type name.
     */
    public final String eventTypeName() {
        return eventTypeName;
    }

    /**
     * <p>
     * The deletion status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #eventsDeletionStatus} will return {@link AsyncJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #eventsDeletionStatusAsString}.
     * </p>
     * 
     * @return The deletion status.
     * @see AsyncJobStatus
     */
    public final AsyncJobStatus eventsDeletionStatus() {
        return AsyncJobStatus.fromValue(eventsDeletionStatus);
    }

    /**
     * <p>
     * The deletion status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #eventsDeletionStatus} will return {@link AsyncJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #eventsDeletionStatusAsString}.
     * </p>
     * 
     * @return The deletion status.
     * @see AsyncJobStatus
     */
    public final String eventsDeletionStatusAsString() {
        return eventsDeletionStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(eventTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(eventsDeletionStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeleteEventsByEventTypeStatusResponse)) {
            return false;
        }
        GetDeleteEventsByEventTypeStatusResponse other = (GetDeleteEventsByEventTypeStatusResponse) obj;
        return Objects.equals(eventTypeName(), other.eventTypeName())
                && Objects.equals(eventsDeletionStatusAsString(), other.eventsDeletionStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDeleteEventsByEventTypeStatusResponse").add("EventTypeName", eventTypeName())
                .add("EventsDeletionStatus", eventsDeletionStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventTypeName":
            return Optional.ofNullable(clazz.cast(eventTypeName()));
        case "eventsDeletionStatus":
            return Optional.ofNullable(clazz.cast(eventsDeletionStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDeleteEventsByEventTypeStatusResponse, T> g) {
        return obj -> g.apply((GetDeleteEventsByEventTypeStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FraudDetectorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDeleteEventsByEventTypeStatusResponse> {
        /**
         * <p>
         * The event type name.
         * </p>
         * 
         * @param eventTypeName
         *        The event type name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypeName(String eventTypeName);

        /**
         * <p>
         * The deletion status.
         * </p>
         * 
         * @param eventsDeletionStatus
         *        The deletion status.
         * @see AsyncJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AsyncJobStatus
         */
        Builder eventsDeletionStatus(String eventsDeletionStatus);

        /**
         * <p>
         * The deletion status.
         * </p>
         * 
         * @param eventsDeletionStatus
         *        The deletion status.
         * @see AsyncJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AsyncJobStatus
         */
        Builder eventsDeletionStatus(AsyncJobStatus eventsDeletionStatus);
    }

    static final class BuilderImpl extends FraudDetectorResponse.BuilderImpl implements Builder {
        private String eventTypeName;

        private String eventsDeletionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeleteEventsByEventTypeStatusResponse model) {
            super(model);
            eventTypeName(model.eventTypeName);
            eventsDeletionStatus(model.eventsDeletionStatus);
        }

        public final String getEventTypeName() {
            return eventTypeName;
        }

        public final void setEventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
        }

        @Override
        public final Builder eventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
            return this;
        }

        public final String getEventsDeletionStatus() {
            return eventsDeletionStatus;
        }

        public final void setEventsDeletionStatus(String eventsDeletionStatus) {
            this.eventsDeletionStatus = eventsDeletionStatus;
        }

        @Override
        public final Builder eventsDeletionStatus(String eventsDeletionStatus) {
            this.eventsDeletionStatus = eventsDeletionStatus;
            return this;
        }

        @Override
        public final Builder eventsDeletionStatus(AsyncJobStatus eventsDeletionStatus) {
            this.eventsDeletionStatus(eventsDeletionStatus == null ? null : eventsDeletionStatus.toString());
            return this;
        }

        @Override
        public GetDeleteEventsByEventTypeStatusResponse build() {
            return new GetDeleteEventsByEventTypeStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
