/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.frauddetector.model.ExternalEventsDetail;
import software.amazon.awssdk.services.frauddetector.model.ModelTypeEnum;
import software.amazon.awssdk.services.frauddetector.model.TrainingDataSchema;
import software.amazon.awssdk.services.frauddetector.model.TrainingDataSourceEnum;
import software.amazon.awssdk.services.frauddetector.model.TrainingResult;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelVersionDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelVersionDetail> {
    private static final SdkField<String> MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelId").getter(ModelVersionDetail.getter(ModelVersionDetail::modelId)).setter(ModelVersionDetail.setter(Builder::modelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()}).build();
    private static final SdkField<String> MODEL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelType").getter(ModelVersionDetail.getter(ModelVersionDetail::modelTypeAsString)).setter(ModelVersionDetail.setter(Builder::modelType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelType").build()}).build();
    private static final SdkField<String> MODEL_VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelVersionNumber").getter(ModelVersionDetail.getter(ModelVersionDetail::modelVersionNumber)).setter(ModelVersionDetail.setter(Builder::modelVersionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelVersionNumber").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ModelVersionDetail.getter(ModelVersionDetail::status)).setter(ModelVersionDetail.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> TRAINING_DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trainingDataSource").getter(ModelVersionDetail.getter(ModelVersionDetail::trainingDataSourceAsString)).setter(ModelVersionDetail.setter(Builder::trainingDataSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingDataSource").build()}).build();
    private static final SdkField<TrainingDataSchema> TRAINING_DATA_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("trainingDataSchema").getter(ModelVersionDetail.getter(ModelVersionDetail::trainingDataSchema)).setter(ModelVersionDetail.setter(Builder::trainingDataSchema)).constructor(TrainingDataSchema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingDataSchema").build()}).build();
    private static final SdkField<ExternalEventsDetail> EXTERNAL_EVENTS_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("externalEventsDetail").getter(ModelVersionDetail.getter(ModelVersionDetail::externalEventsDetail)).setter(ModelVersionDetail.setter(Builder::externalEventsDetail)).constructor(ExternalEventsDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalEventsDetail").build()}).build();
    private static final SdkField<TrainingResult> TRAINING_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("trainingResult").getter(ModelVersionDetail.getter(ModelVersionDetail::trainingResult)).setter(ModelVersionDetail.setter(Builder::trainingResult)).constructor(TrainingResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingResult").build()}).build();
    private static final SdkField<String> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastUpdatedTime").getter(ModelVersionDetail.getter(ModelVersionDetail::lastUpdatedTime)).setter(ModelVersionDetail.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()}).build();
    private static final SdkField<String> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdTime").getter(ModelVersionDetail.getter(ModelVersionDetail::createdTime)).setter(ModelVersionDetail.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ModelVersionDetail.getter(ModelVersionDetail::arn)).setter(ModelVersionDetail.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ID_FIELD, MODEL_TYPE_FIELD, MODEL_VERSION_NUMBER_FIELD, STATUS_FIELD, TRAINING_DATA_SOURCE_FIELD, TRAINING_DATA_SCHEMA_FIELD, EXTERNAL_EVENTS_DETAIL_FIELD, TRAINING_RESULT_FIELD, LAST_UPDATED_TIME_FIELD, CREATED_TIME_FIELD, ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String modelId;
    private final String modelType;
    private final String modelVersionNumber;
    private final String status;
    private final String trainingDataSource;
    private final TrainingDataSchema trainingDataSchema;
    private final ExternalEventsDetail externalEventsDetail;
    private final TrainingResult trainingResult;
    private final String lastUpdatedTime;
    private final String createdTime;
    private final String arn;

    private ModelVersionDetail(BuilderImpl builder) {
        this.modelId = builder.modelId;
        this.modelType = builder.modelType;
        this.modelVersionNumber = builder.modelVersionNumber;
        this.status = builder.status;
        this.trainingDataSource = builder.trainingDataSource;
        this.trainingDataSchema = builder.trainingDataSchema;
        this.externalEventsDetail = builder.externalEventsDetail;
        this.trainingResult = builder.trainingResult;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.createdTime = builder.createdTime;
        this.arn = builder.arn;
    }

    public final String modelId() {
        return this.modelId;
    }

    public final ModelTypeEnum modelType() {
        return ModelTypeEnum.fromValue(this.modelType);
    }

    public final String modelTypeAsString() {
        return this.modelType;
    }

    public final String modelVersionNumber() {
        return this.modelVersionNumber;
    }

    public final String status() {
        return this.status;
    }

    public final TrainingDataSourceEnum trainingDataSource() {
        return TrainingDataSourceEnum.fromValue(this.trainingDataSource);
    }

    public final String trainingDataSourceAsString() {
        return this.trainingDataSource;
    }

    public final TrainingDataSchema trainingDataSchema() {
        return this.trainingDataSchema;
    }

    public final ExternalEventsDetail externalEventsDetail() {
        return this.externalEventsDetail;
    }

    public final TrainingResult trainingResult() {
        return this.trainingResult;
    }

    public final String lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final String createdTime() {
        return this.createdTime;
    }

    public final String arn() {
        return this.arn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelVersionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingDataSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingDataSchema());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalEventsDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingResult());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelVersionDetail)) {
            return false;
        }
        ModelVersionDetail other = (ModelVersionDetail)obj;
        return Objects.equals(this.modelId(), other.modelId()) && Objects.equals(this.modelTypeAsString(), other.modelTypeAsString()) && Objects.equals(this.modelVersionNumber(), other.modelVersionNumber()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.trainingDataSourceAsString(), other.trainingDataSourceAsString()) && Objects.equals(this.trainingDataSchema(), other.trainingDataSchema()) && Objects.equals(this.externalEventsDetail(), other.externalEventsDetail()) && Objects.equals(this.trainingResult(), other.trainingResult()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.arn(), other.arn());
    }

    public final String toString() {
        return ToString.builder((String)"ModelVersionDetail").add("ModelId", (Object)this.modelId()).add("ModelType", (Object)this.modelTypeAsString()).add("ModelVersionNumber", (Object)this.modelVersionNumber()).add("Status", (Object)this.status()).add("TrainingDataSource", (Object)this.trainingDataSourceAsString()).add("TrainingDataSchema", (Object)this.trainingDataSchema()).add("ExternalEventsDetail", (Object)this.externalEventsDetail()).add("TrainingResult", (Object)this.trainingResult()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("CreatedTime", (Object)this.createdTime()).add("Arn", (Object)this.arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "modelId": {
                return Optional.ofNullable(clazz.cast(this.modelId()));
            }
            case "modelType": {
                return Optional.ofNullable(clazz.cast(this.modelTypeAsString()));
            }
            case "modelVersionNumber": {
                return Optional.ofNullable(clazz.cast(this.modelVersionNumber()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "trainingDataSource": {
                return Optional.ofNullable(clazz.cast(this.trainingDataSourceAsString()));
            }
            case "trainingDataSchema": {
                return Optional.ofNullable(clazz.cast(this.trainingDataSchema()));
            }
            case "externalEventsDetail": {
                return Optional.ofNullable(clazz.cast(this.externalEventsDetail()));
            }
            case "trainingResult": {
                return Optional.ofNullable(clazz.cast(this.trainingResult()));
            }
            case "lastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "createdTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelVersionDetail, T> g) {
        return obj -> g.apply((ModelVersionDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String modelId;
        private String modelType;
        private String modelVersionNumber;
        private String status;
        private String trainingDataSource;
        private TrainingDataSchema trainingDataSchema;
        private ExternalEventsDetail externalEventsDetail;
        private TrainingResult trainingResult;
        private String lastUpdatedTime;
        private String createdTime;
        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelVersionDetail model) {
            this.modelId(model.modelId);
            this.modelType(model.modelType);
            this.modelVersionNumber(model.modelVersionNumber);
            this.status(model.status);
            this.trainingDataSource(model.trainingDataSource);
            this.trainingDataSchema(model.trainingDataSchema);
            this.externalEventsDetail(model.externalEventsDetail);
            this.trainingResult(model.trainingResult);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.createdTime(model.createdTime);
            this.arn(model.arn);
        }

        public final String getModelId() {
            return this.modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        @Transient
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final String getModelType() {
            return this.modelType;
        }

        public final void setModelType(String modelType) {
            this.modelType = modelType;
        }

        @Override
        @Transient
        public final Builder modelType(String modelType) {
            this.modelType = modelType;
            return this;
        }

        @Override
        @Transient
        public final Builder modelType(ModelTypeEnum modelType) {
            this.modelType(modelType == null ? null : modelType.toString());
            return this;
        }

        public final String getModelVersionNumber() {
            return this.modelVersionNumber;
        }

        public final void setModelVersionNumber(String modelVersionNumber) {
            this.modelVersionNumber = modelVersionNumber;
        }

        @Override
        @Transient
        public final Builder modelVersionNumber(String modelVersionNumber) {
            this.modelVersionNumber = modelVersionNumber;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getTrainingDataSource() {
            return this.trainingDataSource;
        }

        public final void setTrainingDataSource(String trainingDataSource) {
            this.trainingDataSource = trainingDataSource;
        }

        @Override
        @Transient
        public final Builder trainingDataSource(String trainingDataSource) {
            this.trainingDataSource = trainingDataSource;
            return this;
        }

        @Override
        @Transient
        public final Builder trainingDataSource(TrainingDataSourceEnum trainingDataSource) {
            this.trainingDataSource(trainingDataSource == null ? null : trainingDataSource.toString());
            return this;
        }

        public final TrainingDataSchema.Builder getTrainingDataSchema() {
            return this.trainingDataSchema != null ? this.trainingDataSchema.toBuilder() : null;
        }

        public final void setTrainingDataSchema(TrainingDataSchema.BuilderImpl trainingDataSchema) {
            this.trainingDataSchema = trainingDataSchema != null ? trainingDataSchema.build() : null;
        }

        @Override
        @Transient
        public final Builder trainingDataSchema(TrainingDataSchema trainingDataSchema) {
            this.trainingDataSchema = trainingDataSchema;
            return this;
        }

        public final ExternalEventsDetail.Builder getExternalEventsDetail() {
            return this.externalEventsDetail != null ? this.externalEventsDetail.toBuilder() : null;
        }

        public final void setExternalEventsDetail(ExternalEventsDetail.BuilderImpl externalEventsDetail) {
            this.externalEventsDetail = externalEventsDetail != null ? externalEventsDetail.build() : null;
        }

        @Override
        @Transient
        public final Builder externalEventsDetail(ExternalEventsDetail externalEventsDetail) {
            this.externalEventsDetail = externalEventsDetail;
            return this;
        }

        public final TrainingResult.Builder getTrainingResult() {
            return this.trainingResult != null ? this.trainingResult.toBuilder() : null;
        }

        public final void setTrainingResult(TrainingResult.BuilderImpl trainingResult) {
            this.trainingResult = trainingResult != null ? trainingResult.build() : null;
        }

        @Override
        @Transient
        public final Builder trainingResult(TrainingResult trainingResult) {
            this.trainingResult = trainingResult;
            return this;
        }

        public final String getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        @Transient
        public final Builder lastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        @Transient
        public final Builder createdTime(String createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public ModelVersionDetail build() {
            return new ModelVersionDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelVersionDetail> {
        public Builder modelId(String var1);

        public Builder modelType(String var1);

        public Builder modelType(ModelTypeEnum var1);

        public Builder modelVersionNumber(String var1);

        public Builder status(String var1);

        public Builder trainingDataSource(String var1);

        public Builder trainingDataSource(TrainingDataSourceEnum var1);

        public Builder trainingDataSchema(TrainingDataSchema var1);

        default public Builder trainingDataSchema(Consumer<TrainingDataSchema.Builder> trainingDataSchema) {
            return this.trainingDataSchema((TrainingDataSchema)((TrainingDataSchema.Builder)TrainingDataSchema.builder().applyMutation(trainingDataSchema)).build());
        }

        public Builder externalEventsDetail(ExternalEventsDetail var1);

        default public Builder externalEventsDetail(Consumer<ExternalEventsDetail.Builder> externalEventsDetail) {
            return this.externalEventsDetail((ExternalEventsDetail)((ExternalEventsDetail.Builder)ExternalEventsDetail.builder().applyMutation(externalEventsDetail)).build());
        }

        public Builder trainingResult(TrainingResult var1);

        default public Builder trainingResult(Consumer<TrainingResult.Builder> trainingResult) {
            return this.trainingResult((TrainingResult)((TrainingResult.Builder)TrainingResult.builder().applyMutation(trainingResult)).build());
        }

        public Builder lastUpdatedTime(String var1);

        public Builder createdTime(String var1);

        public Builder arn(String var1);
    }
}

