/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the model version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelVersionDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<ModelVersionDetail.Builder, ModelVersionDetail> {
    private static final SdkField<String> MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelId").getter(getter(ModelVersionDetail::modelId)).setter(setter(Builder::modelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()).build();

    private static final SdkField<String> MODEL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelType").getter(getter(ModelVersionDetail::modelTypeAsString)).setter(setter(Builder::modelType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelType").build()).build();

    private static final SdkField<String> MODEL_VERSION_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelVersionNumber").getter(getter(ModelVersionDetail::modelVersionNumber))
            .setter(setter(Builder::modelVersionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelVersionNumber").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ModelVersionDetail::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> TRAINING_DATA_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trainingDataSource").getter(getter(ModelVersionDetail::trainingDataSourceAsString))
            .setter(setter(Builder::trainingDataSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingDataSource").build())
            .build();

    private static final SdkField<TrainingDataSchema> TRAINING_DATA_SCHEMA_FIELD = SdkField
            .<TrainingDataSchema> builder(MarshallingType.SDK_POJO).memberName("trainingDataSchema")
            .getter(getter(ModelVersionDetail::trainingDataSchema)).setter(setter(Builder::trainingDataSchema))
            .constructor(TrainingDataSchema::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingDataSchema").build())
            .build();

    private static final SdkField<ExternalEventsDetail> EXTERNAL_EVENTS_DETAIL_FIELD = SdkField
            .<ExternalEventsDetail> builder(MarshallingType.SDK_POJO).memberName("externalEventsDetail")
            .getter(getter(ModelVersionDetail::externalEventsDetail)).setter(setter(Builder::externalEventsDetail))
            .constructor(ExternalEventsDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalEventsDetail").build())
            .build();

    private static final SdkField<TrainingResult> TRAINING_RESULT_FIELD = SdkField
            .<TrainingResult> builder(MarshallingType.SDK_POJO).memberName("trainingResult")
            .getter(getter(ModelVersionDetail::trainingResult)).setter(setter(Builder::trainingResult))
            .constructor(TrainingResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingResult").build()).build();

    private static final SdkField<String> LAST_UPDATED_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastUpdatedTime").getter(getter(ModelVersionDetail::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()).build();

    private static final SdkField<String> CREATED_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdTime").getter(getter(ModelVersionDetail::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ModelVersionDetail::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ID_FIELD,
            MODEL_TYPE_FIELD, MODEL_VERSION_NUMBER_FIELD, STATUS_FIELD, TRAINING_DATA_SOURCE_FIELD, TRAINING_DATA_SCHEMA_FIELD,
            EXTERNAL_EVENTS_DETAIL_FIELD, TRAINING_RESULT_FIELD, LAST_UPDATED_TIME_FIELD, CREATED_TIME_FIELD, ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String modelId;

    private final String modelType;

    private final String modelVersionNumber;

    private final String status;

    private final String trainingDataSource;

    private final TrainingDataSchema trainingDataSchema;

    private final ExternalEventsDetail externalEventsDetail;

    private final TrainingResult trainingResult;

    private final String lastUpdatedTime;

    private final String createdTime;

    private final String arn;

    private ModelVersionDetail(BuilderImpl builder) {
        this.modelId = builder.modelId;
        this.modelType = builder.modelType;
        this.modelVersionNumber = builder.modelVersionNumber;
        this.status = builder.status;
        this.trainingDataSource = builder.trainingDataSource;
        this.trainingDataSchema = builder.trainingDataSchema;
        this.externalEventsDetail = builder.externalEventsDetail;
        this.trainingResult = builder.trainingResult;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.createdTime = builder.createdTime;
        this.arn = builder.arn;
    }

    /**
     * <p>
     * The model ID.
     * </p>
     * 
     * @return The model ID.
     */
    public final String modelId() {
        return modelId;
    }

    /**
     * <p>
     * The model type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelType} will
     * return {@link ModelTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modelTypeAsString}.
     * </p>
     * 
     * @return The model type.
     * @see ModelTypeEnum
     */
    public final ModelTypeEnum modelType() {
        return ModelTypeEnum.fromValue(modelType);
    }

    /**
     * <p>
     * The model type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelType} will
     * return {@link ModelTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modelTypeAsString}.
     * </p>
     * 
     * @return The model type.
     * @see ModelTypeEnum
     */
    public final String modelTypeAsString() {
        return modelType;
    }

    /**
     * <p>
     * The model version number.
     * </p>
     * 
     * @return The model version number.
     */
    public final String modelVersionNumber() {
        return modelVersionNumber;
    }

    /**
     * <p>
     * The status of the model version.
     * </p>
     * 
     * @return The status of the model version.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The model version training data source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #trainingDataSource} will return {@link TrainingDataSourceEnum#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #trainingDataSourceAsString}.
     * </p>
     * 
     * @return The model version training data source.
     * @see TrainingDataSourceEnum
     */
    public final TrainingDataSourceEnum trainingDataSource() {
        return TrainingDataSourceEnum.fromValue(trainingDataSource);
    }

    /**
     * <p>
     * The model version training data source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #trainingDataSource} will return {@link TrainingDataSourceEnum#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #trainingDataSourceAsString}.
     * </p>
     * 
     * @return The model version training data source.
     * @see TrainingDataSourceEnum
     */
    public final String trainingDataSourceAsString() {
        return trainingDataSource;
    }

    /**
     * <p>
     * The training data schema.
     * </p>
     * 
     * @return The training data schema.
     */
    public final TrainingDataSchema trainingDataSchema() {
        return trainingDataSchema;
    }

    /**
     * <p>
     * The event details.
     * </p>
     * 
     * @return The event details.
     */
    public final ExternalEventsDetail externalEventsDetail() {
        return externalEventsDetail;
    }

    /**
     * <p>
     * The training results.
     * </p>
     * 
     * @return The training results.
     */
    public final TrainingResult trainingResult() {
        return trainingResult;
    }

    /**
     * <p>
     * The timestamp when the model was last updated.
     * </p>
     * 
     * @return The timestamp when the model was last updated.
     */
    public final String lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * The timestamp when the model was created.
     * </p>
     * 
     * @return The timestamp when the model was created.
     */
    public final String createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The model version ARN.
     * </p>
     * 
     * @return The model version ARN.
     */
    public final String arn() {
        return arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelId());
        hashCode = 31 * hashCode + Objects.hashCode(modelTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(modelVersionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(trainingDataSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(trainingDataSchema());
        hashCode = 31 * hashCode + Objects.hashCode(externalEventsDetail());
        hashCode = 31 * hashCode + Objects.hashCode(trainingResult());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelVersionDetail)) {
            return false;
        }
        ModelVersionDetail other = (ModelVersionDetail) obj;
        return Objects.equals(modelId(), other.modelId()) && Objects.equals(modelTypeAsString(), other.modelTypeAsString())
                && Objects.equals(modelVersionNumber(), other.modelVersionNumber()) && Objects.equals(status(), other.status())
                && Objects.equals(trainingDataSourceAsString(), other.trainingDataSourceAsString())
                && Objects.equals(trainingDataSchema(), other.trainingDataSchema())
                && Objects.equals(externalEventsDetail(), other.externalEventsDetail())
                && Objects.equals(trainingResult(), other.trainingResult())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(createdTime(), other.createdTime()) && Objects.equals(arn(), other.arn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelVersionDetail").add("ModelId", modelId()).add("ModelType", modelTypeAsString())
                .add("ModelVersionNumber", modelVersionNumber()).add("Status", status())
                .add("TrainingDataSource", trainingDataSourceAsString()).add("TrainingDataSchema", trainingDataSchema())
                .add("ExternalEventsDetail", externalEventsDetail()).add("TrainingResult", trainingResult())
                .add("LastUpdatedTime", lastUpdatedTime()).add("CreatedTime", createdTime()).add("Arn", arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "modelId":
            return Optional.ofNullable(clazz.cast(modelId()));
        case "modelType":
            return Optional.ofNullable(clazz.cast(modelTypeAsString()));
        case "modelVersionNumber":
            return Optional.ofNullable(clazz.cast(modelVersionNumber()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "trainingDataSource":
            return Optional.ofNullable(clazz.cast(trainingDataSourceAsString()));
        case "trainingDataSchema":
            return Optional.ofNullable(clazz.cast(trainingDataSchema()));
        case "externalEventsDetail":
            return Optional.ofNullable(clazz.cast(externalEventsDetail()));
        case "trainingResult":
            return Optional.ofNullable(clazz.cast(trainingResult()));
        case "lastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "createdTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelVersionDetail, T> g) {
        return obj -> g.apply((ModelVersionDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelVersionDetail> {
        /**
         * <p>
         * The model ID.
         * </p>
         * 
         * @param modelId
         *        The model ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelId(String modelId);

        /**
         * <p>
         * The model type.
         * </p>
         * 
         * @param modelType
         *        The model type.
         * @see ModelTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelTypeEnum
         */
        Builder modelType(String modelType);

        /**
         * <p>
         * The model type.
         * </p>
         * 
         * @param modelType
         *        The model type.
         * @see ModelTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelTypeEnum
         */
        Builder modelType(ModelTypeEnum modelType);

        /**
         * <p>
         * The model version number.
         * </p>
         * 
         * @param modelVersionNumber
         *        The model version number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVersionNumber(String modelVersionNumber);

        /**
         * <p>
         * The status of the model version.
         * </p>
         * 
         * @param status
         *        The status of the model version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The model version training data source.
         * </p>
         * 
         * @param trainingDataSource
         *        The model version training data source.
         * @see TrainingDataSourceEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainingDataSourceEnum
         */
        Builder trainingDataSource(String trainingDataSource);

        /**
         * <p>
         * The model version training data source.
         * </p>
         * 
         * @param trainingDataSource
         *        The model version training data source.
         * @see TrainingDataSourceEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainingDataSourceEnum
         */
        Builder trainingDataSource(TrainingDataSourceEnum trainingDataSource);

        /**
         * <p>
         * The training data schema.
         * </p>
         * 
         * @param trainingDataSchema
         *        The training data schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingDataSchema(TrainingDataSchema trainingDataSchema);

        /**
         * <p>
         * The training data schema.
         * </p>
         * This is a convenience that creates an instance of the {@link TrainingDataSchema.Builder} avoiding the need to
         * create one manually via {@link TrainingDataSchema#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrainingDataSchema.Builder#build()} is called immediately and its
         * result is passed to {@link #trainingDataSchema(TrainingDataSchema)}.
         * 
         * @param trainingDataSchema
         *        a consumer that will call methods on {@link TrainingDataSchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trainingDataSchema(TrainingDataSchema)
         */
        default Builder trainingDataSchema(Consumer<TrainingDataSchema.Builder> trainingDataSchema) {
            return trainingDataSchema(TrainingDataSchema.builder().applyMutation(trainingDataSchema).build());
        }

        /**
         * <p>
         * The event details.
         * </p>
         * 
         * @param externalEventsDetail
         *        The event details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalEventsDetail(ExternalEventsDetail externalEventsDetail);

        /**
         * <p>
         * The event details.
         * </p>
         * This is a convenience that creates an instance of the {@link ExternalEventsDetail.Builder} avoiding the need
         * to create one manually via {@link ExternalEventsDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExternalEventsDetail.Builder#build()} is called immediately and
         * its result is passed to {@link #externalEventsDetail(ExternalEventsDetail)}.
         * 
         * @param externalEventsDetail
         *        a consumer that will call methods on {@link ExternalEventsDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #externalEventsDetail(ExternalEventsDetail)
         */
        default Builder externalEventsDetail(Consumer<ExternalEventsDetail.Builder> externalEventsDetail) {
            return externalEventsDetail(ExternalEventsDetail.builder().applyMutation(externalEventsDetail).build());
        }

        /**
         * <p>
         * The training results.
         * </p>
         * 
         * @param trainingResult
         *        The training results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingResult(TrainingResult trainingResult);

        /**
         * <p>
         * The training results.
         * </p>
         * This is a convenience that creates an instance of the {@link TrainingResult.Builder} avoiding the need to
         * create one manually via {@link TrainingResult#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrainingResult.Builder#build()} is called immediately and its
         * result is passed to {@link #trainingResult(TrainingResult)}.
         * 
         * @param trainingResult
         *        a consumer that will call methods on {@link TrainingResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trainingResult(TrainingResult)
         */
        default Builder trainingResult(Consumer<TrainingResult.Builder> trainingResult) {
            return trainingResult(TrainingResult.builder().applyMutation(trainingResult).build());
        }

        /**
         * <p>
         * The timestamp when the model was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The timestamp when the model was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(String lastUpdatedTime);

        /**
         * <p>
         * The timestamp when the model was created.
         * </p>
         * 
         * @param createdTime
         *        The timestamp when the model was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(String createdTime);

        /**
         * <p>
         * The model version ARN.
         * </p>
         * 
         * @param arn
         *        The model version ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);
    }

    static final class BuilderImpl implements Builder {
        private String modelId;

        private String modelType;

        private String modelVersionNumber;

        private String status;

        private String trainingDataSource;

        private TrainingDataSchema trainingDataSchema;

        private ExternalEventsDetail externalEventsDetail;

        private TrainingResult trainingResult;

        private String lastUpdatedTime;

        private String createdTime;

        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelVersionDetail model) {
            modelId(model.modelId);
            modelType(model.modelType);
            modelVersionNumber(model.modelVersionNumber);
            status(model.status);
            trainingDataSource(model.trainingDataSource);
            trainingDataSchema(model.trainingDataSchema);
            externalEventsDetail(model.externalEventsDetail);
            trainingResult(model.trainingResult);
            lastUpdatedTime(model.lastUpdatedTime);
            createdTime(model.createdTime);
            arn(model.arn);
        }

        public final String getModelId() {
            return modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        public final String getModelType() {
            return modelType;
        }

        @Override
        public final Builder modelType(String modelType) {
            this.modelType = modelType;
            return this;
        }

        @Override
        public final Builder modelType(ModelTypeEnum modelType) {
            this.modelType(modelType == null ? null : modelType.toString());
            return this;
        }

        public final void setModelType(String modelType) {
            this.modelType = modelType;
        }

        public final String getModelVersionNumber() {
            return modelVersionNumber;
        }

        @Override
        public final Builder modelVersionNumber(String modelVersionNumber) {
            this.modelVersionNumber = modelVersionNumber;
            return this;
        }

        public final void setModelVersionNumber(String modelVersionNumber) {
            this.modelVersionNumber = modelVersionNumber;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getTrainingDataSource() {
            return trainingDataSource;
        }

        @Override
        public final Builder trainingDataSource(String trainingDataSource) {
            this.trainingDataSource = trainingDataSource;
            return this;
        }

        @Override
        public final Builder trainingDataSource(TrainingDataSourceEnum trainingDataSource) {
            this.trainingDataSource(trainingDataSource == null ? null : trainingDataSource.toString());
            return this;
        }

        public final void setTrainingDataSource(String trainingDataSource) {
            this.trainingDataSource = trainingDataSource;
        }

        public final TrainingDataSchema.Builder getTrainingDataSchema() {
            return trainingDataSchema != null ? trainingDataSchema.toBuilder() : null;
        }

        @Override
        public final Builder trainingDataSchema(TrainingDataSchema trainingDataSchema) {
            this.trainingDataSchema = trainingDataSchema;
            return this;
        }

        public final void setTrainingDataSchema(TrainingDataSchema.BuilderImpl trainingDataSchema) {
            this.trainingDataSchema = trainingDataSchema != null ? trainingDataSchema.build() : null;
        }

        public final ExternalEventsDetail.Builder getExternalEventsDetail() {
            return externalEventsDetail != null ? externalEventsDetail.toBuilder() : null;
        }

        @Override
        public final Builder externalEventsDetail(ExternalEventsDetail externalEventsDetail) {
            this.externalEventsDetail = externalEventsDetail;
            return this;
        }

        public final void setExternalEventsDetail(ExternalEventsDetail.BuilderImpl externalEventsDetail) {
            this.externalEventsDetail = externalEventsDetail != null ? externalEventsDetail.build() : null;
        }

        public final TrainingResult.Builder getTrainingResult() {
            return trainingResult != null ? trainingResult.toBuilder() : null;
        }

        @Override
        public final Builder trainingResult(TrainingResult trainingResult) {
            this.trainingResult = trainingResult;
            return this;
        }

        public final void setTrainingResult(TrainingResult.BuilderImpl trainingResult) {
            this.trainingResult = trainingResult != null ? trainingResult.build() : null;
        }

        public final String getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final void setLastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        public final String getCreatedTime() {
            return createdTime;
        }

        @Override
        public final Builder createdTime(String createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public ModelVersionDetail build() {
            return new ModelVersionDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
