/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The detector.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Detector implements SdkPojo, Serializable, ToCopyableBuilder<Detector.Builder, Detector> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("detectorId").getter(getter(Detector::detectorId)).setter(setter(Builder::detectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(Detector::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> EVENT_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventTypeName").getter(getter(Detector::eventTypeName)).setter(setter(Builder::eventTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTypeName").build()).build();

    private static final SdkField<String> LAST_UPDATED_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastUpdatedTime").getter(getter(Detector::lastUpdatedTime)).setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()).build();

    private static final SdkField<String> CREATED_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdTime").getter(getter(Detector::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(Detector::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD,
            DESCRIPTION_FIELD, EVENT_TYPE_NAME_FIELD, LAST_UPDATED_TIME_FIELD, CREATED_TIME_FIELD, ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String detectorId;

    private final String description;

    private final String eventTypeName;

    private final String lastUpdatedTime;

    private final String createdTime;

    private final String arn;

    private Detector(BuilderImpl builder) {
        this.detectorId = builder.detectorId;
        this.description = builder.description;
        this.eventTypeName = builder.eventTypeName;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.createdTime = builder.createdTime;
        this.arn = builder.arn;
    }

    /**
     * <p>
     * The detector ID.
     * </p>
     * 
     * @return The detector ID.
     */
    public final String detectorId() {
        return detectorId;
    }

    /**
     * <p>
     * The detector description.
     * </p>
     * 
     * @return The detector description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the event type.
     * </p>
     * 
     * @return The name of the event type.
     */
    public final String eventTypeName() {
        return eventTypeName;
    }

    /**
     * <p>
     * Timestamp of when the detector was last updated.
     * </p>
     * 
     * @return Timestamp of when the detector was last updated.
     */
    public final String lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * Timestamp of when the detector was created.
     * </p>
     * 
     * @return Timestamp of when the detector was created.
     */
    public final String createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The detector ARN.
     * </p>
     * 
     * @return The detector ARN.
     */
    public final String arn() {
        return arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(eventTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Detector)) {
            return false;
        }
        Detector other = (Detector) obj;
        return Objects.equals(detectorId(), other.detectorId()) && Objects.equals(description(), other.description())
                && Objects.equals(eventTypeName(), other.eventTypeName())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(createdTime(), other.createdTime()) && Objects.equals(arn(), other.arn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Detector").add("DetectorId", detectorId()).add("Description", description())
                .add("EventTypeName", eventTypeName()).add("LastUpdatedTime", lastUpdatedTime())
                .add("CreatedTime", createdTime()).add("Arn", arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "detectorId":
            return Optional.ofNullable(clazz.cast(detectorId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "eventTypeName":
            return Optional.ofNullable(clazz.cast(eventTypeName()));
        case "lastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "createdTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Detector, T> g) {
        return obj -> g.apply((Detector) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Detector> {
        /**
         * <p>
         * The detector ID.
         * </p>
         * 
         * @param detectorId
         *        The detector ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorId(String detectorId);

        /**
         * <p>
         * The detector description.
         * </p>
         * 
         * @param description
         *        The detector description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the event type.
         * </p>
         * 
         * @param eventTypeName
         *        The name of the event type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypeName(String eventTypeName);

        /**
         * <p>
         * Timestamp of when the detector was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        Timestamp of when the detector was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(String lastUpdatedTime);

        /**
         * <p>
         * Timestamp of when the detector was created.
         * </p>
         * 
         * @param createdTime
         *        Timestamp of when the detector was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(String createdTime);

        /**
         * <p>
         * The detector ARN.
         * </p>
         * 
         * @param arn
         *        The detector ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);
    }

    static final class BuilderImpl implements Builder {
        private String detectorId;

        private String description;

        private String eventTypeName;

        private String lastUpdatedTime;

        private String createdTime;

        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(Detector model) {
            detectorId(model.detectorId);
            description(model.description);
            eventTypeName(model.eventTypeName);
            lastUpdatedTime(model.lastUpdatedTime);
            createdTime(model.createdTime);
            arn(model.arn);
        }

        public final String getDetectorId() {
            return detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getEventTypeName() {
            return eventTypeName;
        }

        @Override
        public final Builder eventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
            return this;
        }

        public final void setEventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
        }

        public final String getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final void setLastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        public final String getCreatedTime() {
            return createdTime;
        }

        @Override
        public final Builder createdTime(String createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public Detector build() {
            return new Detector(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
