/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDetectorResponse extends FraudDetectorResponse implements
        ToCopyableBuilder<DescribeDetectorResponse.Builder, DescribeDetectorResponse> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("detectorId").getter(getter(DescribeDetectorResponse::detectorId)).setter(setter(Builder::detectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorId").build()).build();

    private static final SdkField<List<DetectorVersionSummary>> DETECTOR_VERSION_SUMMARIES_FIELD = SdkField
            .<List<DetectorVersionSummary>> builder(MarshallingType.LIST)
            .memberName("detectorVersionSummaries")
            .getter(getter(DescribeDetectorResponse::detectorVersionSummaries))
            .setter(setter(Builder::detectorVersionSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorVersionSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DetectorVersionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(DetectorVersionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeDetectorResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(DescribeDetectorResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD,
            DETECTOR_VERSION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD, ARN_FIELD));

    private final String detectorId;

    private final List<DetectorVersionSummary> detectorVersionSummaries;

    private final String nextToken;

    private final String arn;

    private DescribeDetectorResponse(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.detectorVersionSummaries = builder.detectorVersionSummaries;
        this.nextToken = builder.nextToken;
        this.arn = builder.arn;
    }

    /**
     * <p>
     * The detector ID.
     * </p>
     * 
     * @return The detector ID.
     */
    public final String detectorId() {
        return detectorId;
    }

    /**
     * Returns true if the DetectorVersionSummaries property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasDetectorVersionSummaries() {
        return detectorVersionSummaries != null && !(detectorVersionSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The status and description for each detector version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDetectorVersionSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The status and description for each detector version.
     */
    public final List<DetectorVersionSummary> detectorVersionSummaries() {
        return detectorVersionSummaries;
    }

    /**
     * <p>
     * The next token to be used for subsequent requests.
     * </p>
     * 
     * @return The next token to be used for subsequent requests.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The detector ARN.
     * </p>
     * 
     * @return The detector ARN.
     */
    public final String arn() {
        return arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(hasDetectorVersionSummaries() ? detectorVersionSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDetectorResponse)) {
            return false;
        }
        DescribeDetectorResponse other = (DescribeDetectorResponse) obj;
        return Objects.equals(detectorId(), other.detectorId())
                && hasDetectorVersionSummaries() == other.hasDetectorVersionSummaries()
                && Objects.equals(detectorVersionSummaries(), other.detectorVersionSummaries())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(arn(), other.arn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDetectorResponse").add("DetectorId", detectorId())
                .add("DetectorVersionSummaries", hasDetectorVersionSummaries() ? detectorVersionSummaries() : null)
                .add("NextToken", nextToken()).add("Arn", arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "detectorId":
            return Optional.ofNullable(clazz.cast(detectorId()));
        case "detectorVersionSummaries":
            return Optional.ofNullable(clazz.cast(detectorVersionSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDetectorResponse, T> g) {
        return obj -> g.apply((DescribeDetectorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FraudDetectorResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDetectorResponse> {
        /**
         * <p>
         * The detector ID.
         * </p>
         * 
         * @param detectorId
         *        The detector ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorId(String detectorId);

        /**
         * <p>
         * The status and description for each detector version.
         * </p>
         * 
         * @param detectorVersionSummaries
         *        The status and description for each detector version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorVersionSummaries(Collection<DetectorVersionSummary> detectorVersionSummaries);

        /**
         * <p>
         * The status and description for each detector version.
         * </p>
         * 
         * @param detectorVersionSummaries
         *        The status and description for each detector version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorVersionSummaries(DetectorVersionSummary... detectorVersionSummaries);

        /**
         * <p>
         * The status and description for each detector version.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DetectorVersionSummary>.Builder} avoiding
         * the need to create one manually via {@link List<DetectorVersionSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DetectorVersionSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #detectorVersionSummaries(List<DetectorVersionSummary>)}.
         * 
         * @param detectorVersionSummaries
         *        a consumer that will call methods on {@link List<DetectorVersionSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #detectorVersionSummaries(List<DetectorVersionSummary>)
         */
        Builder detectorVersionSummaries(Consumer<DetectorVersionSummary.Builder>... detectorVersionSummaries);

        /**
         * <p>
         * The next token to be used for subsequent requests.
         * </p>
         * 
         * @param nextToken
         *        The next token to be used for subsequent requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The detector ARN.
         * </p>
         * 
         * @param arn
         *        The detector ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);
    }

    static final class BuilderImpl extends FraudDetectorResponse.BuilderImpl implements Builder {
        private String detectorId;

        private List<DetectorVersionSummary> detectorVersionSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDetectorResponse model) {
            super(model);
            detectorId(model.detectorId);
            detectorVersionSummaries(model.detectorVersionSummaries);
            nextToken(model.nextToken);
            arn(model.arn);
        }

        public final String getDetectorId() {
            return detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        public final Collection<DetectorVersionSummary.Builder> getDetectorVersionSummaries() {
            if (detectorVersionSummaries instanceof SdkAutoConstructList) {
                return null;
            }
            return detectorVersionSummaries != null ? detectorVersionSummaries.stream().map(DetectorVersionSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder detectorVersionSummaries(Collection<DetectorVersionSummary> detectorVersionSummaries) {
            this.detectorVersionSummaries = DetectorVersionSummaryListCopier.copy(detectorVersionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectorVersionSummaries(DetectorVersionSummary... detectorVersionSummaries) {
            detectorVersionSummaries(Arrays.asList(detectorVersionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectorVersionSummaries(Consumer<DetectorVersionSummary.Builder>... detectorVersionSummaries) {
            detectorVersionSummaries(Stream.of(detectorVersionSummaries)
                    .map(c -> DetectorVersionSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDetectorVersionSummaries(Collection<DetectorVersionSummary.BuilderImpl> detectorVersionSummaries) {
            this.detectorVersionSummaries = DetectorVersionSummaryListCopier.copyFromBuilder(detectorVersionSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public DescribeDetectorResponse build() {
            return new DescribeDetectorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
