/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.frauddetector.model.AccessDeniedException;
import software.amazon.awssdk.services.frauddetector.model.BatchCreateVariableRequest;
import software.amazon.awssdk.services.frauddetector.model.BatchCreateVariableResponse;
import software.amazon.awssdk.services.frauddetector.model.BatchGetVariableRequest;
import software.amazon.awssdk.services.frauddetector.model.BatchGetVariableResponse;
import software.amazon.awssdk.services.frauddetector.model.ConflictException;
import software.amazon.awssdk.services.frauddetector.model.CreateDetectorVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.CreateDetectorVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.CreateModelRequest;
import software.amazon.awssdk.services.frauddetector.model.CreateModelResponse;
import software.amazon.awssdk.services.frauddetector.model.CreateModelVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.CreateModelVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.CreateRuleRequest;
import software.amazon.awssdk.services.frauddetector.model.CreateRuleResponse;
import software.amazon.awssdk.services.frauddetector.model.CreateVariableRequest;
import software.amazon.awssdk.services.frauddetector.model.CreateVariableResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteDetectorRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteDetectorResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteDetectorVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteDetectorVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteEntityTypeRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteEntityTypeResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteEventRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteEventResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteEventTypeRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteEventTypeResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteExternalModelRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteExternalModelResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteLabelRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteLabelResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteModelRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteModelResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteModelVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteModelVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteOutcomeRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteOutcomeResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteRuleRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteRuleResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteVariableRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteVariableResponse;
import software.amazon.awssdk.services.frauddetector.model.DescribeDetectorRequest;
import software.amazon.awssdk.services.frauddetector.model.DescribeDetectorResponse;
import software.amazon.awssdk.services.frauddetector.model.DescribeModelVersionsRequest;
import software.amazon.awssdk.services.frauddetector.model.DescribeModelVersionsResponse;
import software.amazon.awssdk.services.frauddetector.model.FraudDetectorException;
import software.amazon.awssdk.services.frauddetector.model.GetDetectorVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.GetDetectorVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.GetDetectorsRequest;
import software.amazon.awssdk.services.frauddetector.model.GetDetectorsResponse;
import software.amazon.awssdk.services.frauddetector.model.GetEntityTypesRequest;
import software.amazon.awssdk.services.frauddetector.model.GetEntityTypesResponse;
import software.amazon.awssdk.services.frauddetector.model.GetEventPredictionRequest;
import software.amazon.awssdk.services.frauddetector.model.GetEventPredictionResponse;
import software.amazon.awssdk.services.frauddetector.model.GetEventTypesRequest;
import software.amazon.awssdk.services.frauddetector.model.GetEventTypesResponse;
import software.amazon.awssdk.services.frauddetector.model.GetExternalModelsRequest;
import software.amazon.awssdk.services.frauddetector.model.GetExternalModelsResponse;
import software.amazon.awssdk.services.frauddetector.model.GetKmsEncryptionKeyRequest;
import software.amazon.awssdk.services.frauddetector.model.GetKmsEncryptionKeyResponse;
import software.amazon.awssdk.services.frauddetector.model.GetLabelsRequest;
import software.amazon.awssdk.services.frauddetector.model.GetLabelsResponse;
import software.amazon.awssdk.services.frauddetector.model.GetModelVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.GetModelVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.GetModelsRequest;
import software.amazon.awssdk.services.frauddetector.model.GetModelsResponse;
import software.amazon.awssdk.services.frauddetector.model.GetOutcomesRequest;
import software.amazon.awssdk.services.frauddetector.model.GetOutcomesResponse;
import software.amazon.awssdk.services.frauddetector.model.GetRulesRequest;
import software.amazon.awssdk.services.frauddetector.model.GetRulesResponse;
import software.amazon.awssdk.services.frauddetector.model.GetVariablesRequest;
import software.amazon.awssdk.services.frauddetector.model.GetVariablesResponse;
import software.amazon.awssdk.services.frauddetector.model.InternalServerException;
import software.amazon.awssdk.services.frauddetector.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.frauddetector.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.frauddetector.model.PutDetectorRequest;
import software.amazon.awssdk.services.frauddetector.model.PutDetectorResponse;
import software.amazon.awssdk.services.frauddetector.model.PutEntityTypeRequest;
import software.amazon.awssdk.services.frauddetector.model.PutEntityTypeResponse;
import software.amazon.awssdk.services.frauddetector.model.PutEventTypeRequest;
import software.amazon.awssdk.services.frauddetector.model.PutEventTypeResponse;
import software.amazon.awssdk.services.frauddetector.model.PutExternalModelRequest;
import software.amazon.awssdk.services.frauddetector.model.PutExternalModelResponse;
import software.amazon.awssdk.services.frauddetector.model.PutKmsEncryptionKeyRequest;
import software.amazon.awssdk.services.frauddetector.model.PutKmsEncryptionKeyResponse;
import software.amazon.awssdk.services.frauddetector.model.PutLabelRequest;
import software.amazon.awssdk.services.frauddetector.model.PutLabelResponse;
import software.amazon.awssdk.services.frauddetector.model.PutOutcomeRequest;
import software.amazon.awssdk.services.frauddetector.model.PutOutcomeResponse;
import software.amazon.awssdk.services.frauddetector.model.ResourceNotFoundException;
import software.amazon.awssdk.services.frauddetector.model.TagResourceRequest;
import software.amazon.awssdk.services.frauddetector.model.TagResourceResponse;
import software.amazon.awssdk.services.frauddetector.model.ThrottlingException;
import software.amazon.awssdk.services.frauddetector.model.UntagResourceRequest;
import software.amazon.awssdk.services.frauddetector.model.UntagResourceResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateDetectorVersionMetadataRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateDetectorVersionMetadataResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateDetectorVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateDetectorVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateDetectorVersionStatusRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateDetectorVersionStatusResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateModelRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateModelResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateModelVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateModelVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateModelVersionStatusRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateModelVersionStatusResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateRuleMetadataRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateRuleMetadataResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateRuleVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateRuleVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateVariableRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateVariableResponse;
import software.amazon.awssdk.services.frauddetector.model.ValidationException;
import software.amazon.awssdk.services.frauddetector.paginators.DescribeModelVersionsIterable;
import software.amazon.awssdk.services.frauddetector.paginators.GetDetectorsIterable;
import software.amazon.awssdk.services.frauddetector.paginators.GetEntityTypesIterable;
import software.amazon.awssdk.services.frauddetector.paginators.GetEventTypesIterable;
import software.amazon.awssdk.services.frauddetector.paginators.GetExternalModelsIterable;
import software.amazon.awssdk.services.frauddetector.paginators.GetLabelsIterable;
import software.amazon.awssdk.services.frauddetector.paginators.GetModelsIterable;
import software.amazon.awssdk.services.frauddetector.paginators.GetOutcomesIterable;
import software.amazon.awssdk.services.frauddetector.paginators.GetRulesIterable;
import software.amazon.awssdk.services.frauddetector.paginators.GetVariablesIterable;
import software.amazon.awssdk.services.frauddetector.paginators.ListTagsForResourceIterable;

/**
 * Service client for accessing Amazon Fraud Detector. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * This is the Amazon Fraud Detector API Reference. This guide is for developers who need detailed information about
 * Amazon Fraud Detector API actions, data types, and errors. For more information about Amazon Fraud Detector features,
 * see the <a href="https://docs.aws.amazon.com/frauddetector/latest/ug/">Amazon Fraud Detector User Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface FraudDetectorClient extends SdkClient {
    String SERVICE_NAME = "frauddetector";

    /**
     * Create a {@link FraudDetectorClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static FraudDetectorClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link FraudDetectorClient}.
     */
    static FraudDetectorClientBuilder builder() {
        return new DefaultFraudDetectorClientBuilder();
    }

    /**
     * <p>
     * Creates a batch of variables.
     * </p>
     *
     * @param batchCreateVariableRequest
     * @return Result of the BatchCreateVariable operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.BatchCreateVariable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/BatchCreateVariable"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchCreateVariableResponse batchCreateVariable(BatchCreateVariableRequest batchCreateVariableRequest)
            throws ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a batch of variables.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchCreateVariableRequest.Builder} avoiding the
     * need to create one manually via {@link BatchCreateVariableRequest#builder()}
     * </p>
     *
     * @param batchCreateVariableRequest
     *        A {@link Consumer} that will call methods on {@link BatchCreateVariableRequest.Builder} to create a
     *        request.
     * @return Result of the BatchCreateVariable operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.BatchCreateVariable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/BatchCreateVariable"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchCreateVariableResponse batchCreateVariable(
            Consumer<BatchCreateVariableRequest.Builder> batchCreateVariableRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        return batchCreateVariable(BatchCreateVariableRequest.builder().applyMutation(batchCreateVariableRequest).build());
    }

    /**
     * <p>
     * Gets a batch of variables.
     * </p>
     *
     * @param batchGetVariableRequest
     * @return Result of the BatchGetVariable operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.BatchGetVariable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/BatchGetVariable" target="_top">AWS
     *      API Documentation</a>
     */
    default BatchGetVariableResponse batchGetVariable(BatchGetVariableRequest batchGetVariableRequest)
            throws ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a batch of variables.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetVariableRequest.Builder} avoiding the need
     * to create one manually via {@link BatchGetVariableRequest#builder()}
     * </p>
     *
     * @param batchGetVariableRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetVariableRequest.Builder} to create a request.
     * @return Result of the BatchGetVariable operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.BatchGetVariable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/BatchGetVariable" target="_top">AWS
     *      API Documentation</a>
     */
    default BatchGetVariableResponse batchGetVariable(Consumer<BatchGetVariableRequest.Builder> batchGetVariableRequest)
            throws ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        return batchGetVariable(BatchGetVariableRequest.builder().applyMutation(batchGetVariableRequest).build());
    }

    /**
     * <p>
     * Creates a detector version. The detector version starts in a <code>DRAFT</code> status.
     * </p>
     *
     * @param createDetectorVersionRequest
     * @return Result of the CreateDetectorVersion operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.CreateDetectorVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateDetectorVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDetectorVersionResponse createDetectorVersion(CreateDetectorVersionRequest createDetectorVersionRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a detector version. The detector version starts in a <code>DRAFT</code> status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDetectorVersionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDetectorVersionRequest#builder()}
     * </p>
     *
     * @param createDetectorVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreateDetectorVersionRequest.Builder} to create a
     *        request.
     * @return Result of the CreateDetectorVersion operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.CreateDetectorVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateDetectorVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDetectorVersionResponse createDetectorVersion(
            Consumer<CreateDetectorVersionRequest.Builder> createDetectorVersionRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        return createDetectorVersion(CreateDetectorVersionRequest.builder().applyMutation(createDetectorVersionRequest).build());
    }

    /**
     * <p>
     * Creates a model using the specified model type.
     * </p>
     *
     * @param createModelRequest
     * @return Result of the CreateModel operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.CreateModel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateModel" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateModelResponse createModel(CreateModelRequest createModelRequest) throws ValidationException,
            InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a model using the specified model type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateModelRequest.Builder} avoiding the need to
     * create one manually via {@link CreateModelRequest#builder()}
     * </p>
     *
     * @param createModelRequest
     *        A {@link Consumer} that will call methods on {@link CreateModelRequest.Builder} to create a request.
     * @return Result of the CreateModel operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.CreateModel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateModel" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateModelResponse createModel(Consumer<CreateModelRequest.Builder> createModelRequest) throws ValidationException,
            InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, FraudDetectorException {
        return createModel(CreateModelRequest.builder().applyMutation(createModelRequest).build());
    }

    /**
     * <p>
     * Creates a version of the model using the specified model type and model id.
     * </p>
     *
     * @param createModelVersionRequest
     * @return Result of the CreateModelVersion operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.CreateModelVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateModelVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateModelVersionResponse createModelVersion(CreateModelVersionRequest createModelVersionRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a version of the model using the specified model type and model id.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateModelVersionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateModelVersionRequest#builder()}
     * </p>
     *
     * @param createModelVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreateModelVersionRequest.Builder} to create a
     *        request.
     * @return Result of the CreateModelVersion operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.CreateModelVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateModelVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateModelVersionResponse createModelVersion(Consumer<CreateModelVersionRequest.Builder> createModelVersionRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, FraudDetectorException {
        return createModelVersion(CreateModelVersionRequest.builder().applyMutation(createModelVersionRequest).build());
    }

    /**
     * <p>
     * Creates a rule for use with the specified detector.
     * </p>
     *
     * @param createRuleRequest
     * @return Result of the CreateRule operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.CreateRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateRuleResponse createRule(CreateRuleRequest createRuleRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a rule for use with the specified detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRuleRequest.Builder} avoiding the need to
     * create one manually via {@link CreateRuleRequest#builder()}
     * </p>
     *
     * @param createRuleRequest
     *        A {@link Consumer} that will call methods on {@link CreateRuleRequest.Builder} to create a request.
     * @return Result of the CreateRule operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.CreateRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateRuleResponse createRule(Consumer<CreateRuleRequest.Builder> createRuleRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        return createRule(CreateRuleRequest.builder().applyMutation(createRuleRequest).build());
    }

    /**
     * <p>
     * Creates a variable.
     * </p>
     *
     * @param createVariableRequest
     * @return Result of the CreateVariable operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.CreateVariable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateVariable" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateVariableResponse createVariable(CreateVariableRequest createVariableRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a variable.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVariableRequest.Builder} avoiding the need to
     * create one manually via {@link CreateVariableRequest#builder()}
     * </p>
     *
     * @param createVariableRequest
     *        A {@link Consumer} that will call methods on {@link CreateVariableRequest.Builder} to create a request.
     * @return Result of the CreateVariable operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.CreateVariable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateVariable" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateVariableResponse createVariable(Consumer<CreateVariableRequest.Builder> createVariableRequest)
            throws ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        return createVariable(CreateVariableRequest.builder().applyMutation(createVariableRequest).build());
    }

    /**
     * <p>
     * Deletes the detector. Before deleting a detector, you must first delete all detector versions and rule versions
     * associated with the detector.
     * </p>
     * <p>
     * When you delete a detector, Amazon Fraud Detector permanently deletes the detector and the data is no longer
     * stored in Amazon Fraud Detector.
     * </p>
     *
     * @param deleteDetectorRequest
     * @return Result of the DeleteDetector operation returned by the service.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation. The following delete operations
     *         can cause a conflict exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         DeleteDetector: A conflict exception will occur if the detector has associated <code>Rules</code> or
     *         <code>DetectorVersions</code>. You can only delete a detector if it has no <code>Rules</code> or
     *         <code>DetectorVersions</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DeleteDetectorVersion: A conflict exception will occur if the <code>DetectorVersion</code> status is
     *         <code>ACTIVE</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DeleteRule: A conflict exception will occur if the <code>RuleVersion</code> is in use by an associated
     *         <code>ACTIVE</code> or <code>INACTIVE DetectorVersion</code>.
     *         </p>
     *         </li>
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.DeleteDetector
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteDetector" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDetectorResponse deleteDetector(DeleteDetectorRequest deleteDetectorRequest) throws ConflictException,
            ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the detector. Before deleting a detector, you must first delete all detector versions and rule versions
     * associated with the detector.
     * </p>
     * <p>
     * When you delete a detector, Amazon Fraud Detector permanently deletes the detector and the data is no longer
     * stored in Amazon Fraud Detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDetectorRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDetectorRequest#builder()}
     * </p>
     *
     * @param deleteDetectorRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDetectorRequest.Builder} to create a request.
     * @return Result of the DeleteDetector operation returned by the service.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation. The following delete operations
     *         can cause a conflict exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         DeleteDetector: A conflict exception will occur if the detector has associated <code>Rules</code> or
     *         <code>DetectorVersions</code>. You can only delete a detector if it has no <code>Rules</code> or
     *         <code>DetectorVersions</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DeleteDetectorVersion: A conflict exception will occur if the <code>DetectorVersion</code> status is
     *         <code>ACTIVE</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DeleteRule: A conflict exception will occur if the <code>RuleVersion</code> is in use by an associated
     *         <code>ACTIVE</code> or <code>INACTIVE DetectorVersion</code>.
     *         </p>
     *         </li>
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.DeleteDetector
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteDetector" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDetectorResponse deleteDetector(Consumer<DeleteDetectorRequest.Builder> deleteDetectorRequest)
            throws ConflictException, ValidationException, InternalServerException, ThrottlingException, AccessDeniedException,
            AwsServiceException, SdkClientException, FraudDetectorException {
        return deleteDetector(DeleteDetectorRequest.builder().applyMutation(deleteDetectorRequest).build());
    }

    /**
     * <p>
     * Deletes the detector version. You cannot delete detector versions that are in <code>ACTIVE</code> status.
     * </p>
     * <p>
     * When you delete a detector version, Amazon Fraud Detector permanently deletes the detector and the data is no
     * longer stored in Amazon Fraud Detector.
     * </p>
     *
     * @param deleteDetectorVersionRequest
     * @return Result of the DeleteDetectorVersion operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation. The following delete operations
     *         can cause a conflict exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         DeleteDetector: A conflict exception will occur if the detector has associated <code>Rules</code> or
     *         <code>DetectorVersions</code>. You can only delete a detector if it has no <code>Rules</code> or
     *         <code>DetectorVersions</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DeleteDetectorVersion: A conflict exception will occur if the <code>DetectorVersion</code> status is
     *         <code>ACTIVE</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DeleteRule: A conflict exception will occur if the <code>RuleVersion</code> is in use by an associated
     *         <code>ACTIVE</code> or <code>INACTIVE DetectorVersion</code>.
     *         </p>
     *         </li>
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.DeleteDetectorVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteDetectorVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDetectorVersionResponse deleteDetectorVersion(DeleteDetectorVersionRequest deleteDetectorVersionRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            ConflictException, AccessDeniedException, AwsServiceException, SdkClientException, FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the detector version. You cannot delete detector versions that are in <code>ACTIVE</code> status.
     * </p>
     * <p>
     * When you delete a detector version, Amazon Fraud Detector permanently deletes the detector and the data is no
     * longer stored in Amazon Fraud Detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDetectorVersionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDetectorVersionRequest#builder()}
     * </p>
     *
     * @param deleteDetectorVersionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDetectorVersionRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteDetectorVersion operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation. The following delete operations
     *         can cause a conflict exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         DeleteDetector: A conflict exception will occur if the detector has associated <code>Rules</code> or
     *         <code>DetectorVersions</code>. You can only delete a detector if it has no <code>Rules</code> or
     *         <code>DetectorVersions</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DeleteDetectorVersion: A conflict exception will occur if the <code>DetectorVersion</code> status is
     *         <code>ACTIVE</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DeleteRule: A conflict exception will occur if the <code>RuleVersion</code> is in use by an associated
     *         <code>ACTIVE</code> or <code>INACTIVE DetectorVersion</code>.
     *         </p>
     *         </li>
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.DeleteDetectorVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteDetectorVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDetectorVersionResponse deleteDetectorVersion(
            Consumer<DeleteDetectorVersionRequest.Builder> deleteDetectorVersionRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, ThrottlingException, ConflictException, AccessDeniedException,
            AwsServiceException, SdkClientException, FraudDetectorException {
        return deleteDetectorVersion(DeleteDetectorVersionRequest.builder().applyMutation(deleteDetectorVersionRequest).build());
    }

    /**
     * <p>
     * Deletes an entity type.
     * </p>
     * <p>
     * You cannot delete an entity type that is included in an event type.
     * </p>
     * <p>
     * When you delete an entity type, Amazon Fraud Detector permanently deletes that entity type and the data is no
     * longer stored in Amazon Fraud Detector.
     * </p>
     *
     * @param deleteEntityTypeRequest
     * @return Result of the DeleteEntityType operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation. The following delete operations
     *         can cause a conflict exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         DeleteDetector: A conflict exception will occur if the detector has associated <code>Rules</code> or
     *         <code>DetectorVersions</code>. You can only delete a detector if it has no <code>Rules</code> or
     *         <code>DetectorVersions</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DeleteDetectorVersion: A conflict exception will occur if the <code>DetectorVersion</code> status is
     *         <code>ACTIVE</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DeleteRule: A conflict exception will occur if the <code>RuleVersion</code> is in use by an associated
     *         <code>ACTIVE</code> or <code>INACTIVE DetectorVersion</code>.
     *         </p>
     *         </li>
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.DeleteEntityType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteEntityType" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteEntityTypeResponse deleteEntityType(DeleteEntityTypeRequest deleteEntityTypeRequest)
            throws ValidationException, ConflictException, InternalServerException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an entity type.
     * </p>
     * <p>
     * You cannot delete an entity type that is included in an event type.
     * </p>
     * <p>
     * When you delete an entity type, Amazon Fraud Detector permanently deletes that entity type and the data is no
     * longer stored in Amazon Fraud Detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEntityTypeRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteEntityTypeRequest#builder()}
     * </p>
     *
     * @param deleteEntityTypeRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEntityTypeRequest.Builder} to create a request.
     * @return Result of the DeleteEntityType operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation. The following delete operations
     *         can cause a conflict exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         DeleteDetector: A conflict exception will occur if the detector has associated <code>Rules</code> or
     *         <code>DetectorVersions</code>. You can only delete a detector if it has no <code>Rules</code> or
     *         <code>DetectorVersions</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DeleteDetectorVersion: A conflict exception will occur if the <code>DetectorVersion</code> status is
     *         <code>ACTIVE</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DeleteRule: A conflict exception will occur if the <code>RuleVersion</code> is in use by an associated
     *         <code>ACTIVE</code> or <code>INACTIVE DetectorVersion</code>.
     *         </p>
     *         </li>
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.DeleteEntityType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteEntityType" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteEntityTypeResponse deleteEntityType(Consumer<DeleteEntityTypeRequest.Builder> deleteEntityTypeRequest)
            throws ValidationException, ConflictException, InternalServerException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        return deleteEntityType(DeleteEntityTypeRequest.builder().applyMutation(deleteEntityTypeRequest).build());
    }

    /**
     * <p>
     * Deletes the specified event.
     * </p>
     * <p>
     * When you delete an event, Amazon Fraud Detector permanently deletes that event and the event data is no longer
     * stored in Amazon Fraud Detector.
     * </p>
     *
     * @param deleteEventRequest
     * @return Result of the DeleteEvent operation returned by the service.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.DeleteEvent
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteEvent" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteEventResponse deleteEvent(DeleteEventRequest deleteEventRequest) throws InternalServerException,
            ThrottlingException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified event.
     * </p>
     * <p>
     * When you delete an event, Amazon Fraud Detector permanently deletes that event and the event data is no longer
     * stored in Amazon Fraud Detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEventRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteEventRequest#builder()}
     * </p>
     *
     * @param deleteEventRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEventRequest.Builder} to create a request.
     * @return Result of the DeleteEvent operation returned by the service.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.DeleteEvent
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteEvent" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteEventResponse deleteEvent(Consumer<DeleteEventRequest.Builder> deleteEventRequest)
            throws InternalServerException, ThrottlingException, AccessDeniedException, ValidationException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        return deleteEvent(DeleteEventRequest.builder().applyMutation(deleteEventRequest).build());
    }

    /**
     * <p>
     * Deletes an event type.
     * </p>
     * <p>
     * You cannot delete an event type that is used in a detector or a model.
     * </p>
     * <p>
     * When you delete an entity type, Amazon Fraud Detector permanently deletes that entity type and the data is no
     * longer stored in Amazon Fraud Detector.
     * </p>
     *
     * @param deleteEventTypeRequest
     * @return Result of the DeleteEventType operation returned by the service.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation. The following delete operations
     *         can cause a conflict exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         DeleteDetector: A conflict exception will occur if the detector has associated <code>Rules</code> or
     *         <code>DetectorVersions</code>. You can only delete a detector if it has no <code>Rules</code> or
     *         <code>DetectorVersions</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DeleteDetectorVersion: A conflict exception will occur if the <code>DetectorVersion</code> status is
     *         <code>ACTIVE</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DeleteRule: A conflict exception will occur if the <code>RuleVersion</code> is in use by an associated
     *         <code>ACTIVE</code> or <code>INACTIVE DetectorVersion</code>.
     *         </p>
     *         </li>
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.DeleteEventType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteEventType" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteEventTypeResponse deleteEventType(DeleteEventTypeRequest deleteEventTypeRequest) throws ConflictException,
            ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an event type.
     * </p>
     * <p>
     * You cannot delete an event type that is used in a detector or a model.
     * </p>
     * <p>
     * When you delete an entity type, Amazon Fraud Detector permanently deletes that entity type and the data is no
     * longer stored in Amazon Fraud Detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEventTypeRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteEventTypeRequest#builder()}
     * </p>
     *
     * @param deleteEventTypeRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEventTypeRequest.Builder} to create a request.
     * @return Result of the DeleteEventType operation returned by the service.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation. The following delete operations
     *         can cause a conflict exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         DeleteDetector: A conflict exception will occur if the detector has associated <code>Rules</code> or
     *         <code>DetectorVersions</code>. You can only delete a detector if it has no <code>Rules</code> or
     *         <code>DetectorVersions</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DeleteDetectorVersion: A conflict exception will occur if the <code>DetectorVersion</code> status is
     *         <code>ACTIVE</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DeleteRule: A conflict exception will occur if the <code>RuleVersion</code> is in use by an associated
     *         <code>ACTIVE</code> or <code>INACTIVE DetectorVersion</code>.
     *         </p>
     *         </li>
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.DeleteEventType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteEventType" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteEventTypeResponse deleteEventType(Consumer<DeleteEventTypeRequest.Builder> deleteEventTypeRequest)
            throws ConflictException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        return deleteEventType(DeleteEventTypeRequest.builder().applyMutation(deleteEventTypeRequest).build());
    }

    /**
     * <p>
     * Removes a SageMaker model from Amazon Fraud Detector.
     * </p>
     * <p>
     * You can remove an Amazon SageMaker model if it is not associated with a detector version. Removing a SageMaker
     * model disconnects it from Amazon Fraud Detector, but the model remains available in SageMaker.
     * </p>
     *
     * @param deleteExternalModelRequest
     * @return Result of the DeleteExternalModel operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation. The following delete operations
     *         can cause a conflict exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         DeleteDetector: A conflict exception will occur if the detector has associated <code>Rules</code> or
     *         <code>DetectorVersions</code>. You can only delete a detector if it has no <code>Rules</code> or
     *         <code>DetectorVersions</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DeleteDetectorVersion: A conflict exception will occur if the <code>DetectorVersion</code> status is
     *         <code>ACTIVE</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DeleteRule: A conflict exception will occur if the <code>RuleVersion</code> is in use by an associated
     *         <code>ACTIVE</code> or <code>INACTIVE DetectorVersion</code>.
     *         </p>
     *         </li>
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.DeleteExternalModel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteExternalModel"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteExternalModelResponse deleteExternalModel(DeleteExternalModelRequest deleteExternalModelRequest)
            throws ValidationException, ConflictException, InternalServerException, ThrottlingException, AccessDeniedException,
            AwsServiceException, SdkClientException, FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a SageMaker model from Amazon Fraud Detector.
     * </p>
     * <p>
     * You can remove an Amazon SageMaker model if it is not associated with a detector version. Removing a SageMaker
     * model disconnects it from Amazon Fraud Detector, but the model remains available in SageMaker.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteExternalModelRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteExternalModelRequest#builder()}
     * </p>
     *
     * @param deleteExternalModelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteExternalModelRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteExternalModel operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation. The following delete operations
     *         can cause a conflict exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         DeleteDetector: A conflict exception will occur if the detector has associated <code>Rules</code> or
     *         <code>DetectorVersions</code>. You can only delete a detector if it has no <code>Rules</code> or
     *         <code>DetectorVersions</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DeleteDetectorVersion: A conflict exception will occur if the <code>DetectorVersion</code> status is
     *         <code>ACTIVE</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DeleteRule: A conflict exception will occur if the <code>RuleVersion</code> is in use by an associated
     *         <code>ACTIVE</code> or <code>INACTIVE DetectorVersion</code>.
     *         </p>
     *         </li>
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.DeleteExternalModel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteExternalModel"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteExternalModelResponse deleteExternalModel(
            Consumer<DeleteExternalModelRequest.Builder> deleteExternalModelRequest) throws ValidationException,
            ConflictException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        return deleteExternalModel(DeleteExternalModelRequest.builder().applyMutation(deleteExternalModelRequest).build());
    }

    /**
     * <p>
     * Deletes a label.
     * </p>
     * <p>
     * You cannot delete labels that are included in an event type in Amazon Fraud Detector.
     * </p>
     * <p>
     * You cannot delete a label assigned to an event ID. You must first delete the relevant event ID.
     * </p>
     * <p>
     * When you delete a label, Amazon Fraud Detector permanently deletes that label and the data is no longer stored in
     * Amazon Fraud Detector.
     * </p>
     *
     * @param deleteLabelRequest
     * @return Result of the DeleteLabel operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation. The following delete operations
     *         can cause a conflict exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         DeleteDetector: A conflict exception will occur if the detector has associated <code>Rules</code> or
     *         <code>DetectorVersions</code>. You can only delete a detector if it has no <code>Rules</code> or
     *         <code>DetectorVersions</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DeleteDetectorVersion: A conflict exception will occur if the <code>DetectorVersion</code> status is
     *         <code>ACTIVE</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DeleteRule: A conflict exception will occur if the <code>RuleVersion</code> is in use by an associated
     *         <code>ACTIVE</code> or <code>INACTIVE DetectorVersion</code>.
     *         </p>
     *         </li>
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.DeleteLabel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteLabel" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteLabelResponse deleteLabel(DeleteLabelRequest deleteLabelRequest) throws ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a label.
     * </p>
     * <p>
     * You cannot delete labels that are included in an event type in Amazon Fraud Detector.
     * </p>
     * <p>
     * You cannot delete a label assigned to an event ID. You must first delete the relevant event ID.
     * </p>
     * <p>
     * When you delete a label, Amazon Fraud Detector permanently deletes that label and the data is no longer stored in
     * Amazon Fraud Detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLabelRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteLabelRequest#builder()}
     * </p>
     *
     * @param deleteLabelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteLabelRequest.Builder} to create a request.
     * @return Result of the DeleteLabel operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation. The following delete operations
     *         can cause a conflict exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         DeleteDetector: A conflict exception will occur if the detector has associated <code>Rules</code> or
     *         <code>DetectorVersions</code>. You can only delete a detector if it has no <code>Rules</code> or
     *         <code>DetectorVersions</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DeleteDetectorVersion: A conflict exception will occur if the <code>DetectorVersion</code> status is
     *         <code>ACTIVE</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DeleteRule: A conflict exception will occur if the <code>RuleVersion</code> is in use by an associated
     *         <code>ACTIVE</code> or <code>INACTIVE DetectorVersion</code>.
     *         </p>
     *         </li>
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.DeleteLabel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteLabel" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteLabelResponse deleteLabel(Consumer<DeleteLabelRequest.Builder> deleteLabelRequest) throws ValidationException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, FraudDetectorException {
        return deleteLabel(DeleteLabelRequest.builder().applyMutation(deleteLabelRequest).build());
    }

    /**
     * <p>
     * Deletes a model.
     * </p>
     * <p>
     * You can delete models and model versions in Amazon Fraud Detector, provided that they are not associated with a
     * detector version.
     * </p>
     * <p>
     * When you delete a model, Amazon Fraud Detector permanently deletes that model and the data is no longer stored in
     * Amazon Fraud Detector.
     * </p>
     *
     * @param deleteModelRequest
     * @return Result of the DeleteModel operation returned by the service.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation. The following delete operations
     *         can cause a conflict exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         DeleteDetector: A conflict exception will occur if the detector has associated <code>Rules</code> or
     *         <code>DetectorVersions</code>. You can only delete a detector if it has no <code>Rules</code> or
     *         <code>DetectorVersions</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DeleteDetectorVersion: A conflict exception will occur if the <code>DetectorVersion</code> status is
     *         <code>ACTIVE</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DeleteRule: A conflict exception will occur if the <code>RuleVersion</code> is in use by an associated
     *         <code>ACTIVE</code> or <code>INACTIVE DetectorVersion</code>.
     *         </p>
     *         </li>
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.DeleteModel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteModel" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteModelResponse deleteModel(DeleteModelRequest deleteModelRequest) throws ConflictException, ValidationException,
            InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a model.
     * </p>
     * <p>
     * You can delete models and model versions in Amazon Fraud Detector, provided that they are not associated with a
     * detector version.
     * </p>
     * <p>
     * When you delete a model, Amazon Fraud Detector permanently deletes that model and the data is no longer stored in
     * Amazon Fraud Detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteModelRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteModelRequest#builder()}
     * </p>
     *
     * @param deleteModelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteModelRequest.Builder} to create a request.
     * @return Result of the DeleteModel operation returned by the service.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation. The following delete operations
     *         can cause a conflict exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         DeleteDetector: A conflict exception will occur if the detector has associated <code>Rules</code> or
     *         <code>DetectorVersions</code>. You can only delete a detector if it has no <code>Rules</code> or
     *         <code>DetectorVersions</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DeleteDetectorVersion: A conflict exception will occur if the <code>DetectorVersion</code> status is
     *         <code>ACTIVE</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DeleteRule: A conflict exception will occur if the <code>RuleVersion</code> is in use by an associated
     *         <code>ACTIVE</code> or <code>INACTIVE DetectorVersion</code>.
     *         </p>
     *         </li>
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.DeleteModel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteModel" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteModelResponse deleteModel(Consumer<DeleteModelRequest.Builder> deleteModelRequest) throws ConflictException,
            ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        return deleteModel(DeleteModelRequest.builder().applyMutation(deleteModelRequest).build());
    }

    /**
     * <p>
     * Deletes a model version.
     * </p>
     * <p>
     * You can delete models and model versions in Amazon Fraud Detector, provided that they are not associated with a
     * detector version.
     * </p>
     * <p>
     * When you delete a model version, Amazon Fraud Detector permanently deletes that model version and the data is no
     * longer stored in Amazon Fraud Detector.
     * </p>
     *
     * @param deleteModelVersionRequest
     * @return Result of the DeleteModelVersion operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation. The following delete operations
     *         can cause a conflict exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         DeleteDetector: A conflict exception will occur if the detector has associated <code>Rules</code> or
     *         <code>DetectorVersions</code>. You can only delete a detector if it has no <code>Rules</code> or
     *         <code>DetectorVersions</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DeleteDetectorVersion: A conflict exception will occur if the <code>DetectorVersion</code> status is
     *         <code>ACTIVE</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DeleteRule: A conflict exception will occur if the <code>RuleVersion</code> is in use by an associated
     *         <code>ACTIVE</code> or <code>INACTIVE DetectorVersion</code>.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.DeleteModelVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteModelVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteModelVersionResponse deleteModelVersion(DeleteModelVersionRequest deleteModelVersionRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ConflictException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a model version.
     * </p>
     * <p>
     * You can delete models and model versions in Amazon Fraud Detector, provided that they are not associated with a
     * detector version.
     * </p>
     * <p>
     * When you delete a model version, Amazon Fraud Detector permanently deletes that model version and the data is no
     * longer stored in Amazon Fraud Detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteModelVersionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteModelVersionRequest#builder()}
     * </p>
     *
     * @param deleteModelVersionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteModelVersionRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteModelVersion operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation. The following delete operations
     *         can cause a conflict exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         DeleteDetector: A conflict exception will occur if the detector has associated <code>Rules</code> or
     *         <code>DetectorVersions</code>. You can only delete a detector if it has no <code>Rules</code> or
     *         <code>DetectorVersions</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DeleteDetectorVersion: A conflict exception will occur if the <code>DetectorVersion</code> status is
     *         <code>ACTIVE</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DeleteRule: A conflict exception will occur if the <code>RuleVersion</code> is in use by an associated
     *         <code>ACTIVE</code> or <code>INACTIVE DetectorVersion</code>.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.DeleteModelVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteModelVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteModelVersionResponse deleteModelVersion(Consumer<DeleteModelVersionRequest.Builder> deleteModelVersionRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, ConflictException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        return deleteModelVersion(DeleteModelVersionRequest.builder().applyMutation(deleteModelVersionRequest).build());
    }

    /**
     * <p>
     * Deletes an outcome.
     * </p>
     * <p>
     * You cannot delete an outcome that is used in a rule version.
     * </p>
     * <p>
     * When you delete an outcome, Amazon Fraud Detector permanently deletes that outcome and the data is no longer
     * stored in Amazon Fraud Detector.
     * </p>
     *
     * @param deleteOutcomeRequest
     * @return Result of the DeleteOutcome operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation. The following delete operations
     *         can cause a conflict exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         DeleteDetector: A conflict exception will occur if the detector has associated <code>Rules</code> or
     *         <code>DetectorVersions</code>. You can only delete a detector if it has no <code>Rules</code> or
     *         <code>DetectorVersions</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DeleteDetectorVersion: A conflict exception will occur if the <code>DetectorVersion</code> status is
     *         <code>ACTIVE</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DeleteRule: A conflict exception will occur if the <code>RuleVersion</code> is in use by an associated
     *         <code>ACTIVE</code> or <code>INACTIVE DetectorVersion</code>.
     *         </p>
     *         </li>
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.DeleteOutcome
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteOutcome" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteOutcomeResponse deleteOutcome(DeleteOutcomeRequest deleteOutcomeRequest) throws ValidationException,
            InternalServerException, ThrottlingException, ConflictException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an outcome.
     * </p>
     * <p>
     * You cannot delete an outcome that is used in a rule version.
     * </p>
     * <p>
     * When you delete an outcome, Amazon Fraud Detector permanently deletes that outcome and the data is no longer
     * stored in Amazon Fraud Detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOutcomeRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteOutcomeRequest#builder()}
     * </p>
     *
     * @param deleteOutcomeRequest
     *        A {@link Consumer} that will call methods on {@link DeleteOutcomeRequest.Builder} to create a request.
     * @return Result of the DeleteOutcome operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation. The following delete operations
     *         can cause a conflict exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         DeleteDetector: A conflict exception will occur if the detector has associated <code>Rules</code> or
     *         <code>DetectorVersions</code>. You can only delete a detector if it has no <code>Rules</code> or
     *         <code>DetectorVersions</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DeleteDetectorVersion: A conflict exception will occur if the <code>DetectorVersion</code> status is
     *         <code>ACTIVE</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DeleteRule: A conflict exception will occur if the <code>RuleVersion</code> is in use by an associated
     *         <code>ACTIVE</code> or <code>INACTIVE DetectorVersion</code>.
     *         </p>
     *         </li>
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.DeleteOutcome
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteOutcome" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteOutcomeResponse deleteOutcome(Consumer<DeleteOutcomeRequest.Builder> deleteOutcomeRequest)
            throws ValidationException, InternalServerException, ThrottlingException, ConflictException, AccessDeniedException,
            AwsServiceException, SdkClientException, FraudDetectorException {
        return deleteOutcome(DeleteOutcomeRequest.builder().applyMutation(deleteOutcomeRequest).build());
    }

    /**
     * <p>
     * Deletes the rule. You cannot delete a rule if it is used by an <code>ACTIVE</code> or <code>INACTIVE</code>
     * detector version.
     * </p>
     * <p>
     * When you delete a rule, Amazon Fraud Detector permanently deletes that rule and the data is no longer stored in
     * Amazon Fraud Detector.
     * </p>
     *
     * @param deleteRuleRequest
     * @return Result of the DeleteRule operation returned by the service.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation. The following delete operations
     *         can cause a conflict exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         DeleteDetector: A conflict exception will occur if the detector has associated <code>Rules</code> or
     *         <code>DetectorVersions</code>. You can only delete a detector if it has no <code>Rules</code> or
     *         <code>DetectorVersions</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DeleteDetectorVersion: A conflict exception will occur if the <code>DetectorVersion</code> status is
     *         <code>ACTIVE</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DeleteRule: A conflict exception will occur if the <code>RuleVersion</code> is in use by an associated
     *         <code>ACTIVE</code> or <code>INACTIVE DetectorVersion</code>.
     *         </p>
     *         </li>
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.DeleteRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteRule" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteRuleResponse deleteRule(DeleteRuleRequest deleteRuleRequest) throws ConflictException, ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the rule. You cannot delete a rule if it is used by an <code>ACTIVE</code> or <code>INACTIVE</code>
     * detector version.
     * </p>
     * <p>
     * When you delete a rule, Amazon Fraud Detector permanently deletes that rule and the data is no longer stored in
     * Amazon Fraud Detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRuleRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteRuleRequest#builder()}
     * </p>
     *
     * @param deleteRuleRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRuleRequest.Builder} to create a request.
     * @return Result of the DeleteRule operation returned by the service.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation. The following delete operations
     *         can cause a conflict exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         DeleteDetector: A conflict exception will occur if the detector has associated <code>Rules</code> or
     *         <code>DetectorVersions</code>. You can only delete a detector if it has no <code>Rules</code> or
     *         <code>DetectorVersions</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DeleteDetectorVersion: A conflict exception will occur if the <code>DetectorVersion</code> status is
     *         <code>ACTIVE</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DeleteRule: A conflict exception will occur if the <code>RuleVersion</code> is in use by an associated
     *         <code>ACTIVE</code> or <code>INACTIVE DetectorVersion</code>.
     *         </p>
     *         </li>
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.DeleteRule
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteRule" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteRuleResponse deleteRule(Consumer<DeleteRuleRequest.Builder> deleteRuleRequest) throws ConflictException,
            ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        return deleteRule(DeleteRuleRequest.builder().applyMutation(deleteRuleRequest).build());
    }

    /**
     * <p>
     * Deletes a variable.
     * </p>
     * <p>
     * You can't delete variables that are included in an event type in Amazon Fraud Detector.
     * </p>
     * <p>
     * Amazon Fraud Detector automatically deletes model output variables and SageMaker model output variables when you
     * delete the model. You can't delete these variables manually.
     * </p>
     * <p>
     * When you delete a variable, Amazon Fraud Detector permanently deletes that variable and the data is no longer
     * stored in Amazon Fraud Detector.
     * </p>
     *
     * @param deleteVariableRequest
     * @return Result of the DeleteVariable operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation. The following delete operations
     *         can cause a conflict exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         DeleteDetector: A conflict exception will occur if the detector has associated <code>Rules</code> or
     *         <code>DetectorVersions</code>. You can only delete a detector if it has no <code>Rules</code> or
     *         <code>DetectorVersions</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DeleteDetectorVersion: A conflict exception will occur if the <code>DetectorVersion</code> status is
     *         <code>ACTIVE</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DeleteRule: A conflict exception will occur if the <code>RuleVersion</code> is in use by an associated
     *         <code>ACTIVE</code> or <code>INACTIVE DetectorVersion</code>.
     *         </p>
     *         </li>
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.DeleteVariable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteVariable" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteVariableResponse deleteVariable(DeleteVariableRequest deleteVariableRequest) throws ValidationException,
            ConflictException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a variable.
     * </p>
     * <p>
     * You can't delete variables that are included in an event type in Amazon Fraud Detector.
     * </p>
     * <p>
     * Amazon Fraud Detector automatically deletes model output variables and SageMaker model output variables when you
     * delete the model. You can't delete these variables manually.
     * </p>
     * <p>
     * When you delete a variable, Amazon Fraud Detector permanently deletes that variable and the data is no longer
     * stored in Amazon Fraud Detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVariableRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteVariableRequest#builder()}
     * </p>
     *
     * @param deleteVariableRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVariableRequest.Builder} to create a request.
     * @return Result of the DeleteVariable operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation. The following delete operations
     *         can cause a conflict exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         DeleteDetector: A conflict exception will occur if the detector has associated <code>Rules</code> or
     *         <code>DetectorVersions</code>. You can only delete a detector if it has no <code>Rules</code> or
     *         <code>DetectorVersions</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DeleteDetectorVersion: A conflict exception will occur if the <code>DetectorVersion</code> status is
     *         <code>ACTIVE</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DeleteRule: A conflict exception will occur if the <code>RuleVersion</code> is in use by an associated
     *         <code>ACTIVE</code> or <code>INACTIVE DetectorVersion</code>.
     *         </p>
     *         </li>
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.DeleteVariable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteVariable" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteVariableResponse deleteVariable(Consumer<DeleteVariableRequest.Builder> deleteVariableRequest)
            throws ValidationException, ConflictException, InternalServerException, ThrottlingException, AccessDeniedException,
            AwsServiceException, SdkClientException, FraudDetectorException {
        return deleteVariable(DeleteVariableRequest.builder().applyMutation(deleteVariableRequest).build());
    }

    /**
     * <p>
     * Gets all versions for a specified detector.
     * </p>
     *
     * @param describeDetectorRequest
     * @return Result of the DescribeDetector operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.DescribeDetector
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DescribeDetector" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDetectorResponse describeDetector(DescribeDetectorRequest describeDetectorRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all versions for a specified detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDetectorRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeDetectorRequest#builder()}
     * </p>
     *
     * @param describeDetectorRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDetectorRequest.Builder} to create a request.
     * @return Result of the DescribeDetector operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.DescribeDetector
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DescribeDetector" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDetectorResponse describeDetector(Consumer<DescribeDetectorRequest.Builder> describeDetectorRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, FraudDetectorException {
        return describeDetector(DescribeDetectorRequest.builder().applyMutation(describeDetectorRequest).build());
    }

    /**
     * <p>
     * Gets all of the model versions for the specified model type or for the specified model type and model ID. You can
     * also get details for a single, specified model version.
     * </p>
     *
     * @param describeModelVersionsRequest
     * @return Result of the DescribeModelVersions operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.DescribeModelVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DescribeModelVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeModelVersionsResponse describeModelVersions(DescribeModelVersionsRequest describeModelVersionsRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, AccessDeniedException,
            AwsServiceException, SdkClientException, FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all of the model versions for the specified model type or for the specified model type and model ID. You can
     * also get details for a single, specified model version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeModelVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeModelVersionsRequest#builder()}
     * </p>
     *
     * @param describeModelVersionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeModelVersionsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeModelVersions operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.DescribeModelVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DescribeModelVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeModelVersionsResponse describeModelVersions(
            Consumer<DescribeModelVersionsRequest.Builder> describeModelVersionsRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        return describeModelVersions(DescribeModelVersionsRequest.builder().applyMutation(describeModelVersionsRequest).build());
    }

    /**
     * <p>
     * Gets all of the model versions for the specified model type or for the specified model type and model ID. You can
     * also get details for a single, specified model version.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeModelVersions(software.amazon.awssdk.services.frauddetector.model.DescribeModelVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.DescribeModelVersionsIterable responses = client.describeModelVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.frauddetector.paginators.DescribeModelVersionsIterable responses = client
     *             .describeModelVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.frauddetector.model.DescribeModelVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.DescribeModelVersionsIterable responses = client.describeModelVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeModelVersions(software.amazon.awssdk.services.frauddetector.model.DescribeModelVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeModelVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.DescribeModelVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DescribeModelVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeModelVersionsIterable describeModelVersionsPaginator(DescribeModelVersionsRequest describeModelVersionsRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, AccessDeniedException,
            AwsServiceException, SdkClientException, FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all of the model versions for the specified model type or for the specified model type and model ID. You can
     * also get details for a single, specified model version.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeModelVersions(software.amazon.awssdk.services.frauddetector.model.DescribeModelVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.DescribeModelVersionsIterable responses = client.describeModelVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.frauddetector.paginators.DescribeModelVersionsIterable responses = client
     *             .describeModelVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.frauddetector.model.DescribeModelVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.DescribeModelVersionsIterable responses = client.describeModelVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeModelVersions(software.amazon.awssdk.services.frauddetector.model.DescribeModelVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeModelVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeModelVersionsRequest#builder()}
     * </p>
     *
     * @param describeModelVersionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeModelVersionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.DescribeModelVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DescribeModelVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeModelVersionsIterable describeModelVersionsPaginator(
            Consumer<DescribeModelVersionsRequest.Builder> describeModelVersionsRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        return describeModelVersionsPaginator(DescribeModelVersionsRequest.builder().applyMutation(describeModelVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Gets a particular detector version.
     * </p>
     *
     * @param getDetectorVersionRequest
     * @return Result of the GetDetectorVersion operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetDetectorVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetDetectorVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDetectorVersionResponse getDetectorVersion(GetDetectorVersionRequest getDetectorVersionRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a particular detector version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDetectorVersionRequest.Builder} avoiding the
     * need to create one manually via {@link GetDetectorVersionRequest#builder()}
     * </p>
     *
     * @param getDetectorVersionRequest
     *        A {@link Consumer} that will call methods on {@link GetDetectorVersionRequest.Builder} to create a
     *        request.
     * @return Result of the GetDetectorVersion operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetDetectorVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetDetectorVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDetectorVersionResponse getDetectorVersion(Consumer<GetDetectorVersionRequest.Builder> getDetectorVersionRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, FraudDetectorException {
        return getDetectorVersion(GetDetectorVersionRequest.builder().applyMutation(getDetectorVersionRequest).build());
    }

    /**
     * <p>
     * Gets all detectors or a single detector if a <code>detectorId</code> is specified. This is a paginated API. If
     * you provide a null <code>maxResults</code>, this action retrieves a maximum of 10 records per page. If you
     * provide a <code>maxResults</code>, the value must be between 5 and 10. To get the next page results, provide the
     * pagination token from the <code>GetDetectorsResponse</code> as part of your request. A null pagination token
     * fetches the records from the beginning.
     * </p>
     *
     * @param getDetectorsRequest
     * @return Result of the GetDetectors operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetDetectors
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetDetectors" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDetectorsResponse getDetectors(GetDetectorsRequest getDetectorsRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all detectors or a single detector if a <code>detectorId</code> is specified. This is a paginated API. If
     * you provide a null <code>maxResults</code>, this action retrieves a maximum of 10 records per page. If you
     * provide a <code>maxResults</code>, the value must be between 5 and 10. To get the next page results, provide the
     * pagination token from the <code>GetDetectorsResponse</code> as part of your request. A null pagination token
     * fetches the records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDetectorsRequest.Builder} avoiding the need to
     * create one manually via {@link GetDetectorsRequest#builder()}
     * </p>
     *
     * @param getDetectorsRequest
     *        A {@link Consumer} that will call methods on {@link GetDetectorsRequest.Builder} to create a request.
     * @return Result of the GetDetectors operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetDetectors
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetDetectors" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDetectorsResponse getDetectors(Consumer<GetDetectorsRequest.Builder> getDetectorsRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, FraudDetectorException {
        return getDetectors(GetDetectorsRequest.builder().applyMutation(getDetectorsRequest).build());
    }

    /**
     * <p>
     * Gets all detectors or a single detector if a <code>detectorId</code> is specified. This is a paginated API. If
     * you provide a null <code>maxResults</code>, this action retrieves a maximum of 10 records per page. If you
     * provide a <code>maxResults</code>, the value must be between 5 and 10. To get the next page results, provide the
     * pagination token from the <code>GetDetectorsResponse</code> as part of your request. A null pagination token
     * fetches the records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getDetectors(software.amazon.awssdk.services.frauddetector.model.GetDetectorsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetDetectorsIterable responses = client.getDetectorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.frauddetector.paginators.GetDetectorsIterable responses = client
     *             .getDetectorsPaginator(request);
     *     for (software.amazon.awssdk.services.frauddetector.model.GetDetectorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetDetectorsIterable responses = client.getDetectorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDetectors(software.amazon.awssdk.services.frauddetector.model.GetDetectorsRequest)} operation.</b>
     * </p>
     *
     * @param getDetectorsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetDetectors
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetDetectors" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDetectorsIterable getDetectorsPaginator(GetDetectorsRequest getDetectorsRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all detectors or a single detector if a <code>detectorId</code> is specified. This is a paginated API. If
     * you provide a null <code>maxResults</code>, this action retrieves a maximum of 10 records per page. If you
     * provide a <code>maxResults</code>, the value must be between 5 and 10. To get the next page results, provide the
     * pagination token from the <code>GetDetectorsResponse</code> as part of your request. A null pagination token
     * fetches the records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getDetectors(software.amazon.awssdk.services.frauddetector.model.GetDetectorsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetDetectorsIterable responses = client.getDetectorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.frauddetector.paginators.GetDetectorsIterable responses = client
     *             .getDetectorsPaginator(request);
     *     for (software.amazon.awssdk.services.frauddetector.model.GetDetectorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetDetectorsIterable responses = client.getDetectorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDetectors(software.amazon.awssdk.services.frauddetector.model.GetDetectorsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDetectorsRequest.Builder} avoiding the need to
     * create one manually via {@link GetDetectorsRequest#builder()}
     * </p>
     *
     * @param getDetectorsRequest
     *        A {@link Consumer} that will call methods on {@link GetDetectorsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetDetectors
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetDetectors" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDetectorsIterable getDetectorsPaginator(Consumer<GetDetectorsRequest.Builder> getDetectorsRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, FraudDetectorException {
        return getDetectorsPaginator(GetDetectorsRequest.builder().applyMutation(getDetectorsRequest).build());
    }

    /**
     * <p>
     * Gets all entity types or a specific entity type if a name is specified. This is a paginated API. If you provide a
     * null <code>maxResults</code>, this action retrieves a maximum of 10 records per page. If you provide a
     * <code>maxResults</code>, the value must be between 5 and 10. To get the next page results, provide the pagination
     * token from the <code>GetEntityTypesResponse</code> as part of your request. A null pagination token fetches the
     * records from the beginning.
     * </p>
     *
     * @param getEntityTypesRequest
     * @return Result of the GetEntityTypes operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetEntityTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEntityTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default GetEntityTypesResponse getEntityTypes(GetEntityTypesRequest getEntityTypesRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all entity types or a specific entity type if a name is specified. This is a paginated API. If you provide a
     * null <code>maxResults</code>, this action retrieves a maximum of 10 records per page. If you provide a
     * <code>maxResults</code>, the value must be between 5 and 10. To get the next page results, provide the pagination
     * token from the <code>GetEntityTypesResponse</code> as part of your request. A null pagination token fetches the
     * records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEntityTypesRequest.Builder} avoiding the need to
     * create one manually via {@link GetEntityTypesRequest#builder()}
     * </p>
     *
     * @param getEntityTypesRequest
     *        A {@link Consumer} that will call methods on {@link GetEntityTypesRequest.Builder} to create a request.
     * @return Result of the GetEntityTypes operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetEntityTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEntityTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default GetEntityTypesResponse getEntityTypes(Consumer<GetEntityTypesRequest.Builder> getEntityTypesRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, AccessDeniedException,
            AwsServiceException, SdkClientException, FraudDetectorException {
        return getEntityTypes(GetEntityTypesRequest.builder().applyMutation(getEntityTypesRequest).build());
    }

    /**
     * <p>
     * Gets all entity types or a specific entity type if a name is specified. This is a paginated API. If you provide a
     * null <code>maxResults</code>, this action retrieves a maximum of 10 records per page. If you provide a
     * <code>maxResults</code>, the value must be between 5 and 10. To get the next page results, provide the pagination
     * token from the <code>GetEntityTypesResponse</code> as part of your request. A null pagination token fetches the
     * records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getEntityTypes(software.amazon.awssdk.services.frauddetector.model.GetEntityTypesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetEntityTypesIterable responses = client.getEntityTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.frauddetector.paginators.GetEntityTypesIterable responses = client
     *             .getEntityTypesPaginator(request);
     *     for (software.amazon.awssdk.services.frauddetector.model.GetEntityTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetEntityTypesIterable responses = client.getEntityTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getEntityTypes(software.amazon.awssdk.services.frauddetector.model.GetEntityTypesRequest)} operation.</b>
     * </p>
     *
     * @param getEntityTypesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetEntityTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEntityTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default GetEntityTypesIterable getEntityTypesPaginator(GetEntityTypesRequest getEntityTypesRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, AccessDeniedException,
            AwsServiceException, SdkClientException, FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all entity types or a specific entity type if a name is specified. This is a paginated API. If you provide a
     * null <code>maxResults</code>, this action retrieves a maximum of 10 records per page. If you provide a
     * <code>maxResults</code>, the value must be between 5 and 10. To get the next page results, provide the pagination
     * token from the <code>GetEntityTypesResponse</code> as part of your request. A null pagination token fetches the
     * records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getEntityTypes(software.amazon.awssdk.services.frauddetector.model.GetEntityTypesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetEntityTypesIterable responses = client.getEntityTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.frauddetector.paginators.GetEntityTypesIterable responses = client
     *             .getEntityTypesPaginator(request);
     *     for (software.amazon.awssdk.services.frauddetector.model.GetEntityTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetEntityTypesIterable responses = client.getEntityTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getEntityTypes(software.amazon.awssdk.services.frauddetector.model.GetEntityTypesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEntityTypesRequest.Builder} avoiding the need to
     * create one manually via {@link GetEntityTypesRequest#builder()}
     * </p>
     *
     * @param getEntityTypesRequest
     *        A {@link Consumer} that will call methods on {@link GetEntityTypesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetEntityTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEntityTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default GetEntityTypesIterable getEntityTypesPaginator(Consumer<GetEntityTypesRequest.Builder> getEntityTypesRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, AccessDeniedException,
            AwsServiceException, SdkClientException, FraudDetectorException {
        return getEntityTypesPaginator(GetEntityTypesRequest.builder().applyMutation(getEntityTypesRequest).build());
    }

    /**
     * <p>
     * Evaluates an event against a detector version. If a version ID is not provided, the detector’s (
     * <code>ACTIVE</code>) version is used.
     * </p>
     *
     * @param getEventPredictionRequest
     * @return Result of the GetEventPrediction operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation. The following delete operations
     *         can cause a conflict exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         DeleteDetector: A conflict exception will occur if the detector has associated <code>Rules</code> or
     *         <code>DetectorVersions</code>. You can only delete a detector if it has no <code>Rules</code> or
     *         <code>DetectorVersions</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DeleteDetectorVersion: A conflict exception will occur if the <code>DetectorVersion</code> status is
     *         <code>ACTIVE</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DeleteRule: A conflict exception will occur if the <code>RuleVersion</code> is in use by an associated
     *         <code>ACTIVE</code> or <code>INACTIVE DetectorVersion</code>.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetEventPrediction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEventPrediction"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEventPredictionResponse getEventPrediction(GetEventPredictionRequest getEventPredictionRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Evaluates an event against a detector version. If a version ID is not provided, the detector’s (
     * <code>ACTIVE</code>) version is used.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEventPredictionRequest.Builder} avoiding the
     * need to create one manually via {@link GetEventPredictionRequest#builder()}
     * </p>
     *
     * @param getEventPredictionRequest
     *        A {@link Consumer} that will call methods on {@link GetEventPredictionRequest.Builder} to create a
     *        request.
     * @return Result of the GetEventPrediction operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws ConflictException
     *         An exception indicating there was a conflict during a delete operation. The following delete operations
     *         can cause a conflict exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         DeleteDetector: A conflict exception will occur if the detector has associated <code>Rules</code> or
     *         <code>DetectorVersions</code>. You can only delete a detector if it has no <code>Rules</code> or
     *         <code>DetectorVersions</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DeleteDetectorVersion: A conflict exception will occur if the <code>DetectorVersion</code> status is
     *         <code>ACTIVE</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DeleteRule: A conflict exception will occur if the <code>RuleVersion</code> is in use by an associated
     *         <code>ACTIVE</code> or <code>INACTIVE DetectorVersion</code>.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetEventPrediction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEventPrediction"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEventPredictionResponse getEventPrediction(Consumer<GetEventPredictionRequest.Builder> getEventPredictionRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, FraudDetectorException {
        return getEventPrediction(GetEventPredictionRequest.builder().applyMutation(getEventPredictionRequest).build());
    }

    /**
     * <p>
     * Gets all event types or a specific event type if name is provided. This is a paginated API. If you provide a null
     * <code>maxResults</code>, this action retrieves a maximum of 10 records per page. If you provide a
     * <code>maxResults</code>, the value must be between 5 and 10. To get the next page results, provide the pagination
     * token from the <code>GetEventTypesResponse</code> as part of your request. A null pagination token fetches the
     * records from the beginning.
     * </p>
     *
     * @param getEventTypesRequest
     * @return Result of the GetEventTypes operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetEventTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEventTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default GetEventTypesResponse getEventTypes(GetEventTypesRequest getEventTypesRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all event types or a specific event type if name is provided. This is a paginated API. If you provide a null
     * <code>maxResults</code>, this action retrieves a maximum of 10 records per page. If you provide a
     * <code>maxResults</code>, the value must be between 5 and 10. To get the next page results, provide the pagination
     * token from the <code>GetEventTypesResponse</code> as part of your request. A null pagination token fetches the
     * records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEventTypesRequest.Builder} avoiding the need to
     * create one manually via {@link GetEventTypesRequest#builder()}
     * </p>
     *
     * @param getEventTypesRequest
     *        A {@link Consumer} that will call methods on {@link GetEventTypesRequest.Builder} to create a request.
     * @return Result of the GetEventTypes operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetEventTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEventTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default GetEventTypesResponse getEventTypes(Consumer<GetEventTypesRequest.Builder> getEventTypesRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, AccessDeniedException,
            AwsServiceException, SdkClientException, FraudDetectorException {
        return getEventTypes(GetEventTypesRequest.builder().applyMutation(getEventTypesRequest).build());
    }

    /**
     * <p>
     * Gets all event types or a specific event type if name is provided. This is a paginated API. If you provide a null
     * <code>maxResults</code>, this action retrieves a maximum of 10 records per page. If you provide a
     * <code>maxResults</code>, the value must be between 5 and 10. To get the next page results, provide the pagination
     * token from the <code>GetEventTypesResponse</code> as part of your request. A null pagination token fetches the
     * records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getEventTypes(software.amazon.awssdk.services.frauddetector.model.GetEventTypesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetEventTypesIterable responses = client.getEventTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.frauddetector.paginators.GetEventTypesIterable responses = client
     *             .getEventTypesPaginator(request);
     *     for (software.amazon.awssdk.services.frauddetector.model.GetEventTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetEventTypesIterable responses = client.getEventTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getEventTypes(software.amazon.awssdk.services.frauddetector.model.GetEventTypesRequest)} operation.</b>
     * </p>
     *
     * @param getEventTypesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetEventTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEventTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default GetEventTypesIterable getEventTypesPaginator(GetEventTypesRequest getEventTypesRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all event types or a specific event type if name is provided. This is a paginated API. If you provide a null
     * <code>maxResults</code>, this action retrieves a maximum of 10 records per page. If you provide a
     * <code>maxResults</code>, the value must be between 5 and 10. To get the next page results, provide the pagination
     * token from the <code>GetEventTypesResponse</code> as part of your request. A null pagination token fetches the
     * records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getEventTypes(software.amazon.awssdk.services.frauddetector.model.GetEventTypesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetEventTypesIterable responses = client.getEventTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.frauddetector.paginators.GetEventTypesIterable responses = client
     *             .getEventTypesPaginator(request);
     *     for (software.amazon.awssdk.services.frauddetector.model.GetEventTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetEventTypesIterable responses = client.getEventTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getEventTypes(software.amazon.awssdk.services.frauddetector.model.GetEventTypesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEventTypesRequest.Builder} avoiding the need to
     * create one manually via {@link GetEventTypesRequest#builder()}
     * </p>
     *
     * @param getEventTypesRequest
     *        A {@link Consumer} that will call methods on {@link GetEventTypesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetEventTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEventTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default GetEventTypesIterable getEventTypesPaginator(Consumer<GetEventTypesRequest.Builder> getEventTypesRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, AccessDeniedException,
            AwsServiceException, SdkClientException, FraudDetectorException {
        return getEventTypesPaginator(GetEventTypesRequest.builder().applyMutation(getEventTypesRequest).build());
    }

    /**
     * <p>
     * Gets the details for one or more Amazon SageMaker models that have been imported into the service. This is a
     * paginated API. If you provide a null <code>maxResults</code>, this actions retrieves a maximum of 10 records per
     * page. If you provide a <code>maxResults</code>, the value must be between 5 and 10. To get the next page results,
     * provide the pagination token from the <code>GetExternalModelsResult</code> as part of your request. A null
     * pagination token fetches the records from the beginning.
     * </p>
     *
     * @param getExternalModelsRequest
     * @return Result of the GetExternalModels operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetExternalModels
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetExternalModels"
     *      target="_top">AWS API Documentation</a>
     */
    default GetExternalModelsResponse getExternalModels(GetExternalModelsRequest getExternalModelsRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the details for one or more Amazon SageMaker models that have been imported into the service. This is a
     * paginated API. If you provide a null <code>maxResults</code>, this actions retrieves a maximum of 10 records per
     * page. If you provide a <code>maxResults</code>, the value must be between 5 and 10. To get the next page results,
     * provide the pagination token from the <code>GetExternalModelsResult</code> as part of your request. A null
     * pagination token fetches the records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetExternalModelsRequest.Builder} avoiding the need
     * to create one manually via {@link GetExternalModelsRequest#builder()}
     * </p>
     *
     * @param getExternalModelsRequest
     *        A {@link Consumer} that will call methods on {@link GetExternalModelsRequest.Builder} to create a request.
     * @return Result of the GetExternalModels operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetExternalModels
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetExternalModels"
     *      target="_top">AWS API Documentation</a>
     */
    default GetExternalModelsResponse getExternalModels(Consumer<GetExternalModelsRequest.Builder> getExternalModelsRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, FraudDetectorException {
        return getExternalModels(GetExternalModelsRequest.builder().applyMutation(getExternalModelsRequest).build());
    }

    /**
     * <p>
     * Gets the details for one or more Amazon SageMaker models that have been imported into the service. This is a
     * paginated API. If you provide a null <code>maxResults</code>, this actions retrieves a maximum of 10 records per
     * page. If you provide a <code>maxResults</code>, the value must be between 5 and 10. To get the next page results,
     * provide the pagination token from the <code>GetExternalModelsResult</code> as part of your request. A null
     * pagination token fetches the records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getExternalModels(software.amazon.awssdk.services.frauddetector.model.GetExternalModelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetExternalModelsIterable responses = client.getExternalModelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.frauddetector.paginators.GetExternalModelsIterable responses = client
     *             .getExternalModelsPaginator(request);
     *     for (software.amazon.awssdk.services.frauddetector.model.GetExternalModelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetExternalModelsIterable responses = client.getExternalModelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getExternalModels(software.amazon.awssdk.services.frauddetector.model.GetExternalModelsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getExternalModelsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetExternalModels
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetExternalModels"
     *      target="_top">AWS API Documentation</a>
     */
    default GetExternalModelsIterable getExternalModelsPaginator(GetExternalModelsRequest getExternalModelsRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the details for one or more Amazon SageMaker models that have been imported into the service. This is a
     * paginated API. If you provide a null <code>maxResults</code>, this actions retrieves a maximum of 10 records per
     * page. If you provide a <code>maxResults</code>, the value must be between 5 and 10. To get the next page results,
     * provide the pagination token from the <code>GetExternalModelsResult</code> as part of your request. A null
     * pagination token fetches the records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getExternalModels(software.amazon.awssdk.services.frauddetector.model.GetExternalModelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetExternalModelsIterable responses = client.getExternalModelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.frauddetector.paginators.GetExternalModelsIterable responses = client
     *             .getExternalModelsPaginator(request);
     *     for (software.amazon.awssdk.services.frauddetector.model.GetExternalModelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetExternalModelsIterable responses = client.getExternalModelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getExternalModels(software.amazon.awssdk.services.frauddetector.model.GetExternalModelsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetExternalModelsRequest.Builder} avoiding the need
     * to create one manually via {@link GetExternalModelsRequest#builder()}
     * </p>
     *
     * @param getExternalModelsRequest
     *        A {@link Consumer} that will call methods on {@link GetExternalModelsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetExternalModels
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetExternalModels"
     *      target="_top">AWS API Documentation</a>
     */
    default GetExternalModelsIterable getExternalModelsPaginator(
            Consumer<GetExternalModelsRequest.Builder> getExternalModelsRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        return getExternalModelsPaginator(GetExternalModelsRequest.builder().applyMutation(getExternalModelsRequest).build());
    }

    /**
     * <p>
     * Gets the encryption key if a Key Management Service (KMS) customer master key (CMK) has been specified to be used
     * to encrypt content in Amazon Fraud Detector.
     * </p>
     *
     * @param getKmsEncryptionKeyRequest
     * @return Result of the GetKMSEncryptionKey operation returned by the service.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetKMSEncryptionKey
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetKMSEncryptionKey"
     *      target="_top">AWS API Documentation</a>
     */
    default GetKmsEncryptionKeyResponse getKMSEncryptionKey(GetKmsEncryptionKeyRequest getKmsEncryptionKeyRequest)
            throws ResourceNotFoundException, InternalServerException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the encryption key if a Key Management Service (KMS) customer master key (CMK) has been specified to be used
     * to encrypt content in Amazon Fraud Detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetKmsEncryptionKeyRequest.Builder} avoiding the
     * need to create one manually via {@link GetKmsEncryptionKeyRequest#builder()}
     * </p>
     *
     * @param getKmsEncryptionKeyRequest
     *        A {@link Consumer} that will call methods on {@link GetKmsEncryptionKeyRequest.Builder} to create a
     *        request.
     * @return Result of the GetKMSEncryptionKey operation returned by the service.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetKMSEncryptionKey
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetKMSEncryptionKey"
     *      target="_top">AWS API Documentation</a>
     */
    default GetKmsEncryptionKeyResponse getKMSEncryptionKey(
            Consumer<GetKmsEncryptionKeyRequest.Builder> getKmsEncryptionKeyRequest) throws ResourceNotFoundException,
            InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, FraudDetectorException {
        return getKMSEncryptionKey(GetKmsEncryptionKeyRequest.builder().applyMutation(getKmsEncryptionKeyRequest).build());
    }

    /**
     * <p>
     * Gets all labels or a specific label if name is provided. This is a paginated API. If you provide a null
     * <code>maxResults</code>, this action retrieves a maximum of 50 records per page. If you provide a
     * <code>maxResults</code>, the value must be between 10 and 50. To get the next page results, provide the
     * pagination token from the <code>GetGetLabelsResponse</code> as part of your request. A null pagination token
     * fetches the records from the beginning.
     * </p>
     *
     * @param getLabelsRequest
     * @return Result of the GetLabels operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetLabels
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetLabels" target="_top">AWS API
     *      Documentation</a>
     */
    default GetLabelsResponse getLabels(GetLabelsRequest getLabelsRequest) throws ValidationException, ResourceNotFoundException,
            InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all labels or a specific label if name is provided. This is a paginated API. If you provide a null
     * <code>maxResults</code>, this action retrieves a maximum of 50 records per page. If you provide a
     * <code>maxResults</code>, the value must be between 10 and 50. To get the next page results, provide the
     * pagination token from the <code>GetGetLabelsResponse</code> as part of your request. A null pagination token
     * fetches the records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLabelsRequest.Builder} avoiding the need to
     * create one manually via {@link GetLabelsRequest#builder()}
     * </p>
     *
     * @param getLabelsRequest
     *        A {@link Consumer} that will call methods on {@link GetLabelsRequest.Builder} to create a request.
     * @return Result of the GetLabels operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetLabels
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetLabels" target="_top">AWS API
     *      Documentation</a>
     */
    default GetLabelsResponse getLabels(Consumer<GetLabelsRequest.Builder> getLabelsRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        return getLabels(GetLabelsRequest.builder().applyMutation(getLabelsRequest).build());
    }

    /**
     * <p>
     * Gets all labels or a specific label if name is provided. This is a paginated API. If you provide a null
     * <code>maxResults</code>, this action retrieves a maximum of 50 records per page. If you provide a
     * <code>maxResults</code>, the value must be between 10 and 50. To get the next page results, provide the
     * pagination token from the <code>GetGetLabelsResponse</code> as part of your request. A null pagination token
     * fetches the records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getLabels(software.amazon.awssdk.services.frauddetector.model.GetLabelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetLabelsIterable responses = client.getLabelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.frauddetector.paginators.GetLabelsIterable responses = client.getLabelsPaginator(request);
     *     for (software.amazon.awssdk.services.frauddetector.model.GetLabelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetLabelsIterable responses = client.getLabelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getLabels(software.amazon.awssdk.services.frauddetector.model.GetLabelsRequest)} operation.</b>
     * </p>
     *
     * @param getLabelsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetLabels
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetLabels" target="_top">AWS API
     *      Documentation</a>
     */
    default GetLabelsIterable getLabelsPaginator(GetLabelsRequest getLabelsRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all labels or a specific label if name is provided. This is a paginated API. If you provide a null
     * <code>maxResults</code>, this action retrieves a maximum of 50 records per page. If you provide a
     * <code>maxResults</code>, the value must be between 10 and 50. To get the next page results, provide the
     * pagination token from the <code>GetGetLabelsResponse</code> as part of your request. A null pagination token
     * fetches the records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getLabels(software.amazon.awssdk.services.frauddetector.model.GetLabelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetLabelsIterable responses = client.getLabelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.frauddetector.paginators.GetLabelsIterable responses = client.getLabelsPaginator(request);
     *     for (software.amazon.awssdk.services.frauddetector.model.GetLabelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetLabelsIterable responses = client.getLabelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getLabels(software.amazon.awssdk.services.frauddetector.model.GetLabelsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLabelsRequest.Builder} avoiding the need to
     * create one manually via {@link GetLabelsRequest#builder()}
     * </p>
     *
     * @param getLabelsRequest
     *        A {@link Consumer} that will call methods on {@link GetLabelsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetLabels
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetLabels" target="_top">AWS API
     *      Documentation</a>
     */
    default GetLabelsIterable getLabelsPaginator(Consumer<GetLabelsRequest.Builder> getLabelsRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        return getLabelsPaginator(GetLabelsRequest.builder().applyMutation(getLabelsRequest).build());
    }

    /**
     * <p>
     * Gets the details of the specified model version.
     * </p>
     *
     * @param getModelVersionRequest
     * @return Result of the GetModelVersion operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetModelVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetModelVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default GetModelVersionResponse getModelVersion(GetModelVersionRequest getModelVersionRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the details of the specified model version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetModelVersionRequest.Builder} avoiding the need
     * to create one manually via {@link GetModelVersionRequest#builder()}
     * </p>
     *
     * @param getModelVersionRequest
     *        A {@link Consumer} that will call methods on {@link GetModelVersionRequest.Builder} to create a request.
     * @return Result of the GetModelVersion operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetModelVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetModelVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default GetModelVersionResponse getModelVersion(Consumer<GetModelVersionRequest.Builder> getModelVersionRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, AccessDeniedException,
            AwsServiceException, SdkClientException, FraudDetectorException {
        return getModelVersion(GetModelVersionRequest.builder().applyMutation(getModelVersionRequest).build());
    }

    /**
     * <p>
     * Gets one or more models. Gets all models for the AWS account if no model type and no model id provided. Gets all
     * models for the AWS account and model type, if the model type is specified but model id is not provided. Gets a
     * specific model if (model type, model id) tuple is specified.
     * </p>
     * <p>
     * This is a paginated API. If you provide a null <code>maxResults</code>, this action retrieves a maximum of 10
     * records per page. If you provide a <code>maxResults</code>, the value must be between 1 and 10. To get the next
     * page results, provide the pagination token from the response as part of your request. A null pagination token
     * fetches the records from the beginning.
     * </p>
     *
     * @param getModelsRequest
     * @return Result of the GetModels operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetModels
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetModels" target="_top">AWS API
     *      Documentation</a>
     */
    default GetModelsResponse getModels(GetModelsRequest getModelsRequest) throws ValidationException, ResourceNotFoundException,
            InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets one or more models. Gets all models for the AWS account if no model type and no model id provided. Gets all
     * models for the AWS account and model type, if the model type is specified but model id is not provided. Gets a
     * specific model if (model type, model id) tuple is specified.
     * </p>
     * <p>
     * This is a paginated API. If you provide a null <code>maxResults</code>, this action retrieves a maximum of 10
     * records per page. If you provide a <code>maxResults</code>, the value must be between 1 and 10. To get the next
     * page results, provide the pagination token from the response as part of your request. A null pagination token
     * fetches the records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetModelsRequest.Builder} avoiding the need to
     * create one manually via {@link GetModelsRequest#builder()}
     * </p>
     *
     * @param getModelsRequest
     *        A {@link Consumer} that will call methods on {@link GetModelsRequest.Builder} to create a request.
     * @return Result of the GetModels operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetModels
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetModels" target="_top">AWS API
     *      Documentation</a>
     */
    default GetModelsResponse getModels(Consumer<GetModelsRequest.Builder> getModelsRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        return getModels(GetModelsRequest.builder().applyMutation(getModelsRequest).build());
    }

    /**
     * <p>
     * Gets one or more models. Gets all models for the AWS account if no model type and no model id provided. Gets all
     * models for the AWS account and model type, if the model type is specified but model id is not provided. Gets a
     * specific model if (model type, model id) tuple is specified.
     * </p>
     * <p>
     * This is a paginated API. If you provide a null <code>maxResults</code>, this action retrieves a maximum of 10
     * records per page. If you provide a <code>maxResults</code>, the value must be between 1 and 10. To get the next
     * page results, provide the pagination token from the response as part of your request. A null pagination token
     * fetches the records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getModels(software.amazon.awssdk.services.frauddetector.model.GetModelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetModelsIterable responses = client.getModelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.frauddetector.paginators.GetModelsIterable responses = client.getModelsPaginator(request);
     *     for (software.amazon.awssdk.services.frauddetector.model.GetModelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetModelsIterable responses = client.getModelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getModels(software.amazon.awssdk.services.frauddetector.model.GetModelsRequest)} operation.</b>
     * </p>
     *
     * @param getModelsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetModels
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetModels" target="_top">AWS API
     *      Documentation</a>
     */
    default GetModelsIterable getModelsPaginator(GetModelsRequest getModelsRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets one or more models. Gets all models for the AWS account if no model type and no model id provided. Gets all
     * models for the AWS account and model type, if the model type is specified but model id is not provided. Gets a
     * specific model if (model type, model id) tuple is specified.
     * </p>
     * <p>
     * This is a paginated API. If you provide a null <code>maxResults</code>, this action retrieves a maximum of 10
     * records per page. If you provide a <code>maxResults</code>, the value must be between 1 and 10. To get the next
     * page results, provide the pagination token from the response as part of your request. A null pagination token
     * fetches the records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getModels(software.amazon.awssdk.services.frauddetector.model.GetModelsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetModelsIterable responses = client.getModelsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.frauddetector.paginators.GetModelsIterable responses = client.getModelsPaginator(request);
     *     for (software.amazon.awssdk.services.frauddetector.model.GetModelsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetModelsIterable responses = client.getModelsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getModels(software.amazon.awssdk.services.frauddetector.model.GetModelsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetModelsRequest.Builder} avoiding the need to
     * create one manually via {@link GetModelsRequest#builder()}
     * </p>
     *
     * @param getModelsRequest
     *        A {@link Consumer} that will call methods on {@link GetModelsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetModels
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetModels" target="_top">AWS API
     *      Documentation</a>
     */
    default GetModelsIterable getModelsPaginator(Consumer<GetModelsRequest.Builder> getModelsRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        return getModelsPaginator(GetModelsRequest.builder().applyMutation(getModelsRequest).build());
    }

    /**
     * <p>
     * Gets one or more outcomes. This is a paginated API. If you provide a null <code>maxResults</code>, this actions
     * retrieves a maximum of 100 records per page. If you provide a <code>maxResults</code>, the value must be between
     * 50 and 100. To get the next page results, provide the pagination token from the <code>GetOutcomesResult</code> as
     * part of your request. A null pagination token fetches the records from the beginning.
     * </p>
     *
     * @param getOutcomesRequest
     * @return Result of the GetOutcomes operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetOutcomes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetOutcomes" target="_top">AWS API
     *      Documentation</a>
     */
    default GetOutcomesResponse getOutcomes(GetOutcomesRequest getOutcomesRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets one or more outcomes. This is a paginated API. If you provide a null <code>maxResults</code>, this actions
     * retrieves a maximum of 100 records per page. If you provide a <code>maxResults</code>, the value must be between
     * 50 and 100. To get the next page results, provide the pagination token from the <code>GetOutcomesResult</code> as
     * part of your request. A null pagination token fetches the records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOutcomesRequest.Builder} avoiding the need to
     * create one manually via {@link GetOutcomesRequest#builder()}
     * </p>
     *
     * @param getOutcomesRequest
     *        A {@link Consumer} that will call methods on {@link GetOutcomesRequest.Builder} to create a request.
     * @return Result of the GetOutcomes operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetOutcomes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetOutcomes" target="_top">AWS API
     *      Documentation</a>
     */
    default GetOutcomesResponse getOutcomes(Consumer<GetOutcomesRequest.Builder> getOutcomesRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        return getOutcomes(GetOutcomesRequest.builder().applyMutation(getOutcomesRequest).build());
    }

    /**
     * <p>
     * Gets one or more outcomes. This is a paginated API. If you provide a null <code>maxResults</code>, this actions
     * retrieves a maximum of 100 records per page. If you provide a <code>maxResults</code>, the value must be between
     * 50 and 100. To get the next page results, provide the pagination token from the <code>GetOutcomesResult</code> as
     * part of your request. A null pagination token fetches the records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getOutcomes(software.amazon.awssdk.services.frauddetector.model.GetOutcomesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetOutcomesIterable responses = client.getOutcomesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.frauddetector.paginators.GetOutcomesIterable responses = client.getOutcomesPaginator(request);
     *     for (software.amazon.awssdk.services.frauddetector.model.GetOutcomesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetOutcomesIterable responses = client.getOutcomesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getOutcomes(software.amazon.awssdk.services.frauddetector.model.GetOutcomesRequest)} operation.</b>
     * </p>
     *
     * @param getOutcomesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetOutcomes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetOutcomes" target="_top">AWS API
     *      Documentation</a>
     */
    default GetOutcomesIterable getOutcomesPaginator(GetOutcomesRequest getOutcomesRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets one or more outcomes. This is a paginated API. If you provide a null <code>maxResults</code>, this actions
     * retrieves a maximum of 100 records per page. If you provide a <code>maxResults</code>, the value must be between
     * 50 and 100. To get the next page results, provide the pagination token from the <code>GetOutcomesResult</code> as
     * part of your request. A null pagination token fetches the records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getOutcomes(software.amazon.awssdk.services.frauddetector.model.GetOutcomesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetOutcomesIterable responses = client.getOutcomesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.frauddetector.paginators.GetOutcomesIterable responses = client.getOutcomesPaginator(request);
     *     for (software.amazon.awssdk.services.frauddetector.model.GetOutcomesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetOutcomesIterable responses = client.getOutcomesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getOutcomes(software.amazon.awssdk.services.frauddetector.model.GetOutcomesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOutcomesRequest.Builder} avoiding the need to
     * create one manually via {@link GetOutcomesRequest#builder()}
     * </p>
     *
     * @param getOutcomesRequest
     *        A {@link Consumer} that will call methods on {@link GetOutcomesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetOutcomes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetOutcomes" target="_top">AWS API
     *      Documentation</a>
     */
    default GetOutcomesIterable getOutcomesPaginator(Consumer<GetOutcomesRequest.Builder> getOutcomesRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, FraudDetectorException {
        return getOutcomesPaginator(GetOutcomesRequest.builder().applyMutation(getOutcomesRequest).build());
    }

    /**
     * <p>
     * Get all rules for a detector (paginated) if <code>ruleId</code> and <code>ruleVersion</code> are not specified.
     * Gets all rules for the detector and the <code>ruleId</code> if present (paginated). Gets a specific rule if both
     * the <code>ruleId</code> and the <code>ruleVersion</code> are specified.
     * </p>
     * <p>
     * This is a paginated API. Providing null maxResults results in retrieving maximum of 100 records per page. If you
     * provide maxResults the value must be between 50 and 100. To get the next page result, a provide a pagination
     * token from GetRulesResult as part of your request. Null pagination token fetches the records from the beginning.
     * </p>
     *
     * @param getRulesRequest
     * @return Result of the GetRules operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetRules
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetRules" target="_top">AWS API
     *      Documentation</a>
     */
    default GetRulesResponse getRules(GetRulesRequest getRulesRequest) throws ValidationException, ResourceNotFoundException,
            InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get all rules for a detector (paginated) if <code>ruleId</code> and <code>ruleVersion</code> are not specified.
     * Gets all rules for the detector and the <code>ruleId</code> if present (paginated). Gets a specific rule if both
     * the <code>ruleId</code> and the <code>ruleVersion</code> are specified.
     * </p>
     * <p>
     * This is a paginated API. Providing null maxResults results in retrieving maximum of 100 records per page. If you
     * provide maxResults the value must be between 50 and 100. To get the next page result, a provide a pagination
     * token from GetRulesResult as part of your request. Null pagination token fetches the records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRulesRequest.Builder} avoiding the need to
     * create one manually via {@link GetRulesRequest#builder()}
     * </p>
     *
     * @param getRulesRequest
     *        A {@link Consumer} that will call methods on {@link GetRulesRequest.Builder} to create a request.
     * @return Result of the GetRules operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetRules
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetRules" target="_top">AWS API
     *      Documentation</a>
     */
    default GetRulesResponse getRules(Consumer<GetRulesRequest.Builder> getRulesRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        return getRules(GetRulesRequest.builder().applyMutation(getRulesRequest).build());
    }

    /**
     * <p>
     * Get all rules for a detector (paginated) if <code>ruleId</code> and <code>ruleVersion</code> are not specified.
     * Gets all rules for the detector and the <code>ruleId</code> if present (paginated). Gets a specific rule if both
     * the <code>ruleId</code> and the <code>ruleVersion</code> are specified.
     * </p>
     * <p>
     * This is a paginated API. Providing null maxResults results in retrieving maximum of 100 records per page. If you
     * provide maxResults the value must be between 50 and 100. To get the next page result, a provide a pagination
     * token from GetRulesResult as part of your request. Null pagination token fetches the records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getRules(software.amazon.awssdk.services.frauddetector.model.GetRulesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetRulesIterable responses = client.getRulesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.frauddetector.paginators.GetRulesIterable responses = client.getRulesPaginator(request);
     *     for (software.amazon.awssdk.services.frauddetector.model.GetRulesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetRulesIterable responses = client.getRulesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getRules(software.amazon.awssdk.services.frauddetector.model.GetRulesRequest)} operation.</b>
     * </p>
     *
     * @param getRulesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetRules
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetRules" target="_top">AWS API
     *      Documentation</a>
     */
    default GetRulesIterable getRulesPaginator(GetRulesRequest getRulesRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get all rules for a detector (paginated) if <code>ruleId</code> and <code>ruleVersion</code> are not specified.
     * Gets all rules for the detector and the <code>ruleId</code> if present (paginated). Gets a specific rule if both
     * the <code>ruleId</code> and the <code>ruleVersion</code> are specified.
     * </p>
     * <p>
     * This is a paginated API. Providing null maxResults results in retrieving maximum of 100 records per page. If you
     * provide maxResults the value must be between 50 and 100. To get the next page result, a provide a pagination
     * token from GetRulesResult as part of your request. Null pagination token fetches the records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getRules(software.amazon.awssdk.services.frauddetector.model.GetRulesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetRulesIterable responses = client.getRulesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.frauddetector.paginators.GetRulesIterable responses = client.getRulesPaginator(request);
     *     for (software.amazon.awssdk.services.frauddetector.model.GetRulesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetRulesIterable responses = client.getRulesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getRules(software.amazon.awssdk.services.frauddetector.model.GetRulesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRulesRequest.Builder} avoiding the need to
     * create one manually via {@link GetRulesRequest#builder()}
     * </p>
     *
     * @param getRulesRequest
     *        A {@link Consumer} that will call methods on {@link GetRulesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetRules
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetRules" target="_top">AWS API
     *      Documentation</a>
     */
    default GetRulesIterable getRulesPaginator(Consumer<GetRulesRequest.Builder> getRulesRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        return getRulesPaginator(GetRulesRequest.builder().applyMutation(getRulesRequest).build());
    }

    /**
     * <p>
     * Gets all of the variables or the specific variable. This is a paginated API. Providing null
     * <code>maxSizePerPage</code> results in retrieving maximum of 100 records per page. If you provide
     * <code>maxSizePerPage</code> the value must be between 50 and 100. To get the next page result, a provide a
     * pagination token from <code>GetVariablesResult</code> as part of your request. Null pagination token fetches the
     * records from the beginning.
     * </p>
     *
     * @param getVariablesRequest
     * @return Result of the GetVariables operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetVariables
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetVariables" target="_top">AWS API
     *      Documentation</a>
     */
    default GetVariablesResponse getVariables(GetVariablesRequest getVariablesRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all of the variables or the specific variable. This is a paginated API. Providing null
     * <code>maxSizePerPage</code> results in retrieving maximum of 100 records per page. If you provide
     * <code>maxSizePerPage</code> the value must be between 50 and 100. To get the next page result, a provide a
     * pagination token from <code>GetVariablesResult</code> as part of your request. Null pagination token fetches the
     * records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVariablesRequest.Builder} avoiding the need to
     * create one manually via {@link GetVariablesRequest#builder()}
     * </p>
     *
     * @param getVariablesRequest
     *        A {@link Consumer} that will call methods on {@link GetVariablesRequest.Builder} to create a request.
     * @return Result of the GetVariables operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetVariables
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetVariables" target="_top">AWS API
     *      Documentation</a>
     */
    default GetVariablesResponse getVariables(Consumer<GetVariablesRequest.Builder> getVariablesRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, FraudDetectorException {
        return getVariables(GetVariablesRequest.builder().applyMutation(getVariablesRequest).build());
    }

    /**
     * <p>
     * Gets all of the variables or the specific variable. This is a paginated API. Providing null
     * <code>maxSizePerPage</code> results in retrieving maximum of 100 records per page. If you provide
     * <code>maxSizePerPage</code> the value must be between 50 and 100. To get the next page result, a provide a
     * pagination token from <code>GetVariablesResult</code> as part of your request. Null pagination token fetches the
     * records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getVariables(software.amazon.awssdk.services.frauddetector.model.GetVariablesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetVariablesIterable responses = client.getVariablesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.frauddetector.paginators.GetVariablesIterable responses = client
     *             .getVariablesPaginator(request);
     *     for (software.amazon.awssdk.services.frauddetector.model.GetVariablesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetVariablesIterable responses = client.getVariablesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getVariables(software.amazon.awssdk.services.frauddetector.model.GetVariablesRequest)} operation.</b>
     * </p>
     *
     * @param getVariablesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetVariables
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetVariables" target="_top">AWS API
     *      Documentation</a>
     */
    default GetVariablesIterable getVariablesPaginator(GetVariablesRequest getVariablesRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all of the variables or the specific variable. This is a paginated API. Providing null
     * <code>maxSizePerPage</code> results in retrieving maximum of 100 records per page. If you provide
     * <code>maxSizePerPage</code> the value must be between 50 and 100. To get the next page result, a provide a
     * pagination token from <code>GetVariablesResult</code> as part of your request. Null pagination token fetches the
     * records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getVariables(software.amazon.awssdk.services.frauddetector.model.GetVariablesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetVariablesIterable responses = client.getVariablesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.frauddetector.paginators.GetVariablesIterable responses = client
     *             .getVariablesPaginator(request);
     *     for (software.amazon.awssdk.services.frauddetector.model.GetVariablesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetVariablesIterable responses = client.getVariablesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getVariables(software.amazon.awssdk.services.frauddetector.model.GetVariablesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVariablesRequest.Builder} avoiding the need to
     * create one manually via {@link GetVariablesRequest#builder()}
     * </p>
     *
     * @param getVariablesRequest
     *        A {@link Consumer} that will call methods on {@link GetVariablesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.GetVariables
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetVariables" target="_top">AWS API
     *      Documentation</a>
     */
    default GetVariablesIterable getVariablesPaginator(Consumer<GetVariablesRequest.Builder> getVariablesRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, FraudDetectorException {
        return getVariablesPaginator(GetVariablesRequest.builder().applyMutation(getVariablesRequest).build());
    }

    /**
     * <p>
     * Lists all tags associated with the resource. This is a paginated API. To get the next page results, provide the
     * pagination token from the response as part of your request. A null pagination token fetches the records from the
     * beginning.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags associated with the resource. This is a paginated API. To get the next page results, provide the
     * pagination token from the response as part of your request. A null pagination token fetches the records from the
     * beginning.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, FraudDetectorException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists all tags associated with the resource. This is a paginated API. To get the next page results, provide the
     * pagination token from the response as part of your request. A null pagination token fetches the records from the
     * beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.frauddetector.model.ListTagsForResourceRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.frauddetector.paginators.ListTagsForResourceIterable responses = client
     *             .listTagsForResourcePaginator(request);
     *     for (software.amazon.awssdk.services.frauddetector.model.ListTagsForResourceResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.frauddetector.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceIterable listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags associated with the resource. This is a paginated API. To get the next page results, provide the
     * pagination token from the response as part of your request. A null pagination token fetches the records from the
     * beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.frauddetector.model.ListTagsForResourceRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.frauddetector.paginators.ListTagsForResourceIterable responses = client
     *             .listTagsForResourcePaginator(request);
     *     for (software.amazon.awssdk.services.frauddetector.model.ListTagsForResourceResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.frauddetector.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceIterable listTagsForResourcePaginator(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, FraudDetectorException {
        return listTagsForResourcePaginator(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)
                .build());
    }

    /**
     * <p>
     * Creates or updates a detector.
     * </p>
     *
     * @param putDetectorRequest
     * @return Result of the PutDetector operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.PutDetector
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutDetector" target="_top">AWS API
     *      Documentation</a>
     */
    default PutDetectorResponse putDetector(PutDetectorRequest putDetectorRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutDetectorRequest.Builder} avoiding the need to
     * create one manually via {@link PutDetectorRequest#builder()}
     * </p>
     *
     * @param putDetectorRequest
     *        A {@link Consumer} that will call methods on {@link PutDetectorRequest.Builder} to create a request.
     * @return Result of the PutDetector operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.PutDetector
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutDetector" target="_top">AWS API
     *      Documentation</a>
     */
    default PutDetectorResponse putDetector(Consumer<PutDetectorRequest.Builder> putDetectorRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        return putDetector(PutDetectorRequest.builder().applyMutation(putDetectorRequest).build());
    }

    /**
     * <p>
     * Creates or updates an entity type. An entity represents who is performing the event. As part of a fraud
     * prediction, you pass the entity ID to indicate the specific entity who performed the event. An entity type
     * classifies the entity. Example classifications include customer, merchant, or account.
     * </p>
     *
     * @param putEntityTypeRequest
     * @return Result of the PutEntityType operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.PutEntityType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutEntityType" target="_top">AWS
     *      API Documentation</a>
     */
    default PutEntityTypeResponse putEntityType(PutEntityTypeRequest putEntityTypeRequest) throws ValidationException,
            InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates an entity type. An entity represents who is performing the event. As part of a fraud
     * prediction, you pass the entity ID to indicate the specific entity who performed the event. An entity type
     * classifies the entity. Example classifications include customer, merchant, or account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutEntityTypeRequest.Builder} avoiding the need to
     * create one manually via {@link PutEntityTypeRequest#builder()}
     * </p>
     *
     * @param putEntityTypeRequest
     *        A {@link Consumer} that will call methods on {@link PutEntityTypeRequest.Builder} to create a request.
     * @return Result of the PutEntityType operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.PutEntityType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutEntityType" target="_top">AWS
     *      API Documentation</a>
     */
    default PutEntityTypeResponse putEntityType(Consumer<PutEntityTypeRequest.Builder> putEntityTypeRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        return putEntityType(PutEntityTypeRequest.builder().applyMutation(putEntityTypeRequest).build());
    }

    /**
     * <p>
     * Creates or updates an event type. An event is a business activity that is evaluated for fraud risk. With Amazon
     * Fraud Detector, you generate fraud predictions for events. An event type defines the structure for an event sent
     * to Amazon Fraud Detector. This includes the variables sent as part of the event, the entity performing the event
     * (such as a customer), and the labels that classify the event. Example event types include online payment
     * transactions, account registrations, and authentications.
     * </p>
     *
     * @param putEventTypeRequest
     * @return Result of the PutEventType operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.PutEventType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutEventType" target="_top">AWS API
     *      Documentation</a>
     */
    default PutEventTypeResponse putEventType(PutEventTypeRequest putEventTypeRequest) throws ValidationException,
            InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates an event type. An event is a business activity that is evaluated for fraud risk. With Amazon
     * Fraud Detector, you generate fraud predictions for events. An event type defines the structure for an event sent
     * to Amazon Fraud Detector. This includes the variables sent as part of the event, the entity performing the event
     * (such as a customer), and the labels that classify the event. Example event types include online payment
     * transactions, account registrations, and authentications.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutEventTypeRequest.Builder} avoiding the need to
     * create one manually via {@link PutEventTypeRequest#builder()}
     * </p>
     *
     * @param putEventTypeRequest
     *        A {@link Consumer} that will call methods on {@link PutEventTypeRequest.Builder} to create a request.
     * @return Result of the PutEventType operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.PutEventType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutEventType" target="_top">AWS API
     *      Documentation</a>
     */
    default PutEventTypeResponse putEventType(Consumer<PutEventTypeRequest.Builder> putEventTypeRequest)
            throws ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        return putEventType(PutEventTypeRequest.builder().applyMutation(putEventTypeRequest).build());
    }

    /**
     * <p>
     * Creates or updates an Amazon SageMaker model endpoint. You can also use this action to update the configuration
     * of the model endpoint, including the IAM role and/or the mapped variables.
     * </p>
     *
     * @param putExternalModelRequest
     * @return Result of the PutExternalModel operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.PutExternalModel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutExternalModel" target="_top">AWS
     *      API Documentation</a>
     */
    default PutExternalModelResponse putExternalModel(PutExternalModelRequest putExternalModelRequest)
            throws ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates an Amazon SageMaker model endpoint. You can also use this action to update the configuration
     * of the model endpoint, including the IAM role and/or the mapped variables.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutExternalModelRequest.Builder} avoiding the need
     * to create one manually via {@link PutExternalModelRequest#builder()}
     * </p>
     *
     * @param putExternalModelRequest
     *        A {@link Consumer} that will call methods on {@link PutExternalModelRequest.Builder} to create a request.
     * @return Result of the PutExternalModel operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.PutExternalModel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutExternalModel" target="_top">AWS
     *      API Documentation</a>
     */
    default PutExternalModelResponse putExternalModel(Consumer<PutExternalModelRequest.Builder> putExternalModelRequest)
            throws ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        return putExternalModel(PutExternalModelRequest.builder().applyMutation(putExternalModelRequest).build());
    }

    /**
     * <p>
     * Specifies the Key Management Service (KMS) customer master key (CMK) to be used to encrypt content in Amazon
     * Fraud Detector.
     * </p>
     *
     * @param putKmsEncryptionKeyRequest
     * @return Result of the PutKMSEncryptionKey operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.PutKMSEncryptionKey
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutKMSEncryptionKey"
     *      target="_top">AWS API Documentation</a>
     */
    default PutKmsEncryptionKeyResponse putKMSEncryptionKey(PutKmsEncryptionKeyRequest putKmsEncryptionKeyRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, AccessDeniedException,
            AwsServiceException, SdkClientException, FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Specifies the Key Management Service (KMS) customer master key (CMK) to be used to encrypt content in Amazon
     * Fraud Detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutKmsEncryptionKeyRequest.Builder} avoiding the
     * need to create one manually via {@link PutKmsEncryptionKeyRequest#builder()}
     * </p>
     *
     * @param putKmsEncryptionKeyRequest
     *        A {@link Consumer} that will call methods on {@link PutKMSEncryptionKeyRequest.Builder} to create a
     *        request.
     * @return Result of the PutKMSEncryptionKey operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.PutKMSEncryptionKey
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutKMSEncryptionKey"
     *      target="_top">AWS API Documentation</a>
     */
    default PutKmsEncryptionKeyResponse putKMSEncryptionKey(
            Consumer<PutKmsEncryptionKeyRequest.Builder> putKmsEncryptionKeyRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        return putKMSEncryptionKey(PutKmsEncryptionKeyRequest.builder().applyMutation(putKmsEncryptionKeyRequest).build());
    }

    /**
     * <p>
     * Creates or updates label. A label classifies an event as fraudulent or legitimate. Labels are associated with
     * event types and used to train supervised machine learning models in Amazon Fraud Detector.
     * </p>
     *
     * @param putLabelRequest
     * @return Result of the PutLabel operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.PutLabel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutLabel" target="_top">AWS API
     *      Documentation</a>
     */
    default PutLabelResponse putLabel(PutLabelRequest putLabelRequest) throws ValidationException, InternalServerException,
            AccessDeniedException, AwsServiceException, SdkClientException, FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates label. A label classifies an event as fraudulent or legitimate. Labels are associated with
     * event types and used to train supervised machine learning models in Amazon Fraud Detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutLabelRequest.Builder} avoiding the need to
     * create one manually via {@link PutLabelRequest#builder()}
     * </p>
     *
     * @param putLabelRequest
     *        A {@link Consumer} that will call methods on {@link PutLabelRequest.Builder} to create a request.
     * @return Result of the PutLabel operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.PutLabel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutLabel" target="_top">AWS API
     *      Documentation</a>
     */
    default PutLabelResponse putLabel(Consumer<PutLabelRequest.Builder> putLabelRequest) throws ValidationException,
            InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, FraudDetectorException {
        return putLabel(PutLabelRequest.builder().applyMutation(putLabelRequest).build());
    }

    /**
     * <p>
     * Creates or updates an outcome.
     * </p>
     *
     * @param putOutcomeRequest
     * @return Result of the PutOutcome operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.PutOutcome
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutOutcome" target="_top">AWS API
     *      Documentation</a>
     */
    default PutOutcomeResponse putOutcome(PutOutcomeRequest putOutcomeRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates an outcome.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutOutcomeRequest.Builder} avoiding the need to
     * create one manually via {@link PutOutcomeRequest#builder()}
     * </p>
     *
     * @param putOutcomeRequest
     *        A {@link Consumer} that will call methods on {@link PutOutcomeRequest.Builder} to create a request.
     * @return Result of the PutOutcome operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.PutOutcome
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutOutcome" target="_top">AWS API
     *      Documentation</a>
     */
    default PutOutcomeResponse putOutcome(Consumer<PutOutcomeRequest.Builder> putOutcomeRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        return putOutcome(PutOutcomeRequest.builder().applyMutation(putOutcomeRequest).build());
    }

    /**
     * <p>
     * Assigns tags to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns tags to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, FraudDetectorException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates a detector version. The detector version attributes that you can update include models, external model
     * endpoints, rules, rule execution mode, and description. You can only update a <code>DRAFT</code> detector
     * version.
     * </p>
     *
     * @param updateDetectorVersionRequest
     * @return Result of the UpdateDetectorVersion operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.UpdateDetectorVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateDetectorVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDetectorVersionResponse updateDetectorVersion(UpdateDetectorVersionRequest updateDetectorVersionRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a detector version. The detector version attributes that you can update include models, external model
     * endpoints, rules, rule execution mode, and description. You can only update a <code>DRAFT</code> detector
     * version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDetectorVersionRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateDetectorVersionRequest#builder()}
     * </p>
     *
     * @param updateDetectorVersionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDetectorVersionRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateDetectorVersion operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.UpdateDetectorVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateDetectorVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDetectorVersionResponse updateDetectorVersion(
            Consumer<UpdateDetectorVersionRequest.Builder> updateDetectorVersionRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        return updateDetectorVersion(UpdateDetectorVersionRequest.builder().applyMutation(updateDetectorVersionRequest).build());
    }

    /**
     * <p>
     * Updates the detector version's description. You can update the metadata for any detector version (
     * <code>DRAFT, ACTIVE,</code> or <code>INACTIVE</code>).
     * </p>
     *
     * @param updateDetectorVersionMetadataRequest
     * @return Result of the UpdateDetectorVersionMetadata operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.UpdateDetectorVersionMetadata
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateDetectorVersionMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDetectorVersionMetadataResponse updateDetectorVersionMetadata(
            UpdateDetectorVersionMetadataRequest updateDetectorVersionMetadataRequest) throws ValidationException,
            InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the detector version's description. You can update the metadata for any detector version (
     * <code>DRAFT, ACTIVE,</code> or <code>INACTIVE</code>).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDetectorVersionMetadataRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateDetectorVersionMetadataRequest#builder()}
     * </p>
     *
     * @param updateDetectorVersionMetadataRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDetectorVersionMetadataRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateDetectorVersionMetadata operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.UpdateDetectorVersionMetadata
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateDetectorVersionMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDetectorVersionMetadataResponse updateDetectorVersionMetadata(
            Consumer<UpdateDetectorVersionMetadataRequest.Builder> updateDetectorVersionMetadataRequest)
            throws ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        return updateDetectorVersionMetadata(UpdateDetectorVersionMetadataRequest.builder()
                .applyMutation(updateDetectorVersionMetadataRequest).build());
    }

    /**
     * <p>
     * Updates the detector version’s status. You can perform the following promotions or demotions using
     * <code>UpdateDetectorVersionStatus</code>: <code>DRAFT</code> to <code>ACTIVE</code>, <code>ACTIVE</code> to
     * <code>INACTIVE</code>, and <code>INACTIVE</code> to <code>ACTIVE</code>.
     * </p>
     *
     * @param updateDetectorVersionStatusRequest
     * @return Result of the UpdateDetectorVersionStatus operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.UpdateDetectorVersionStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateDetectorVersionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDetectorVersionStatusResponse updateDetectorVersionStatus(
            UpdateDetectorVersionStatusRequest updateDetectorVersionStatusRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the detector version’s status. You can perform the following promotions or demotions using
     * <code>UpdateDetectorVersionStatus</code>: <code>DRAFT</code> to <code>ACTIVE</code>, <code>ACTIVE</code> to
     * <code>INACTIVE</code>, and <code>INACTIVE</code> to <code>ACTIVE</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDetectorVersionStatusRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateDetectorVersionStatusRequest#builder()}
     * </p>
     *
     * @param updateDetectorVersionStatusRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDetectorVersionStatusRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateDetectorVersionStatus operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.UpdateDetectorVersionStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateDetectorVersionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDetectorVersionStatusResponse updateDetectorVersionStatus(
            Consumer<UpdateDetectorVersionStatusRequest.Builder> updateDetectorVersionStatusRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        return updateDetectorVersionStatus(UpdateDetectorVersionStatusRequest.builder()
                .applyMutation(updateDetectorVersionStatusRequest).build());
    }

    /**
     * <p>
     * Updates a model. You can update the description attribute using this action.
     * </p>
     *
     * @param updateModelRequest
     * @return Result of the UpdateModel operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.UpdateModel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateModel" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateModelResponse updateModel(UpdateModelRequest updateModelRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a model. You can update the description attribute using this action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateModelRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateModelRequest#builder()}
     * </p>
     *
     * @param updateModelRequest
     *        A {@link Consumer} that will call methods on {@link UpdateModelRequest.Builder} to create a request.
     * @return Result of the UpdateModel operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.UpdateModel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateModel" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateModelResponse updateModel(Consumer<UpdateModelRequest.Builder> updateModelRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        return updateModel(UpdateModelRequest.builder().applyMutation(updateModelRequest).build());
    }

    /**
     * <p>
     * Updates a model version. Updating a model version retrains an existing model version using updated training data
     * and produces a new minor version of the model. You can update the training data set location and data access role
     * attributes using this action. This action creates and trains a new minor version of the model, for example
     * version 1.01, 1.02, 1.03.
     * </p>
     *
     * @param updateModelVersionRequest
     * @return Result of the UpdateModelVersion operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.UpdateModelVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateModelVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateModelVersionResponse updateModelVersion(UpdateModelVersionRequest updateModelVersionRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a model version. Updating a model version retrains an existing model version using updated training data
     * and produces a new minor version of the model. You can update the training data set location and data access role
     * attributes using this action. This action creates and trains a new minor version of the model, for example
     * version 1.01, 1.02, 1.03.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateModelVersionRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateModelVersionRequest#builder()}
     * </p>
     *
     * @param updateModelVersionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateModelVersionRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateModelVersion operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.UpdateModelVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateModelVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateModelVersionResponse updateModelVersion(Consumer<UpdateModelVersionRequest.Builder> updateModelVersionRequest)
            throws ValidationException, ResourceNotFoundException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, FraudDetectorException {
        return updateModelVersion(UpdateModelVersionRequest.builder().applyMutation(updateModelVersionRequest).build());
    }

    /**
     * <p>
     * Updates the status of a model version.
     * </p>
     * <p>
     * You can perform the following status updates:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Change the <code>TRAINING_COMPLETE</code> status to <code>ACTIVE</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Change <code>ACTIVE</code>to <code>INACTIVE</code>.
     * </p>
     * </li>
     * </ol>
     *
     * @param updateModelVersionStatusRequest
     * @return Result of the UpdateModelVersionStatus operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.UpdateModelVersionStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateModelVersionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateModelVersionStatusResponse updateModelVersionStatus(
            UpdateModelVersionStatusRequest updateModelVersionStatusRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the status of a model version.
     * </p>
     * <p>
     * You can perform the following status updates:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Change the <code>TRAINING_COMPLETE</code> status to <code>ACTIVE</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Change <code>ACTIVE</code>to <code>INACTIVE</code>.
     * </p>
     * </li>
     * </ol>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateModelVersionStatusRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateModelVersionStatusRequest#builder()}
     * </p>
     *
     * @param updateModelVersionStatusRequest
     *        A {@link Consumer} that will call methods on {@link UpdateModelVersionStatusRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateModelVersionStatus operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.UpdateModelVersionStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateModelVersionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateModelVersionStatusResponse updateModelVersionStatus(
            Consumer<UpdateModelVersionStatusRequest.Builder> updateModelVersionStatusRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException,
            FraudDetectorException {
        return updateModelVersionStatus(UpdateModelVersionStatusRequest.builder().applyMutation(updateModelVersionStatusRequest)
                .build());
    }

    /**
     * <p>
     * Updates a rule's metadata. The description attribute can be updated.
     * </p>
     *
     * @param updateRuleMetadataRequest
     * @return Result of the UpdateRuleMetadata operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.UpdateRuleMetadata
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateRuleMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRuleMetadataResponse updateRuleMetadata(UpdateRuleMetadataRequest updateRuleMetadataRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a rule's metadata. The description attribute can be updated.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRuleMetadataRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateRuleMetadataRequest#builder()}
     * </p>
     *
     * @param updateRuleMetadataRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRuleMetadataRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateRuleMetadata operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.UpdateRuleMetadata
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateRuleMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRuleMetadataResponse updateRuleMetadata(Consumer<UpdateRuleMetadataRequest.Builder> updateRuleMetadataRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, FraudDetectorException {
        return updateRuleMetadata(UpdateRuleMetadataRequest.builder().applyMutation(updateRuleMetadataRequest).build());
    }

    /**
     * <p>
     * Updates a rule version resulting in a new rule version. Updates a rule version resulting in a new rule version
     * (version 1, 2, 3 ...).
     * </p>
     *
     * @param updateRuleVersionRequest
     * @return Result of the UpdateRuleVersion operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.UpdateRuleVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateRuleVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRuleVersionResponse updateRuleVersion(UpdateRuleVersionRequest updateRuleVersionRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a rule version resulting in a new rule version. Updates a rule version resulting in a new rule version
     * (version 1, 2, 3 ...).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRuleVersionRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateRuleVersionRequest#builder()}
     * </p>
     *
     * @param updateRuleVersionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRuleVersionRequest.Builder} to create a request.
     * @return Result of the UpdateRuleVersion operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.UpdateRuleVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateRuleVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRuleVersionResponse updateRuleVersion(Consumer<UpdateRuleVersionRequest.Builder> updateRuleVersionRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, FraudDetectorException {
        return updateRuleVersion(UpdateRuleVersionRequest.builder().applyMutation(updateRuleVersionRequest).build());
    }

    /**
     * <p>
     * Updates a variable.
     * </p>
     *
     * @param updateVariableRequest
     * @return Result of the UpdateVariable operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.UpdateVariable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateVariable" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateVariableResponse updateVariable(UpdateVariableRequest updateVariableRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, FraudDetectorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a variable.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateVariableRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateVariableRequest#builder()}
     * </p>
     *
     * @param updateVariableRequest
     *        A {@link Consumer} that will call methods on {@link UpdateVariableRequest.Builder} to create a request.
     * @return Result of the UpdateVariable operation returned by the service.
     * @throws ValidationException
     *         An exception indicating a specified value is not allowed.
     * @throws ResourceNotFoundException
     *         An exception indicating the specified resource was not found.
     * @throws InternalServerException
     *         An exception indicating an internal server error.
     * @throws ThrottlingException
     *         An exception indicating a throttling error.
     * @throws AccessDeniedException
     *         An exception indicating Amazon Fraud Detector does not have the needed permissions. This can occur if you
     *         submit a request, such as <code>PutExternalModel</code>, that specifies a role that is not in your
     *         account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FraudDetectorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FraudDetectorClient.UpdateVariable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateVariable" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateVariableResponse updateVariable(Consumer<UpdateVariableRequest.Builder> updateVariableRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, FraudDetectorException {
        return updateVariable(UpdateVariableRequest.builder().applyMutation(updateVariableRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("frauddetector");
    }
}
