/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.frauddetector.model.MetricDataPoint;
import software.amazon.awssdk.services.frauddetector.model._metricDataPointsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrainingMetrics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrainingMetrics> {
    private static final SdkField<Float> AUC_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("auc").getter(TrainingMetrics.getter(TrainingMetrics::auc)).setter(TrainingMetrics.setter(Builder::auc)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("auc").build()}).build();
    private static final SdkField<List<MetricDataPoint>> METRIC_DATA_POINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("metricDataPoints").getter(TrainingMetrics.getter(TrainingMetrics::metricDataPoints)).setter(TrainingMetrics.setter(Builder::metricDataPoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricDataPoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricDataPoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUC_FIELD, METRIC_DATA_POINTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Float auc;
    private final List<MetricDataPoint> metricDataPoints;

    private TrainingMetrics(BuilderImpl builder) {
        this.auc = builder.auc;
        this.metricDataPoints = builder.metricDataPoints;
    }

    public final Float auc() {
        return this.auc;
    }

    public final boolean hasMetricDataPoints() {
        return this.metricDataPoints != null && !(this.metricDataPoints instanceof SdkAutoConstructList);
    }

    public final List<MetricDataPoint> metricDataPoints() {
        return this.metricDataPoints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.auc());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricDataPoints() ? this.metricDataPoints() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainingMetrics)) {
            return false;
        }
        TrainingMetrics other = (TrainingMetrics)obj;
        return Objects.equals(this.auc(), other.auc()) && this.hasMetricDataPoints() == other.hasMetricDataPoints() && Objects.equals(this.metricDataPoints(), other.metricDataPoints());
    }

    public final String toString() {
        return ToString.builder((String)"TrainingMetrics").add("Auc", (Object)this.auc()).add("MetricDataPoints", this.hasMetricDataPoints() ? this.metricDataPoints() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "auc": {
                return Optional.ofNullable(clazz.cast(this.auc()));
            }
            case "metricDataPoints": {
                return Optional.ofNullable(clazz.cast(this.metricDataPoints()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrainingMetrics, T> g) {
        return obj -> g.apply((TrainingMetrics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Float auc;
        private List<MetricDataPoint> metricDataPoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TrainingMetrics model) {
            this.auc(model.auc);
            this.metricDataPoints(model.metricDataPoints);
        }

        public final Float getAuc() {
            return this.auc;
        }

        @Override
        public final Builder auc(Float auc) {
            this.auc = auc;
            return this;
        }

        public final void setAuc(Float auc) {
            this.auc = auc;
        }

        public final Collection<MetricDataPoint.Builder> getMetricDataPoints() {
            if (this.metricDataPoints instanceof SdkAutoConstructList) {
                return null;
            }
            return this.metricDataPoints != null ? (Collection)this.metricDataPoints.stream().map(MetricDataPoint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder metricDataPoints(Collection<MetricDataPoint> metricDataPoints) {
            this.metricDataPoints = _metricDataPointsListCopier.copy(metricDataPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDataPoints(MetricDataPoint ... metricDataPoints) {
            this.metricDataPoints(Arrays.asList(metricDataPoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDataPoints(Consumer<MetricDataPoint.Builder> ... metricDataPoints) {
            this.metricDataPoints(Stream.of(metricDataPoints).map(c -> (MetricDataPoint)((MetricDataPoint.Builder)MetricDataPoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMetricDataPoints(Collection<MetricDataPoint.BuilderImpl> metricDataPoints) {
            this.metricDataPoints = _metricDataPointsListCopier.copyFromBuilder(metricDataPoints);
        }

        public TrainingMetrics build() {
            return new TrainingMetrics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrainingMetrics> {
        public Builder auc(Float var1);

        public Builder metricDataPoints(Collection<MetricDataPoint> var1);

        public Builder metricDataPoints(MetricDataPoint ... var1);

        public Builder metricDataPoints(Consumer<MetricDataPoint.Builder> ... var1);
    }
}

