/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The training data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrainingDataSource implements SdkPojo, Serializable,
        ToCopyableBuilder<TrainingDataSource.Builder, TrainingDataSource> {
    private static final SdkField<String> DATA_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TrainingDataSource::dataLocation)).setter(setter(Builder::dataLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataLocation").build()).build();

    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TrainingDataSource::dataAccessRoleArn)).setter(setter(Builder::dataAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataAccessRoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_LOCATION_FIELD,
            DATA_ACCESS_ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dataLocation;

    private final String dataAccessRoleArn;

    private TrainingDataSource(BuilderImpl builder) {
        this.dataLocation = builder.dataLocation;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
    }

    /**
     * <p>
     * The data location of the training data source.
     * </p>
     * 
     * @return The data location of the training data source.
     */
    public String dataLocation() {
        return dataLocation;
    }

    /**
     * <p>
     * The data access role ARN for the training data source.
     * </p>
     * 
     * @return The data access role ARN for the training data source.
     */
    public String dataAccessRoleArn() {
        return dataAccessRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataLocation());
        hashCode = 31 * hashCode + Objects.hashCode(dataAccessRoleArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainingDataSource)) {
            return false;
        }
        TrainingDataSource other = (TrainingDataSource) obj;
        return Objects.equals(dataLocation(), other.dataLocation())
                && Objects.equals(dataAccessRoleArn(), other.dataAccessRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TrainingDataSource").add("DataLocation", dataLocation())
                .add("DataAccessRoleArn", dataAccessRoleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataLocation":
            return Optional.ofNullable(clazz.cast(dataLocation()));
        case "dataAccessRoleArn":
            return Optional.ofNullable(clazz.cast(dataAccessRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrainingDataSource, T> g) {
        return obj -> g.apply((TrainingDataSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrainingDataSource> {
        /**
         * <p>
         * The data location of the training data source.
         * </p>
         * 
         * @param dataLocation
         *        The data location of the training data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataLocation(String dataLocation);

        /**
         * <p>
         * The data access role ARN for the training data source.
         * </p>
         * 
         * @param dataAccessRoleArn
         *        The data access role ARN for the training data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataAccessRoleArn(String dataAccessRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private String dataLocation;

        private String dataAccessRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(TrainingDataSource model) {
            dataLocation(model.dataLocation);
            dataAccessRoleArn(model.dataAccessRoleArn);
        }

        public final String getDataLocation() {
            return dataLocation;
        }

        @Override
        public final Builder dataLocation(String dataLocation) {
            this.dataLocation = dataLocation;
            return this;
        }

        public final void setDataLocation(String dataLocation) {
            this.dataLocation = dataLocation;
        }

        public final String getDataAccessRoleArn() {
            return dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        @Override
        public TrainingDataSource build() {
            return new TrainingDataSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
