/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetOutcomesResponse extends FraudDetectorResponse implements
        ToCopyableBuilder<GetOutcomesResponse.Builder, GetOutcomesResponse> {
    private static final SdkField<List<Outcome>> OUTCOMES_FIELD = SdkField
            .<List<Outcome>> builder(MarshallingType.LIST)
            .getter(getter(GetOutcomesResponse::outcomes))
            .setter(setter(Builder::outcomes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outcomes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Outcome> builder(MarshallingType.SDK_POJO)
                                            .constructor(Outcome::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetOutcomesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTCOMES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Outcome> outcomes;

    private final String nextToken;

    private GetOutcomesResponse(BuilderImpl builder) {
        super(builder);
        this.outcomes = builder.outcomes;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Outcomes property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasOutcomes() {
        return outcomes != null && !(outcomes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The outcomes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOutcomes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The outcomes.
     */
    public List<Outcome> outcomes() {
        return outcomes;
    }

    /**
     * <p>
     * The next page token for subsequent requests.
     * </p>
     * 
     * @return The next page token for subsequent requests.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(outcomes());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOutcomesResponse)) {
            return false;
        }
        GetOutcomesResponse other = (GetOutcomesResponse) obj;
        return Objects.equals(outcomes(), other.outcomes()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetOutcomesResponse").add("Outcomes", outcomes()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "outcomes":
            return Optional.ofNullable(clazz.cast(outcomes()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetOutcomesResponse, T> g) {
        return obj -> g.apply((GetOutcomesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FraudDetectorResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetOutcomesResponse> {
        /**
         * <p>
         * The outcomes.
         * </p>
         * 
         * @param outcomes
         *        The outcomes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outcomes(Collection<Outcome> outcomes);

        /**
         * <p>
         * The outcomes.
         * </p>
         * 
         * @param outcomes
         *        The outcomes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outcomes(Outcome... outcomes);

        /**
         * <p>
         * The outcomes.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Outcome>.Builder} avoiding the need to
         * create one manually via {@link List<Outcome>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Outcome>.Builder#build()} is called immediately and its
         * result is passed to {@link #outcomes(List<Outcome>)}.
         * 
         * @param outcomes
         *        a consumer that will call methods on {@link List<Outcome>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outcomes(List<Outcome>)
         */
        Builder outcomes(Consumer<Outcome.Builder>... outcomes);

        /**
         * <p>
         * The next page token for subsequent requests.
         * </p>
         * 
         * @param nextToken
         *        The next page token for subsequent requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends FraudDetectorResponse.BuilderImpl implements Builder {
        private List<Outcome> outcomes = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOutcomesResponse model) {
            super(model);
            outcomes(model.outcomes);
            nextToken(model.nextToken);
        }

        public final Collection<Outcome.Builder> getOutcomes() {
            return outcomes != null ? outcomes.stream().map(Outcome::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder outcomes(Collection<Outcome> outcomes) {
            this.outcomes = OutcomeListCopier.copy(outcomes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outcomes(Outcome... outcomes) {
            outcomes(Arrays.asList(outcomes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outcomes(Consumer<Outcome.Builder>... outcomes) {
            outcomes(Stream.of(outcomes).map(c -> Outcome.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOutcomes(Collection<Outcome.BuilderImpl> outcomes) {
            this.outcomes = OutcomeListCopier.copyFromBuilder(outcomes);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetOutcomesResponse build() {
            return new GetOutcomesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
