/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutExternalModelRequest extends FraudDetectorRequest implements
        ToCopyableBuilder<PutExternalModelRequest.Builder, PutExternalModelRequest> {
    private static final SdkField<String> MODEL_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutExternalModelRequest::modelEndpoint)).setter(setter(Builder::modelEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelEndpoint").build()).build();

    private static final SdkField<String> MODEL_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutExternalModelRequest::modelSourceAsString)).setter(setter(Builder::modelSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelSource").build()).build();

    private static final SdkField<Role> ROLE_FIELD = SdkField.<Role> builder(MarshallingType.SDK_POJO)
            .getter(getter(PutExternalModelRequest::role)).setter(setter(Builder::role)).constructor(Role::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("role").build()).build();

    private static final SdkField<ModelInputConfiguration> INPUT_CONFIGURATION_FIELD = SdkField
            .<ModelInputConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(PutExternalModelRequest::inputConfiguration)).setter(setter(Builder::inputConfiguration))
            .constructor(ModelInputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputConfiguration").build())
            .build();

    private static final SdkField<ModelOutputConfiguration> OUTPUT_CONFIGURATION_FIELD = SdkField
            .<ModelOutputConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(PutExternalModelRequest::outputConfiguration)).setter(setter(Builder::outputConfiguration))
            .constructor(ModelOutputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputConfiguration").build())
            .build();

    private static final SdkField<String> MODEL_ENDPOINT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutExternalModelRequest::modelEndpointStatusAsString)).setter(setter(Builder::modelEndpointStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelEndpointStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ENDPOINT_FIELD,
            MODEL_SOURCE_FIELD, ROLE_FIELD, INPUT_CONFIGURATION_FIELD, OUTPUT_CONFIGURATION_FIELD, MODEL_ENDPOINT_STATUS_FIELD));

    private final String modelEndpoint;

    private final String modelSource;

    private final Role role;

    private final ModelInputConfiguration inputConfiguration;

    private final ModelOutputConfiguration outputConfiguration;

    private final String modelEndpointStatus;

    private PutExternalModelRequest(BuilderImpl builder) {
        super(builder);
        this.modelEndpoint = builder.modelEndpoint;
        this.modelSource = builder.modelSource;
        this.role = builder.role;
        this.inputConfiguration = builder.inputConfiguration;
        this.outputConfiguration = builder.outputConfiguration;
        this.modelEndpointStatus = builder.modelEndpointStatus;
    }

    /**
     * <p>
     * The model endpoints name.
     * </p>
     * 
     * @return The model endpoints name.
     */
    public String modelEndpoint() {
        return modelEndpoint;
    }

    /**
     * <p>
     * The source of the model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelSource} will
     * return {@link ModelSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modelSourceAsString}.
     * </p>
     * 
     * @return The source of the model.
     * @see ModelSource
     */
    public ModelSource modelSource() {
        return ModelSource.fromValue(modelSource);
    }

    /**
     * <p>
     * The source of the model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelSource} will
     * return {@link ModelSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modelSourceAsString}.
     * </p>
     * 
     * @return The source of the model.
     * @see ModelSource
     */
    public String modelSourceAsString() {
        return modelSource;
    }

    /**
     * <p>
     * The IAM role used to invoke the model endpoint.
     * </p>
     * 
     * @return The IAM role used to invoke the model endpoint.
     */
    public Role role() {
        return role;
    }

    /**
     * <p>
     * The model endpoint input configuration.
     * </p>
     * 
     * @return The model endpoint input configuration.
     */
    public ModelInputConfiguration inputConfiguration() {
        return inputConfiguration;
    }

    /**
     * <p>
     * The model endpoint output configuration.
     * </p>
     * 
     * @return The model endpoint output configuration.
     */
    public ModelOutputConfiguration outputConfiguration() {
        return outputConfiguration;
    }

    /**
     * <p>
     * The model endpoint’s status in Amazon Fraud Detector.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #modelEndpointStatus} will return {@link ModelEndpointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #modelEndpointStatusAsString}.
     * </p>
     * 
     * @return The model endpoint’s status in Amazon Fraud Detector.
     * @see ModelEndpointStatus
     */
    public ModelEndpointStatus modelEndpointStatus() {
        return ModelEndpointStatus.fromValue(modelEndpointStatus);
    }

    /**
     * <p>
     * The model endpoint’s status in Amazon Fraud Detector.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #modelEndpointStatus} will return {@link ModelEndpointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #modelEndpointStatusAsString}.
     * </p>
     * 
     * @return The model endpoint’s status in Amazon Fraud Detector.
     * @see ModelEndpointStatus
     */
    public String modelEndpointStatusAsString() {
        return modelEndpointStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modelEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(modelSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(role());
        hashCode = 31 * hashCode + Objects.hashCode(inputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(outputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(modelEndpointStatusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutExternalModelRequest)) {
            return false;
        }
        PutExternalModelRequest other = (PutExternalModelRequest) obj;
        return Objects.equals(modelEndpoint(), other.modelEndpoint())
                && Objects.equals(modelSourceAsString(), other.modelSourceAsString()) && Objects.equals(role(), other.role())
                && Objects.equals(inputConfiguration(), other.inputConfiguration())
                && Objects.equals(outputConfiguration(), other.outputConfiguration())
                && Objects.equals(modelEndpointStatusAsString(), other.modelEndpointStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutExternalModelRequest").add("ModelEndpoint", modelEndpoint())
                .add("ModelSource", modelSourceAsString()).add("Role", role()).add("InputConfiguration", inputConfiguration())
                .add("OutputConfiguration", outputConfiguration()).add("ModelEndpointStatus", modelEndpointStatusAsString())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "modelEndpoint":
            return Optional.ofNullable(clazz.cast(modelEndpoint()));
        case "modelSource":
            return Optional.ofNullable(clazz.cast(modelSourceAsString()));
        case "role":
            return Optional.ofNullable(clazz.cast(role()));
        case "inputConfiguration":
            return Optional.ofNullable(clazz.cast(inputConfiguration()));
        case "outputConfiguration":
            return Optional.ofNullable(clazz.cast(outputConfiguration()));
        case "modelEndpointStatus":
            return Optional.ofNullable(clazz.cast(modelEndpointStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutExternalModelRequest, T> g) {
        return obj -> g.apply((PutExternalModelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FraudDetectorRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutExternalModelRequest> {
        /**
         * <p>
         * The model endpoints name.
         * </p>
         * 
         * @param modelEndpoint
         *        The model endpoints name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelEndpoint(String modelEndpoint);

        /**
         * <p>
         * The source of the model.
         * </p>
         * 
         * @param modelSource
         *        The source of the model.
         * @see ModelSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelSource
         */
        Builder modelSource(String modelSource);

        /**
         * <p>
         * The source of the model.
         * </p>
         * 
         * @param modelSource
         *        The source of the model.
         * @see ModelSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelSource
         */
        Builder modelSource(ModelSource modelSource);

        /**
         * <p>
         * The IAM role used to invoke the model endpoint.
         * </p>
         * 
         * @param role
         *        The IAM role used to invoke the model endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder role(Role role);

        /**
         * <p>
         * The IAM role used to invoke the model endpoint.
         * </p>
         * This is a convenience that creates an instance of the {@link Role.Builder} avoiding the need to create one
         * manually via {@link Role#builder()}.
         *
         * When the {@link Consumer} completes, {@link Role.Builder#build()} is called immediately and its result is
         * passed to {@link #role(Role)}.
         * 
         * @param role
         *        a consumer that will call methods on {@link Role.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #role(Role)
         */
        default Builder role(Consumer<Role.Builder> role) {
            return role(Role.builder().applyMutation(role).build());
        }

        /**
         * <p>
         * The model endpoint input configuration.
         * </p>
         * 
         * @param inputConfiguration
         *        The model endpoint input configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputConfiguration(ModelInputConfiguration inputConfiguration);

        /**
         * <p>
         * The model endpoint input configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link ModelInputConfiguration.Builder} avoiding the
         * need to create one manually via {@link ModelInputConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ModelInputConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #inputConfiguration(ModelInputConfiguration)}.
         * 
         * @param inputConfiguration
         *        a consumer that will call methods on {@link ModelInputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputConfiguration(ModelInputConfiguration)
         */
        default Builder inputConfiguration(Consumer<ModelInputConfiguration.Builder> inputConfiguration) {
            return inputConfiguration(ModelInputConfiguration.builder().applyMutation(inputConfiguration).build());
        }

        /**
         * <p>
         * The model endpoint output configuration.
         * </p>
         * 
         * @param outputConfiguration
         *        The model endpoint output configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfiguration(ModelOutputConfiguration outputConfiguration);

        /**
         * <p>
         * The model endpoint output configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link ModelOutputConfiguration.Builder} avoiding the
         * need to create one manually via {@link ModelOutputConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ModelOutputConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #outputConfiguration(ModelOutputConfiguration)}.
         * 
         * @param outputConfiguration
         *        a consumer that will call methods on {@link ModelOutputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfiguration(ModelOutputConfiguration)
         */
        default Builder outputConfiguration(Consumer<ModelOutputConfiguration.Builder> outputConfiguration) {
            return outputConfiguration(ModelOutputConfiguration.builder().applyMutation(outputConfiguration).build());
        }

        /**
         * <p>
         * The model endpoint’s status in Amazon Fraud Detector.
         * </p>
         * 
         * @param modelEndpointStatus
         *        The model endpoint’s status in Amazon Fraud Detector.
         * @see ModelEndpointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelEndpointStatus
         */
        Builder modelEndpointStatus(String modelEndpointStatus);

        /**
         * <p>
         * The model endpoint’s status in Amazon Fraud Detector.
         * </p>
         * 
         * @param modelEndpointStatus
         *        The model endpoint’s status in Amazon Fraud Detector.
         * @see ModelEndpointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelEndpointStatus
         */
        Builder modelEndpointStatus(ModelEndpointStatus modelEndpointStatus);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FraudDetectorRequest.BuilderImpl implements Builder {
        private String modelEndpoint;

        private String modelSource;

        private Role role;

        private ModelInputConfiguration inputConfiguration;

        private ModelOutputConfiguration outputConfiguration;

        private String modelEndpointStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(PutExternalModelRequest model) {
            super(model);
            modelEndpoint(model.modelEndpoint);
            modelSource(model.modelSource);
            role(model.role);
            inputConfiguration(model.inputConfiguration);
            outputConfiguration(model.outputConfiguration);
            modelEndpointStatus(model.modelEndpointStatus);
        }

        public final String getModelEndpoint() {
            return modelEndpoint;
        }

        @Override
        public final Builder modelEndpoint(String modelEndpoint) {
            this.modelEndpoint = modelEndpoint;
            return this;
        }

        public final void setModelEndpoint(String modelEndpoint) {
            this.modelEndpoint = modelEndpoint;
        }

        public final String getModelSourceAsString() {
            return modelSource;
        }

        @Override
        public final Builder modelSource(String modelSource) {
            this.modelSource = modelSource;
            return this;
        }

        @Override
        public final Builder modelSource(ModelSource modelSource) {
            this.modelSource(modelSource == null ? null : modelSource.toString());
            return this;
        }

        public final void setModelSource(String modelSource) {
            this.modelSource = modelSource;
        }

        public final Role.Builder getRole() {
            return role != null ? role.toBuilder() : null;
        }

        @Override
        public final Builder role(Role role) {
            this.role = role;
            return this;
        }

        public final void setRole(Role.BuilderImpl role) {
            this.role = role != null ? role.build() : null;
        }

        public final ModelInputConfiguration.Builder getInputConfiguration() {
            return inputConfiguration != null ? inputConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder inputConfiguration(ModelInputConfiguration inputConfiguration) {
            this.inputConfiguration = inputConfiguration;
            return this;
        }

        public final void setInputConfiguration(ModelInputConfiguration.BuilderImpl inputConfiguration) {
            this.inputConfiguration = inputConfiguration != null ? inputConfiguration.build() : null;
        }

        public final ModelOutputConfiguration.Builder getOutputConfiguration() {
            return outputConfiguration != null ? outputConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder outputConfiguration(ModelOutputConfiguration outputConfiguration) {
            this.outputConfiguration = outputConfiguration;
            return this;
        }

        public final void setOutputConfiguration(ModelOutputConfiguration.BuilderImpl outputConfiguration) {
            this.outputConfiguration = outputConfiguration != null ? outputConfiguration.build() : null;
        }

        public final String getModelEndpointStatusAsString() {
            return modelEndpointStatus;
        }

        @Override
        public final Builder modelEndpointStatus(String modelEndpointStatus) {
            this.modelEndpointStatus = modelEndpointStatus;
            return this;
        }

        @Override
        public final Builder modelEndpointStatus(ModelEndpointStatus modelEndpointStatus) {
            this.modelEndpointStatus(modelEndpointStatus == null ? null : modelEndpointStatus.toString());
            return this;
        }

        public final void setModelEndpointStatus(String modelEndpointStatus) {
            this.modelEndpointStatus = modelEndpointStatus;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutExternalModelRequest build() {
            return new PutExternalModelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
