/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The model version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelVersion implements SdkPojo, Serializable, ToCopyableBuilder<ModelVersion.Builder, ModelVersion> {
    private static final SdkField<String> MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModelVersion::modelId)).setter(setter(Builder::modelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()).build();

    private static final SdkField<String> MODEL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModelVersion::modelTypeAsString)).setter(setter(Builder::modelType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelType").build()).build();

    private static final SdkField<String> MODEL_VERSION_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModelVersion::modelVersionNumber)).setter(setter(Builder::modelVersionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelVersionNumber").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ID_FIELD,
            MODEL_TYPE_FIELD, MODEL_VERSION_NUMBER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String modelId;

    private final String modelType;

    private final String modelVersionNumber;

    private ModelVersion(BuilderImpl builder) {
        this.modelId = builder.modelId;
        this.modelType = builder.modelType;
        this.modelVersionNumber = builder.modelVersionNumber;
    }

    /**
     * <p>
     * The parent model ID.
     * </p>
     * 
     * @return The parent model ID.
     */
    public String modelId() {
        return modelId;
    }

    /**
     * <p>
     * The model type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelType} will
     * return {@link ModelTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modelTypeAsString}.
     * </p>
     * 
     * @return The model type.
     * @see ModelTypeEnum
     */
    public ModelTypeEnum modelType() {
        return ModelTypeEnum.fromValue(modelType);
    }

    /**
     * <p>
     * The model type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelType} will
     * return {@link ModelTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modelTypeAsString}.
     * </p>
     * 
     * @return The model type.
     * @see ModelTypeEnum
     */
    public String modelTypeAsString() {
        return modelType;
    }

    /**
     * <p>
     * The model version.
     * </p>
     * 
     * @return The model version.
     */
    public String modelVersionNumber() {
        return modelVersionNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelId());
        hashCode = 31 * hashCode + Objects.hashCode(modelTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(modelVersionNumber());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelVersion)) {
            return false;
        }
        ModelVersion other = (ModelVersion) obj;
        return Objects.equals(modelId(), other.modelId()) && Objects.equals(modelTypeAsString(), other.modelTypeAsString())
                && Objects.equals(modelVersionNumber(), other.modelVersionNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModelVersion").add("ModelId", modelId()).add("ModelType", modelTypeAsString())
                .add("ModelVersionNumber", modelVersionNumber()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "modelId":
            return Optional.ofNullable(clazz.cast(modelId()));
        case "modelType":
            return Optional.ofNullable(clazz.cast(modelTypeAsString()));
        case "modelVersionNumber":
            return Optional.ofNullable(clazz.cast(modelVersionNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelVersion, T> g) {
        return obj -> g.apply((ModelVersion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelVersion> {
        /**
         * <p>
         * The parent model ID.
         * </p>
         * 
         * @param modelId
         *        The parent model ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelId(String modelId);

        /**
         * <p>
         * The model type.
         * </p>
         * 
         * @param modelType
         *        The model type.
         * @see ModelTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelTypeEnum
         */
        Builder modelType(String modelType);

        /**
         * <p>
         * The model type.
         * </p>
         * 
         * @param modelType
         *        The model type.
         * @see ModelTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelTypeEnum
         */
        Builder modelType(ModelTypeEnum modelType);

        /**
         * <p>
         * The model version.
         * </p>
         * 
         * @param modelVersionNumber
         *        The model version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVersionNumber(String modelVersionNumber);
    }

    static final class BuilderImpl implements Builder {
        private String modelId;

        private String modelType;

        private String modelVersionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelVersion model) {
            modelId(model.modelId);
            modelType(model.modelType);
            modelVersionNumber(model.modelVersionNumber);
        }

        public final String getModelId() {
            return modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        public final String getModelTypeAsString() {
            return modelType;
        }

        @Override
        public final Builder modelType(String modelType) {
            this.modelType = modelType;
            return this;
        }

        @Override
        public final Builder modelType(ModelTypeEnum modelType) {
            this.modelType(modelType == null ? null : modelType.toString());
            return this;
        }

        public final void setModelType(String modelType) {
            this.modelType = modelType;
        }

        public final String getModelVersionNumber() {
            return modelVersionNumber;
        }

        @Override
        public final Builder modelVersionNumber(String modelVersionNumber) {
            this.modelVersionNumber = modelVersionNumber;
            return this;
        }

        public final void setModelVersionNumber(String modelVersionNumber) {
            this.modelVersionNumber = modelVersionNumber;
        }

        @Override
        public ModelVersion build() {
            return new ModelVersion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
