/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetModelsRequest extends FraudDetectorRequest implements
        ToCopyableBuilder<GetModelsRequest.Builder, GetModelsRequest> {
    private static final SdkField<String> MODEL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetModelsRequest::modelTypeAsString)).setter(setter(Builder::modelType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelType").build()).build();

    private static final SdkField<String> MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetModelsRequest::modelId)).setter(setter(Builder::modelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetModelsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(GetModelsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_TYPE_FIELD,
            MODEL_ID_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String modelType;

    private final String modelId;

    private final String nextToken;

    private final Integer maxResults;

    private GetModelsRequest(BuilderImpl builder) {
        super(builder);
        this.modelType = builder.modelType;
        this.modelId = builder.modelId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The model type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelType} will
     * return {@link ModelTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modelTypeAsString}.
     * </p>
     * 
     * @return The model type.
     * @see ModelTypeEnum
     */
    public ModelTypeEnum modelType() {
        return ModelTypeEnum.fromValue(modelType);
    }

    /**
     * <p>
     * The model type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelType} will
     * return {@link ModelTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modelTypeAsString}.
     * </p>
     * 
     * @return The model type.
     * @see ModelTypeEnum
     */
    public String modelTypeAsString() {
        return modelType;
    }

    /**
     * <p>
     * The model ID.
     * </p>
     * 
     * @return The model ID.
     */
    public String modelId() {
        return modelId;
    }

    /**
     * <p>
     * The next token for the request.
     * </p>
     * 
     * @return The next token for the request.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum results to return for the request.
     * </p>
     * 
     * @return The maximum results to return for the request.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modelTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(modelId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetModelsRequest)) {
            return false;
        }
        GetModelsRequest other = (GetModelsRequest) obj;
        return Objects.equals(modelTypeAsString(), other.modelTypeAsString()) && Objects.equals(modelId(), other.modelId())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetModelsRequest").add("ModelType", modelTypeAsString()).add("ModelId", modelId())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "modelType":
            return Optional.ofNullable(clazz.cast(modelTypeAsString()));
        case "modelId":
            return Optional.ofNullable(clazz.cast(modelId()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetModelsRequest, T> g) {
        return obj -> g.apply((GetModelsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FraudDetectorRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetModelsRequest> {
        /**
         * <p>
         * The model type.
         * </p>
         * 
         * @param modelType
         *        The model type.
         * @see ModelTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelTypeEnum
         */
        Builder modelType(String modelType);

        /**
         * <p>
         * The model type.
         * </p>
         * 
         * @param modelType
         *        The model type.
         * @see ModelTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelTypeEnum
         */
        Builder modelType(ModelTypeEnum modelType);

        /**
         * <p>
         * The model ID.
         * </p>
         * 
         * @param modelId
         *        The model ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelId(String modelId);

        /**
         * <p>
         * The next token for the request.
         * </p>
         * 
         * @param nextToken
         *        The next token for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum results to return for the request.
         * </p>
         * 
         * @param maxResults
         *        The maximum results to return for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FraudDetectorRequest.BuilderImpl implements Builder {
        private String modelType;

        private String modelId;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetModelsRequest model) {
            super(model);
            modelType(model.modelType);
            modelId(model.modelId);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getModelTypeAsString() {
            return modelType;
        }

        @Override
        public final Builder modelType(String modelType) {
            this.modelType = modelType;
            return this;
        }

        @Override
        public final Builder modelType(ModelTypeEnum modelType) {
            this.modelType(modelType == null ? null : modelType.toString());
            return this;
        }

        public final void setModelType(String modelType) {
            this.modelType = modelType;
        }

        public final String getModelId() {
            return modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetModelsRequest build() {
            return new GetModelsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
