/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The status, start time, and end time of a backtest, as well as a failure reason if applicable.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestWindowSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<TestWindowSummary.Builder, TestWindowSummary> {
    private static final SdkField<Instant> TEST_WINDOW_START_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("TestWindowStart").getter(getter(TestWindowSummary::testWindowStart))
            .setter(setter(Builder::testWindowStart))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TestWindowStart").build()).build();

    private static final SdkField<Instant> TEST_WINDOW_END_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("TestWindowEnd").getter(getter(TestWindowSummary::testWindowEnd)).setter(setter(Builder::testWindowEnd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TestWindowEnd").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(TestWindowSummary::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(TestWindowSummary::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_WINDOW_START_FIELD,
            TEST_WINDOW_END_FIELD, STATUS_FIELD, MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant testWindowStart;

    private final Instant testWindowEnd;

    private final String status;

    private final String message;

    private TestWindowSummary(BuilderImpl builder) {
        this.testWindowStart = builder.testWindowStart;
        this.testWindowEnd = builder.testWindowEnd;
        this.status = builder.status;
        this.message = builder.message;
    }

    /**
     * <p>
     * The time at which the test began.
     * </p>
     * 
     * @return The time at which the test began.
     */
    public final Instant testWindowStart() {
        return testWindowStart;
    }

    /**
     * <p>
     * The time at which the test ended.
     * </p>
     * 
     * @return The time at which the test ended.
     */
    public final Instant testWindowEnd() {
        return testWindowEnd;
    }

    /**
     * <p>
     * The status of the test. Possible status values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_IN_PROGRESS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_FAILED</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the test. Possible status values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_IN_PROGRESS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_FAILED</code>
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * If the test failed, the reason why it failed.
     * </p>
     * 
     * @return If the test failed, the reason why it failed.
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(testWindowStart());
        hashCode = 31 * hashCode + Objects.hashCode(testWindowEnd());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestWindowSummary)) {
            return false;
        }
        TestWindowSummary other = (TestWindowSummary) obj;
        return Objects.equals(testWindowStart(), other.testWindowStart())
                && Objects.equals(testWindowEnd(), other.testWindowEnd()) && Objects.equals(status(), other.status())
                && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestWindowSummary").add("TestWindowStart", testWindowStart())
                .add("TestWindowEnd", testWindowEnd()).add("Status", status()).add("Message", message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TestWindowStart":
            return Optional.ofNullable(clazz.cast(testWindowStart()));
        case "TestWindowEnd":
            return Optional.ofNullable(clazz.cast(testWindowEnd()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TestWindowStart", TEST_WINDOW_START_FIELD);
        map.put("TestWindowEnd", TEST_WINDOW_END_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Message", MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TestWindowSummary, T> g) {
        return obj -> g.apply((TestWindowSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TestWindowSummary> {
        /**
         * <p>
         * The time at which the test began.
         * </p>
         * 
         * @param testWindowStart
         *        The time at which the test began.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testWindowStart(Instant testWindowStart);

        /**
         * <p>
         * The time at which the test ended.
         * </p>
         * 
         * @param testWindowEnd
         *        The time at which the test ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testWindowEnd(Instant testWindowEnd);

        /**
         * <p>
         * The status of the test. Possible status values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_IN_PROGRESS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_FAILED</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the test. Possible status values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_IN_PROGRESS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_FAILED</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * If the test failed, the reason why it failed.
         * </p>
         * 
         * @param message
         *        If the test failed, the reason why it failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private Instant testWindowStart;

        private Instant testWindowEnd;

        private String status;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(TestWindowSummary model) {
            testWindowStart(model.testWindowStart);
            testWindowEnd(model.testWindowEnd);
            status(model.status);
            message(model.message);
        }

        public final Instant getTestWindowStart() {
            return testWindowStart;
        }

        public final void setTestWindowStart(Instant testWindowStart) {
            this.testWindowStart = testWindowStart;
        }

        @Override
        public final Builder testWindowStart(Instant testWindowStart) {
            this.testWindowStart = testWindowStart;
            return this;
        }

        public final Instant getTestWindowEnd() {
            return testWindowEnd;
        }

        public final void setTestWindowEnd(Instant testWindowEnd) {
            this.testWindowEnd = testWindowEnd;
        }

        @Override
        public final Builder testWindowEnd(Instant testWindowEnd) {
            this.testWindowEnd = testWindowEnd;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public TestWindowSummary build() {
            return new TestWindowSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
