/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a summary of the Explainability properties used in the <a>ListExplainabilities</a> operation. To get a
 * complete set of properties, call the <a>DescribeExplainability</a> operation, and provide the listed
 * <code>ExplainabilityArn</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExplainabilitySummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ExplainabilitySummary.Builder, ExplainabilitySummary> {
    private static final SdkField<String> EXPLAINABILITY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExplainabilityArn").getter(getter(ExplainabilitySummary::explainabilityArn))
            .setter(setter(Builder::explainabilityArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExplainabilityArn").build()).build();

    private static final SdkField<String> EXPLAINABILITY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExplainabilityName").getter(getter(ExplainabilitySummary::explainabilityName))
            .setter(setter(Builder::explainabilityName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExplainabilityName").build())
            .build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(ExplainabilitySummary::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<ExplainabilityConfig> EXPLAINABILITY_CONFIG_FIELD = SdkField
            .<ExplainabilityConfig> builder(MarshallingType.SDK_POJO).memberName("ExplainabilityConfig")
            .getter(getter(ExplainabilitySummary::explainabilityConfig)).setter(setter(Builder::explainabilityConfig))
            .constructor(ExplainabilityConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExplainabilityConfig").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ExplainabilitySummary::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(ExplainabilitySummary::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(ExplainabilitySummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModificationTime").getter(getter(ExplainabilitySummary::lastModificationTime))
            .setter(setter(Builder::lastModificationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPLAINABILITY_ARN_FIELD,
            EXPLAINABILITY_NAME_FIELD, RESOURCE_ARN_FIELD, EXPLAINABILITY_CONFIG_FIELD, STATUS_FIELD, MESSAGE_FIELD,
            CREATION_TIME_FIELD, LAST_MODIFICATION_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String explainabilityArn;

    private final String explainabilityName;

    private final String resourceArn;

    private final ExplainabilityConfig explainabilityConfig;

    private final String status;

    private final String message;

    private final Instant creationTime;

    private final Instant lastModificationTime;

    private ExplainabilitySummary(BuilderImpl builder) {
        this.explainabilityArn = builder.explainabilityArn;
        this.explainabilityName = builder.explainabilityName;
        this.resourceArn = builder.resourceArn;
        this.explainabilityConfig = builder.explainabilityConfig;
        this.status = builder.status;
        this.message = builder.message;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Explainability.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Explainability.
     */
    public final String explainabilityArn() {
        return explainabilityArn;
    }

    /**
     * <p>
     * The name of the Explainability.
     * </p>
     * 
     * @return The name of the Explainability.
     */
    public final String explainabilityName() {
        return explainabilityName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Predictor or Forecast used to create the Explainability.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Predictor or Forecast used to create the Explainability.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The configuration settings that define the granularity of time series and time points for the Explainability.
     * </p>
     * 
     * @return The configuration settings that define the granularity of time series and time points for the
     *         Explainability.
     */
    public final ExplainabilityConfig explainabilityConfig() {
        return explainabilityConfig;
    }

    /**
     * <p>
     * The status of the Explainability. States include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the Explainability. States include: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * Information about any errors that may have occurred during the Explainability creation process.
     * </p>
     * 
     * @return Information about any errors that may have occurred during the Explainability creation process.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * When the Explainability was created.
     * </p>
     * 
     * @return When the Explainability was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The last time the resource was modified. The timestamp depends on the status of the job:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_IN_PROGRESS</code> - The current timestamp.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPING</code> - The current timestamp.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPED</code> - When the job stopped.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The last time the resource was modified. The timestamp depends on the status of the job:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_IN_PROGRESS</code> - The current timestamp.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_STOPPING</code> - The current timestamp.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_STOPPED</code> - When the job stopped.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
     *         </p>
     *         </li>
     */
    public final Instant lastModificationTime() {
        return lastModificationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(explainabilityArn());
        hashCode = 31 * hashCode + Objects.hashCode(explainabilityName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(explainabilityConfig());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModificationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExplainabilitySummary)) {
            return false;
        }
        ExplainabilitySummary other = (ExplainabilitySummary) obj;
        return Objects.equals(explainabilityArn(), other.explainabilityArn())
                && Objects.equals(explainabilityName(), other.explainabilityName())
                && Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(explainabilityConfig(), other.explainabilityConfig())
                && Objects.equals(status(), other.status()) && Objects.equals(message(), other.message())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModificationTime(), other.lastModificationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExplainabilitySummary").add("ExplainabilityArn", explainabilityArn())
                .add("ExplainabilityName", explainabilityName()).add("ResourceArn", resourceArn())
                .add("ExplainabilityConfig", explainabilityConfig()).add("Status", status()).add("Message", message())
                .add("CreationTime", creationTime()).add("LastModificationTime", lastModificationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExplainabilityArn":
            return Optional.ofNullable(clazz.cast(explainabilityArn()));
        case "ExplainabilityName":
            return Optional.ofNullable(clazz.cast(explainabilityName()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "ExplainabilityConfig":
            return Optional.ofNullable(clazz.cast(explainabilityConfig()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModificationTime":
            return Optional.ofNullable(clazz.cast(lastModificationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ExplainabilityArn", EXPLAINABILITY_ARN_FIELD);
        map.put("ExplainabilityName", EXPLAINABILITY_NAME_FIELD);
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("ExplainabilityConfig", EXPLAINABILITY_CONFIG_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Message", MESSAGE_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModificationTime", LAST_MODIFICATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExplainabilitySummary, T> g) {
        return obj -> g.apply((ExplainabilitySummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExplainabilitySummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Explainability.
         * </p>
         * 
         * @param explainabilityArn
         *        The Amazon Resource Name (ARN) of the Explainability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder explainabilityArn(String explainabilityArn);

        /**
         * <p>
         * The name of the Explainability.
         * </p>
         * 
         * @param explainabilityName
         *        The name of the Explainability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder explainabilityName(String explainabilityName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Predictor or Forecast used to create the Explainability.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the Predictor or Forecast used to create the Explainability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The configuration settings that define the granularity of time series and time points for the Explainability.
         * </p>
         * 
         * @param explainabilityConfig
         *        The configuration settings that define the granularity of time series and time points for the
         *        Explainability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder explainabilityConfig(ExplainabilityConfig explainabilityConfig);

        /**
         * <p>
         * The configuration settings that define the granularity of time series and time points for the Explainability.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExplainabilityConfig.Builder} avoiding
         * the need to create one manually via {@link ExplainabilityConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExplainabilityConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #explainabilityConfig(ExplainabilityConfig)}.
         * 
         * @param explainabilityConfig
         *        a consumer that will call methods on {@link ExplainabilityConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #explainabilityConfig(ExplainabilityConfig)
         */
        default Builder explainabilityConfig(Consumer<ExplainabilityConfig.Builder> explainabilityConfig) {
            return explainabilityConfig(ExplainabilityConfig.builder().applyMutation(explainabilityConfig).build());
        }

        /**
         * <p>
         * The status of the Explainability. States include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the Explainability. States include: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * Information about any errors that may have occurred during the Explainability creation process.
         * </p>
         * 
         * @param message
         *        Information about any errors that may have occurred during the Explainability creation process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * When the Explainability was created.
         * </p>
         * 
         * @param creationTime
         *        When the Explainability was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The last time the resource was modified. The timestamp depends on the status of the job:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_IN_PROGRESS</code> - The current timestamp.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_STOPPING</code> - The current timestamp.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_STOPPED</code> - When the job stopped.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param lastModificationTime
         *        The last time the resource was modified. The timestamp depends on the status of the job:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_IN_PROGRESS</code> - The current timestamp.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_STOPPING</code> - The current timestamp.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_STOPPED</code> - When the job stopped.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModificationTime(Instant lastModificationTime);
    }

    static final class BuilderImpl implements Builder {
        private String explainabilityArn;

        private String explainabilityName;

        private String resourceArn;

        private ExplainabilityConfig explainabilityConfig;

        private String status;

        private String message;

        private Instant creationTime;

        private Instant lastModificationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ExplainabilitySummary model) {
            explainabilityArn(model.explainabilityArn);
            explainabilityName(model.explainabilityName);
            resourceArn(model.resourceArn);
            explainabilityConfig(model.explainabilityConfig);
            status(model.status);
            message(model.message);
            creationTime(model.creationTime);
            lastModificationTime(model.lastModificationTime);
        }

        public final String getExplainabilityArn() {
            return explainabilityArn;
        }

        public final void setExplainabilityArn(String explainabilityArn) {
            this.explainabilityArn = explainabilityArn;
        }

        @Override
        public final Builder explainabilityArn(String explainabilityArn) {
            this.explainabilityArn = explainabilityArn;
            return this;
        }

        public final String getExplainabilityName() {
            return explainabilityName;
        }

        public final void setExplainabilityName(String explainabilityName) {
            this.explainabilityName = explainabilityName;
        }

        @Override
        public final Builder explainabilityName(String explainabilityName) {
            this.explainabilityName = explainabilityName;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final ExplainabilityConfig.Builder getExplainabilityConfig() {
            return explainabilityConfig != null ? explainabilityConfig.toBuilder() : null;
        }

        public final void setExplainabilityConfig(ExplainabilityConfig.BuilderImpl explainabilityConfig) {
            this.explainabilityConfig = explainabilityConfig != null ? explainabilityConfig.build() : null;
        }

        @Override
        public final Builder explainabilityConfig(ExplainabilityConfig explainabilityConfig) {
            this.explainabilityConfig = explainabilityConfig;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModificationTime() {
            return lastModificationTime;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        @Override
        public ExplainabilitySummary build() {
            return new ExplainabilitySummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
