/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The data configuration for your dataset group and any additional datasets.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataConfig implements SdkPojo, Serializable, ToCopyableBuilder<DataConfig.Builder, DataConfig> {
    private static final SdkField<String> DATASET_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetGroupArn").getter(getter(DataConfig::datasetGroupArn)).setter(setter(Builder::datasetGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetGroupArn").build()).build();

    private static final SdkField<List<AttributeConfig>> ATTRIBUTE_CONFIGS_FIELD = SdkField
            .<List<AttributeConfig>> builder(MarshallingType.LIST)
            .memberName("AttributeConfigs")
            .getter(getter(DataConfig::attributeConfigs))
            .setter(setter(Builder::attributeConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttributeConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AdditionalDataset>> ADDITIONAL_DATASETS_FIELD = SdkField
            .<List<AdditionalDataset>> builder(MarshallingType.LIST)
            .memberName("AdditionalDatasets")
            .getter(getter(DataConfig::additionalDatasets))
            .setter(setter(Builder::additionalDatasets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalDatasets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AdditionalDataset> builder(MarshallingType.SDK_POJO)
                                            .constructor(AdditionalDataset::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_GROUP_ARN_FIELD,
            ATTRIBUTE_CONFIGS_FIELD, ADDITIONAL_DATASETS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String datasetGroupArn;

    private final List<AttributeConfig> attributeConfigs;

    private final List<AdditionalDataset> additionalDatasets;

    private DataConfig(BuilderImpl builder) {
        this.datasetGroupArn = builder.datasetGroupArn;
        this.attributeConfigs = builder.attributeConfigs;
        this.additionalDatasets = builder.additionalDatasets;
    }

    /**
     * <p>
     * The ARN of the dataset group used to train the predictor.
     * </p>
     * 
     * @return The ARN of the dataset group used to train the predictor.
     */
    public final String datasetGroupArn() {
        return datasetGroupArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the AttributeConfigs property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttributeConfigs() {
        return attributeConfigs != null && !(attributeConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Aggregation and filling options for attributes in your dataset group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributeConfigs} method.
     * </p>
     * 
     * @return Aggregation and filling options for attributes in your dataset group.
     */
    public final List<AttributeConfig> attributeConfigs() {
        return attributeConfigs;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalDatasets property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAdditionalDatasets() {
        return additionalDatasets != null && !(additionalDatasets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Additional built-in datasets like Holidays and the Weather Index.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalDatasets} method.
     * </p>
     * 
     * @return Additional built-in datasets like Holidays and the Weather Index.
     */
    public final List<AdditionalDataset> additionalDatasets() {
        return additionalDatasets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(datasetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributeConfigs() ? attributeConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalDatasets() ? additionalDatasets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataConfig)) {
            return false;
        }
        DataConfig other = (DataConfig) obj;
        return Objects.equals(datasetGroupArn(), other.datasetGroupArn()) && hasAttributeConfigs() == other.hasAttributeConfigs()
                && Objects.equals(attributeConfigs(), other.attributeConfigs())
                && hasAdditionalDatasets() == other.hasAdditionalDatasets()
                && Objects.equals(additionalDatasets(), other.additionalDatasets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataConfig").add("DatasetGroupArn", datasetGroupArn())
                .add("AttributeConfigs", hasAttributeConfigs() ? attributeConfigs() : null)
                .add("AdditionalDatasets", hasAdditionalDatasets() ? additionalDatasets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatasetGroupArn":
            return Optional.ofNullable(clazz.cast(datasetGroupArn()));
        case "AttributeConfigs":
            return Optional.ofNullable(clazz.cast(attributeConfigs()));
        case "AdditionalDatasets":
            return Optional.ofNullable(clazz.cast(additionalDatasets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DatasetGroupArn", DATASET_GROUP_ARN_FIELD);
        map.put("AttributeConfigs", ATTRIBUTE_CONFIGS_FIELD);
        map.put("AdditionalDatasets", ADDITIONAL_DATASETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataConfig, T> g) {
        return obj -> g.apply((DataConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataConfig> {
        /**
         * <p>
         * The ARN of the dataset group used to train the predictor.
         * </p>
         * 
         * @param datasetGroupArn
         *        The ARN of the dataset group used to train the predictor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetGroupArn(String datasetGroupArn);

        /**
         * <p>
         * Aggregation and filling options for attributes in your dataset group.
         * </p>
         * 
         * @param attributeConfigs
         *        Aggregation and filling options for attributes in your dataset group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeConfigs(Collection<AttributeConfig> attributeConfigs);

        /**
         * <p>
         * Aggregation and filling options for attributes in your dataset group.
         * </p>
         * 
         * @param attributeConfigs
         *        Aggregation and filling options for attributes in your dataset group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeConfigs(AttributeConfig... attributeConfigs);

        /**
         * <p>
         * Aggregation and filling options for attributes in your dataset group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.forecast.model.AttributeConfig.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.forecast.model.AttributeConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.forecast.model.AttributeConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #attributeConfigs(List<AttributeConfig>)}.
         * 
         * @param attributeConfigs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.forecast.model.AttributeConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributeConfigs(java.util.Collection<AttributeConfig>)
         */
        Builder attributeConfigs(Consumer<AttributeConfig.Builder>... attributeConfigs);

        /**
         * <p>
         * Additional built-in datasets like Holidays and the Weather Index.
         * </p>
         * 
         * @param additionalDatasets
         *        Additional built-in datasets like Holidays and the Weather Index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalDatasets(Collection<AdditionalDataset> additionalDatasets);

        /**
         * <p>
         * Additional built-in datasets like Holidays and the Weather Index.
         * </p>
         * 
         * @param additionalDatasets
         *        Additional built-in datasets like Holidays and the Weather Index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalDatasets(AdditionalDataset... additionalDatasets);

        /**
         * <p>
         * Additional built-in datasets like Holidays and the Weather Index.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.forecast.model.AdditionalDataset.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.forecast.model.AdditionalDataset#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.forecast.model.AdditionalDataset.Builder#build()} is called
         * immediately and its result is passed to {@link #additionalDatasets(List<AdditionalDataset>)}.
         * 
         * @param additionalDatasets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.forecast.model.AdditionalDataset.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalDatasets(java.util.Collection<AdditionalDataset>)
         */
        Builder additionalDatasets(Consumer<AdditionalDataset.Builder>... additionalDatasets);
    }

    static final class BuilderImpl implements Builder {
        private String datasetGroupArn;

        private List<AttributeConfig> attributeConfigs = DefaultSdkAutoConstructList.getInstance();

        private List<AdditionalDataset> additionalDatasets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DataConfig model) {
            datasetGroupArn(model.datasetGroupArn);
            attributeConfigs(model.attributeConfigs);
            additionalDatasets(model.additionalDatasets);
        }

        public final String getDatasetGroupArn() {
            return datasetGroupArn;
        }

        public final void setDatasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
        }

        @Override
        public final Builder datasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
            return this;
        }

        public final List<AttributeConfig.Builder> getAttributeConfigs() {
            List<AttributeConfig.Builder> result = AttributeConfigsCopier.copyToBuilder(this.attributeConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributeConfigs(Collection<AttributeConfig.BuilderImpl> attributeConfigs) {
            this.attributeConfigs = AttributeConfigsCopier.copyFromBuilder(attributeConfigs);
        }

        @Override
        public final Builder attributeConfigs(Collection<AttributeConfig> attributeConfigs) {
            this.attributeConfigs = AttributeConfigsCopier.copy(attributeConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeConfigs(AttributeConfig... attributeConfigs) {
            attributeConfigs(Arrays.asList(attributeConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeConfigs(Consumer<AttributeConfig.Builder>... attributeConfigs) {
            attributeConfigs(Stream.of(attributeConfigs).map(c -> AttributeConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AdditionalDataset.Builder> getAdditionalDatasets() {
            List<AdditionalDataset.Builder> result = AdditionalDatasetsCopier.copyToBuilder(this.additionalDatasets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalDatasets(Collection<AdditionalDataset.BuilderImpl> additionalDatasets) {
            this.additionalDatasets = AdditionalDatasetsCopier.copyFromBuilder(additionalDatasets);
        }

        @Override
        public final Builder additionalDatasets(Collection<AdditionalDataset> additionalDatasets) {
            this.additionalDatasets = AdditionalDatasetsCopier.copy(additionalDatasets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalDatasets(AdditionalDataset... additionalDatasets) {
            additionalDatasets(Arrays.asList(additionalDatasets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalDatasets(Consumer<AdditionalDataset.Builder>... additionalDatasets) {
            additionalDatasets(Stream.of(additionalDatasets).map(c -> AdditionalDataset.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DataConfig build() {
            return new DataConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
