/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAutoPredictorResponse extends ForecastResponse implements
        ToCopyableBuilder<CreateAutoPredictorResponse.Builder, CreateAutoPredictorResponse> {
    private static final SdkField<String> PREDICTOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PredictorArn").getter(getter(CreateAutoPredictorResponse::predictorArn))
            .setter(setter(Builder::predictorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictorArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREDICTOR_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String predictorArn;

    private CreateAutoPredictorResponse(BuilderImpl builder) {
        super(builder);
        this.predictorArn = builder.predictorArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the predictor.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the predictor.
     */
    public final String predictorArn() {
        return predictorArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(predictorArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAutoPredictorResponse)) {
            return false;
        }
        CreateAutoPredictorResponse other = (CreateAutoPredictorResponse) obj;
        return Objects.equals(predictorArn(), other.predictorArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAutoPredictorResponse").add("PredictorArn", predictorArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PredictorArn":
            return Optional.ofNullable(clazz.cast(predictorArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PredictorArn", PREDICTOR_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAutoPredictorResponse, T> g) {
        return obj -> g.apply((CreateAutoPredictorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ForecastResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateAutoPredictorResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the predictor.
         * </p>
         * 
         * @param predictorArn
         *        The Amazon Resource Name (ARN) of the predictor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictorArn(String predictorArn);
    }

    static final class BuilderImpl extends ForecastResponse.BuilderImpl implements Builder {
        private String predictorArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAutoPredictorResponse model) {
            super(model);
            predictorArn(model.predictorArn);
        }

        public final String getPredictorArn() {
            return predictorArn;
        }

        public final void setPredictorArn(String predictorArn) {
            this.predictorArn = predictorArn;
        }

        @Override
        public final Builder predictorArn(String predictorArn) {
            this.predictorArn = predictorArn;
            return this;
        }

        @Override
        public CreateAutoPredictorResponse build() {
            return new CreateAutoPredictorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
