/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ScalingType {
    AUTO("Auto"),
    LINEAR("Linear"),
    LOGARITHMIC("Logarithmic"),
    REVERSE_LOGARITHMIC("ReverseLogarithmic"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ScalingType> VALUE_MAP;
    private final String value;

    private ScalingType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ScalingType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ScalingType> knownValues() {
        EnumSet<ScalingType> knownValues = EnumSet.allOf(ScalingType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ScalingType.class, ScalingType::toString);
    }
}

