/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.forecast.model.ErrorMetric;
import software.amazon.awssdk.services.forecast.model.ErrorMetricsCopier;
import software.amazon.awssdk.services.forecast.model.WeightedQuantileLoss;
import software.amazon.awssdk.services.forecast.model.WeightedQuantileLossesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Metrics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Metrics> {
    private static final SdkField<Double> RMSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("RMSE").getter(Metrics.getter(Metrics::rmse)).setter(Metrics.setter(Builder::rmse)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RMSE").build()}).build();
    private static final SdkField<List<WeightedQuantileLoss>> WEIGHTED_QUANTILE_LOSSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WeightedQuantileLosses").getter(Metrics.getter(Metrics::weightedQuantileLosses)).setter(Metrics.setter(Builder::weightedQuantileLosses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeightedQuantileLosses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WeightedQuantileLoss::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ErrorMetric>> ERROR_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ErrorMetrics").getter(Metrics.getter(Metrics::errorMetrics)).setter(Metrics.setter(Builder::errorMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ErrorMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Double> AVERAGE_WEIGHTED_QUANTILE_LOSS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("AverageWeightedQuantileLoss").getter(Metrics.getter(Metrics::averageWeightedQuantileLoss)).setter(Metrics.setter(Builder::averageWeightedQuantileLoss)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AverageWeightedQuantileLoss").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RMSE_FIELD, WEIGHTED_QUANTILE_LOSSES_FIELD, ERROR_METRICS_FIELD, AVERAGE_WEIGHTED_QUANTILE_LOSS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("RMSE", RMSE_FIELD);
            this.put("WeightedQuantileLosses", WEIGHTED_QUANTILE_LOSSES_FIELD);
            this.put("ErrorMetrics", ERROR_METRICS_FIELD);
            this.put("AverageWeightedQuantileLoss", AVERAGE_WEIGHTED_QUANTILE_LOSS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Double rmse;
    private final List<WeightedQuantileLoss> weightedQuantileLosses;
    private final List<ErrorMetric> errorMetrics;
    private final Double averageWeightedQuantileLoss;

    private Metrics(BuilderImpl builder) {
        this.rmse = builder.rmse;
        this.weightedQuantileLosses = builder.weightedQuantileLosses;
        this.errorMetrics = builder.errorMetrics;
        this.averageWeightedQuantileLoss = builder.averageWeightedQuantileLoss;
    }

    @Deprecated
    public final Double rmse() {
        return this.rmse;
    }

    public final boolean hasWeightedQuantileLosses() {
        return this.weightedQuantileLosses != null && !(this.weightedQuantileLosses instanceof SdkAutoConstructList);
    }

    public final List<WeightedQuantileLoss> weightedQuantileLosses() {
        return this.weightedQuantileLosses;
    }

    public final boolean hasErrorMetrics() {
        return this.errorMetrics != null && !(this.errorMetrics instanceof SdkAutoConstructList);
    }

    public final List<ErrorMetric> errorMetrics() {
        return this.errorMetrics;
    }

    public final Double averageWeightedQuantileLoss() {
        return this.averageWeightedQuantileLoss;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rmse());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWeightedQuantileLosses() ? this.weightedQuantileLosses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrorMetrics() ? this.errorMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.averageWeightedQuantileLoss());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Metrics)) {
            return false;
        }
        Metrics other = (Metrics)obj;
        return Objects.equals(this.rmse(), other.rmse()) && this.hasWeightedQuantileLosses() == other.hasWeightedQuantileLosses() && Objects.equals(this.weightedQuantileLosses(), other.weightedQuantileLosses()) && this.hasErrorMetrics() == other.hasErrorMetrics() && Objects.equals(this.errorMetrics(), other.errorMetrics()) && Objects.equals(this.averageWeightedQuantileLoss(), other.averageWeightedQuantileLoss());
    }

    public final String toString() {
        return ToString.builder((String)"Metrics").add("RMSE", (Object)this.rmse()).add("WeightedQuantileLosses", this.hasWeightedQuantileLosses() ? this.weightedQuantileLosses() : null).add("ErrorMetrics", this.hasErrorMetrics() ? this.errorMetrics() : null).add("AverageWeightedQuantileLoss", (Object)this.averageWeightedQuantileLoss()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RMSE": {
                return Optional.ofNullable(clazz.cast(this.rmse()));
            }
            case "WeightedQuantileLosses": {
                return Optional.ofNullable(clazz.cast(this.weightedQuantileLosses()));
            }
            case "ErrorMetrics": {
                return Optional.ofNullable(clazz.cast(this.errorMetrics()));
            }
            case "AverageWeightedQuantileLoss": {
                return Optional.ofNullable(clazz.cast(this.averageWeightedQuantileLoss()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Metrics, T> g) {
        return obj -> g.apply((Metrics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double rmse;
        private List<WeightedQuantileLoss> weightedQuantileLosses = DefaultSdkAutoConstructList.getInstance();
        private List<ErrorMetric> errorMetrics = DefaultSdkAutoConstructList.getInstance();
        private Double averageWeightedQuantileLoss;

        private BuilderImpl() {
        }

        private BuilderImpl(Metrics model) {
            this.rmse(model.rmse);
            this.weightedQuantileLosses(model.weightedQuantileLosses);
            this.errorMetrics(model.errorMetrics);
            this.averageWeightedQuantileLoss(model.averageWeightedQuantileLoss);
        }

        @Deprecated
        public final Double getRmse() {
            return this.rmse;
        }

        @Deprecated
        public final void setRmse(Double rmse) {
            this.rmse = rmse;
        }

        @Override
        @Deprecated
        public final Builder rmse(Double rmse) {
            this.rmse = rmse;
            return this;
        }

        public final List<WeightedQuantileLoss.Builder> getWeightedQuantileLosses() {
            List<WeightedQuantileLoss.Builder> result = WeightedQuantileLossesCopier.copyToBuilder(this.weightedQuantileLosses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWeightedQuantileLosses(Collection<WeightedQuantileLoss.BuilderImpl> weightedQuantileLosses) {
            this.weightedQuantileLosses = WeightedQuantileLossesCopier.copyFromBuilder(weightedQuantileLosses);
        }

        @Override
        public final Builder weightedQuantileLosses(Collection<WeightedQuantileLoss> weightedQuantileLosses) {
            this.weightedQuantileLosses = WeightedQuantileLossesCopier.copy(weightedQuantileLosses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder weightedQuantileLosses(WeightedQuantileLoss ... weightedQuantileLosses) {
            this.weightedQuantileLosses(Arrays.asList(weightedQuantileLosses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder weightedQuantileLosses(Consumer<WeightedQuantileLoss.Builder> ... weightedQuantileLosses) {
            this.weightedQuantileLosses(Stream.of(weightedQuantileLosses).map(c -> (WeightedQuantileLoss)((WeightedQuantileLoss.Builder)WeightedQuantileLoss.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ErrorMetric.Builder> getErrorMetrics() {
            List<ErrorMetric.Builder> result = ErrorMetricsCopier.copyToBuilder(this.errorMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrorMetrics(Collection<ErrorMetric.BuilderImpl> errorMetrics) {
            this.errorMetrics = ErrorMetricsCopier.copyFromBuilder(errorMetrics);
        }

        @Override
        public final Builder errorMetrics(Collection<ErrorMetric> errorMetrics) {
            this.errorMetrics = ErrorMetricsCopier.copy(errorMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorMetrics(ErrorMetric ... errorMetrics) {
            this.errorMetrics(Arrays.asList(errorMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorMetrics(Consumer<ErrorMetric.Builder> ... errorMetrics) {
            this.errorMetrics(Stream.of(errorMetrics).map(c -> (ErrorMetric)((ErrorMetric.Builder)ErrorMetric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Double getAverageWeightedQuantileLoss() {
            return this.averageWeightedQuantileLoss;
        }

        public final void setAverageWeightedQuantileLoss(Double averageWeightedQuantileLoss) {
            this.averageWeightedQuantileLoss = averageWeightedQuantileLoss;
        }

        @Override
        public final Builder averageWeightedQuantileLoss(Double averageWeightedQuantileLoss) {
            this.averageWeightedQuantileLoss = averageWeightedQuantileLoss;
            return this;
        }

        public Metrics build() {
            return new Metrics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Metrics> {
        @Deprecated
        public Builder rmse(Double var1);

        public Builder weightedQuantileLosses(Collection<WeightedQuantileLoss> var1);

        public Builder weightedQuantileLosses(WeightedQuantileLoss ... var1);

        public Builder weightedQuantileLosses(Consumer<WeightedQuantileLoss.Builder> ... var1);

        public Builder errorMetrics(Collection<ErrorMetric> var1);

        public Builder errorMetrics(ErrorMetric ... var1);

        public Builder errorMetrics(Consumer<ErrorMetric.Builder> ... var1);

        public Builder averageWeightedQuantileLoss(Double var1);
    }
}

