/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.forecast.ForecastClient;
import software.amazon.awssdk.services.forecast.model.ListWhatIfForecastsRequest;
import software.amazon.awssdk.services.forecast.model.ListWhatIfForecastsResponse;
import software.amazon.awssdk.services.forecast.model.WhatIfForecastSummary;

public class ListWhatIfForecastsIterable
implements SdkIterable<ListWhatIfForecastsResponse> {
    private final ForecastClient client;
    private final ListWhatIfForecastsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWhatIfForecastsIterable(ForecastClient client, ListWhatIfForecastsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListWhatIfForecastsResponseFetcher();
    }

    public Iterator<ListWhatIfForecastsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<WhatIfForecastSummary> whatIfForecasts() {
        Function<ListWhatIfForecastsResponse, Iterator> getIterator = response -> {
            if (response != null && response.whatIfForecasts() != null) {
                return response.whatIfForecasts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListWhatIfForecastsResponseFetcher
    implements SyncPageFetcher<ListWhatIfForecastsResponse> {
        private ListWhatIfForecastsResponseFetcher() {
        }

        public boolean hasNextPage(ListWhatIfForecastsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWhatIfForecastsResponse nextPage(ListWhatIfForecastsResponse previousPage) {
            if (previousPage == null) {
                return ListWhatIfForecastsIterable.this.client.listWhatIfForecasts(ListWhatIfForecastsIterable.this.firstRequest);
            }
            return ListWhatIfForecastsIterable.this.client.listWhatIfForecasts((ListWhatIfForecastsRequest)((Object)ListWhatIfForecastsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

