/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WeightedQuantileLoss
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WeightedQuantileLoss> {
    private static final SdkField<Double> QUANTILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Quantile").getter(WeightedQuantileLoss.getter(WeightedQuantileLoss::quantile)).setter(WeightedQuantileLoss.setter(Builder::quantile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quantile").build()}).build();
    private static final SdkField<Double> LOSS_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("LossValue").getter(WeightedQuantileLoss.getter(WeightedQuantileLoss::lossValue)).setter(WeightedQuantileLoss.setter(Builder::lossValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LossValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUANTILE_FIELD, LOSS_VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Double quantile;
    private final Double lossValue;

    private WeightedQuantileLoss(BuilderImpl builder) {
        this.quantile = builder.quantile;
        this.lossValue = builder.lossValue;
    }

    public final Double quantile() {
        return this.quantile;
    }

    public final Double lossValue() {
        return this.lossValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.quantile());
        hashCode = 31 * hashCode + Objects.hashCode(this.lossValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WeightedQuantileLoss)) {
            return false;
        }
        WeightedQuantileLoss other = (WeightedQuantileLoss)obj;
        return Objects.equals(this.quantile(), other.quantile()) && Objects.equals(this.lossValue(), other.lossValue());
    }

    public final String toString() {
        return ToString.builder((String)"WeightedQuantileLoss").add("Quantile", (Object)this.quantile()).add("LossValue", (Object)this.lossValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Quantile": {
                return Optional.ofNullable(clazz.cast(this.quantile()));
            }
            case "LossValue": {
                return Optional.ofNullable(clazz.cast(this.lossValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WeightedQuantileLoss, T> g) {
        return obj -> g.apply((WeightedQuantileLoss)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double quantile;
        private Double lossValue;

        private BuilderImpl() {
        }

        private BuilderImpl(WeightedQuantileLoss model) {
            this.quantile(model.quantile);
            this.lossValue(model.lossValue);
        }

        public final Double getQuantile() {
            return this.quantile;
        }

        public final void setQuantile(Double quantile) {
            this.quantile = quantile;
        }

        @Override
        public final Builder quantile(Double quantile) {
            this.quantile = quantile;
            return this;
        }

        public final Double getLossValue() {
            return this.lossValue;
        }

        public final void setLossValue(Double lossValue) {
            this.lossValue = lossValue;
        }

        @Override
        public final Builder lossValue(Double lossValue) {
            this.lossValue = lossValue;
            return this;
        }

        public WeightedQuantileLoss build() {
            return new WeightedQuantileLoss(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WeightedQuantileLoss> {
        public Builder quantile(Double var1);

        public Builder lossValue(Double var1);
    }
}

