/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.forecast.model.AdditionalDataset;
import software.amazon.awssdk.services.forecast.model.AdditionalDatasetsCopier;
import software.amazon.awssdk.services.forecast.model.AttributeConfig;
import software.amazon.awssdk.services.forecast.model.AttributeConfigsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataConfig> {
    private static final SdkField<String> DATASET_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetGroupArn").getter(DataConfig.getter(DataConfig::datasetGroupArn)).setter(DataConfig.setter(Builder::datasetGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetGroupArn").build()}).build();
    private static final SdkField<List<AttributeConfig>> ATTRIBUTE_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttributeConfigs").getter(DataConfig.getter(DataConfig::attributeConfigs)).setter(DataConfig.setter(Builder::attributeConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AdditionalDataset>> ADDITIONAL_DATASETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalDatasets").getter(DataConfig.getter(DataConfig::additionalDatasets)).setter(DataConfig.setter(Builder::additionalDatasets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalDatasets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AdditionalDataset::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_GROUP_ARN_FIELD, ATTRIBUTE_CONFIGS_FIELD, ADDITIONAL_DATASETS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String datasetGroupArn;
    private final List<AttributeConfig> attributeConfigs;
    private final List<AdditionalDataset> additionalDatasets;

    private DataConfig(BuilderImpl builder) {
        this.datasetGroupArn = builder.datasetGroupArn;
        this.attributeConfigs = builder.attributeConfigs;
        this.additionalDatasets = builder.additionalDatasets;
    }

    public final String datasetGroupArn() {
        return this.datasetGroupArn;
    }

    public final boolean hasAttributeConfigs() {
        return this.attributeConfigs != null && !(this.attributeConfigs instanceof SdkAutoConstructList);
    }

    public final List<AttributeConfig> attributeConfigs() {
        return this.attributeConfigs;
    }

    public final boolean hasAdditionalDatasets() {
        return this.additionalDatasets != null && !(this.additionalDatasets instanceof SdkAutoConstructList);
    }

    public final List<AdditionalDataset> additionalDatasets() {
        return this.additionalDatasets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributeConfigs() ? this.attributeConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalDatasets() ? this.additionalDatasets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataConfig)) {
            return false;
        }
        DataConfig other = (DataConfig)obj;
        return Objects.equals(this.datasetGroupArn(), other.datasetGroupArn()) && this.hasAttributeConfigs() == other.hasAttributeConfigs() && Objects.equals(this.attributeConfigs(), other.attributeConfigs()) && this.hasAdditionalDatasets() == other.hasAdditionalDatasets() && Objects.equals(this.additionalDatasets(), other.additionalDatasets());
    }

    public final String toString() {
        return ToString.builder((String)"DataConfig").add("DatasetGroupArn", (Object)this.datasetGroupArn()).add("AttributeConfigs", this.hasAttributeConfigs() ? this.attributeConfigs() : null).add("AdditionalDatasets", this.hasAdditionalDatasets() ? this.additionalDatasets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatasetGroupArn": {
                return Optional.ofNullable(clazz.cast(this.datasetGroupArn()));
            }
            case "AttributeConfigs": {
                return Optional.ofNullable(clazz.cast(this.attributeConfigs()));
            }
            case "AdditionalDatasets": {
                return Optional.ofNullable(clazz.cast(this.additionalDatasets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataConfig, T> g) {
        return obj -> g.apply((DataConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String datasetGroupArn;
        private List<AttributeConfig> attributeConfigs = DefaultSdkAutoConstructList.getInstance();
        private List<AdditionalDataset> additionalDatasets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DataConfig model) {
            this.datasetGroupArn(model.datasetGroupArn);
            this.attributeConfigs(model.attributeConfigs);
            this.additionalDatasets(model.additionalDatasets);
        }

        public final String getDatasetGroupArn() {
            return this.datasetGroupArn;
        }

        public final void setDatasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
        }

        @Override
        @Transient
        public final Builder datasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
            return this;
        }

        public final List<AttributeConfig.Builder> getAttributeConfigs() {
            List<AttributeConfig.Builder> result = AttributeConfigsCopier.copyToBuilder(this.attributeConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributeConfigs(Collection<AttributeConfig.BuilderImpl> attributeConfigs) {
            this.attributeConfigs = AttributeConfigsCopier.copyFromBuilder(attributeConfigs);
        }

        @Override
        @Transient
        public final Builder attributeConfigs(Collection<AttributeConfig> attributeConfigs) {
            this.attributeConfigs = AttributeConfigsCopier.copy(attributeConfigs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attributeConfigs(AttributeConfig ... attributeConfigs) {
            this.attributeConfigs(Arrays.asList(attributeConfigs));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attributeConfigs(Consumer<AttributeConfig.Builder> ... attributeConfigs) {
            this.attributeConfigs(Stream.of(attributeConfigs).map(c -> (AttributeConfig)((AttributeConfig.Builder)AttributeConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AdditionalDataset.Builder> getAdditionalDatasets() {
            List<AdditionalDataset.Builder> result = AdditionalDatasetsCopier.copyToBuilder(this.additionalDatasets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalDatasets(Collection<AdditionalDataset.BuilderImpl> additionalDatasets) {
            this.additionalDatasets = AdditionalDatasetsCopier.copyFromBuilder(additionalDatasets);
        }

        @Override
        @Transient
        public final Builder additionalDatasets(Collection<AdditionalDataset> additionalDatasets) {
            this.additionalDatasets = AdditionalDatasetsCopier.copy(additionalDatasets);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder additionalDatasets(AdditionalDataset ... additionalDatasets) {
            this.additionalDatasets(Arrays.asList(additionalDatasets));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder additionalDatasets(Consumer<AdditionalDataset.Builder> ... additionalDatasets) {
            this.additionalDatasets(Stream.of(additionalDatasets).map(c -> (AdditionalDataset)((AdditionalDataset.Builder)AdditionalDataset.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DataConfig build() {
            return new DataConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataConfig> {
        public Builder datasetGroupArn(String var1);

        public Builder attributeConfigs(Collection<AttributeConfig> var1);

        public Builder attributeConfigs(AttributeConfig ... var1);

        public Builder attributeConfigs(Consumer<AttributeConfig.Builder> ... var1);

        public Builder additionalDatasets(Collection<AdditionalDataset> var1);

        public Builder additionalDatasets(AdditionalDataset ... var1);

        public Builder additionalDatasets(Consumer<AdditionalDataset.Builder> ... var1);
    }
}

