/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePredictorBacktestExportJobRequest extends ForecastRequest implements
        ToCopyableBuilder<CreatePredictorBacktestExportJobRequest.Builder, CreatePredictorBacktestExportJobRequest> {
    private static final SdkField<String> PREDICTOR_BACKTEST_EXPORT_JOB_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PredictorBacktestExportJobName")
            .getter(getter(CreatePredictorBacktestExportJobRequest::predictorBacktestExportJobName))
            .setter(setter(Builder::predictorBacktestExportJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictorBacktestExportJobName")
                    .build()).build();

    private static final SdkField<String> PREDICTOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PredictorArn").getter(getter(CreatePredictorBacktestExportJobRequest::predictorArn))
            .setter(setter(Builder::predictorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictorArn").build()).build();

    private static final SdkField<DataDestination> DESTINATION_FIELD = SdkField
            .<DataDestination> builder(MarshallingType.SDK_POJO).memberName("Destination")
            .getter(getter(CreatePredictorBacktestExportJobRequest::destination)).setter(setter(Builder::destination))
            .constructor(DataDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreatePredictorBacktestExportJobRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PREDICTOR_BACKTEST_EXPORT_JOB_NAME_FIELD, PREDICTOR_ARN_FIELD, DESTINATION_FIELD, TAGS_FIELD));

    private final String predictorBacktestExportJobName;

    private final String predictorArn;

    private final DataDestination destination;

    private final List<Tag> tags;

    private CreatePredictorBacktestExportJobRequest(BuilderImpl builder) {
        super(builder);
        this.predictorBacktestExportJobName = builder.predictorBacktestExportJobName;
        this.predictorArn = builder.predictorArn;
        this.destination = builder.destination;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name for the backtest export job.
     * </p>
     * 
     * @return The name for the backtest export job.
     */
    public final String predictorBacktestExportJobName() {
        return predictorBacktestExportJobName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the predictor that you want to export.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the predictor that you want to export.
     */
    public final String predictorArn() {
        return predictorArn;
    }

    /**
     * Returns the value of the Destination property for this object.
     * 
     * @return The value of the Destination property for this object.
     */
    public final DataDestination destination() {
        return destination;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Optional metadata to help you categorize and organize your backtests. Each tag consists of a key and an optional
     * value, both of which you define. Tag keys and values are case sensitive.
     * </p>
     * <p>
     * The following restrictions apply to tags:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For each resource, each tag key must be unique and each tag key must have one value.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum number of tags per resource: 50.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum key length: 128 Unicode characters in UTF-8.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum value length: 256 Unicode characters in UTF-8.
     * </p>
     * </li>
     * <li>
     * <p>
     * Accepted characters: all letters and numbers, spaces representable in UTF-8, and + - = . _ : / @. If your tagging
     * schema is used across other services and resources, the character restrictions of those services also apply.
     * </p>
     * </li>
     * <li>
     * <p>
     * Key prefixes cannot include any upper or lowercase combination of <code>aws:</code> or <code>AWS:</code>. Values
     * can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, Forecast considers
     * it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of
     * <code>aws</code> do not count against your tags per resource limit. You cannot edit or delete tag keys with this
     * prefix.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Optional metadata to help you categorize and organize your backtests. Each tag consists of a key and an
     *         optional value, both of which you define. Tag keys and values are case sensitive.</p>
     *         <p>
     *         The following restrictions apply to tags:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For each resource, each tag key must be unique and each tag key must have one value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum number of tags per resource: 50.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum key length: 128 Unicode characters in UTF-8.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum value length: 256 Unicode characters in UTF-8.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Accepted characters: all letters and numbers, spaces representable in UTF-8, and + - = . _ : / @. If your
     *         tagging schema is used across other services and resources, the character restrictions of those services
     *         also apply.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Key prefixes cannot include any upper or lowercase combination of <code>aws:</code> or <code>AWS:</code>.
     *         Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not,
     *         Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the
     *         key prefix of <code>aws</code> do not count against your tags per resource limit. You cannot edit or
     *         delete tag keys with this prefix.
     *         </p>
     *         </li>
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(predictorBacktestExportJobName());
        hashCode = 31 * hashCode + Objects.hashCode(predictorArn());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePredictorBacktestExportJobRequest)) {
            return false;
        }
        CreatePredictorBacktestExportJobRequest other = (CreatePredictorBacktestExportJobRequest) obj;
        return Objects.equals(predictorBacktestExportJobName(), other.predictorBacktestExportJobName())
                && Objects.equals(predictorArn(), other.predictorArn()) && Objects.equals(destination(), other.destination())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePredictorBacktestExportJobRequest")
                .add("PredictorBacktestExportJobName", predictorBacktestExportJobName()).add("PredictorArn", predictorArn())
                .add("Destination", destination()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PredictorBacktestExportJobName":
            return Optional.ofNullable(clazz.cast(predictorBacktestExportJobName()));
        case "PredictorArn":
            return Optional.ofNullable(clazz.cast(predictorArn()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePredictorBacktestExportJobRequest, T> g) {
        return obj -> g.apply((CreatePredictorBacktestExportJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ForecastRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreatePredictorBacktestExportJobRequest> {
        /**
         * <p>
         * The name for the backtest export job.
         * </p>
         * 
         * @param predictorBacktestExportJobName
         *        The name for the backtest export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictorBacktestExportJobName(String predictorBacktestExportJobName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the predictor that you want to export.
         * </p>
         * 
         * @param predictorArn
         *        The Amazon Resource Name (ARN) of the predictor that you want to export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictorArn(String predictorArn);

        /**
         * Sets the value of the Destination property for this object.
         *
         * @param destination
         *        The new value for the Destination property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(DataDestination destination);

        /**
         * Sets the value of the Destination property for this object.
         *
         * This is a convenience that creates an instance of the {@link DataDestination.Builder} avoiding the need to
         * create one manually via {@link DataDestination#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataDestination.Builder#build()} is called immediately and its
         * result is passed to {@link #destination(DataDestination)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link DataDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(DataDestination)
         */
        default Builder destination(Consumer<DataDestination.Builder> destination) {
            return destination(DataDestination.builder().applyMutation(destination).build());
        }

        /**
         * <p>
         * Optional metadata to help you categorize and organize your backtests. Each tag consists of a key and an
         * optional value, both of which you define. Tag keys and values are case sensitive.
         * </p>
         * <p>
         * The following restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For each resource, each tag key must be unique and each tag key must have one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum number of tags per resource: 50.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length: 128 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length: 256 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * Accepted characters: all letters and numbers, spaces representable in UTF-8, and + - = . _ : / @. If your
         * tagging schema is used across other services and resources, the character restrictions of those services also
         * apply.
         * </p>
         * </li>
         * <li>
         * <p>
         * Key prefixes cannot include any upper or lowercase combination of <code>aws:</code> or <code>AWS:</code>.
         * Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, Forecast
         * considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of
         * <code>aws</code> do not count against your tags per resource limit. You cannot edit or delete tag keys with
         * this prefix.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        Optional metadata to help you categorize and organize your backtests. Each tag consists of a key and
         *        an optional value, both of which you define. Tag keys and values are case sensitive.</p>
         *        <p>
         *        The following restrictions apply to tags:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For each resource, each tag key must be unique and each tag key must have one value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum number of tags per resource: 50.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum key length: 128 Unicode characters in UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum value length: 256 Unicode characters in UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Accepted characters: all letters and numbers, spaces representable in UTF-8, and + - = . _ : / @. If
         *        your tagging schema is used across other services and resources, the character restrictions of those
         *        services also apply.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key prefixes cannot include any upper or lowercase combination of <code>aws:</code> or
         *        <code>AWS:</code>. Values can have this prefix. If a tag value has <code>aws</code> as its prefix but
         *        the key does not, Forecast considers it to be a user tag and will count against the limit of 50 tags.
         *        Tags with only the key prefix of <code>aws</code> do not count against your tags per resource limit.
         *        You cannot edit or delete tag keys with this prefix.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Optional metadata to help you categorize and organize your backtests. Each tag consists of a key and an
         * optional value, both of which you define. Tag keys and values are case sensitive.
         * </p>
         * <p>
         * The following restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For each resource, each tag key must be unique and each tag key must have one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum number of tags per resource: 50.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length: 128 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length: 256 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * Accepted characters: all letters and numbers, spaces representable in UTF-8, and + - = . _ : / @. If your
         * tagging schema is used across other services and resources, the character restrictions of those services also
         * apply.
         * </p>
         * </li>
         * <li>
         * <p>
         * Key prefixes cannot include any upper or lowercase combination of <code>aws:</code> or <code>AWS:</code>.
         * Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, Forecast
         * considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of
         * <code>aws</code> do not count against your tags per resource limit. You cannot edit or delete tag keys with
         * this prefix.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        Optional metadata to help you categorize and organize your backtests. Each tag consists of a key and
         *        an optional value, both of which you define. Tag keys and values are case sensitive.</p>
         *        <p>
         *        The following restrictions apply to tags:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For each resource, each tag key must be unique and each tag key must have one value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum number of tags per resource: 50.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum key length: 128 Unicode characters in UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum value length: 256 Unicode characters in UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Accepted characters: all letters and numbers, spaces representable in UTF-8, and + - = . _ : / @. If
         *        your tagging schema is used across other services and resources, the character restrictions of those
         *        services also apply.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key prefixes cannot include any upper or lowercase combination of <code>aws:</code> or
         *        <code>AWS:</code>. Values can have this prefix. If a tag value has <code>aws</code> as its prefix but
         *        the key does not, Forecast considers it to be a user tag and will count against the limit of 50 tags.
         *        Tags with only the key prefix of <code>aws</code> do not count against your tags per resource limit.
         *        You cannot edit or delete tag keys with this prefix.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Optional metadata to help you categorize and organize your backtests. Each tag consists of a key and an
         * optional value, both of which you define. Tag keys and values are case sensitive.
         * </p>
         * <p>
         * The following restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For each resource, each tag key must be unique and each tag key must have one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum number of tags per resource: 50.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length: 128 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length: 256 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * Accepted characters: all letters and numbers, spaces representable in UTF-8, and + - = . _ : / @. If your
         * tagging schema is used across other services and resources, the character restrictions of those services also
         * apply.
         * </p>
         * </li>
         * <li>
         * <p>
         * Key prefixes cannot include any upper or lowercase combination of <code>aws:</code> or <code>AWS:</code>.
         * Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, Forecast
         * considers it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of
         * <code>aws</code> do not count against your tags per resource limit. You cannot edit or delete tag keys with
         * this prefix.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ForecastRequest.BuilderImpl implements Builder {
        private String predictorBacktestExportJobName;

        private String predictorArn;

        private DataDestination destination;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePredictorBacktestExportJobRequest model) {
            super(model);
            predictorBacktestExportJobName(model.predictorBacktestExportJobName);
            predictorArn(model.predictorArn);
            destination(model.destination);
            tags(model.tags);
        }

        public final String getPredictorBacktestExportJobName() {
            return predictorBacktestExportJobName;
        }

        @Override
        public final Builder predictorBacktestExportJobName(String predictorBacktestExportJobName) {
            this.predictorBacktestExportJobName = predictorBacktestExportJobName;
            return this;
        }

        public final void setPredictorBacktestExportJobName(String predictorBacktestExportJobName) {
            this.predictorBacktestExportJobName = predictorBacktestExportJobName;
        }

        public final String getPredictorArn() {
            return predictorArn;
        }

        @Override
        public final Builder predictorArn(String predictorArn) {
            this.predictorArn = predictorArn;
            return this;
        }

        public final void setPredictorArn(String predictorArn) {
            this.predictorArn = predictorArn;
        }

        public final DataDestination.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        @Override
        public final Builder destination(DataDestination destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(DataDestination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePredictorBacktestExportJobRequest build() {
            return new CreatePredictorBacktestExportJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
