/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.forecast.model.TestWindowDetailsCopier;
import software.amazon.awssdk.services.forecast.model.TestWindowSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PredictorExecution
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PredictorExecution> {
    private static final SdkField<String> ALGORITHM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlgorithmArn").getter(PredictorExecution.getter(PredictorExecution::algorithmArn)).setter(PredictorExecution.setter(Builder::algorithmArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmArn").build()}).build();
    private static final SdkField<List<TestWindowSummary>> TEST_WINDOWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TestWindows").getter(PredictorExecution.getter(PredictorExecution::testWindows)).setter(PredictorExecution.setter(Builder::testWindows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TestWindows").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TestWindowSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALGORITHM_ARN_FIELD, TEST_WINDOWS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String algorithmArn;
    private final List<TestWindowSummary> testWindows;

    private PredictorExecution(BuilderImpl builder) {
        this.algorithmArn = builder.algorithmArn;
        this.testWindows = builder.testWindows;
    }

    public String algorithmArn() {
        return this.algorithmArn;
    }

    public boolean hasTestWindows() {
        return this.testWindows != null && !(this.testWindows instanceof SdkAutoConstructList);
    }

    public List<TestWindowSummary> testWindows() {
        return this.testWindows;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.testWindows());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredictorExecution)) {
            return false;
        }
        PredictorExecution other = (PredictorExecution)obj;
        return Objects.equals(this.algorithmArn(), other.algorithmArn()) && Objects.equals(this.testWindows(), other.testWindows());
    }

    public String toString() {
        return ToString.builder((String)"PredictorExecution").add("AlgorithmArn", (Object)this.algorithmArn()).add("TestWindows", this.testWindows()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AlgorithmArn": {
                return Optional.ofNullable(clazz.cast(this.algorithmArn()));
            }
            case "TestWindows": {
                return Optional.ofNullable(clazz.cast(this.testWindows()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PredictorExecution, T> g) {
        return obj -> g.apply((PredictorExecution)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String algorithmArn;
        private List<TestWindowSummary> testWindows = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PredictorExecution model) {
            this.algorithmArn(model.algorithmArn);
            this.testWindows(model.testWindows);
        }

        public final String getAlgorithmArn() {
            return this.algorithmArn;
        }

        @Override
        public final Builder algorithmArn(String algorithmArn) {
            this.algorithmArn = algorithmArn;
            return this;
        }

        public final void setAlgorithmArn(String algorithmArn) {
            this.algorithmArn = algorithmArn;
        }

        public final Collection<TestWindowSummary.Builder> getTestWindows() {
            return this.testWindows != null ? (Collection)this.testWindows.stream().map(TestWindowSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder testWindows(Collection<TestWindowSummary> testWindows) {
            this.testWindows = TestWindowDetailsCopier.copy(testWindows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testWindows(TestWindowSummary ... testWindows) {
            this.testWindows(Arrays.asList(testWindows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testWindows(Consumer<TestWindowSummary.Builder> ... testWindows) {
            this.testWindows(Stream.of(testWindows).map(c -> (TestWindowSummary)((TestWindowSummary.Builder)TestWindowSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTestWindows(Collection<TestWindowSummary.BuilderImpl> testWindows) {
            this.testWindows = TestWindowDetailsCopier.copyFromBuilder(testWindows);
        }

        public PredictorExecution build() {
            return new PredictorExecution(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PredictorExecution> {
        public Builder algorithmArn(String var1);

        public Builder testWindows(Collection<TestWindowSummary> var1);

        public Builder testWindows(TestWindowSummary ... var1);

        public Builder testWindows(Consumer<TestWindowSummary.Builder> ... var1);
    }
}

