/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fms.model.SecurityServiceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SecurityServicePolicyData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SecurityServicePolicyData> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SecurityServicePolicyData.getter(SecurityServicePolicyData::typeAsString)).setter(SecurityServicePolicyData.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> MANAGED_SERVICE_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SecurityServicePolicyData.getter(SecurityServicePolicyData::managedServiceData)).setter(SecurityServicePolicyData.setter(Builder::managedServiceData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedServiceData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, MANAGED_SERVICE_DATA_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String managedServiceData;

    private SecurityServicePolicyData(BuilderImpl builder) {
        this.type = builder.type;
        this.managedServiceData = builder.managedServiceData;
    }

    public SecurityServiceType type() {
        return SecurityServiceType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String managedServiceData() {
        return this.managedServiceData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedServiceData());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityServicePolicyData)) {
            return false;
        }
        SecurityServicePolicyData other = (SecurityServicePolicyData)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.managedServiceData(), other.managedServiceData());
    }

    public String toString() {
        return ToString.builder((String)"SecurityServicePolicyData").add("Type", (Object)this.typeAsString()).add("ManagedServiceData", (Object)this.managedServiceData()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "ManagedServiceData": {
                return Optional.ofNullable(clazz.cast(this.managedServiceData()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SecurityServicePolicyData, T> g) {
        return obj -> g.apply((SecurityServicePolicyData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String managedServiceData;

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityServicePolicyData model) {
            this.type(model.type);
            this.managedServiceData(model.managedServiceData);
        }

        public final String getTypeAsString() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SecurityServiceType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getManagedServiceData() {
            return this.managedServiceData;
        }

        @Override
        public final Builder managedServiceData(String managedServiceData) {
            this.managedServiceData = managedServiceData;
            return this;
        }

        public final void setManagedServiceData(String managedServiceData) {
            this.managedServiceData = managedServiceData;
        }

        public SecurityServicePolicyData build() {
            return new SecurityServicePolicyData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SecurityServicePolicyData> {
        public Builder type(String var1);

        public Builder type(SecurityServiceType var1);

        public Builder managedServiceData(String var1);
    }
}

