/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.fms.model.FmsResponse;
import software.amazon.awssdk.services.fms.model.PolicyComplianceStatus;
import software.amazon.awssdk.services.fms.model.PolicyComplianceStatusListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListComplianceStatusResponse
extends FmsResponse
implements ToCopyableBuilder<Builder, ListComplianceStatusResponse> {
    private static final SdkField<List<PolicyComplianceStatus>> POLICY_COMPLIANCE_STATUS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListComplianceStatusResponse.getter(ListComplianceStatusResponse::policyComplianceStatusList)).setter(ListComplianceStatusResponse.setter(Builder::policyComplianceStatusList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyComplianceStatusList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PolicyComplianceStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListComplianceStatusResponse.getter(ListComplianceStatusResponse::nextToken)).setter(ListComplianceStatusResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_COMPLIANCE_STATUS_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<PolicyComplianceStatus> policyComplianceStatusList;
    private final String nextToken;

    private ListComplianceStatusResponse(BuilderImpl builder) {
        super(builder);
        this.policyComplianceStatusList = builder.policyComplianceStatusList;
        this.nextToken = builder.nextToken;
    }

    public List<PolicyComplianceStatus> policyComplianceStatusList() {
        return this.policyComplianceStatusList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyComplianceStatusList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListComplianceStatusResponse)) {
            return false;
        }
        ListComplianceStatusResponse other = (ListComplianceStatusResponse)((Object)obj);
        return Objects.equals(this.policyComplianceStatusList(), other.policyComplianceStatusList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListComplianceStatusResponse").add("PolicyComplianceStatusList", this.policyComplianceStatusList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyComplianceStatusList": {
                return Optional.ofNullable(clazz.cast(this.policyComplianceStatusList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListComplianceStatusResponse, T> g) {
        return obj -> g.apply((ListComplianceStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FmsResponse.BuilderImpl
    implements Builder {
        private List<PolicyComplianceStatus> policyComplianceStatusList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListComplianceStatusResponse model) {
            super(model);
            this.policyComplianceStatusList(model.policyComplianceStatusList);
            this.nextToken(model.nextToken);
        }

        public final Collection<PolicyComplianceStatus.Builder> getPolicyComplianceStatusList() {
            return this.policyComplianceStatusList != null ? (Collection)this.policyComplianceStatusList.stream().map(PolicyComplianceStatus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder policyComplianceStatusList(Collection<PolicyComplianceStatus> policyComplianceStatusList) {
            this.policyComplianceStatusList = PolicyComplianceStatusListCopier.copy(policyComplianceStatusList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyComplianceStatusList(PolicyComplianceStatus ... policyComplianceStatusList) {
            this.policyComplianceStatusList(Arrays.asList(policyComplianceStatusList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyComplianceStatusList(Consumer<PolicyComplianceStatus.Builder> ... policyComplianceStatusList) {
            this.policyComplianceStatusList(Stream.of(policyComplianceStatusList).map(c -> (PolicyComplianceStatus)((PolicyComplianceStatus.Builder)PolicyComplianceStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPolicyComplianceStatusList(Collection<PolicyComplianceStatus.BuilderImpl> policyComplianceStatusList) {
            this.policyComplianceStatusList = PolicyComplianceStatusListCopier.copyFromBuilder(policyComplianceStatusList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListComplianceStatusResponse build() {
            return new ListComplianceStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FmsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListComplianceStatusResponse> {
        public Builder policyComplianceStatusList(Collection<PolicyComplianceStatus> var1);

        public Builder policyComplianceStatusList(PolicyComplianceStatus ... var1);

        public Builder policyComplianceStatusList(Consumer<PolicyComplianceStatus.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

