/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListComplianceStatusResponse extends FmsResponse implements
        ToCopyableBuilder<ListComplianceStatusResponse.Builder, ListComplianceStatusResponse> {
    private static final SdkField<List<PolicyComplianceStatus>> POLICY_COMPLIANCE_STATUS_LIST_FIELD = SdkField
            .<List<PolicyComplianceStatus>> builder(MarshallingType.LIST)
            .memberName("PolicyComplianceStatusList")
            .getter(getter(ListComplianceStatusResponse::policyComplianceStatusList))
            .setter(setter(Builder::policyComplianceStatusList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyComplianceStatusList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PolicyComplianceStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(PolicyComplianceStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListComplianceStatusResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            POLICY_COMPLIANCE_STATUS_LIST_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<PolicyComplianceStatus> policyComplianceStatusList;

    private final String nextToken;

    private ListComplianceStatusResponse(BuilderImpl builder) {
        super(builder);
        this.policyComplianceStatusList = builder.policyComplianceStatusList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the PolicyComplianceStatusList property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPolicyComplianceStatusList() {
        return policyComplianceStatusList != null && !(policyComplianceStatusList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>PolicyComplianceStatus</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPolicyComplianceStatusList} method.
     * </p>
     * 
     * @return An array of <code>PolicyComplianceStatus</code> objects.
     */
    public final List<PolicyComplianceStatus> policyComplianceStatusList() {
        return policyComplianceStatusList;
    }

    /**
     * <p>
     * If you have more <code>PolicyComplianceStatus</code> objects than the number that you specified for
     * <code>MaxResults</code> in the request, the response includes a <code>NextToken</code> value. To list more
     * <code>PolicyComplianceStatus</code> objects, submit another <code>ListComplianceStatus</code> request, and
     * specify the <code>NextToken</code> value from the response in the <code>NextToken</code> value in the next
     * request.
     * </p>
     * 
     * @return If you have more <code>PolicyComplianceStatus</code> objects than the number that you specified for
     *         <code>MaxResults</code> in the request, the response includes a <code>NextToken</code> value. To list
     *         more <code>PolicyComplianceStatus</code> objects, submit another <code>ListComplianceStatus</code>
     *         request, and specify the <code>NextToken</code> value from the response in the <code>NextToken</code>
     *         value in the next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPolicyComplianceStatusList() ? policyComplianceStatusList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListComplianceStatusResponse)) {
            return false;
        }
        ListComplianceStatusResponse other = (ListComplianceStatusResponse) obj;
        return hasPolicyComplianceStatusList() == other.hasPolicyComplianceStatusList()
                && Objects.equals(policyComplianceStatusList(), other.policyComplianceStatusList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListComplianceStatusResponse")
                .add("PolicyComplianceStatusList", hasPolicyComplianceStatusList() ? policyComplianceStatusList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyComplianceStatusList":
            return Optional.ofNullable(clazz.cast(policyComplianceStatusList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PolicyComplianceStatusList", POLICY_COMPLIANCE_STATUS_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListComplianceStatusResponse, T> g) {
        return obj -> g.apply((ListComplianceStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends FmsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListComplianceStatusResponse> {
        /**
         * <p>
         * An array of <code>PolicyComplianceStatus</code> objects.
         * </p>
         * 
         * @param policyComplianceStatusList
         *        An array of <code>PolicyComplianceStatus</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyComplianceStatusList(Collection<PolicyComplianceStatus> policyComplianceStatusList);

        /**
         * <p>
         * An array of <code>PolicyComplianceStatus</code> objects.
         * </p>
         * 
         * @param policyComplianceStatusList
         *        An array of <code>PolicyComplianceStatus</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyComplianceStatusList(PolicyComplianceStatus... policyComplianceStatusList);

        /**
         * <p>
         * An array of <code>PolicyComplianceStatus</code> objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.fms.model.PolicyComplianceStatus.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.fms.model.PolicyComplianceStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.fms.model.PolicyComplianceStatus.Builder#build()} is called
         * immediately and its result is passed to {@link #policyComplianceStatusList(List<PolicyComplianceStatus>)}.
         * 
         * @param policyComplianceStatusList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.fms.model.PolicyComplianceStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policyComplianceStatusList(java.util.Collection<PolicyComplianceStatus>)
         */
        Builder policyComplianceStatusList(Consumer<PolicyComplianceStatus.Builder>... policyComplianceStatusList);

        /**
         * <p>
         * If you have more <code>PolicyComplianceStatus</code> objects than the number that you specified for
         * <code>MaxResults</code> in the request, the response includes a <code>NextToken</code> value. To list more
         * <code>PolicyComplianceStatus</code> objects, submit another <code>ListComplianceStatus</code> request, and
         * specify the <code>NextToken</code> value from the response in the <code>NextToken</code> value in the next
         * request.
         * </p>
         * 
         * @param nextToken
         *        If you have more <code>PolicyComplianceStatus</code> objects than the number that you specified for
         *        <code>MaxResults</code> in the request, the response includes a <code>NextToken</code> value. To list
         *        more <code>PolicyComplianceStatus</code> objects, submit another <code>ListComplianceStatus</code>
         *        request, and specify the <code>NextToken</code> value from the response in the <code>NextToken</code>
         *        value in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends FmsResponse.BuilderImpl implements Builder {
        private List<PolicyComplianceStatus> policyComplianceStatusList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListComplianceStatusResponse model) {
            super(model);
            policyComplianceStatusList(model.policyComplianceStatusList);
            nextToken(model.nextToken);
        }

        public final List<PolicyComplianceStatus.Builder> getPolicyComplianceStatusList() {
            List<PolicyComplianceStatus.Builder> result = PolicyComplianceStatusListCopier
                    .copyToBuilder(this.policyComplianceStatusList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolicyComplianceStatusList(Collection<PolicyComplianceStatus.BuilderImpl> policyComplianceStatusList) {
            this.policyComplianceStatusList = PolicyComplianceStatusListCopier.copyFromBuilder(policyComplianceStatusList);
        }

        @Override
        public final Builder policyComplianceStatusList(Collection<PolicyComplianceStatus> policyComplianceStatusList) {
            this.policyComplianceStatusList = PolicyComplianceStatusListCopier.copy(policyComplianceStatusList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyComplianceStatusList(PolicyComplianceStatus... policyComplianceStatusList) {
            policyComplianceStatusList(Arrays.asList(policyComplianceStatusList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyComplianceStatusList(Consumer<PolicyComplianceStatus.Builder>... policyComplianceStatusList) {
            policyComplianceStatusList(Stream.of(policyComplianceStatusList)
                    .map(c -> PolicyComplianceStatus.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListComplianceStatusResponse build() {
            return new ListComplianceStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
