/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Violation detail for the entries in a network ACL resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvalidNetworkAclEntriesViolation implements SdkPojo, Serializable,
        ToCopyableBuilder<InvalidNetworkAclEntriesViolation.Builder, InvalidNetworkAclEntriesViolation> {
    private static final SdkField<String> VPC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Vpc")
            .getter(getter(InvalidNetworkAclEntriesViolation::vpc)).setter(setter(Builder::vpc))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vpc").build()).build();

    private static final SdkField<String> SUBNET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Subnet")
            .getter(getter(InvalidNetworkAclEntriesViolation::subnet)).setter(setter(Builder::subnet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subnet").build()).build();

    private static final SdkField<String> SUBNET_AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetAvailabilityZone").getter(getter(InvalidNetworkAclEntriesViolation::subnetAvailabilityZone))
            .setter(setter(Builder::subnetAvailabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetAvailabilityZone").build())
            .build();

    private static final SdkField<String> CURRENT_ASSOCIATED_NETWORK_ACL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CurrentAssociatedNetworkAcl")
            .getter(getter(InvalidNetworkAclEntriesViolation::currentAssociatedNetworkAcl))
            .setter(setter(Builder::currentAssociatedNetworkAcl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentAssociatedNetworkAcl")
                    .build()).build();

    private static final SdkField<List<EntryViolation>> ENTRY_VIOLATIONS_FIELD = SdkField
            .<List<EntryViolation>> builder(MarshallingType.LIST)
            .memberName("EntryViolations")
            .getter(getter(InvalidNetworkAclEntriesViolation::entryViolations))
            .setter(setter(Builder::entryViolations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntryViolations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EntryViolation> builder(MarshallingType.SDK_POJO)
                                            .constructor(EntryViolation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_FIELD, SUBNET_FIELD,
            SUBNET_AVAILABILITY_ZONE_FIELD, CURRENT_ASSOCIATED_NETWORK_ACL_FIELD, ENTRY_VIOLATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String vpc;

    private final String subnet;

    private final String subnetAvailabilityZone;

    private final String currentAssociatedNetworkAcl;

    private final List<EntryViolation> entryViolations;

    private InvalidNetworkAclEntriesViolation(BuilderImpl builder) {
        this.vpc = builder.vpc;
        this.subnet = builder.subnet;
        this.subnetAvailabilityZone = builder.subnetAvailabilityZone;
        this.currentAssociatedNetworkAcl = builder.currentAssociatedNetworkAcl;
        this.entryViolations = builder.entryViolations;
    }

    /**
     * <p>
     * The VPC where the violation was found.
     * </p>
     * 
     * @return The VPC where the violation was found.
     */
    public final String vpc() {
        return vpc;
    }

    /**
     * <p>
     * The subnet that's associated with the network ACL.
     * </p>
     * 
     * @return The subnet that's associated with the network ACL.
     */
    public final String subnet() {
        return subnet;
    }

    /**
     * <p>
     * The Availability Zone where the network ACL is in use.
     * </p>
     * 
     * @return The Availability Zone where the network ACL is in use.
     */
    public final String subnetAvailabilityZone() {
        return subnetAvailabilityZone;
    }

    /**
     * <p>
     * The network ACL containing the entry violations.
     * </p>
     * 
     * @return The network ACL containing the entry violations.
     */
    public final String currentAssociatedNetworkAcl() {
        return currentAssociatedNetworkAcl;
    }

    /**
     * For responses, this returns true if the service returned a value for the EntryViolations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEntryViolations() {
        return entryViolations != null && !(entryViolations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Detailed information about the entry violations in the network ACL.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntryViolations} method.
     * </p>
     * 
     * @return Detailed information about the entry violations in the network ACL.
     */
    public final List<EntryViolation> entryViolations() {
        return entryViolations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpc());
        hashCode = 31 * hashCode + Objects.hashCode(subnet());
        hashCode = 31 * hashCode + Objects.hashCode(subnetAvailabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(currentAssociatedNetworkAcl());
        hashCode = 31 * hashCode + Objects.hashCode(hasEntryViolations() ? entryViolations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvalidNetworkAclEntriesViolation)) {
            return false;
        }
        InvalidNetworkAclEntriesViolation other = (InvalidNetworkAclEntriesViolation) obj;
        return Objects.equals(vpc(), other.vpc()) && Objects.equals(subnet(), other.subnet())
                && Objects.equals(subnetAvailabilityZone(), other.subnetAvailabilityZone())
                && Objects.equals(currentAssociatedNetworkAcl(), other.currentAssociatedNetworkAcl())
                && hasEntryViolations() == other.hasEntryViolations()
                && Objects.equals(entryViolations(), other.entryViolations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvalidNetworkAclEntriesViolation").add("Vpc", vpc()).add("Subnet", subnet())
                .add("SubnetAvailabilityZone", subnetAvailabilityZone())
                .add("CurrentAssociatedNetworkAcl", currentAssociatedNetworkAcl())
                .add("EntryViolations", hasEntryViolations() ? entryViolations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Vpc":
            return Optional.ofNullable(clazz.cast(vpc()));
        case "Subnet":
            return Optional.ofNullable(clazz.cast(subnet()));
        case "SubnetAvailabilityZone":
            return Optional.ofNullable(clazz.cast(subnetAvailabilityZone()));
        case "CurrentAssociatedNetworkAcl":
            return Optional.ofNullable(clazz.cast(currentAssociatedNetworkAcl()));
        case "EntryViolations":
            return Optional.ofNullable(clazz.cast(entryViolations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Vpc", VPC_FIELD);
        map.put("Subnet", SUBNET_FIELD);
        map.put("SubnetAvailabilityZone", SUBNET_AVAILABILITY_ZONE_FIELD);
        map.put("CurrentAssociatedNetworkAcl", CURRENT_ASSOCIATED_NETWORK_ACL_FIELD);
        map.put("EntryViolations", ENTRY_VIOLATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvalidNetworkAclEntriesViolation, T> g) {
        return obj -> g.apply((InvalidNetworkAclEntriesViolation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InvalidNetworkAclEntriesViolation> {
        /**
         * <p>
         * The VPC where the violation was found.
         * </p>
         * 
         * @param vpc
         *        The VPC where the violation was found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpc(String vpc);

        /**
         * <p>
         * The subnet that's associated with the network ACL.
         * </p>
         * 
         * @param subnet
         *        The subnet that's associated with the network ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnet(String subnet);

        /**
         * <p>
         * The Availability Zone where the network ACL is in use.
         * </p>
         * 
         * @param subnetAvailabilityZone
         *        The Availability Zone where the network ACL is in use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetAvailabilityZone(String subnetAvailabilityZone);

        /**
         * <p>
         * The network ACL containing the entry violations.
         * </p>
         * 
         * @param currentAssociatedNetworkAcl
         *        The network ACL containing the entry violations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentAssociatedNetworkAcl(String currentAssociatedNetworkAcl);

        /**
         * <p>
         * Detailed information about the entry violations in the network ACL.
         * </p>
         * 
         * @param entryViolations
         *        Detailed information about the entry violations in the network ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entryViolations(Collection<EntryViolation> entryViolations);

        /**
         * <p>
         * Detailed information about the entry violations in the network ACL.
         * </p>
         * 
         * @param entryViolations
         *        Detailed information about the entry violations in the network ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entryViolations(EntryViolation... entryViolations);

        /**
         * <p>
         * Detailed information about the entry violations in the network ACL.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.fms.model.EntryViolation.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.fms.model.EntryViolation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.fms.model.EntryViolation.Builder#build()} is called immediately and
         * its result is passed to {@link #entryViolations(List<EntryViolation>)}.
         * 
         * @param entryViolations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.fms.model.EntryViolation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entryViolations(java.util.Collection<EntryViolation>)
         */
        Builder entryViolations(Consumer<EntryViolation.Builder>... entryViolations);
    }

    static final class BuilderImpl implements Builder {
        private String vpc;

        private String subnet;

        private String subnetAvailabilityZone;

        private String currentAssociatedNetworkAcl;

        private List<EntryViolation> entryViolations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidNetworkAclEntriesViolation model) {
            vpc(model.vpc);
            subnet(model.subnet);
            subnetAvailabilityZone(model.subnetAvailabilityZone);
            currentAssociatedNetworkAcl(model.currentAssociatedNetworkAcl);
            entryViolations(model.entryViolations);
        }

        public final String getVpc() {
            return vpc;
        }

        public final void setVpc(String vpc) {
            this.vpc = vpc;
        }

        @Override
        public final Builder vpc(String vpc) {
            this.vpc = vpc;
            return this;
        }

        public final String getSubnet() {
            return subnet;
        }

        public final void setSubnet(String subnet) {
            this.subnet = subnet;
        }

        @Override
        public final Builder subnet(String subnet) {
            this.subnet = subnet;
            return this;
        }

        public final String getSubnetAvailabilityZone() {
            return subnetAvailabilityZone;
        }

        public final void setSubnetAvailabilityZone(String subnetAvailabilityZone) {
            this.subnetAvailabilityZone = subnetAvailabilityZone;
        }

        @Override
        public final Builder subnetAvailabilityZone(String subnetAvailabilityZone) {
            this.subnetAvailabilityZone = subnetAvailabilityZone;
            return this;
        }

        public final String getCurrentAssociatedNetworkAcl() {
            return currentAssociatedNetworkAcl;
        }

        public final void setCurrentAssociatedNetworkAcl(String currentAssociatedNetworkAcl) {
            this.currentAssociatedNetworkAcl = currentAssociatedNetworkAcl;
        }

        @Override
        public final Builder currentAssociatedNetworkAcl(String currentAssociatedNetworkAcl) {
            this.currentAssociatedNetworkAcl = currentAssociatedNetworkAcl;
            return this;
        }

        public final List<EntryViolation.Builder> getEntryViolations() {
            List<EntryViolation.Builder> result = EntryViolationsCopier.copyToBuilder(this.entryViolations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntryViolations(Collection<EntryViolation.BuilderImpl> entryViolations) {
            this.entryViolations = EntryViolationsCopier.copyFromBuilder(entryViolations);
        }

        @Override
        public final Builder entryViolations(Collection<EntryViolation> entryViolations) {
            this.entryViolations = EntryViolationsCopier.copy(entryViolations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entryViolations(EntryViolation... entryViolations) {
            entryViolations(Arrays.asList(entryViolations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entryViolations(Consumer<EntryViolation.Builder>... entryViolations) {
            entryViolations(Stream.of(entryViolations).map(c -> EntryViolation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public InvalidNetworkAclEntriesViolation build() {
            return new InvalidNetworkAclEntriesViolation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
