/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeletePolicyRequest extends FmsRequest implements
        ToCopyableBuilder<DeletePolicyRequest.Builder, DeletePolicyRequest> {
    private static final SdkField<String> POLICY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyId").getter(getter(DeletePolicyRequest::policyId)).setter(setter(Builder::policyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyId").build()).build();

    private static final SdkField<Boolean> DELETE_ALL_POLICY_RESOURCES_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("DeleteAllPolicyResources")
            .getter(getter(DeletePolicyRequest::deleteAllPolicyResources)).setter(setter(Builder::deleteAllPolicyResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteAllPolicyResources").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ID_FIELD,
            DELETE_ALL_POLICY_RESOURCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String policyId;

    private final Boolean deleteAllPolicyResources;

    private DeletePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.policyId = builder.policyId;
        this.deleteAllPolicyResources = builder.deleteAllPolicyResources;
    }

    /**
     * <p>
     * The ID of the policy that you want to delete. You can retrieve this ID from <code>PutPolicy</code> and
     * <code>ListPolicies</code>.
     * </p>
     * 
     * @return The ID of the policy that you want to delete. You can retrieve this ID from <code>PutPolicy</code> and
     *         <code>ListPolicies</code>.
     */
    public final String policyId() {
        return policyId;
    }

    /**
     * <p>
     * If <code>True</code>, the request performs cleanup according to the policy type.
     * </p>
     * <p>
     * For WAF and Shield Advanced policies, the cleanup does the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Deletes rule groups created by Firewall Manager
     * </p>
     * </li>
     * <li>
     * <p>
     * Removes web ACLs from in-scope resources
     * </p>
     * </li>
     * <li>
     * <p>
     * Deletes web ACLs that contain no rules or rule groups
     * </p>
     * </li>
     * </ul>
     * <p>
     * For security group policies, the cleanup does the following for each security group in the policy:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Disassociates the security group from in-scope resources
     * </p>
     * </li>
     * <li>
     * <p>
     * Deletes the security group if it was created through Firewall Manager and if it's no longer associated with any
     * resources through another policy
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * For security group common policies, even if set to <code>False</code>, Firewall Manager deletes all security
     * groups created by Firewall Manager that aren't associated with any other resources through another policy.
     * </p>
     * </note>
     * <p>
     * After the cleanup, in-scope resources are no longer protected by web ACLs in this policy. Protection of
     * out-of-scope resources remains unchanged. Scope is determined by tags that you create and accounts that you
     * associate with the policy. When creating the policy, if you specify that only resources in specific accounts or
     * with specific tags are in scope of the policy, those accounts and resources are handled by the policy. All others
     * are out of scope. If you don't specify tags or accounts, all resources are in scope.
     * </p>
     * 
     * @return If <code>True</code>, the request performs cleanup according to the policy type. </p>
     *         <p>
     *         For WAF and Shield Advanced policies, the cleanup does the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Deletes rule groups created by Firewall Manager
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Removes web ACLs from in-scope resources
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Deletes web ACLs that contain no rules or rule groups
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For security group policies, the cleanup does the following for each security group in the policy:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Disassociates the security group from in-scope resources
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Deletes the security group if it was created through Firewall Manager and if it's no longer associated
     *         with any resources through another policy
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         For security group common policies, even if set to <code>False</code>, Firewall Manager deletes all
     *         security groups created by Firewall Manager that aren't associated with any other resources through
     *         another policy.
     *         </p>
     *         </note>
     *         <p>
     *         After the cleanup, in-scope resources are no longer protected by web ACLs in this policy. Protection of
     *         out-of-scope resources remains unchanged. Scope is determined by tags that you create and accounts that
     *         you associate with the policy. When creating the policy, if you specify that only resources in specific
     *         accounts or with specific tags are in scope of the policy, those accounts and resources are handled by
     *         the policy. All others are out of scope. If you don't specify tags or accounts, all resources are in
     *         scope.
     */
    public final Boolean deleteAllPolicyResources() {
        return deleteAllPolicyResources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyId());
        hashCode = 31 * hashCode + Objects.hashCode(deleteAllPolicyResources());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletePolicyRequest)) {
            return false;
        }
        DeletePolicyRequest other = (DeletePolicyRequest) obj;
        return Objects.equals(policyId(), other.policyId())
                && Objects.equals(deleteAllPolicyResources(), other.deleteAllPolicyResources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeletePolicyRequest").add("PolicyId", policyId())
                .add("DeleteAllPolicyResources", deleteAllPolicyResources()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyId":
            return Optional.ofNullable(clazz.cast(policyId()));
        case "DeleteAllPolicyResources":
            return Optional.ofNullable(clazz.cast(deleteAllPolicyResources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PolicyId", POLICY_ID_FIELD);
        map.put("DeleteAllPolicyResources", DELETE_ALL_POLICY_RESOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeletePolicyRequest, T> g) {
        return obj -> g.apply((DeletePolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends FmsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeletePolicyRequest> {
        /**
         * <p>
         * The ID of the policy that you want to delete. You can retrieve this ID from <code>PutPolicy</code> and
         * <code>ListPolicies</code>.
         * </p>
         * 
         * @param policyId
         *        The ID of the policy that you want to delete. You can retrieve this ID from <code>PutPolicy</code> and
         *        <code>ListPolicies</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyId(String policyId);

        /**
         * <p>
         * If <code>True</code>, the request performs cleanup according to the policy type.
         * </p>
         * <p>
         * For WAF and Shield Advanced policies, the cleanup does the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Deletes rule groups created by Firewall Manager
         * </p>
         * </li>
         * <li>
         * <p>
         * Removes web ACLs from in-scope resources
         * </p>
         * </li>
         * <li>
         * <p>
         * Deletes web ACLs that contain no rules or rule groups
         * </p>
         * </li>
         * </ul>
         * <p>
         * For security group policies, the cleanup does the following for each security group in the policy:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Disassociates the security group from in-scope resources
         * </p>
         * </li>
         * <li>
         * <p>
         * Deletes the security group if it was created through Firewall Manager and if it's no longer associated with
         * any resources through another policy
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * For security group common policies, even if set to <code>False</code>, Firewall Manager deletes all security
         * groups created by Firewall Manager that aren't associated with any other resources through another policy.
         * </p>
         * </note>
         * <p>
         * After the cleanup, in-scope resources are no longer protected by web ACLs in this policy. Protection of
         * out-of-scope resources remains unchanged. Scope is determined by tags that you create and accounts that you
         * associate with the policy. When creating the policy, if you specify that only resources in specific accounts
         * or with specific tags are in scope of the policy, those accounts and resources are handled by the policy. All
         * others are out of scope. If you don't specify tags or accounts, all resources are in scope.
         * </p>
         * 
         * @param deleteAllPolicyResources
         *        If <code>True</code>, the request performs cleanup according to the policy type. </p>
         *        <p>
         *        For WAF and Shield Advanced policies, the cleanup does the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Deletes rule groups created by Firewall Manager
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Removes web ACLs from in-scope resources
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Deletes web ACLs that contain no rules or rule groups
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For security group policies, the cleanup does the following for each security group in the policy:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Disassociates the security group from in-scope resources
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Deletes the security group if it was created through Firewall Manager and if it's no longer associated
         *        with any resources through another policy
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        For security group common policies, even if set to <code>False</code>, Firewall Manager deletes all
         *        security groups created by Firewall Manager that aren't associated with any other resources through
         *        another policy.
         *        </p>
         *        </note>
         *        <p>
         *        After the cleanup, in-scope resources are no longer protected by web ACLs in this policy. Protection
         *        of out-of-scope resources remains unchanged. Scope is determined by tags that you create and accounts
         *        that you associate with the policy. When creating the policy, if you specify that only resources in
         *        specific accounts or with specific tags are in scope of the policy, those accounts and resources are
         *        handled by the policy. All others are out of scope. If you don't specify tags or accounts, all
         *        resources are in scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteAllPolicyResources(Boolean deleteAllPolicyResources);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FmsRequest.BuilderImpl implements Builder {
        private String policyId;

        private Boolean deleteAllPolicyResources;

        private BuilderImpl() {
        }

        private BuilderImpl(DeletePolicyRequest model) {
            super(model);
            policyId(model.policyId);
            deleteAllPolicyResources(model.deleteAllPolicyResources);
        }

        public final String getPolicyId() {
            return policyId;
        }

        public final void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        @Override
        public final Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public final Boolean getDeleteAllPolicyResources() {
            return deleteAllPolicyResources;
        }

        public final void setDeleteAllPolicyResources(Boolean deleteAllPolicyResources) {
            this.deleteAllPolicyResources = deleteAllPolicyResources;
        }

        @Override
        public final Builder deleteAllPolicyResources(Boolean deleteAllPolicyResources) {
            this.deleteAllPolicyResources = deleteAllPolicyResources;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeletePolicyRequest build() {
            return new DeletePolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
