/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fms.model.ExpectedRoute;
import software.amazon.awssdk.services.fms.model.ExpectedRoutesCopier;
import software.amazon.awssdk.services.fms.model.Route;
import software.amazon.awssdk.services.fms.model.RoutesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkFirewallInternetTrafficNotInspectedViolation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkFirewallInternetTrafficNotInspectedViolation> {
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(NetworkFirewallInternetTrafficNotInspectedViolation.getter(NetworkFirewallInternetTrafficNotInspectedViolation::subnetId)).setter(NetworkFirewallInternetTrafficNotInspectedViolation.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()}).build();
    private static final SdkField<String> SUBNET_AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetAvailabilityZone").getter(NetworkFirewallInternetTrafficNotInspectedViolation.getter(NetworkFirewallInternetTrafficNotInspectedViolation::subnetAvailabilityZone)).setter(NetworkFirewallInternetTrafficNotInspectedViolation.setter(Builder::subnetAvailabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetAvailabilityZone").build()}).build();
    private static final SdkField<String> ROUTE_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouteTableId").getter(NetworkFirewallInternetTrafficNotInspectedViolation.getter(NetworkFirewallInternetTrafficNotInspectedViolation::routeTableId)).setter(NetworkFirewallInternetTrafficNotInspectedViolation.setter(Builder::routeTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableId").build()}).build();
    private static final SdkField<List<Route>> VIOLATING_ROUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ViolatingRoutes").getter(NetworkFirewallInternetTrafficNotInspectedViolation.getter(NetworkFirewallInternetTrafficNotInspectedViolation::violatingRoutes)).setter(NetworkFirewallInternetTrafficNotInspectedViolation.setter(Builder::violatingRoutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViolatingRoutes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Route::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_ROUTE_TABLE_USED_IN_DIFFERENT_AZ_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsRouteTableUsedInDifferentAZ").getter(NetworkFirewallInternetTrafficNotInspectedViolation.getter(NetworkFirewallInternetTrafficNotInspectedViolation::isRouteTableUsedInDifferentAZ)).setter(NetworkFirewallInternetTrafficNotInspectedViolation.setter(Builder::isRouteTableUsedInDifferentAZ)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsRouteTableUsedInDifferentAZ").build()}).build();
    private static final SdkField<String> CURRENT_FIREWALL_SUBNET_ROUTE_TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentFirewallSubnetRouteTable").getter(NetworkFirewallInternetTrafficNotInspectedViolation.getter(NetworkFirewallInternetTrafficNotInspectedViolation::currentFirewallSubnetRouteTable)).setter(NetworkFirewallInternetTrafficNotInspectedViolation.setter(Builder::currentFirewallSubnetRouteTable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentFirewallSubnetRouteTable").build()}).build();
    private static final SdkField<String> EXPECTED_FIREWALL_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExpectedFirewallEndpoint").getter(NetworkFirewallInternetTrafficNotInspectedViolation.getter(NetworkFirewallInternetTrafficNotInspectedViolation::expectedFirewallEndpoint)).setter(NetworkFirewallInternetTrafficNotInspectedViolation.setter(Builder::expectedFirewallEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedFirewallEndpoint").build()}).build();
    private static final SdkField<String> FIREWALL_SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallSubnetId").getter(NetworkFirewallInternetTrafficNotInspectedViolation.getter(NetworkFirewallInternetTrafficNotInspectedViolation::firewallSubnetId)).setter(NetworkFirewallInternetTrafficNotInspectedViolation.setter(Builder::firewallSubnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallSubnetId").build()}).build();
    private static final SdkField<List<ExpectedRoute>> EXPECTED_FIREWALL_SUBNET_ROUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExpectedFirewallSubnetRoutes").getter(NetworkFirewallInternetTrafficNotInspectedViolation.getter(NetworkFirewallInternetTrafficNotInspectedViolation::expectedFirewallSubnetRoutes)).setter(NetworkFirewallInternetTrafficNotInspectedViolation.setter(Builder::expectedFirewallSubnetRoutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedFirewallSubnetRoutes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExpectedRoute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Route>> ACTUAL_FIREWALL_SUBNET_ROUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ActualFirewallSubnetRoutes").getter(NetworkFirewallInternetTrafficNotInspectedViolation.getter(NetworkFirewallInternetTrafficNotInspectedViolation::actualFirewallSubnetRoutes)).setter(NetworkFirewallInternetTrafficNotInspectedViolation.setter(Builder::actualFirewallSubnetRoutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActualFirewallSubnetRoutes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Route::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INTERNET_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InternetGatewayId").getter(NetworkFirewallInternetTrafficNotInspectedViolation.getter(NetworkFirewallInternetTrafficNotInspectedViolation::internetGatewayId)).setter(NetworkFirewallInternetTrafficNotInspectedViolation.setter(Builder::internetGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InternetGatewayId").build()}).build();
    private static final SdkField<String> CURRENT_INTERNET_GATEWAY_ROUTE_TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentInternetGatewayRouteTable").getter(NetworkFirewallInternetTrafficNotInspectedViolation.getter(NetworkFirewallInternetTrafficNotInspectedViolation::currentInternetGatewayRouteTable)).setter(NetworkFirewallInternetTrafficNotInspectedViolation.setter(Builder::currentInternetGatewayRouteTable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentInternetGatewayRouteTable").build()}).build();
    private static final SdkField<List<ExpectedRoute>> EXPECTED_INTERNET_GATEWAY_ROUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExpectedInternetGatewayRoutes").getter(NetworkFirewallInternetTrafficNotInspectedViolation.getter(NetworkFirewallInternetTrafficNotInspectedViolation::expectedInternetGatewayRoutes)).setter(NetworkFirewallInternetTrafficNotInspectedViolation.setter(Builder::expectedInternetGatewayRoutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedInternetGatewayRoutes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExpectedRoute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Route>> ACTUAL_INTERNET_GATEWAY_ROUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ActualInternetGatewayRoutes").getter(NetworkFirewallInternetTrafficNotInspectedViolation.getter(NetworkFirewallInternetTrafficNotInspectedViolation::actualInternetGatewayRoutes)).setter(NetworkFirewallInternetTrafficNotInspectedViolation.setter(Builder::actualInternetGatewayRoutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActualInternetGatewayRoutes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Route::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(NetworkFirewallInternetTrafficNotInspectedViolation.getter(NetworkFirewallInternetTrafficNotInspectedViolation::vpcId)).setter(NetworkFirewallInternetTrafficNotInspectedViolation.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_ID_FIELD, SUBNET_AVAILABILITY_ZONE_FIELD, ROUTE_TABLE_ID_FIELD, VIOLATING_ROUTES_FIELD, IS_ROUTE_TABLE_USED_IN_DIFFERENT_AZ_FIELD, CURRENT_FIREWALL_SUBNET_ROUTE_TABLE_FIELD, EXPECTED_FIREWALL_ENDPOINT_FIELD, FIREWALL_SUBNET_ID_FIELD, EXPECTED_FIREWALL_SUBNET_ROUTES_FIELD, ACTUAL_FIREWALL_SUBNET_ROUTES_FIELD, INTERNET_GATEWAY_ID_FIELD, CURRENT_INTERNET_GATEWAY_ROUTE_TABLE_FIELD, EXPECTED_INTERNET_GATEWAY_ROUTES_FIELD, ACTUAL_INTERNET_GATEWAY_ROUTES_FIELD, VPC_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NetworkFirewallInternetTrafficNotInspectedViolation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String subnetId;
    private final String subnetAvailabilityZone;
    private final String routeTableId;
    private final List<Route> violatingRoutes;
    private final Boolean isRouteTableUsedInDifferentAZ;
    private final String currentFirewallSubnetRouteTable;
    private final String expectedFirewallEndpoint;
    private final String firewallSubnetId;
    private final List<ExpectedRoute> expectedFirewallSubnetRoutes;
    private final List<Route> actualFirewallSubnetRoutes;
    private final String internetGatewayId;
    private final String currentInternetGatewayRouteTable;
    private final List<ExpectedRoute> expectedInternetGatewayRoutes;
    private final List<Route> actualInternetGatewayRoutes;
    private final String vpcId;

    private NetworkFirewallInternetTrafficNotInspectedViolation(BuilderImpl builder) {
        this.subnetId = builder.subnetId;
        this.subnetAvailabilityZone = builder.subnetAvailabilityZone;
        this.routeTableId = builder.routeTableId;
        this.violatingRoutes = builder.violatingRoutes;
        this.isRouteTableUsedInDifferentAZ = builder.isRouteTableUsedInDifferentAZ;
        this.currentFirewallSubnetRouteTable = builder.currentFirewallSubnetRouteTable;
        this.expectedFirewallEndpoint = builder.expectedFirewallEndpoint;
        this.firewallSubnetId = builder.firewallSubnetId;
        this.expectedFirewallSubnetRoutes = builder.expectedFirewallSubnetRoutes;
        this.actualFirewallSubnetRoutes = builder.actualFirewallSubnetRoutes;
        this.internetGatewayId = builder.internetGatewayId;
        this.currentInternetGatewayRouteTable = builder.currentInternetGatewayRouteTable;
        this.expectedInternetGatewayRoutes = builder.expectedInternetGatewayRoutes;
        this.actualInternetGatewayRoutes = builder.actualInternetGatewayRoutes;
        this.vpcId = builder.vpcId;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final String subnetAvailabilityZone() {
        return this.subnetAvailabilityZone;
    }

    public final String routeTableId() {
        return this.routeTableId;
    }

    public final boolean hasViolatingRoutes() {
        return this.violatingRoutes != null && !(this.violatingRoutes instanceof SdkAutoConstructList);
    }

    public final List<Route> violatingRoutes() {
        return this.violatingRoutes;
    }

    public final Boolean isRouteTableUsedInDifferentAZ() {
        return this.isRouteTableUsedInDifferentAZ;
    }

    public final String currentFirewallSubnetRouteTable() {
        return this.currentFirewallSubnetRouteTable;
    }

    public final String expectedFirewallEndpoint() {
        return this.expectedFirewallEndpoint;
    }

    public final String firewallSubnetId() {
        return this.firewallSubnetId;
    }

    public final boolean hasExpectedFirewallSubnetRoutes() {
        return this.expectedFirewallSubnetRoutes != null && !(this.expectedFirewallSubnetRoutes instanceof SdkAutoConstructList);
    }

    public final List<ExpectedRoute> expectedFirewallSubnetRoutes() {
        return this.expectedFirewallSubnetRoutes;
    }

    public final boolean hasActualFirewallSubnetRoutes() {
        return this.actualFirewallSubnetRoutes != null && !(this.actualFirewallSubnetRoutes instanceof SdkAutoConstructList);
    }

    public final List<Route> actualFirewallSubnetRoutes() {
        return this.actualFirewallSubnetRoutes;
    }

    public final String internetGatewayId() {
        return this.internetGatewayId;
    }

    public final String currentInternetGatewayRouteTable() {
        return this.currentInternetGatewayRouteTable;
    }

    public final boolean hasExpectedInternetGatewayRoutes() {
        return this.expectedInternetGatewayRoutes != null && !(this.expectedInternetGatewayRoutes instanceof SdkAutoConstructList);
    }

    public final List<ExpectedRoute> expectedInternetGatewayRoutes() {
        return this.expectedInternetGatewayRoutes;
    }

    public final boolean hasActualInternetGatewayRoutes() {
        return this.actualInternetGatewayRoutes != null && !(this.actualInternetGatewayRoutes instanceof SdkAutoConstructList);
    }

    public final List<Route> actualInternetGatewayRoutes() {
        return this.actualInternetGatewayRoutes;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetAvailabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasViolatingRoutes() ? this.violatingRoutes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isRouteTableUsedInDifferentAZ());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentFirewallSubnetRouteTable());
        hashCode = 31 * hashCode + Objects.hashCode(this.expectedFirewallEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallSubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExpectedFirewallSubnetRoutes() ? this.expectedFirewallSubnetRoutes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActualFirewallSubnetRoutes() ? this.actualFirewallSubnetRoutes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.internetGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentInternetGatewayRouteTable());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExpectedInternetGatewayRoutes() ? this.expectedInternetGatewayRoutes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActualInternetGatewayRoutes() ? this.actualInternetGatewayRoutes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkFirewallInternetTrafficNotInspectedViolation)) {
            return false;
        }
        NetworkFirewallInternetTrafficNotInspectedViolation other = (NetworkFirewallInternetTrafficNotInspectedViolation)obj;
        return Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.subnetAvailabilityZone(), other.subnetAvailabilityZone()) && Objects.equals(this.routeTableId(), other.routeTableId()) && this.hasViolatingRoutes() == other.hasViolatingRoutes() && Objects.equals(this.violatingRoutes(), other.violatingRoutes()) && Objects.equals(this.isRouteTableUsedInDifferentAZ(), other.isRouteTableUsedInDifferentAZ()) && Objects.equals(this.currentFirewallSubnetRouteTable(), other.currentFirewallSubnetRouteTable()) && Objects.equals(this.expectedFirewallEndpoint(), other.expectedFirewallEndpoint()) && Objects.equals(this.firewallSubnetId(), other.firewallSubnetId()) && this.hasExpectedFirewallSubnetRoutes() == other.hasExpectedFirewallSubnetRoutes() && Objects.equals(this.expectedFirewallSubnetRoutes(), other.expectedFirewallSubnetRoutes()) && this.hasActualFirewallSubnetRoutes() == other.hasActualFirewallSubnetRoutes() && Objects.equals(this.actualFirewallSubnetRoutes(), other.actualFirewallSubnetRoutes()) && Objects.equals(this.internetGatewayId(), other.internetGatewayId()) && Objects.equals(this.currentInternetGatewayRouteTable(), other.currentInternetGatewayRouteTable()) && this.hasExpectedInternetGatewayRoutes() == other.hasExpectedInternetGatewayRoutes() && Objects.equals(this.expectedInternetGatewayRoutes(), other.expectedInternetGatewayRoutes()) && this.hasActualInternetGatewayRoutes() == other.hasActualInternetGatewayRoutes() && Objects.equals(this.actualInternetGatewayRoutes(), other.actualInternetGatewayRoutes()) && Objects.equals(this.vpcId(), other.vpcId());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkFirewallInternetTrafficNotInspectedViolation").add("SubnetId", (Object)this.subnetId()).add("SubnetAvailabilityZone", (Object)this.subnetAvailabilityZone()).add("RouteTableId", (Object)this.routeTableId()).add("ViolatingRoutes", this.hasViolatingRoutes() ? this.violatingRoutes() : null).add("IsRouteTableUsedInDifferentAZ", (Object)this.isRouteTableUsedInDifferentAZ()).add("CurrentFirewallSubnetRouteTable", (Object)this.currentFirewallSubnetRouteTable()).add("ExpectedFirewallEndpoint", (Object)this.expectedFirewallEndpoint()).add("FirewallSubnetId", (Object)this.firewallSubnetId()).add("ExpectedFirewallSubnetRoutes", this.hasExpectedFirewallSubnetRoutes() ? this.expectedFirewallSubnetRoutes() : null).add("ActualFirewallSubnetRoutes", this.hasActualFirewallSubnetRoutes() ? this.actualFirewallSubnetRoutes() : null).add("InternetGatewayId", (Object)this.internetGatewayId()).add("CurrentInternetGatewayRouteTable", (Object)this.currentInternetGatewayRouteTable()).add("ExpectedInternetGatewayRoutes", this.hasExpectedInternetGatewayRoutes() ? this.expectedInternetGatewayRoutes() : null).add("ActualInternetGatewayRoutes", this.hasActualInternetGatewayRoutes() ? this.actualInternetGatewayRoutes() : null).add("VpcId", (Object)this.vpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "SubnetAvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.subnetAvailabilityZone()));
            }
            case "RouteTableId": {
                return Optional.ofNullable(clazz.cast(this.routeTableId()));
            }
            case "ViolatingRoutes": {
                return Optional.ofNullable(clazz.cast(this.violatingRoutes()));
            }
            case "IsRouteTableUsedInDifferentAZ": {
                return Optional.ofNullable(clazz.cast(this.isRouteTableUsedInDifferentAZ()));
            }
            case "CurrentFirewallSubnetRouteTable": {
                return Optional.ofNullable(clazz.cast(this.currentFirewallSubnetRouteTable()));
            }
            case "ExpectedFirewallEndpoint": {
                return Optional.ofNullable(clazz.cast(this.expectedFirewallEndpoint()));
            }
            case "FirewallSubnetId": {
                return Optional.ofNullable(clazz.cast(this.firewallSubnetId()));
            }
            case "ExpectedFirewallSubnetRoutes": {
                return Optional.ofNullable(clazz.cast(this.expectedFirewallSubnetRoutes()));
            }
            case "ActualFirewallSubnetRoutes": {
                return Optional.ofNullable(clazz.cast(this.actualFirewallSubnetRoutes()));
            }
            case "InternetGatewayId": {
                return Optional.ofNullable(clazz.cast(this.internetGatewayId()));
            }
            case "CurrentInternetGatewayRouteTable": {
                return Optional.ofNullable(clazz.cast(this.currentInternetGatewayRouteTable()));
            }
            case "ExpectedInternetGatewayRoutes": {
                return Optional.ofNullable(clazz.cast(this.expectedInternetGatewayRoutes()));
            }
            case "ActualInternetGatewayRoutes": {
                return Optional.ofNullable(clazz.cast(this.actualInternetGatewayRoutes()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SubnetId", SUBNET_ID_FIELD);
        map.put("SubnetAvailabilityZone", SUBNET_AVAILABILITY_ZONE_FIELD);
        map.put("RouteTableId", ROUTE_TABLE_ID_FIELD);
        map.put("ViolatingRoutes", VIOLATING_ROUTES_FIELD);
        map.put("IsRouteTableUsedInDifferentAZ", IS_ROUTE_TABLE_USED_IN_DIFFERENT_AZ_FIELD);
        map.put("CurrentFirewallSubnetRouteTable", CURRENT_FIREWALL_SUBNET_ROUTE_TABLE_FIELD);
        map.put("ExpectedFirewallEndpoint", EXPECTED_FIREWALL_ENDPOINT_FIELD);
        map.put("FirewallSubnetId", FIREWALL_SUBNET_ID_FIELD);
        map.put("ExpectedFirewallSubnetRoutes", EXPECTED_FIREWALL_SUBNET_ROUTES_FIELD);
        map.put("ActualFirewallSubnetRoutes", ACTUAL_FIREWALL_SUBNET_ROUTES_FIELD);
        map.put("InternetGatewayId", INTERNET_GATEWAY_ID_FIELD);
        map.put("CurrentInternetGatewayRouteTable", CURRENT_INTERNET_GATEWAY_ROUTE_TABLE_FIELD);
        map.put("ExpectedInternetGatewayRoutes", EXPECTED_INTERNET_GATEWAY_ROUTES_FIELD);
        map.put("ActualInternetGatewayRoutes", ACTUAL_INTERNET_GATEWAY_ROUTES_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkFirewallInternetTrafficNotInspectedViolation, T> g) {
        return obj -> g.apply((NetworkFirewallInternetTrafficNotInspectedViolation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String subnetId;
        private String subnetAvailabilityZone;
        private String routeTableId;
        private List<Route> violatingRoutes = DefaultSdkAutoConstructList.getInstance();
        private Boolean isRouteTableUsedInDifferentAZ;
        private String currentFirewallSubnetRouteTable;
        private String expectedFirewallEndpoint;
        private String firewallSubnetId;
        private List<ExpectedRoute> expectedFirewallSubnetRoutes = DefaultSdkAutoConstructList.getInstance();
        private List<Route> actualFirewallSubnetRoutes = DefaultSdkAutoConstructList.getInstance();
        private String internetGatewayId;
        private String currentInternetGatewayRouteTable;
        private List<ExpectedRoute> expectedInternetGatewayRoutes = DefaultSdkAutoConstructList.getInstance();
        private List<Route> actualInternetGatewayRoutes = DefaultSdkAutoConstructList.getInstance();
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkFirewallInternetTrafficNotInspectedViolation model) {
            this.subnetId(model.subnetId);
            this.subnetAvailabilityZone(model.subnetAvailabilityZone);
            this.routeTableId(model.routeTableId);
            this.violatingRoutes(model.violatingRoutes);
            this.isRouteTableUsedInDifferentAZ(model.isRouteTableUsedInDifferentAZ);
            this.currentFirewallSubnetRouteTable(model.currentFirewallSubnetRouteTable);
            this.expectedFirewallEndpoint(model.expectedFirewallEndpoint);
            this.firewallSubnetId(model.firewallSubnetId);
            this.expectedFirewallSubnetRoutes(model.expectedFirewallSubnetRoutes);
            this.actualFirewallSubnetRoutes(model.actualFirewallSubnetRoutes);
            this.internetGatewayId(model.internetGatewayId);
            this.currentInternetGatewayRouteTable(model.currentInternetGatewayRouteTable);
            this.expectedInternetGatewayRoutes(model.expectedInternetGatewayRoutes);
            this.actualInternetGatewayRoutes(model.actualInternetGatewayRoutes);
            this.vpcId(model.vpcId);
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getSubnetAvailabilityZone() {
            return this.subnetAvailabilityZone;
        }

        public final void setSubnetAvailabilityZone(String subnetAvailabilityZone) {
            this.subnetAvailabilityZone = subnetAvailabilityZone;
        }

        @Override
        public final Builder subnetAvailabilityZone(String subnetAvailabilityZone) {
            this.subnetAvailabilityZone = subnetAvailabilityZone;
            return this;
        }

        public final String getRouteTableId() {
            return this.routeTableId;
        }

        public final void setRouteTableId(String routeTableId) {
            this.routeTableId = routeTableId;
        }

        @Override
        public final Builder routeTableId(String routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        public final List<Route.Builder> getViolatingRoutes() {
            List<Route.Builder> result = RoutesCopier.copyToBuilder(this.violatingRoutes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setViolatingRoutes(Collection<Route.BuilderImpl> violatingRoutes) {
            this.violatingRoutes = RoutesCopier.copyFromBuilder(violatingRoutes);
        }

        @Override
        public final Builder violatingRoutes(Collection<Route> violatingRoutes) {
            this.violatingRoutes = RoutesCopier.copy(violatingRoutes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder violatingRoutes(Route ... violatingRoutes) {
            this.violatingRoutes(Arrays.asList(violatingRoutes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder violatingRoutes(Consumer<Route.Builder> ... violatingRoutes) {
            this.violatingRoutes(Stream.of(violatingRoutes).map(c -> (Route)((Route.Builder)Route.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIsRouteTableUsedInDifferentAZ() {
            return this.isRouteTableUsedInDifferentAZ;
        }

        public final void setIsRouteTableUsedInDifferentAZ(Boolean isRouteTableUsedInDifferentAZ) {
            this.isRouteTableUsedInDifferentAZ = isRouteTableUsedInDifferentAZ;
        }

        @Override
        public final Builder isRouteTableUsedInDifferentAZ(Boolean isRouteTableUsedInDifferentAZ) {
            this.isRouteTableUsedInDifferentAZ = isRouteTableUsedInDifferentAZ;
            return this;
        }

        public final String getCurrentFirewallSubnetRouteTable() {
            return this.currentFirewallSubnetRouteTable;
        }

        public final void setCurrentFirewallSubnetRouteTable(String currentFirewallSubnetRouteTable) {
            this.currentFirewallSubnetRouteTable = currentFirewallSubnetRouteTable;
        }

        @Override
        public final Builder currentFirewallSubnetRouteTable(String currentFirewallSubnetRouteTable) {
            this.currentFirewallSubnetRouteTable = currentFirewallSubnetRouteTable;
            return this;
        }

        public final String getExpectedFirewallEndpoint() {
            return this.expectedFirewallEndpoint;
        }

        public final void setExpectedFirewallEndpoint(String expectedFirewallEndpoint) {
            this.expectedFirewallEndpoint = expectedFirewallEndpoint;
        }

        @Override
        public final Builder expectedFirewallEndpoint(String expectedFirewallEndpoint) {
            this.expectedFirewallEndpoint = expectedFirewallEndpoint;
            return this;
        }

        public final String getFirewallSubnetId() {
            return this.firewallSubnetId;
        }

        public final void setFirewallSubnetId(String firewallSubnetId) {
            this.firewallSubnetId = firewallSubnetId;
        }

        @Override
        public final Builder firewallSubnetId(String firewallSubnetId) {
            this.firewallSubnetId = firewallSubnetId;
            return this;
        }

        public final List<ExpectedRoute.Builder> getExpectedFirewallSubnetRoutes() {
            List<ExpectedRoute.Builder> result = ExpectedRoutesCopier.copyToBuilder(this.expectedFirewallSubnetRoutes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExpectedFirewallSubnetRoutes(Collection<ExpectedRoute.BuilderImpl> expectedFirewallSubnetRoutes) {
            this.expectedFirewallSubnetRoutes = ExpectedRoutesCopier.copyFromBuilder(expectedFirewallSubnetRoutes);
        }

        @Override
        public final Builder expectedFirewallSubnetRoutes(Collection<ExpectedRoute> expectedFirewallSubnetRoutes) {
            this.expectedFirewallSubnetRoutes = ExpectedRoutesCopier.copy(expectedFirewallSubnetRoutes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expectedFirewallSubnetRoutes(ExpectedRoute ... expectedFirewallSubnetRoutes) {
            this.expectedFirewallSubnetRoutes(Arrays.asList(expectedFirewallSubnetRoutes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expectedFirewallSubnetRoutes(Consumer<ExpectedRoute.Builder> ... expectedFirewallSubnetRoutes) {
            this.expectedFirewallSubnetRoutes(Stream.of(expectedFirewallSubnetRoutes).map(c -> (ExpectedRoute)((ExpectedRoute.Builder)ExpectedRoute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Route.Builder> getActualFirewallSubnetRoutes() {
            List<Route.Builder> result = RoutesCopier.copyToBuilder(this.actualFirewallSubnetRoutes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActualFirewallSubnetRoutes(Collection<Route.BuilderImpl> actualFirewallSubnetRoutes) {
            this.actualFirewallSubnetRoutes = RoutesCopier.copyFromBuilder(actualFirewallSubnetRoutes);
        }

        @Override
        public final Builder actualFirewallSubnetRoutes(Collection<Route> actualFirewallSubnetRoutes) {
            this.actualFirewallSubnetRoutes = RoutesCopier.copy(actualFirewallSubnetRoutes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actualFirewallSubnetRoutes(Route ... actualFirewallSubnetRoutes) {
            this.actualFirewallSubnetRoutes(Arrays.asList(actualFirewallSubnetRoutes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actualFirewallSubnetRoutes(Consumer<Route.Builder> ... actualFirewallSubnetRoutes) {
            this.actualFirewallSubnetRoutes(Stream.of(actualFirewallSubnetRoutes).map(c -> (Route)((Route.Builder)Route.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getInternetGatewayId() {
            return this.internetGatewayId;
        }

        public final void setInternetGatewayId(String internetGatewayId) {
            this.internetGatewayId = internetGatewayId;
        }

        @Override
        public final Builder internetGatewayId(String internetGatewayId) {
            this.internetGatewayId = internetGatewayId;
            return this;
        }

        public final String getCurrentInternetGatewayRouteTable() {
            return this.currentInternetGatewayRouteTable;
        }

        public final void setCurrentInternetGatewayRouteTable(String currentInternetGatewayRouteTable) {
            this.currentInternetGatewayRouteTable = currentInternetGatewayRouteTable;
        }

        @Override
        public final Builder currentInternetGatewayRouteTable(String currentInternetGatewayRouteTable) {
            this.currentInternetGatewayRouteTable = currentInternetGatewayRouteTable;
            return this;
        }

        public final List<ExpectedRoute.Builder> getExpectedInternetGatewayRoutes() {
            List<ExpectedRoute.Builder> result = ExpectedRoutesCopier.copyToBuilder(this.expectedInternetGatewayRoutes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExpectedInternetGatewayRoutes(Collection<ExpectedRoute.BuilderImpl> expectedInternetGatewayRoutes) {
            this.expectedInternetGatewayRoutes = ExpectedRoutesCopier.copyFromBuilder(expectedInternetGatewayRoutes);
        }

        @Override
        public final Builder expectedInternetGatewayRoutes(Collection<ExpectedRoute> expectedInternetGatewayRoutes) {
            this.expectedInternetGatewayRoutes = ExpectedRoutesCopier.copy(expectedInternetGatewayRoutes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expectedInternetGatewayRoutes(ExpectedRoute ... expectedInternetGatewayRoutes) {
            this.expectedInternetGatewayRoutes(Arrays.asList(expectedInternetGatewayRoutes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expectedInternetGatewayRoutes(Consumer<ExpectedRoute.Builder> ... expectedInternetGatewayRoutes) {
            this.expectedInternetGatewayRoutes(Stream.of(expectedInternetGatewayRoutes).map(c -> (ExpectedRoute)((ExpectedRoute.Builder)ExpectedRoute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Route.Builder> getActualInternetGatewayRoutes() {
            List<Route.Builder> result = RoutesCopier.copyToBuilder(this.actualInternetGatewayRoutes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActualInternetGatewayRoutes(Collection<Route.BuilderImpl> actualInternetGatewayRoutes) {
            this.actualInternetGatewayRoutes = RoutesCopier.copyFromBuilder(actualInternetGatewayRoutes);
        }

        @Override
        public final Builder actualInternetGatewayRoutes(Collection<Route> actualInternetGatewayRoutes) {
            this.actualInternetGatewayRoutes = RoutesCopier.copy(actualInternetGatewayRoutes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actualInternetGatewayRoutes(Route ... actualInternetGatewayRoutes) {
            this.actualInternetGatewayRoutes(Arrays.asList(actualInternetGatewayRoutes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actualInternetGatewayRoutes(Consumer<Route.Builder> ... actualInternetGatewayRoutes) {
            this.actualInternetGatewayRoutes(Stream.of(actualInternetGatewayRoutes).map(c -> (Route)((Route.Builder)Route.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public NetworkFirewallInternetTrafficNotInspectedViolation build() {
            return new NetworkFirewallInternetTrafficNotInspectedViolation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkFirewallInternetTrafficNotInspectedViolation> {
        public Builder subnetId(String var1);

        public Builder subnetAvailabilityZone(String var1);

        public Builder routeTableId(String var1);

        public Builder violatingRoutes(Collection<Route> var1);

        public Builder violatingRoutes(Route ... var1);

        public Builder violatingRoutes(Consumer<Route.Builder> ... var1);

        public Builder isRouteTableUsedInDifferentAZ(Boolean var1);

        public Builder currentFirewallSubnetRouteTable(String var1);

        public Builder expectedFirewallEndpoint(String var1);

        public Builder firewallSubnetId(String var1);

        public Builder expectedFirewallSubnetRoutes(Collection<ExpectedRoute> var1);

        public Builder expectedFirewallSubnetRoutes(ExpectedRoute ... var1);

        public Builder expectedFirewallSubnetRoutes(Consumer<ExpectedRoute.Builder> ... var1);

        public Builder actualFirewallSubnetRoutes(Collection<Route> var1);

        public Builder actualFirewallSubnetRoutes(Route ... var1);

        public Builder actualFirewallSubnetRoutes(Consumer<Route.Builder> ... var1);

        public Builder internetGatewayId(String var1);

        public Builder currentInternetGatewayRouteTable(String var1);

        public Builder expectedInternetGatewayRoutes(Collection<ExpectedRoute> var1);

        public Builder expectedInternetGatewayRoutes(ExpectedRoute ... var1);

        public Builder expectedInternetGatewayRoutes(Consumer<ExpectedRoute.Builder> ... var1);

        public Builder actualInternetGatewayRoutes(Collection<Route> var1);

        public Builder actualInternetGatewayRoutes(Route ... var1);

        public Builder actualInternetGatewayRoutes(Consumer<Route.Builder> ... var1);

        public Builder vpcId(String var1);
    }
}

