/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fms.model.AdminScope;
import software.amazon.awssdk.services.fms.model.FmsResponse;
import software.amazon.awssdk.services.fms.model.OrganizationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAdminScopeResponse
extends FmsResponse
implements ToCopyableBuilder<Builder, GetAdminScopeResponse> {
    private static final SdkField<AdminScope> ADMIN_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AdminScope").getter(GetAdminScopeResponse.getter(GetAdminScopeResponse::adminScope)).setter(GetAdminScopeResponse.setter(Builder::adminScope)).constructor(AdminScope::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdminScope").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetAdminScopeResponse.getter(GetAdminScopeResponse::statusAsString)).setter(GetAdminScopeResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADMIN_SCOPE_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AdminScope", ADMIN_SCOPE_FIELD);
            this.put("Status", STATUS_FIELD);
        }
    });
    private final AdminScope adminScope;
    private final String status;

    private GetAdminScopeResponse(BuilderImpl builder) {
        super(builder);
        this.adminScope = builder.adminScope;
        this.status = builder.status;
    }

    public final AdminScope adminScope() {
        return this.adminScope;
    }

    public final OrganizationStatus status() {
        return OrganizationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.adminScope());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAdminScopeResponse)) {
            return false;
        }
        GetAdminScopeResponse other = (GetAdminScopeResponse)((Object)obj);
        return Objects.equals(this.adminScope(), other.adminScope()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetAdminScopeResponse").add("AdminScope", (Object)this.adminScope()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdminScope": {
                return Optional.ofNullable(clazz.cast(this.adminScope()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetAdminScopeResponse, T> g) {
        return obj -> g.apply((GetAdminScopeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FmsResponse.BuilderImpl
    implements Builder {
        private AdminScope adminScope;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAdminScopeResponse model) {
            super(model);
            this.adminScope(model.adminScope);
            this.status(model.status);
        }

        public final AdminScope.Builder getAdminScope() {
            return this.adminScope != null ? this.adminScope.toBuilder() : null;
        }

        public final void setAdminScope(AdminScope.BuilderImpl adminScope) {
            this.adminScope = adminScope != null ? adminScope.build() : null;
        }

        @Override
        public final Builder adminScope(AdminScope adminScope) {
            this.adminScope = adminScope;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OrganizationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public GetAdminScopeResponse build() {
            return new GetAdminScopeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FmsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAdminScopeResponse> {
        public Builder adminScope(AdminScope var1);

        default public Builder adminScope(Consumer<AdminScope.Builder> adminScope) {
            return this.adminScope((AdminScope)((AdminScope.Builder)AdminScope.builder().applyMutation(adminScope)).build());
        }

        public Builder status(String var1);

        public Builder status(OrganizationStatus var1);
    }
}

