/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fms.model.AwsEc2InstanceViolation;
import software.amazon.awssdk.services.fms.model.AwsEc2NetworkInterfaceViolation;
import software.amazon.awssdk.services.fms.model.AwsVPCSecurityGroupViolation;
import software.amazon.awssdk.services.fms.model.DnsDuplicateRuleGroupViolation;
import software.amazon.awssdk.services.fms.model.DnsRuleGroupLimitExceededViolation;
import software.amazon.awssdk.services.fms.model.DnsRuleGroupPriorityConflictViolation;
import software.amazon.awssdk.services.fms.model.FirewallSubnetIsOutOfScopeViolation;
import software.amazon.awssdk.services.fms.model.FirewallSubnetMissingVPCEndpointViolation;
import software.amazon.awssdk.services.fms.model.InvalidNetworkAclEntriesViolation;
import software.amazon.awssdk.services.fms.model.NetworkFirewallBlackHoleRouteDetectedViolation;
import software.amazon.awssdk.services.fms.model.NetworkFirewallInternetTrafficNotInspectedViolation;
import software.amazon.awssdk.services.fms.model.NetworkFirewallInvalidRouteConfigurationViolation;
import software.amazon.awssdk.services.fms.model.NetworkFirewallMissingExpectedRTViolation;
import software.amazon.awssdk.services.fms.model.NetworkFirewallMissingExpectedRoutesViolation;
import software.amazon.awssdk.services.fms.model.NetworkFirewallMissingFirewallViolation;
import software.amazon.awssdk.services.fms.model.NetworkFirewallMissingSubnetViolation;
import software.amazon.awssdk.services.fms.model.NetworkFirewallPolicyModifiedViolation;
import software.amazon.awssdk.services.fms.model.NetworkFirewallUnexpectedFirewallRoutesViolation;
import software.amazon.awssdk.services.fms.model.NetworkFirewallUnexpectedGatewayRoutesViolation;
import software.amazon.awssdk.services.fms.model.PossibleRemediationActions;
import software.amazon.awssdk.services.fms.model.RouteHasOutOfScopeEndpointViolation;
import software.amazon.awssdk.services.fms.model.ThirdPartyFirewallMissingExpectedRouteTableViolation;
import software.amazon.awssdk.services.fms.model.ThirdPartyFirewallMissingFirewallViolation;
import software.amazon.awssdk.services.fms.model.ThirdPartyFirewallMissingSubnetViolation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceViolation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceViolation> {
    private static final SdkField<AwsVPCSecurityGroupViolation> AWS_VPC_SECURITY_GROUP_VIOLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AwsVPCSecurityGroupViolation").getter(ResourceViolation.getter(ResourceViolation::awsVPCSecurityGroupViolation)).setter(ResourceViolation.setter(Builder::awsVPCSecurityGroupViolation)).constructor(AwsVPCSecurityGroupViolation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsVPCSecurityGroupViolation").build()}).build();
    private static final SdkField<AwsEc2NetworkInterfaceViolation> AWS_EC2_NETWORK_INTERFACE_VIOLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AwsEc2NetworkInterfaceViolation").getter(ResourceViolation.getter(ResourceViolation::awsEc2NetworkInterfaceViolation)).setter(ResourceViolation.setter(Builder::awsEc2NetworkInterfaceViolation)).constructor(AwsEc2NetworkInterfaceViolation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsEc2NetworkInterfaceViolation").build()}).build();
    private static final SdkField<AwsEc2InstanceViolation> AWS_EC2_INSTANCE_VIOLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AwsEc2InstanceViolation").getter(ResourceViolation.getter(ResourceViolation::awsEc2InstanceViolation)).setter(ResourceViolation.setter(Builder::awsEc2InstanceViolation)).constructor(AwsEc2InstanceViolation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsEc2InstanceViolation").build()}).build();
    private static final SdkField<NetworkFirewallMissingFirewallViolation> NETWORK_FIREWALL_MISSING_FIREWALL_VIOLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkFirewallMissingFirewallViolation").getter(ResourceViolation.getter(ResourceViolation::networkFirewallMissingFirewallViolation)).setter(ResourceViolation.setter(Builder::networkFirewallMissingFirewallViolation)).constructor(NetworkFirewallMissingFirewallViolation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkFirewallMissingFirewallViolation").build()}).build();
    private static final SdkField<NetworkFirewallMissingSubnetViolation> NETWORK_FIREWALL_MISSING_SUBNET_VIOLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkFirewallMissingSubnetViolation").getter(ResourceViolation.getter(ResourceViolation::networkFirewallMissingSubnetViolation)).setter(ResourceViolation.setter(Builder::networkFirewallMissingSubnetViolation)).constructor(NetworkFirewallMissingSubnetViolation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkFirewallMissingSubnetViolation").build()}).build();
    private static final SdkField<NetworkFirewallMissingExpectedRTViolation> NETWORK_FIREWALL_MISSING_EXPECTED_RT_VIOLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkFirewallMissingExpectedRTViolation").getter(ResourceViolation.getter(ResourceViolation::networkFirewallMissingExpectedRTViolation)).setter(ResourceViolation.setter(Builder::networkFirewallMissingExpectedRTViolation)).constructor(NetworkFirewallMissingExpectedRTViolation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkFirewallMissingExpectedRTViolation").build()}).build();
    private static final SdkField<NetworkFirewallPolicyModifiedViolation> NETWORK_FIREWALL_POLICY_MODIFIED_VIOLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkFirewallPolicyModifiedViolation").getter(ResourceViolation.getter(ResourceViolation::networkFirewallPolicyModifiedViolation)).setter(ResourceViolation.setter(Builder::networkFirewallPolicyModifiedViolation)).constructor(NetworkFirewallPolicyModifiedViolation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkFirewallPolicyModifiedViolation").build()}).build();
    private static final SdkField<NetworkFirewallInternetTrafficNotInspectedViolation> NETWORK_FIREWALL_INTERNET_TRAFFIC_NOT_INSPECTED_VIOLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkFirewallInternetTrafficNotInspectedViolation").getter(ResourceViolation.getter(ResourceViolation::networkFirewallInternetTrafficNotInspectedViolation)).setter(ResourceViolation.setter(Builder::networkFirewallInternetTrafficNotInspectedViolation)).constructor(NetworkFirewallInternetTrafficNotInspectedViolation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkFirewallInternetTrafficNotInspectedViolation").build()}).build();
    private static final SdkField<NetworkFirewallInvalidRouteConfigurationViolation> NETWORK_FIREWALL_INVALID_ROUTE_CONFIGURATION_VIOLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkFirewallInvalidRouteConfigurationViolation").getter(ResourceViolation.getter(ResourceViolation::networkFirewallInvalidRouteConfigurationViolation)).setter(ResourceViolation.setter(Builder::networkFirewallInvalidRouteConfigurationViolation)).constructor(NetworkFirewallInvalidRouteConfigurationViolation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkFirewallInvalidRouteConfigurationViolation").build()}).build();
    private static final SdkField<NetworkFirewallBlackHoleRouteDetectedViolation> NETWORK_FIREWALL_BLACK_HOLE_ROUTE_DETECTED_VIOLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkFirewallBlackHoleRouteDetectedViolation").getter(ResourceViolation.getter(ResourceViolation::networkFirewallBlackHoleRouteDetectedViolation)).setter(ResourceViolation.setter(Builder::networkFirewallBlackHoleRouteDetectedViolation)).constructor(NetworkFirewallBlackHoleRouteDetectedViolation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkFirewallBlackHoleRouteDetectedViolation").build()}).build();
    private static final SdkField<NetworkFirewallUnexpectedFirewallRoutesViolation> NETWORK_FIREWALL_UNEXPECTED_FIREWALL_ROUTES_VIOLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkFirewallUnexpectedFirewallRoutesViolation").getter(ResourceViolation.getter(ResourceViolation::networkFirewallUnexpectedFirewallRoutesViolation)).setter(ResourceViolation.setter(Builder::networkFirewallUnexpectedFirewallRoutesViolation)).constructor(NetworkFirewallUnexpectedFirewallRoutesViolation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkFirewallUnexpectedFirewallRoutesViolation").build()}).build();
    private static final SdkField<NetworkFirewallUnexpectedGatewayRoutesViolation> NETWORK_FIREWALL_UNEXPECTED_GATEWAY_ROUTES_VIOLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkFirewallUnexpectedGatewayRoutesViolation").getter(ResourceViolation.getter(ResourceViolation::networkFirewallUnexpectedGatewayRoutesViolation)).setter(ResourceViolation.setter(Builder::networkFirewallUnexpectedGatewayRoutesViolation)).constructor(NetworkFirewallUnexpectedGatewayRoutesViolation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkFirewallUnexpectedGatewayRoutesViolation").build()}).build();
    private static final SdkField<NetworkFirewallMissingExpectedRoutesViolation> NETWORK_FIREWALL_MISSING_EXPECTED_ROUTES_VIOLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkFirewallMissingExpectedRoutesViolation").getter(ResourceViolation.getter(ResourceViolation::networkFirewallMissingExpectedRoutesViolation)).setter(ResourceViolation.setter(Builder::networkFirewallMissingExpectedRoutesViolation)).constructor(NetworkFirewallMissingExpectedRoutesViolation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkFirewallMissingExpectedRoutesViolation").build()}).build();
    private static final SdkField<DnsRuleGroupPriorityConflictViolation> DNS_RULE_GROUP_PRIORITY_CONFLICT_VIOLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DnsRuleGroupPriorityConflictViolation").getter(ResourceViolation.getter(ResourceViolation::dnsRuleGroupPriorityConflictViolation)).setter(ResourceViolation.setter(Builder::dnsRuleGroupPriorityConflictViolation)).constructor(DnsRuleGroupPriorityConflictViolation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsRuleGroupPriorityConflictViolation").build()}).build();
    private static final SdkField<DnsDuplicateRuleGroupViolation> DNS_DUPLICATE_RULE_GROUP_VIOLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DnsDuplicateRuleGroupViolation").getter(ResourceViolation.getter(ResourceViolation::dnsDuplicateRuleGroupViolation)).setter(ResourceViolation.setter(Builder::dnsDuplicateRuleGroupViolation)).constructor(DnsDuplicateRuleGroupViolation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsDuplicateRuleGroupViolation").build()}).build();
    private static final SdkField<DnsRuleGroupLimitExceededViolation> DNS_RULE_GROUP_LIMIT_EXCEEDED_VIOLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DnsRuleGroupLimitExceededViolation").getter(ResourceViolation.getter(ResourceViolation::dnsRuleGroupLimitExceededViolation)).setter(ResourceViolation.setter(Builder::dnsRuleGroupLimitExceededViolation)).constructor(DnsRuleGroupLimitExceededViolation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsRuleGroupLimitExceededViolation").build()}).build();
    private static final SdkField<FirewallSubnetIsOutOfScopeViolation> FIREWALL_SUBNET_IS_OUT_OF_SCOPE_VIOLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FirewallSubnetIsOutOfScopeViolation").getter(ResourceViolation.getter(ResourceViolation::firewallSubnetIsOutOfScopeViolation)).setter(ResourceViolation.setter(Builder::firewallSubnetIsOutOfScopeViolation)).constructor(FirewallSubnetIsOutOfScopeViolation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallSubnetIsOutOfScopeViolation").build()}).build();
    private static final SdkField<RouteHasOutOfScopeEndpointViolation> ROUTE_HAS_OUT_OF_SCOPE_ENDPOINT_VIOLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RouteHasOutOfScopeEndpointViolation").getter(ResourceViolation.getter(ResourceViolation::routeHasOutOfScopeEndpointViolation)).setter(ResourceViolation.setter(Builder::routeHasOutOfScopeEndpointViolation)).constructor(RouteHasOutOfScopeEndpointViolation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteHasOutOfScopeEndpointViolation").build()}).build();
    private static final SdkField<ThirdPartyFirewallMissingFirewallViolation> THIRD_PARTY_FIREWALL_MISSING_FIREWALL_VIOLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ThirdPartyFirewallMissingFirewallViolation").getter(ResourceViolation.getter(ResourceViolation::thirdPartyFirewallMissingFirewallViolation)).setter(ResourceViolation.setter(Builder::thirdPartyFirewallMissingFirewallViolation)).constructor(ThirdPartyFirewallMissingFirewallViolation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThirdPartyFirewallMissingFirewallViolation").build()}).build();
    private static final SdkField<ThirdPartyFirewallMissingSubnetViolation> THIRD_PARTY_FIREWALL_MISSING_SUBNET_VIOLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ThirdPartyFirewallMissingSubnetViolation").getter(ResourceViolation.getter(ResourceViolation::thirdPartyFirewallMissingSubnetViolation)).setter(ResourceViolation.setter(Builder::thirdPartyFirewallMissingSubnetViolation)).constructor(ThirdPartyFirewallMissingSubnetViolation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThirdPartyFirewallMissingSubnetViolation").build()}).build();
    private static final SdkField<ThirdPartyFirewallMissingExpectedRouteTableViolation> THIRD_PARTY_FIREWALL_MISSING_EXPECTED_ROUTE_TABLE_VIOLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ThirdPartyFirewallMissingExpectedRouteTableViolation").getter(ResourceViolation.getter(ResourceViolation::thirdPartyFirewallMissingExpectedRouteTableViolation)).setter(ResourceViolation.setter(Builder::thirdPartyFirewallMissingExpectedRouteTableViolation)).constructor(ThirdPartyFirewallMissingExpectedRouteTableViolation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThirdPartyFirewallMissingExpectedRouteTableViolation").build()}).build();
    private static final SdkField<FirewallSubnetMissingVPCEndpointViolation> FIREWALL_SUBNET_MISSING_VPC_ENDPOINT_VIOLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FirewallSubnetMissingVPCEndpointViolation").getter(ResourceViolation.getter(ResourceViolation::firewallSubnetMissingVPCEndpointViolation)).setter(ResourceViolation.setter(Builder::firewallSubnetMissingVPCEndpointViolation)).constructor(FirewallSubnetMissingVPCEndpointViolation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallSubnetMissingVPCEndpointViolation").build()}).build();
    private static final SdkField<InvalidNetworkAclEntriesViolation> INVALID_NETWORK_ACL_ENTRIES_VIOLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InvalidNetworkAclEntriesViolation").getter(ResourceViolation.getter(ResourceViolation::invalidNetworkAclEntriesViolation)).setter(ResourceViolation.setter(Builder::invalidNetworkAclEntriesViolation)).constructor(InvalidNetworkAclEntriesViolation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvalidNetworkAclEntriesViolation").build()}).build();
    private static final SdkField<PossibleRemediationActions> POSSIBLE_REMEDIATION_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PossibleRemediationActions").getter(ResourceViolation.getter(ResourceViolation::possibleRemediationActions)).setter(ResourceViolation.setter(Builder::possibleRemediationActions)).constructor(PossibleRemediationActions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PossibleRemediationActions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_VPC_SECURITY_GROUP_VIOLATION_FIELD, AWS_EC2_NETWORK_INTERFACE_VIOLATION_FIELD, AWS_EC2_INSTANCE_VIOLATION_FIELD, NETWORK_FIREWALL_MISSING_FIREWALL_VIOLATION_FIELD, NETWORK_FIREWALL_MISSING_SUBNET_VIOLATION_FIELD, NETWORK_FIREWALL_MISSING_EXPECTED_RT_VIOLATION_FIELD, NETWORK_FIREWALL_POLICY_MODIFIED_VIOLATION_FIELD, NETWORK_FIREWALL_INTERNET_TRAFFIC_NOT_INSPECTED_VIOLATION_FIELD, NETWORK_FIREWALL_INVALID_ROUTE_CONFIGURATION_VIOLATION_FIELD, NETWORK_FIREWALL_BLACK_HOLE_ROUTE_DETECTED_VIOLATION_FIELD, NETWORK_FIREWALL_UNEXPECTED_FIREWALL_ROUTES_VIOLATION_FIELD, NETWORK_FIREWALL_UNEXPECTED_GATEWAY_ROUTES_VIOLATION_FIELD, NETWORK_FIREWALL_MISSING_EXPECTED_ROUTES_VIOLATION_FIELD, DNS_RULE_GROUP_PRIORITY_CONFLICT_VIOLATION_FIELD, DNS_DUPLICATE_RULE_GROUP_VIOLATION_FIELD, DNS_RULE_GROUP_LIMIT_EXCEEDED_VIOLATION_FIELD, FIREWALL_SUBNET_IS_OUT_OF_SCOPE_VIOLATION_FIELD, ROUTE_HAS_OUT_OF_SCOPE_ENDPOINT_VIOLATION_FIELD, THIRD_PARTY_FIREWALL_MISSING_FIREWALL_VIOLATION_FIELD, THIRD_PARTY_FIREWALL_MISSING_SUBNET_VIOLATION_FIELD, THIRD_PARTY_FIREWALL_MISSING_EXPECTED_ROUTE_TABLE_VIOLATION_FIELD, FIREWALL_SUBNET_MISSING_VPC_ENDPOINT_VIOLATION_FIELD, INVALID_NETWORK_ACL_ENTRIES_VIOLATION_FIELD, POSSIBLE_REMEDIATION_ACTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final AwsVPCSecurityGroupViolation awsVPCSecurityGroupViolation;
    private final AwsEc2NetworkInterfaceViolation awsEc2NetworkInterfaceViolation;
    private final AwsEc2InstanceViolation awsEc2InstanceViolation;
    private final NetworkFirewallMissingFirewallViolation networkFirewallMissingFirewallViolation;
    private final NetworkFirewallMissingSubnetViolation networkFirewallMissingSubnetViolation;
    private final NetworkFirewallMissingExpectedRTViolation networkFirewallMissingExpectedRTViolation;
    private final NetworkFirewallPolicyModifiedViolation networkFirewallPolicyModifiedViolation;
    private final NetworkFirewallInternetTrafficNotInspectedViolation networkFirewallInternetTrafficNotInspectedViolation;
    private final NetworkFirewallInvalidRouteConfigurationViolation networkFirewallInvalidRouteConfigurationViolation;
    private final NetworkFirewallBlackHoleRouteDetectedViolation networkFirewallBlackHoleRouteDetectedViolation;
    private final NetworkFirewallUnexpectedFirewallRoutesViolation networkFirewallUnexpectedFirewallRoutesViolation;
    private final NetworkFirewallUnexpectedGatewayRoutesViolation networkFirewallUnexpectedGatewayRoutesViolation;
    private final NetworkFirewallMissingExpectedRoutesViolation networkFirewallMissingExpectedRoutesViolation;
    private final DnsRuleGroupPriorityConflictViolation dnsRuleGroupPriorityConflictViolation;
    private final DnsDuplicateRuleGroupViolation dnsDuplicateRuleGroupViolation;
    private final DnsRuleGroupLimitExceededViolation dnsRuleGroupLimitExceededViolation;
    private final FirewallSubnetIsOutOfScopeViolation firewallSubnetIsOutOfScopeViolation;
    private final RouteHasOutOfScopeEndpointViolation routeHasOutOfScopeEndpointViolation;
    private final ThirdPartyFirewallMissingFirewallViolation thirdPartyFirewallMissingFirewallViolation;
    private final ThirdPartyFirewallMissingSubnetViolation thirdPartyFirewallMissingSubnetViolation;
    private final ThirdPartyFirewallMissingExpectedRouteTableViolation thirdPartyFirewallMissingExpectedRouteTableViolation;
    private final FirewallSubnetMissingVPCEndpointViolation firewallSubnetMissingVPCEndpointViolation;
    private final InvalidNetworkAclEntriesViolation invalidNetworkAclEntriesViolation;
    private final PossibleRemediationActions possibleRemediationActions;

    private ResourceViolation(BuilderImpl builder) {
        this.awsVPCSecurityGroupViolation = builder.awsVPCSecurityGroupViolation;
        this.awsEc2NetworkInterfaceViolation = builder.awsEc2NetworkInterfaceViolation;
        this.awsEc2InstanceViolation = builder.awsEc2InstanceViolation;
        this.networkFirewallMissingFirewallViolation = builder.networkFirewallMissingFirewallViolation;
        this.networkFirewallMissingSubnetViolation = builder.networkFirewallMissingSubnetViolation;
        this.networkFirewallMissingExpectedRTViolation = builder.networkFirewallMissingExpectedRTViolation;
        this.networkFirewallPolicyModifiedViolation = builder.networkFirewallPolicyModifiedViolation;
        this.networkFirewallInternetTrafficNotInspectedViolation = builder.networkFirewallInternetTrafficNotInspectedViolation;
        this.networkFirewallInvalidRouteConfigurationViolation = builder.networkFirewallInvalidRouteConfigurationViolation;
        this.networkFirewallBlackHoleRouteDetectedViolation = builder.networkFirewallBlackHoleRouteDetectedViolation;
        this.networkFirewallUnexpectedFirewallRoutesViolation = builder.networkFirewallUnexpectedFirewallRoutesViolation;
        this.networkFirewallUnexpectedGatewayRoutesViolation = builder.networkFirewallUnexpectedGatewayRoutesViolation;
        this.networkFirewallMissingExpectedRoutesViolation = builder.networkFirewallMissingExpectedRoutesViolation;
        this.dnsRuleGroupPriorityConflictViolation = builder.dnsRuleGroupPriorityConflictViolation;
        this.dnsDuplicateRuleGroupViolation = builder.dnsDuplicateRuleGroupViolation;
        this.dnsRuleGroupLimitExceededViolation = builder.dnsRuleGroupLimitExceededViolation;
        this.firewallSubnetIsOutOfScopeViolation = builder.firewallSubnetIsOutOfScopeViolation;
        this.routeHasOutOfScopeEndpointViolation = builder.routeHasOutOfScopeEndpointViolation;
        this.thirdPartyFirewallMissingFirewallViolation = builder.thirdPartyFirewallMissingFirewallViolation;
        this.thirdPartyFirewallMissingSubnetViolation = builder.thirdPartyFirewallMissingSubnetViolation;
        this.thirdPartyFirewallMissingExpectedRouteTableViolation = builder.thirdPartyFirewallMissingExpectedRouteTableViolation;
        this.firewallSubnetMissingVPCEndpointViolation = builder.firewallSubnetMissingVPCEndpointViolation;
        this.invalidNetworkAclEntriesViolation = builder.invalidNetworkAclEntriesViolation;
        this.possibleRemediationActions = builder.possibleRemediationActions;
    }

    public final AwsVPCSecurityGroupViolation awsVPCSecurityGroupViolation() {
        return this.awsVPCSecurityGroupViolation;
    }

    public final AwsEc2NetworkInterfaceViolation awsEc2NetworkInterfaceViolation() {
        return this.awsEc2NetworkInterfaceViolation;
    }

    public final AwsEc2InstanceViolation awsEc2InstanceViolation() {
        return this.awsEc2InstanceViolation;
    }

    public final NetworkFirewallMissingFirewallViolation networkFirewallMissingFirewallViolation() {
        return this.networkFirewallMissingFirewallViolation;
    }

    public final NetworkFirewallMissingSubnetViolation networkFirewallMissingSubnetViolation() {
        return this.networkFirewallMissingSubnetViolation;
    }

    public final NetworkFirewallMissingExpectedRTViolation networkFirewallMissingExpectedRTViolation() {
        return this.networkFirewallMissingExpectedRTViolation;
    }

    public final NetworkFirewallPolicyModifiedViolation networkFirewallPolicyModifiedViolation() {
        return this.networkFirewallPolicyModifiedViolation;
    }

    public final NetworkFirewallInternetTrafficNotInspectedViolation networkFirewallInternetTrafficNotInspectedViolation() {
        return this.networkFirewallInternetTrafficNotInspectedViolation;
    }

    public final NetworkFirewallInvalidRouteConfigurationViolation networkFirewallInvalidRouteConfigurationViolation() {
        return this.networkFirewallInvalidRouteConfigurationViolation;
    }

    public final NetworkFirewallBlackHoleRouteDetectedViolation networkFirewallBlackHoleRouteDetectedViolation() {
        return this.networkFirewallBlackHoleRouteDetectedViolation;
    }

    public final NetworkFirewallUnexpectedFirewallRoutesViolation networkFirewallUnexpectedFirewallRoutesViolation() {
        return this.networkFirewallUnexpectedFirewallRoutesViolation;
    }

    public final NetworkFirewallUnexpectedGatewayRoutesViolation networkFirewallUnexpectedGatewayRoutesViolation() {
        return this.networkFirewallUnexpectedGatewayRoutesViolation;
    }

    public final NetworkFirewallMissingExpectedRoutesViolation networkFirewallMissingExpectedRoutesViolation() {
        return this.networkFirewallMissingExpectedRoutesViolation;
    }

    public final DnsRuleGroupPriorityConflictViolation dnsRuleGroupPriorityConflictViolation() {
        return this.dnsRuleGroupPriorityConflictViolation;
    }

    public final DnsDuplicateRuleGroupViolation dnsDuplicateRuleGroupViolation() {
        return this.dnsDuplicateRuleGroupViolation;
    }

    public final DnsRuleGroupLimitExceededViolation dnsRuleGroupLimitExceededViolation() {
        return this.dnsRuleGroupLimitExceededViolation;
    }

    public final FirewallSubnetIsOutOfScopeViolation firewallSubnetIsOutOfScopeViolation() {
        return this.firewallSubnetIsOutOfScopeViolation;
    }

    public final RouteHasOutOfScopeEndpointViolation routeHasOutOfScopeEndpointViolation() {
        return this.routeHasOutOfScopeEndpointViolation;
    }

    public final ThirdPartyFirewallMissingFirewallViolation thirdPartyFirewallMissingFirewallViolation() {
        return this.thirdPartyFirewallMissingFirewallViolation;
    }

    public final ThirdPartyFirewallMissingSubnetViolation thirdPartyFirewallMissingSubnetViolation() {
        return this.thirdPartyFirewallMissingSubnetViolation;
    }

    public final ThirdPartyFirewallMissingExpectedRouteTableViolation thirdPartyFirewallMissingExpectedRouteTableViolation() {
        return this.thirdPartyFirewallMissingExpectedRouteTableViolation;
    }

    public final FirewallSubnetMissingVPCEndpointViolation firewallSubnetMissingVPCEndpointViolation() {
        return this.firewallSubnetMissingVPCEndpointViolation;
    }

    public final InvalidNetworkAclEntriesViolation invalidNetworkAclEntriesViolation() {
        return this.invalidNetworkAclEntriesViolation;
    }

    public final PossibleRemediationActions possibleRemediationActions() {
        return this.possibleRemediationActions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.awsVPCSecurityGroupViolation());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsEc2NetworkInterfaceViolation());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsEc2InstanceViolation());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkFirewallMissingFirewallViolation());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkFirewallMissingSubnetViolation());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkFirewallMissingExpectedRTViolation());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkFirewallPolicyModifiedViolation());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkFirewallInternetTrafficNotInspectedViolation());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkFirewallInvalidRouteConfigurationViolation());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkFirewallBlackHoleRouteDetectedViolation());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkFirewallUnexpectedFirewallRoutesViolation());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkFirewallUnexpectedGatewayRoutesViolation());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkFirewallMissingExpectedRoutesViolation());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsRuleGroupPriorityConflictViolation());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsDuplicateRuleGroupViolation());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsRuleGroupLimitExceededViolation());
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallSubnetIsOutOfScopeViolation());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeHasOutOfScopeEndpointViolation());
        hashCode = 31 * hashCode + Objects.hashCode(this.thirdPartyFirewallMissingFirewallViolation());
        hashCode = 31 * hashCode + Objects.hashCode(this.thirdPartyFirewallMissingSubnetViolation());
        hashCode = 31 * hashCode + Objects.hashCode(this.thirdPartyFirewallMissingExpectedRouteTableViolation());
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallSubnetMissingVPCEndpointViolation());
        hashCode = 31 * hashCode + Objects.hashCode(this.invalidNetworkAclEntriesViolation());
        hashCode = 31 * hashCode + Objects.hashCode(this.possibleRemediationActions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceViolation)) {
            return false;
        }
        ResourceViolation other = (ResourceViolation)obj;
        return Objects.equals(this.awsVPCSecurityGroupViolation(), other.awsVPCSecurityGroupViolation()) && Objects.equals(this.awsEc2NetworkInterfaceViolation(), other.awsEc2NetworkInterfaceViolation()) && Objects.equals(this.awsEc2InstanceViolation(), other.awsEc2InstanceViolation()) && Objects.equals(this.networkFirewallMissingFirewallViolation(), other.networkFirewallMissingFirewallViolation()) && Objects.equals(this.networkFirewallMissingSubnetViolation(), other.networkFirewallMissingSubnetViolation()) && Objects.equals(this.networkFirewallMissingExpectedRTViolation(), other.networkFirewallMissingExpectedRTViolation()) && Objects.equals(this.networkFirewallPolicyModifiedViolation(), other.networkFirewallPolicyModifiedViolation()) && Objects.equals(this.networkFirewallInternetTrafficNotInspectedViolation(), other.networkFirewallInternetTrafficNotInspectedViolation()) && Objects.equals(this.networkFirewallInvalidRouteConfigurationViolation(), other.networkFirewallInvalidRouteConfigurationViolation()) && Objects.equals(this.networkFirewallBlackHoleRouteDetectedViolation(), other.networkFirewallBlackHoleRouteDetectedViolation()) && Objects.equals(this.networkFirewallUnexpectedFirewallRoutesViolation(), other.networkFirewallUnexpectedFirewallRoutesViolation()) && Objects.equals(this.networkFirewallUnexpectedGatewayRoutesViolation(), other.networkFirewallUnexpectedGatewayRoutesViolation()) && Objects.equals(this.networkFirewallMissingExpectedRoutesViolation(), other.networkFirewallMissingExpectedRoutesViolation()) && Objects.equals(this.dnsRuleGroupPriorityConflictViolation(), other.dnsRuleGroupPriorityConflictViolation()) && Objects.equals(this.dnsDuplicateRuleGroupViolation(), other.dnsDuplicateRuleGroupViolation()) && Objects.equals(this.dnsRuleGroupLimitExceededViolation(), other.dnsRuleGroupLimitExceededViolation()) && Objects.equals(this.firewallSubnetIsOutOfScopeViolation(), other.firewallSubnetIsOutOfScopeViolation()) && Objects.equals(this.routeHasOutOfScopeEndpointViolation(), other.routeHasOutOfScopeEndpointViolation()) && Objects.equals(this.thirdPartyFirewallMissingFirewallViolation(), other.thirdPartyFirewallMissingFirewallViolation()) && Objects.equals(this.thirdPartyFirewallMissingSubnetViolation(), other.thirdPartyFirewallMissingSubnetViolation()) && Objects.equals(this.thirdPartyFirewallMissingExpectedRouteTableViolation(), other.thirdPartyFirewallMissingExpectedRouteTableViolation()) && Objects.equals(this.firewallSubnetMissingVPCEndpointViolation(), other.firewallSubnetMissingVPCEndpointViolation()) && Objects.equals(this.invalidNetworkAclEntriesViolation(), other.invalidNetworkAclEntriesViolation()) && Objects.equals(this.possibleRemediationActions(), other.possibleRemediationActions());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceViolation").add("AwsVPCSecurityGroupViolation", (Object)this.awsVPCSecurityGroupViolation()).add("AwsEc2NetworkInterfaceViolation", (Object)this.awsEc2NetworkInterfaceViolation()).add("AwsEc2InstanceViolation", (Object)this.awsEc2InstanceViolation()).add("NetworkFirewallMissingFirewallViolation", (Object)this.networkFirewallMissingFirewallViolation()).add("NetworkFirewallMissingSubnetViolation", (Object)this.networkFirewallMissingSubnetViolation()).add("NetworkFirewallMissingExpectedRTViolation", (Object)this.networkFirewallMissingExpectedRTViolation()).add("NetworkFirewallPolicyModifiedViolation", (Object)this.networkFirewallPolicyModifiedViolation()).add("NetworkFirewallInternetTrafficNotInspectedViolation", (Object)this.networkFirewallInternetTrafficNotInspectedViolation()).add("NetworkFirewallInvalidRouteConfigurationViolation", (Object)this.networkFirewallInvalidRouteConfigurationViolation()).add("NetworkFirewallBlackHoleRouteDetectedViolation", (Object)this.networkFirewallBlackHoleRouteDetectedViolation()).add("NetworkFirewallUnexpectedFirewallRoutesViolation", (Object)this.networkFirewallUnexpectedFirewallRoutesViolation()).add("NetworkFirewallUnexpectedGatewayRoutesViolation", (Object)this.networkFirewallUnexpectedGatewayRoutesViolation()).add("NetworkFirewallMissingExpectedRoutesViolation", (Object)this.networkFirewallMissingExpectedRoutesViolation()).add("DnsRuleGroupPriorityConflictViolation", (Object)this.dnsRuleGroupPriorityConflictViolation()).add("DnsDuplicateRuleGroupViolation", (Object)this.dnsDuplicateRuleGroupViolation()).add("DnsRuleGroupLimitExceededViolation", (Object)this.dnsRuleGroupLimitExceededViolation()).add("FirewallSubnetIsOutOfScopeViolation", (Object)this.firewallSubnetIsOutOfScopeViolation()).add("RouteHasOutOfScopeEndpointViolation", (Object)this.routeHasOutOfScopeEndpointViolation()).add("ThirdPartyFirewallMissingFirewallViolation", (Object)this.thirdPartyFirewallMissingFirewallViolation()).add("ThirdPartyFirewallMissingSubnetViolation", (Object)this.thirdPartyFirewallMissingSubnetViolation()).add("ThirdPartyFirewallMissingExpectedRouteTableViolation", (Object)this.thirdPartyFirewallMissingExpectedRouteTableViolation()).add("FirewallSubnetMissingVPCEndpointViolation", (Object)this.firewallSubnetMissingVPCEndpointViolation()).add("InvalidNetworkAclEntriesViolation", (Object)this.invalidNetworkAclEntriesViolation()).add("PossibleRemediationActions", (Object)this.possibleRemediationActions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsVPCSecurityGroupViolation": {
                return Optional.ofNullable(clazz.cast(this.awsVPCSecurityGroupViolation()));
            }
            case "AwsEc2NetworkInterfaceViolation": {
                return Optional.ofNullable(clazz.cast(this.awsEc2NetworkInterfaceViolation()));
            }
            case "AwsEc2InstanceViolation": {
                return Optional.ofNullable(clazz.cast(this.awsEc2InstanceViolation()));
            }
            case "NetworkFirewallMissingFirewallViolation": {
                return Optional.ofNullable(clazz.cast(this.networkFirewallMissingFirewallViolation()));
            }
            case "NetworkFirewallMissingSubnetViolation": {
                return Optional.ofNullable(clazz.cast(this.networkFirewallMissingSubnetViolation()));
            }
            case "NetworkFirewallMissingExpectedRTViolation": {
                return Optional.ofNullable(clazz.cast(this.networkFirewallMissingExpectedRTViolation()));
            }
            case "NetworkFirewallPolicyModifiedViolation": {
                return Optional.ofNullable(clazz.cast(this.networkFirewallPolicyModifiedViolation()));
            }
            case "NetworkFirewallInternetTrafficNotInspectedViolation": {
                return Optional.ofNullable(clazz.cast(this.networkFirewallInternetTrafficNotInspectedViolation()));
            }
            case "NetworkFirewallInvalidRouteConfigurationViolation": {
                return Optional.ofNullable(clazz.cast(this.networkFirewallInvalidRouteConfigurationViolation()));
            }
            case "NetworkFirewallBlackHoleRouteDetectedViolation": {
                return Optional.ofNullable(clazz.cast(this.networkFirewallBlackHoleRouteDetectedViolation()));
            }
            case "NetworkFirewallUnexpectedFirewallRoutesViolation": {
                return Optional.ofNullable(clazz.cast(this.networkFirewallUnexpectedFirewallRoutesViolation()));
            }
            case "NetworkFirewallUnexpectedGatewayRoutesViolation": {
                return Optional.ofNullable(clazz.cast(this.networkFirewallUnexpectedGatewayRoutesViolation()));
            }
            case "NetworkFirewallMissingExpectedRoutesViolation": {
                return Optional.ofNullable(clazz.cast(this.networkFirewallMissingExpectedRoutesViolation()));
            }
            case "DnsRuleGroupPriorityConflictViolation": {
                return Optional.ofNullable(clazz.cast(this.dnsRuleGroupPriorityConflictViolation()));
            }
            case "DnsDuplicateRuleGroupViolation": {
                return Optional.ofNullable(clazz.cast(this.dnsDuplicateRuleGroupViolation()));
            }
            case "DnsRuleGroupLimitExceededViolation": {
                return Optional.ofNullable(clazz.cast(this.dnsRuleGroupLimitExceededViolation()));
            }
            case "FirewallSubnetIsOutOfScopeViolation": {
                return Optional.ofNullable(clazz.cast(this.firewallSubnetIsOutOfScopeViolation()));
            }
            case "RouteHasOutOfScopeEndpointViolation": {
                return Optional.ofNullable(clazz.cast(this.routeHasOutOfScopeEndpointViolation()));
            }
            case "ThirdPartyFirewallMissingFirewallViolation": {
                return Optional.ofNullable(clazz.cast(this.thirdPartyFirewallMissingFirewallViolation()));
            }
            case "ThirdPartyFirewallMissingSubnetViolation": {
                return Optional.ofNullable(clazz.cast(this.thirdPartyFirewallMissingSubnetViolation()));
            }
            case "ThirdPartyFirewallMissingExpectedRouteTableViolation": {
                return Optional.ofNullable(clazz.cast(this.thirdPartyFirewallMissingExpectedRouteTableViolation()));
            }
            case "FirewallSubnetMissingVPCEndpointViolation": {
                return Optional.ofNullable(clazz.cast(this.firewallSubnetMissingVPCEndpointViolation()));
            }
            case "InvalidNetworkAclEntriesViolation": {
                return Optional.ofNullable(clazz.cast(this.invalidNetworkAclEntriesViolation()));
            }
            case "PossibleRemediationActions": {
                return Optional.ofNullable(clazz.cast(this.possibleRemediationActions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceViolation, T> g) {
        return obj -> g.apply((ResourceViolation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AwsVPCSecurityGroupViolation awsVPCSecurityGroupViolation;
        private AwsEc2NetworkInterfaceViolation awsEc2NetworkInterfaceViolation;
        private AwsEc2InstanceViolation awsEc2InstanceViolation;
        private NetworkFirewallMissingFirewallViolation networkFirewallMissingFirewallViolation;
        private NetworkFirewallMissingSubnetViolation networkFirewallMissingSubnetViolation;
        private NetworkFirewallMissingExpectedRTViolation networkFirewallMissingExpectedRTViolation;
        private NetworkFirewallPolicyModifiedViolation networkFirewallPolicyModifiedViolation;
        private NetworkFirewallInternetTrafficNotInspectedViolation networkFirewallInternetTrafficNotInspectedViolation;
        private NetworkFirewallInvalidRouteConfigurationViolation networkFirewallInvalidRouteConfigurationViolation;
        private NetworkFirewallBlackHoleRouteDetectedViolation networkFirewallBlackHoleRouteDetectedViolation;
        private NetworkFirewallUnexpectedFirewallRoutesViolation networkFirewallUnexpectedFirewallRoutesViolation;
        private NetworkFirewallUnexpectedGatewayRoutesViolation networkFirewallUnexpectedGatewayRoutesViolation;
        private NetworkFirewallMissingExpectedRoutesViolation networkFirewallMissingExpectedRoutesViolation;
        private DnsRuleGroupPriorityConflictViolation dnsRuleGroupPriorityConflictViolation;
        private DnsDuplicateRuleGroupViolation dnsDuplicateRuleGroupViolation;
        private DnsRuleGroupLimitExceededViolation dnsRuleGroupLimitExceededViolation;
        private FirewallSubnetIsOutOfScopeViolation firewallSubnetIsOutOfScopeViolation;
        private RouteHasOutOfScopeEndpointViolation routeHasOutOfScopeEndpointViolation;
        private ThirdPartyFirewallMissingFirewallViolation thirdPartyFirewallMissingFirewallViolation;
        private ThirdPartyFirewallMissingSubnetViolation thirdPartyFirewallMissingSubnetViolation;
        private ThirdPartyFirewallMissingExpectedRouteTableViolation thirdPartyFirewallMissingExpectedRouteTableViolation;
        private FirewallSubnetMissingVPCEndpointViolation firewallSubnetMissingVPCEndpointViolation;
        private InvalidNetworkAclEntriesViolation invalidNetworkAclEntriesViolation;
        private PossibleRemediationActions possibleRemediationActions;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceViolation model) {
            this.awsVPCSecurityGroupViolation(model.awsVPCSecurityGroupViolation);
            this.awsEc2NetworkInterfaceViolation(model.awsEc2NetworkInterfaceViolation);
            this.awsEc2InstanceViolation(model.awsEc2InstanceViolation);
            this.networkFirewallMissingFirewallViolation(model.networkFirewallMissingFirewallViolation);
            this.networkFirewallMissingSubnetViolation(model.networkFirewallMissingSubnetViolation);
            this.networkFirewallMissingExpectedRTViolation(model.networkFirewallMissingExpectedRTViolation);
            this.networkFirewallPolicyModifiedViolation(model.networkFirewallPolicyModifiedViolation);
            this.networkFirewallInternetTrafficNotInspectedViolation(model.networkFirewallInternetTrafficNotInspectedViolation);
            this.networkFirewallInvalidRouteConfigurationViolation(model.networkFirewallInvalidRouteConfigurationViolation);
            this.networkFirewallBlackHoleRouteDetectedViolation(model.networkFirewallBlackHoleRouteDetectedViolation);
            this.networkFirewallUnexpectedFirewallRoutesViolation(model.networkFirewallUnexpectedFirewallRoutesViolation);
            this.networkFirewallUnexpectedGatewayRoutesViolation(model.networkFirewallUnexpectedGatewayRoutesViolation);
            this.networkFirewallMissingExpectedRoutesViolation(model.networkFirewallMissingExpectedRoutesViolation);
            this.dnsRuleGroupPriorityConflictViolation(model.dnsRuleGroupPriorityConflictViolation);
            this.dnsDuplicateRuleGroupViolation(model.dnsDuplicateRuleGroupViolation);
            this.dnsRuleGroupLimitExceededViolation(model.dnsRuleGroupLimitExceededViolation);
            this.firewallSubnetIsOutOfScopeViolation(model.firewallSubnetIsOutOfScopeViolation);
            this.routeHasOutOfScopeEndpointViolation(model.routeHasOutOfScopeEndpointViolation);
            this.thirdPartyFirewallMissingFirewallViolation(model.thirdPartyFirewallMissingFirewallViolation);
            this.thirdPartyFirewallMissingSubnetViolation(model.thirdPartyFirewallMissingSubnetViolation);
            this.thirdPartyFirewallMissingExpectedRouteTableViolation(model.thirdPartyFirewallMissingExpectedRouteTableViolation);
            this.firewallSubnetMissingVPCEndpointViolation(model.firewallSubnetMissingVPCEndpointViolation);
            this.invalidNetworkAclEntriesViolation(model.invalidNetworkAclEntriesViolation);
            this.possibleRemediationActions(model.possibleRemediationActions);
        }

        public final AwsVPCSecurityGroupViolation.Builder getAwsVPCSecurityGroupViolation() {
            return this.awsVPCSecurityGroupViolation != null ? this.awsVPCSecurityGroupViolation.toBuilder() : null;
        }

        public final void setAwsVPCSecurityGroupViolation(AwsVPCSecurityGroupViolation.BuilderImpl awsVPCSecurityGroupViolation) {
            this.awsVPCSecurityGroupViolation = awsVPCSecurityGroupViolation != null ? awsVPCSecurityGroupViolation.build() : null;
        }

        @Override
        public final Builder awsVPCSecurityGroupViolation(AwsVPCSecurityGroupViolation awsVPCSecurityGroupViolation) {
            this.awsVPCSecurityGroupViolation = awsVPCSecurityGroupViolation;
            return this;
        }

        public final AwsEc2NetworkInterfaceViolation.Builder getAwsEc2NetworkInterfaceViolation() {
            return this.awsEc2NetworkInterfaceViolation != null ? this.awsEc2NetworkInterfaceViolation.toBuilder() : null;
        }

        public final void setAwsEc2NetworkInterfaceViolation(AwsEc2NetworkInterfaceViolation.BuilderImpl awsEc2NetworkInterfaceViolation) {
            this.awsEc2NetworkInterfaceViolation = awsEc2NetworkInterfaceViolation != null ? awsEc2NetworkInterfaceViolation.build() : null;
        }

        @Override
        public final Builder awsEc2NetworkInterfaceViolation(AwsEc2NetworkInterfaceViolation awsEc2NetworkInterfaceViolation) {
            this.awsEc2NetworkInterfaceViolation = awsEc2NetworkInterfaceViolation;
            return this;
        }

        public final AwsEc2InstanceViolation.Builder getAwsEc2InstanceViolation() {
            return this.awsEc2InstanceViolation != null ? this.awsEc2InstanceViolation.toBuilder() : null;
        }

        public final void setAwsEc2InstanceViolation(AwsEc2InstanceViolation.BuilderImpl awsEc2InstanceViolation) {
            this.awsEc2InstanceViolation = awsEc2InstanceViolation != null ? awsEc2InstanceViolation.build() : null;
        }

        @Override
        public final Builder awsEc2InstanceViolation(AwsEc2InstanceViolation awsEc2InstanceViolation) {
            this.awsEc2InstanceViolation = awsEc2InstanceViolation;
            return this;
        }

        public final NetworkFirewallMissingFirewallViolation.Builder getNetworkFirewallMissingFirewallViolation() {
            return this.networkFirewallMissingFirewallViolation != null ? this.networkFirewallMissingFirewallViolation.toBuilder() : null;
        }

        public final void setNetworkFirewallMissingFirewallViolation(NetworkFirewallMissingFirewallViolation.BuilderImpl networkFirewallMissingFirewallViolation) {
            this.networkFirewallMissingFirewallViolation = networkFirewallMissingFirewallViolation != null ? networkFirewallMissingFirewallViolation.build() : null;
        }

        @Override
        public final Builder networkFirewallMissingFirewallViolation(NetworkFirewallMissingFirewallViolation networkFirewallMissingFirewallViolation) {
            this.networkFirewallMissingFirewallViolation = networkFirewallMissingFirewallViolation;
            return this;
        }

        public final NetworkFirewallMissingSubnetViolation.Builder getNetworkFirewallMissingSubnetViolation() {
            return this.networkFirewallMissingSubnetViolation != null ? this.networkFirewallMissingSubnetViolation.toBuilder() : null;
        }

        public final void setNetworkFirewallMissingSubnetViolation(NetworkFirewallMissingSubnetViolation.BuilderImpl networkFirewallMissingSubnetViolation) {
            this.networkFirewallMissingSubnetViolation = networkFirewallMissingSubnetViolation != null ? networkFirewallMissingSubnetViolation.build() : null;
        }

        @Override
        public final Builder networkFirewallMissingSubnetViolation(NetworkFirewallMissingSubnetViolation networkFirewallMissingSubnetViolation) {
            this.networkFirewallMissingSubnetViolation = networkFirewallMissingSubnetViolation;
            return this;
        }

        public final NetworkFirewallMissingExpectedRTViolation.Builder getNetworkFirewallMissingExpectedRTViolation() {
            return this.networkFirewallMissingExpectedRTViolation != null ? this.networkFirewallMissingExpectedRTViolation.toBuilder() : null;
        }

        public final void setNetworkFirewallMissingExpectedRTViolation(NetworkFirewallMissingExpectedRTViolation.BuilderImpl networkFirewallMissingExpectedRTViolation) {
            this.networkFirewallMissingExpectedRTViolation = networkFirewallMissingExpectedRTViolation != null ? networkFirewallMissingExpectedRTViolation.build() : null;
        }

        @Override
        public final Builder networkFirewallMissingExpectedRTViolation(NetworkFirewallMissingExpectedRTViolation networkFirewallMissingExpectedRTViolation) {
            this.networkFirewallMissingExpectedRTViolation = networkFirewallMissingExpectedRTViolation;
            return this;
        }

        public final NetworkFirewallPolicyModifiedViolation.Builder getNetworkFirewallPolicyModifiedViolation() {
            return this.networkFirewallPolicyModifiedViolation != null ? this.networkFirewallPolicyModifiedViolation.toBuilder() : null;
        }

        public final void setNetworkFirewallPolicyModifiedViolation(NetworkFirewallPolicyModifiedViolation.BuilderImpl networkFirewallPolicyModifiedViolation) {
            this.networkFirewallPolicyModifiedViolation = networkFirewallPolicyModifiedViolation != null ? networkFirewallPolicyModifiedViolation.build() : null;
        }

        @Override
        public final Builder networkFirewallPolicyModifiedViolation(NetworkFirewallPolicyModifiedViolation networkFirewallPolicyModifiedViolation) {
            this.networkFirewallPolicyModifiedViolation = networkFirewallPolicyModifiedViolation;
            return this;
        }

        public final NetworkFirewallInternetTrafficNotInspectedViolation.Builder getNetworkFirewallInternetTrafficNotInspectedViolation() {
            return this.networkFirewallInternetTrafficNotInspectedViolation != null ? this.networkFirewallInternetTrafficNotInspectedViolation.toBuilder() : null;
        }

        public final void setNetworkFirewallInternetTrafficNotInspectedViolation(NetworkFirewallInternetTrafficNotInspectedViolation.BuilderImpl networkFirewallInternetTrafficNotInspectedViolation) {
            this.networkFirewallInternetTrafficNotInspectedViolation = networkFirewallInternetTrafficNotInspectedViolation != null ? networkFirewallInternetTrafficNotInspectedViolation.build() : null;
        }

        @Override
        public final Builder networkFirewallInternetTrafficNotInspectedViolation(NetworkFirewallInternetTrafficNotInspectedViolation networkFirewallInternetTrafficNotInspectedViolation) {
            this.networkFirewallInternetTrafficNotInspectedViolation = networkFirewallInternetTrafficNotInspectedViolation;
            return this;
        }

        public final NetworkFirewallInvalidRouteConfigurationViolation.Builder getNetworkFirewallInvalidRouteConfigurationViolation() {
            return this.networkFirewallInvalidRouteConfigurationViolation != null ? this.networkFirewallInvalidRouteConfigurationViolation.toBuilder() : null;
        }

        public final void setNetworkFirewallInvalidRouteConfigurationViolation(NetworkFirewallInvalidRouteConfigurationViolation.BuilderImpl networkFirewallInvalidRouteConfigurationViolation) {
            this.networkFirewallInvalidRouteConfigurationViolation = networkFirewallInvalidRouteConfigurationViolation != null ? networkFirewallInvalidRouteConfigurationViolation.build() : null;
        }

        @Override
        public final Builder networkFirewallInvalidRouteConfigurationViolation(NetworkFirewallInvalidRouteConfigurationViolation networkFirewallInvalidRouteConfigurationViolation) {
            this.networkFirewallInvalidRouteConfigurationViolation = networkFirewallInvalidRouteConfigurationViolation;
            return this;
        }

        public final NetworkFirewallBlackHoleRouteDetectedViolation.Builder getNetworkFirewallBlackHoleRouteDetectedViolation() {
            return this.networkFirewallBlackHoleRouteDetectedViolation != null ? this.networkFirewallBlackHoleRouteDetectedViolation.toBuilder() : null;
        }

        public final void setNetworkFirewallBlackHoleRouteDetectedViolation(NetworkFirewallBlackHoleRouteDetectedViolation.BuilderImpl networkFirewallBlackHoleRouteDetectedViolation) {
            this.networkFirewallBlackHoleRouteDetectedViolation = networkFirewallBlackHoleRouteDetectedViolation != null ? networkFirewallBlackHoleRouteDetectedViolation.build() : null;
        }

        @Override
        public final Builder networkFirewallBlackHoleRouteDetectedViolation(NetworkFirewallBlackHoleRouteDetectedViolation networkFirewallBlackHoleRouteDetectedViolation) {
            this.networkFirewallBlackHoleRouteDetectedViolation = networkFirewallBlackHoleRouteDetectedViolation;
            return this;
        }

        public final NetworkFirewallUnexpectedFirewallRoutesViolation.Builder getNetworkFirewallUnexpectedFirewallRoutesViolation() {
            return this.networkFirewallUnexpectedFirewallRoutesViolation != null ? this.networkFirewallUnexpectedFirewallRoutesViolation.toBuilder() : null;
        }

        public final void setNetworkFirewallUnexpectedFirewallRoutesViolation(NetworkFirewallUnexpectedFirewallRoutesViolation.BuilderImpl networkFirewallUnexpectedFirewallRoutesViolation) {
            this.networkFirewallUnexpectedFirewallRoutesViolation = networkFirewallUnexpectedFirewallRoutesViolation != null ? networkFirewallUnexpectedFirewallRoutesViolation.build() : null;
        }

        @Override
        public final Builder networkFirewallUnexpectedFirewallRoutesViolation(NetworkFirewallUnexpectedFirewallRoutesViolation networkFirewallUnexpectedFirewallRoutesViolation) {
            this.networkFirewallUnexpectedFirewallRoutesViolation = networkFirewallUnexpectedFirewallRoutesViolation;
            return this;
        }

        public final NetworkFirewallUnexpectedGatewayRoutesViolation.Builder getNetworkFirewallUnexpectedGatewayRoutesViolation() {
            return this.networkFirewallUnexpectedGatewayRoutesViolation != null ? this.networkFirewallUnexpectedGatewayRoutesViolation.toBuilder() : null;
        }

        public final void setNetworkFirewallUnexpectedGatewayRoutesViolation(NetworkFirewallUnexpectedGatewayRoutesViolation.BuilderImpl networkFirewallUnexpectedGatewayRoutesViolation) {
            this.networkFirewallUnexpectedGatewayRoutesViolation = networkFirewallUnexpectedGatewayRoutesViolation != null ? networkFirewallUnexpectedGatewayRoutesViolation.build() : null;
        }

        @Override
        public final Builder networkFirewallUnexpectedGatewayRoutesViolation(NetworkFirewallUnexpectedGatewayRoutesViolation networkFirewallUnexpectedGatewayRoutesViolation) {
            this.networkFirewallUnexpectedGatewayRoutesViolation = networkFirewallUnexpectedGatewayRoutesViolation;
            return this;
        }

        public final NetworkFirewallMissingExpectedRoutesViolation.Builder getNetworkFirewallMissingExpectedRoutesViolation() {
            return this.networkFirewallMissingExpectedRoutesViolation != null ? this.networkFirewallMissingExpectedRoutesViolation.toBuilder() : null;
        }

        public final void setNetworkFirewallMissingExpectedRoutesViolation(NetworkFirewallMissingExpectedRoutesViolation.BuilderImpl networkFirewallMissingExpectedRoutesViolation) {
            this.networkFirewallMissingExpectedRoutesViolation = networkFirewallMissingExpectedRoutesViolation != null ? networkFirewallMissingExpectedRoutesViolation.build() : null;
        }

        @Override
        public final Builder networkFirewallMissingExpectedRoutesViolation(NetworkFirewallMissingExpectedRoutesViolation networkFirewallMissingExpectedRoutesViolation) {
            this.networkFirewallMissingExpectedRoutesViolation = networkFirewallMissingExpectedRoutesViolation;
            return this;
        }

        public final DnsRuleGroupPriorityConflictViolation.Builder getDnsRuleGroupPriorityConflictViolation() {
            return this.dnsRuleGroupPriorityConflictViolation != null ? this.dnsRuleGroupPriorityConflictViolation.toBuilder() : null;
        }

        public final void setDnsRuleGroupPriorityConflictViolation(DnsRuleGroupPriorityConflictViolation.BuilderImpl dnsRuleGroupPriorityConflictViolation) {
            this.dnsRuleGroupPriorityConflictViolation = dnsRuleGroupPriorityConflictViolation != null ? dnsRuleGroupPriorityConflictViolation.build() : null;
        }

        @Override
        public final Builder dnsRuleGroupPriorityConflictViolation(DnsRuleGroupPriorityConflictViolation dnsRuleGroupPriorityConflictViolation) {
            this.dnsRuleGroupPriorityConflictViolation = dnsRuleGroupPriorityConflictViolation;
            return this;
        }

        public final DnsDuplicateRuleGroupViolation.Builder getDnsDuplicateRuleGroupViolation() {
            return this.dnsDuplicateRuleGroupViolation != null ? this.dnsDuplicateRuleGroupViolation.toBuilder() : null;
        }

        public final void setDnsDuplicateRuleGroupViolation(DnsDuplicateRuleGroupViolation.BuilderImpl dnsDuplicateRuleGroupViolation) {
            this.dnsDuplicateRuleGroupViolation = dnsDuplicateRuleGroupViolation != null ? dnsDuplicateRuleGroupViolation.build() : null;
        }

        @Override
        public final Builder dnsDuplicateRuleGroupViolation(DnsDuplicateRuleGroupViolation dnsDuplicateRuleGroupViolation) {
            this.dnsDuplicateRuleGroupViolation = dnsDuplicateRuleGroupViolation;
            return this;
        }

        public final DnsRuleGroupLimitExceededViolation.Builder getDnsRuleGroupLimitExceededViolation() {
            return this.dnsRuleGroupLimitExceededViolation != null ? this.dnsRuleGroupLimitExceededViolation.toBuilder() : null;
        }

        public final void setDnsRuleGroupLimitExceededViolation(DnsRuleGroupLimitExceededViolation.BuilderImpl dnsRuleGroupLimitExceededViolation) {
            this.dnsRuleGroupLimitExceededViolation = dnsRuleGroupLimitExceededViolation != null ? dnsRuleGroupLimitExceededViolation.build() : null;
        }

        @Override
        public final Builder dnsRuleGroupLimitExceededViolation(DnsRuleGroupLimitExceededViolation dnsRuleGroupLimitExceededViolation) {
            this.dnsRuleGroupLimitExceededViolation = dnsRuleGroupLimitExceededViolation;
            return this;
        }

        public final FirewallSubnetIsOutOfScopeViolation.Builder getFirewallSubnetIsOutOfScopeViolation() {
            return this.firewallSubnetIsOutOfScopeViolation != null ? this.firewallSubnetIsOutOfScopeViolation.toBuilder() : null;
        }

        public final void setFirewallSubnetIsOutOfScopeViolation(FirewallSubnetIsOutOfScopeViolation.BuilderImpl firewallSubnetIsOutOfScopeViolation) {
            this.firewallSubnetIsOutOfScopeViolation = firewallSubnetIsOutOfScopeViolation != null ? firewallSubnetIsOutOfScopeViolation.build() : null;
        }

        @Override
        public final Builder firewallSubnetIsOutOfScopeViolation(FirewallSubnetIsOutOfScopeViolation firewallSubnetIsOutOfScopeViolation) {
            this.firewallSubnetIsOutOfScopeViolation = firewallSubnetIsOutOfScopeViolation;
            return this;
        }

        public final RouteHasOutOfScopeEndpointViolation.Builder getRouteHasOutOfScopeEndpointViolation() {
            return this.routeHasOutOfScopeEndpointViolation != null ? this.routeHasOutOfScopeEndpointViolation.toBuilder() : null;
        }

        public final void setRouteHasOutOfScopeEndpointViolation(RouteHasOutOfScopeEndpointViolation.BuilderImpl routeHasOutOfScopeEndpointViolation) {
            this.routeHasOutOfScopeEndpointViolation = routeHasOutOfScopeEndpointViolation != null ? routeHasOutOfScopeEndpointViolation.build() : null;
        }

        @Override
        public final Builder routeHasOutOfScopeEndpointViolation(RouteHasOutOfScopeEndpointViolation routeHasOutOfScopeEndpointViolation) {
            this.routeHasOutOfScopeEndpointViolation = routeHasOutOfScopeEndpointViolation;
            return this;
        }

        public final ThirdPartyFirewallMissingFirewallViolation.Builder getThirdPartyFirewallMissingFirewallViolation() {
            return this.thirdPartyFirewallMissingFirewallViolation != null ? this.thirdPartyFirewallMissingFirewallViolation.toBuilder() : null;
        }

        public final void setThirdPartyFirewallMissingFirewallViolation(ThirdPartyFirewallMissingFirewallViolation.BuilderImpl thirdPartyFirewallMissingFirewallViolation) {
            this.thirdPartyFirewallMissingFirewallViolation = thirdPartyFirewallMissingFirewallViolation != null ? thirdPartyFirewallMissingFirewallViolation.build() : null;
        }

        @Override
        public final Builder thirdPartyFirewallMissingFirewallViolation(ThirdPartyFirewallMissingFirewallViolation thirdPartyFirewallMissingFirewallViolation) {
            this.thirdPartyFirewallMissingFirewallViolation = thirdPartyFirewallMissingFirewallViolation;
            return this;
        }

        public final ThirdPartyFirewallMissingSubnetViolation.Builder getThirdPartyFirewallMissingSubnetViolation() {
            return this.thirdPartyFirewallMissingSubnetViolation != null ? this.thirdPartyFirewallMissingSubnetViolation.toBuilder() : null;
        }

        public final void setThirdPartyFirewallMissingSubnetViolation(ThirdPartyFirewallMissingSubnetViolation.BuilderImpl thirdPartyFirewallMissingSubnetViolation) {
            this.thirdPartyFirewallMissingSubnetViolation = thirdPartyFirewallMissingSubnetViolation != null ? thirdPartyFirewallMissingSubnetViolation.build() : null;
        }

        @Override
        public final Builder thirdPartyFirewallMissingSubnetViolation(ThirdPartyFirewallMissingSubnetViolation thirdPartyFirewallMissingSubnetViolation) {
            this.thirdPartyFirewallMissingSubnetViolation = thirdPartyFirewallMissingSubnetViolation;
            return this;
        }

        public final ThirdPartyFirewallMissingExpectedRouteTableViolation.Builder getThirdPartyFirewallMissingExpectedRouteTableViolation() {
            return this.thirdPartyFirewallMissingExpectedRouteTableViolation != null ? this.thirdPartyFirewallMissingExpectedRouteTableViolation.toBuilder() : null;
        }

        public final void setThirdPartyFirewallMissingExpectedRouteTableViolation(ThirdPartyFirewallMissingExpectedRouteTableViolation.BuilderImpl thirdPartyFirewallMissingExpectedRouteTableViolation) {
            this.thirdPartyFirewallMissingExpectedRouteTableViolation = thirdPartyFirewallMissingExpectedRouteTableViolation != null ? thirdPartyFirewallMissingExpectedRouteTableViolation.build() : null;
        }

        @Override
        public final Builder thirdPartyFirewallMissingExpectedRouteTableViolation(ThirdPartyFirewallMissingExpectedRouteTableViolation thirdPartyFirewallMissingExpectedRouteTableViolation) {
            this.thirdPartyFirewallMissingExpectedRouteTableViolation = thirdPartyFirewallMissingExpectedRouteTableViolation;
            return this;
        }

        public final FirewallSubnetMissingVPCEndpointViolation.Builder getFirewallSubnetMissingVPCEndpointViolation() {
            return this.firewallSubnetMissingVPCEndpointViolation != null ? this.firewallSubnetMissingVPCEndpointViolation.toBuilder() : null;
        }

        public final void setFirewallSubnetMissingVPCEndpointViolation(FirewallSubnetMissingVPCEndpointViolation.BuilderImpl firewallSubnetMissingVPCEndpointViolation) {
            this.firewallSubnetMissingVPCEndpointViolation = firewallSubnetMissingVPCEndpointViolation != null ? firewallSubnetMissingVPCEndpointViolation.build() : null;
        }

        @Override
        public final Builder firewallSubnetMissingVPCEndpointViolation(FirewallSubnetMissingVPCEndpointViolation firewallSubnetMissingVPCEndpointViolation) {
            this.firewallSubnetMissingVPCEndpointViolation = firewallSubnetMissingVPCEndpointViolation;
            return this;
        }

        public final InvalidNetworkAclEntriesViolation.Builder getInvalidNetworkAclEntriesViolation() {
            return this.invalidNetworkAclEntriesViolation != null ? this.invalidNetworkAclEntriesViolation.toBuilder() : null;
        }

        public final void setInvalidNetworkAclEntriesViolation(InvalidNetworkAclEntriesViolation.BuilderImpl invalidNetworkAclEntriesViolation) {
            this.invalidNetworkAclEntriesViolation = invalidNetworkAclEntriesViolation != null ? invalidNetworkAclEntriesViolation.build() : null;
        }

        @Override
        public final Builder invalidNetworkAclEntriesViolation(InvalidNetworkAclEntriesViolation invalidNetworkAclEntriesViolation) {
            this.invalidNetworkAclEntriesViolation = invalidNetworkAclEntriesViolation;
            return this;
        }

        public final PossibleRemediationActions.Builder getPossibleRemediationActions() {
            return this.possibleRemediationActions != null ? this.possibleRemediationActions.toBuilder() : null;
        }

        public final void setPossibleRemediationActions(PossibleRemediationActions.BuilderImpl possibleRemediationActions) {
            this.possibleRemediationActions = possibleRemediationActions != null ? possibleRemediationActions.build() : null;
        }

        @Override
        public final Builder possibleRemediationActions(PossibleRemediationActions possibleRemediationActions) {
            this.possibleRemediationActions = possibleRemediationActions;
            return this;
        }

        public ResourceViolation build() {
            return new ResourceViolation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceViolation> {
        public Builder awsVPCSecurityGroupViolation(AwsVPCSecurityGroupViolation var1);

        default public Builder awsVPCSecurityGroupViolation(Consumer<AwsVPCSecurityGroupViolation.Builder> awsVPCSecurityGroupViolation) {
            return this.awsVPCSecurityGroupViolation((AwsVPCSecurityGroupViolation)((AwsVPCSecurityGroupViolation.Builder)AwsVPCSecurityGroupViolation.builder().applyMutation(awsVPCSecurityGroupViolation)).build());
        }

        public Builder awsEc2NetworkInterfaceViolation(AwsEc2NetworkInterfaceViolation var1);

        default public Builder awsEc2NetworkInterfaceViolation(Consumer<AwsEc2NetworkInterfaceViolation.Builder> awsEc2NetworkInterfaceViolation) {
            return this.awsEc2NetworkInterfaceViolation((AwsEc2NetworkInterfaceViolation)((AwsEc2NetworkInterfaceViolation.Builder)AwsEc2NetworkInterfaceViolation.builder().applyMutation(awsEc2NetworkInterfaceViolation)).build());
        }

        public Builder awsEc2InstanceViolation(AwsEc2InstanceViolation var1);

        default public Builder awsEc2InstanceViolation(Consumer<AwsEc2InstanceViolation.Builder> awsEc2InstanceViolation) {
            return this.awsEc2InstanceViolation((AwsEc2InstanceViolation)((AwsEc2InstanceViolation.Builder)AwsEc2InstanceViolation.builder().applyMutation(awsEc2InstanceViolation)).build());
        }

        public Builder networkFirewallMissingFirewallViolation(NetworkFirewallMissingFirewallViolation var1);

        default public Builder networkFirewallMissingFirewallViolation(Consumer<NetworkFirewallMissingFirewallViolation.Builder> networkFirewallMissingFirewallViolation) {
            return this.networkFirewallMissingFirewallViolation((NetworkFirewallMissingFirewallViolation)((NetworkFirewallMissingFirewallViolation.Builder)NetworkFirewallMissingFirewallViolation.builder().applyMutation(networkFirewallMissingFirewallViolation)).build());
        }

        public Builder networkFirewallMissingSubnetViolation(NetworkFirewallMissingSubnetViolation var1);

        default public Builder networkFirewallMissingSubnetViolation(Consumer<NetworkFirewallMissingSubnetViolation.Builder> networkFirewallMissingSubnetViolation) {
            return this.networkFirewallMissingSubnetViolation((NetworkFirewallMissingSubnetViolation)((NetworkFirewallMissingSubnetViolation.Builder)NetworkFirewallMissingSubnetViolation.builder().applyMutation(networkFirewallMissingSubnetViolation)).build());
        }

        public Builder networkFirewallMissingExpectedRTViolation(NetworkFirewallMissingExpectedRTViolation var1);

        default public Builder networkFirewallMissingExpectedRTViolation(Consumer<NetworkFirewallMissingExpectedRTViolation.Builder> networkFirewallMissingExpectedRTViolation) {
            return this.networkFirewallMissingExpectedRTViolation((NetworkFirewallMissingExpectedRTViolation)((NetworkFirewallMissingExpectedRTViolation.Builder)NetworkFirewallMissingExpectedRTViolation.builder().applyMutation(networkFirewallMissingExpectedRTViolation)).build());
        }

        public Builder networkFirewallPolicyModifiedViolation(NetworkFirewallPolicyModifiedViolation var1);

        default public Builder networkFirewallPolicyModifiedViolation(Consumer<NetworkFirewallPolicyModifiedViolation.Builder> networkFirewallPolicyModifiedViolation) {
            return this.networkFirewallPolicyModifiedViolation((NetworkFirewallPolicyModifiedViolation)((NetworkFirewallPolicyModifiedViolation.Builder)NetworkFirewallPolicyModifiedViolation.builder().applyMutation(networkFirewallPolicyModifiedViolation)).build());
        }

        public Builder networkFirewallInternetTrafficNotInspectedViolation(NetworkFirewallInternetTrafficNotInspectedViolation var1);

        default public Builder networkFirewallInternetTrafficNotInspectedViolation(Consumer<NetworkFirewallInternetTrafficNotInspectedViolation.Builder> networkFirewallInternetTrafficNotInspectedViolation) {
            return this.networkFirewallInternetTrafficNotInspectedViolation((NetworkFirewallInternetTrafficNotInspectedViolation)((NetworkFirewallInternetTrafficNotInspectedViolation.Builder)NetworkFirewallInternetTrafficNotInspectedViolation.builder().applyMutation(networkFirewallInternetTrafficNotInspectedViolation)).build());
        }

        public Builder networkFirewallInvalidRouteConfigurationViolation(NetworkFirewallInvalidRouteConfigurationViolation var1);

        default public Builder networkFirewallInvalidRouteConfigurationViolation(Consumer<NetworkFirewallInvalidRouteConfigurationViolation.Builder> networkFirewallInvalidRouteConfigurationViolation) {
            return this.networkFirewallInvalidRouteConfigurationViolation((NetworkFirewallInvalidRouteConfigurationViolation)((NetworkFirewallInvalidRouteConfigurationViolation.Builder)NetworkFirewallInvalidRouteConfigurationViolation.builder().applyMutation(networkFirewallInvalidRouteConfigurationViolation)).build());
        }

        public Builder networkFirewallBlackHoleRouteDetectedViolation(NetworkFirewallBlackHoleRouteDetectedViolation var1);

        default public Builder networkFirewallBlackHoleRouteDetectedViolation(Consumer<NetworkFirewallBlackHoleRouteDetectedViolation.Builder> networkFirewallBlackHoleRouteDetectedViolation) {
            return this.networkFirewallBlackHoleRouteDetectedViolation((NetworkFirewallBlackHoleRouteDetectedViolation)((NetworkFirewallBlackHoleRouteDetectedViolation.Builder)NetworkFirewallBlackHoleRouteDetectedViolation.builder().applyMutation(networkFirewallBlackHoleRouteDetectedViolation)).build());
        }

        public Builder networkFirewallUnexpectedFirewallRoutesViolation(NetworkFirewallUnexpectedFirewallRoutesViolation var1);

        default public Builder networkFirewallUnexpectedFirewallRoutesViolation(Consumer<NetworkFirewallUnexpectedFirewallRoutesViolation.Builder> networkFirewallUnexpectedFirewallRoutesViolation) {
            return this.networkFirewallUnexpectedFirewallRoutesViolation((NetworkFirewallUnexpectedFirewallRoutesViolation)((NetworkFirewallUnexpectedFirewallRoutesViolation.Builder)NetworkFirewallUnexpectedFirewallRoutesViolation.builder().applyMutation(networkFirewallUnexpectedFirewallRoutesViolation)).build());
        }

        public Builder networkFirewallUnexpectedGatewayRoutesViolation(NetworkFirewallUnexpectedGatewayRoutesViolation var1);

        default public Builder networkFirewallUnexpectedGatewayRoutesViolation(Consumer<NetworkFirewallUnexpectedGatewayRoutesViolation.Builder> networkFirewallUnexpectedGatewayRoutesViolation) {
            return this.networkFirewallUnexpectedGatewayRoutesViolation((NetworkFirewallUnexpectedGatewayRoutesViolation)((NetworkFirewallUnexpectedGatewayRoutesViolation.Builder)NetworkFirewallUnexpectedGatewayRoutesViolation.builder().applyMutation(networkFirewallUnexpectedGatewayRoutesViolation)).build());
        }

        public Builder networkFirewallMissingExpectedRoutesViolation(NetworkFirewallMissingExpectedRoutesViolation var1);

        default public Builder networkFirewallMissingExpectedRoutesViolation(Consumer<NetworkFirewallMissingExpectedRoutesViolation.Builder> networkFirewallMissingExpectedRoutesViolation) {
            return this.networkFirewallMissingExpectedRoutesViolation((NetworkFirewallMissingExpectedRoutesViolation)((NetworkFirewallMissingExpectedRoutesViolation.Builder)NetworkFirewallMissingExpectedRoutesViolation.builder().applyMutation(networkFirewallMissingExpectedRoutesViolation)).build());
        }

        public Builder dnsRuleGroupPriorityConflictViolation(DnsRuleGroupPriorityConflictViolation var1);

        default public Builder dnsRuleGroupPriorityConflictViolation(Consumer<DnsRuleGroupPriorityConflictViolation.Builder> dnsRuleGroupPriorityConflictViolation) {
            return this.dnsRuleGroupPriorityConflictViolation((DnsRuleGroupPriorityConflictViolation)((DnsRuleGroupPriorityConflictViolation.Builder)DnsRuleGroupPriorityConflictViolation.builder().applyMutation(dnsRuleGroupPriorityConflictViolation)).build());
        }

        public Builder dnsDuplicateRuleGroupViolation(DnsDuplicateRuleGroupViolation var1);

        default public Builder dnsDuplicateRuleGroupViolation(Consumer<DnsDuplicateRuleGroupViolation.Builder> dnsDuplicateRuleGroupViolation) {
            return this.dnsDuplicateRuleGroupViolation((DnsDuplicateRuleGroupViolation)((DnsDuplicateRuleGroupViolation.Builder)DnsDuplicateRuleGroupViolation.builder().applyMutation(dnsDuplicateRuleGroupViolation)).build());
        }

        public Builder dnsRuleGroupLimitExceededViolation(DnsRuleGroupLimitExceededViolation var1);

        default public Builder dnsRuleGroupLimitExceededViolation(Consumer<DnsRuleGroupLimitExceededViolation.Builder> dnsRuleGroupLimitExceededViolation) {
            return this.dnsRuleGroupLimitExceededViolation((DnsRuleGroupLimitExceededViolation)((DnsRuleGroupLimitExceededViolation.Builder)DnsRuleGroupLimitExceededViolation.builder().applyMutation(dnsRuleGroupLimitExceededViolation)).build());
        }

        public Builder firewallSubnetIsOutOfScopeViolation(FirewallSubnetIsOutOfScopeViolation var1);

        default public Builder firewallSubnetIsOutOfScopeViolation(Consumer<FirewallSubnetIsOutOfScopeViolation.Builder> firewallSubnetIsOutOfScopeViolation) {
            return this.firewallSubnetIsOutOfScopeViolation((FirewallSubnetIsOutOfScopeViolation)((FirewallSubnetIsOutOfScopeViolation.Builder)FirewallSubnetIsOutOfScopeViolation.builder().applyMutation(firewallSubnetIsOutOfScopeViolation)).build());
        }

        public Builder routeHasOutOfScopeEndpointViolation(RouteHasOutOfScopeEndpointViolation var1);

        default public Builder routeHasOutOfScopeEndpointViolation(Consumer<RouteHasOutOfScopeEndpointViolation.Builder> routeHasOutOfScopeEndpointViolation) {
            return this.routeHasOutOfScopeEndpointViolation((RouteHasOutOfScopeEndpointViolation)((RouteHasOutOfScopeEndpointViolation.Builder)RouteHasOutOfScopeEndpointViolation.builder().applyMutation(routeHasOutOfScopeEndpointViolation)).build());
        }

        public Builder thirdPartyFirewallMissingFirewallViolation(ThirdPartyFirewallMissingFirewallViolation var1);

        default public Builder thirdPartyFirewallMissingFirewallViolation(Consumer<ThirdPartyFirewallMissingFirewallViolation.Builder> thirdPartyFirewallMissingFirewallViolation) {
            return this.thirdPartyFirewallMissingFirewallViolation((ThirdPartyFirewallMissingFirewallViolation)((ThirdPartyFirewallMissingFirewallViolation.Builder)ThirdPartyFirewallMissingFirewallViolation.builder().applyMutation(thirdPartyFirewallMissingFirewallViolation)).build());
        }

        public Builder thirdPartyFirewallMissingSubnetViolation(ThirdPartyFirewallMissingSubnetViolation var1);

        default public Builder thirdPartyFirewallMissingSubnetViolation(Consumer<ThirdPartyFirewallMissingSubnetViolation.Builder> thirdPartyFirewallMissingSubnetViolation) {
            return this.thirdPartyFirewallMissingSubnetViolation((ThirdPartyFirewallMissingSubnetViolation)((ThirdPartyFirewallMissingSubnetViolation.Builder)ThirdPartyFirewallMissingSubnetViolation.builder().applyMutation(thirdPartyFirewallMissingSubnetViolation)).build());
        }

        public Builder thirdPartyFirewallMissingExpectedRouteTableViolation(ThirdPartyFirewallMissingExpectedRouteTableViolation var1);

        default public Builder thirdPartyFirewallMissingExpectedRouteTableViolation(Consumer<ThirdPartyFirewallMissingExpectedRouteTableViolation.Builder> thirdPartyFirewallMissingExpectedRouteTableViolation) {
            return this.thirdPartyFirewallMissingExpectedRouteTableViolation((ThirdPartyFirewallMissingExpectedRouteTableViolation)((ThirdPartyFirewallMissingExpectedRouteTableViolation.Builder)ThirdPartyFirewallMissingExpectedRouteTableViolation.builder().applyMutation(thirdPartyFirewallMissingExpectedRouteTableViolation)).build());
        }

        public Builder firewallSubnetMissingVPCEndpointViolation(FirewallSubnetMissingVPCEndpointViolation var1);

        default public Builder firewallSubnetMissingVPCEndpointViolation(Consumer<FirewallSubnetMissingVPCEndpointViolation.Builder> firewallSubnetMissingVPCEndpointViolation) {
            return this.firewallSubnetMissingVPCEndpointViolation((FirewallSubnetMissingVPCEndpointViolation)((FirewallSubnetMissingVPCEndpointViolation.Builder)FirewallSubnetMissingVPCEndpointViolation.builder().applyMutation(firewallSubnetMissingVPCEndpointViolation)).build());
        }

        public Builder invalidNetworkAclEntriesViolation(InvalidNetworkAclEntriesViolation var1);

        default public Builder invalidNetworkAclEntriesViolation(Consumer<InvalidNetworkAclEntriesViolation.Builder> invalidNetworkAclEntriesViolation) {
            return this.invalidNetworkAclEntriesViolation((InvalidNetworkAclEntriesViolation)((InvalidNetworkAclEntriesViolation.Builder)InvalidNetworkAclEntriesViolation.builder().applyMutation(invalidNetworkAclEntriesViolation)).build());
        }

        public Builder possibleRemediationActions(PossibleRemediationActions var1);

        default public Builder possibleRemediationActions(Consumer<PossibleRemediationActions.Builder> possibleRemediationActions) {
            return this.possibleRemediationActions((PossibleRemediationActions)((PossibleRemediationActions.Builder)PossibleRemediationActions.builder().applyMutation(possibleRemediationActions)).build());
        }
    }
}

