/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.fms.FmsAsyncClient;
import software.amazon.awssdk.services.fms.model.ListComplianceStatusRequest;
import software.amazon.awssdk.services.fms.model.ListComplianceStatusResponse;
import software.amazon.awssdk.services.fms.model.PolicyComplianceStatus;

public class ListComplianceStatusPublisher
implements SdkPublisher<ListComplianceStatusResponse> {
    private final FmsAsyncClient client;
    private final ListComplianceStatusRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListComplianceStatusPublisher(FmsAsyncClient client, ListComplianceStatusRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListComplianceStatusPublisher(FmsAsyncClient client, ListComplianceStatusRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListComplianceStatusResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListComplianceStatusResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PolicyComplianceStatus> policyComplianceStatusList() {
        Function<ListComplianceStatusResponse, Iterator> getIterator = response -> {
            if (response != null && response.policyComplianceStatusList() != null) {
                return response.policyComplianceStatusList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListComplianceStatusResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListComplianceStatusResponseFetcher
    implements AsyncPageFetcher<ListComplianceStatusResponse> {
        private ListComplianceStatusResponseFetcher() {
        }

        public boolean hasNextPage(ListComplianceStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListComplianceStatusResponse> nextPage(ListComplianceStatusResponse previousPage) {
            if (previousPage == null) {
                return ListComplianceStatusPublisher.this.client.listComplianceStatus(ListComplianceStatusPublisher.this.firstRequest);
            }
            return ListComplianceStatusPublisher.this.client.listComplianceStatus((ListComplianceStatusRequest)((Object)ListComplianceStatusPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

