/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fms.model.AwsEc2InstanceViolation;
import software.amazon.awssdk.services.fms.model.AwsEc2NetworkInterfaceViolation;
import software.amazon.awssdk.services.fms.model.AwsVPCSecurityGroupViolation;
import software.amazon.awssdk.services.fms.model.NetworkFirewallMissingExpectedRTViolation;
import software.amazon.awssdk.services.fms.model.NetworkFirewallMissingFirewallViolation;
import software.amazon.awssdk.services.fms.model.NetworkFirewallMissingSubnetViolation;
import software.amazon.awssdk.services.fms.model.NetworkFirewallPolicyModifiedViolation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceViolation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceViolation> {
    private static final SdkField<AwsVPCSecurityGroupViolation> AWS_VPC_SECURITY_GROUP_VIOLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AwsVPCSecurityGroupViolation").getter(ResourceViolation.getter(ResourceViolation::awsVPCSecurityGroupViolation)).setter(ResourceViolation.setter(Builder::awsVPCSecurityGroupViolation)).constructor(AwsVPCSecurityGroupViolation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsVPCSecurityGroupViolation").build()}).build();
    private static final SdkField<AwsEc2NetworkInterfaceViolation> AWS_EC2_NETWORK_INTERFACE_VIOLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AwsEc2NetworkInterfaceViolation").getter(ResourceViolation.getter(ResourceViolation::awsEc2NetworkInterfaceViolation)).setter(ResourceViolation.setter(Builder::awsEc2NetworkInterfaceViolation)).constructor(AwsEc2NetworkInterfaceViolation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsEc2NetworkInterfaceViolation").build()}).build();
    private static final SdkField<AwsEc2InstanceViolation> AWS_EC2_INSTANCE_VIOLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AwsEc2InstanceViolation").getter(ResourceViolation.getter(ResourceViolation::awsEc2InstanceViolation)).setter(ResourceViolation.setter(Builder::awsEc2InstanceViolation)).constructor(AwsEc2InstanceViolation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsEc2InstanceViolation").build()}).build();
    private static final SdkField<NetworkFirewallMissingFirewallViolation> NETWORK_FIREWALL_MISSING_FIREWALL_VIOLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkFirewallMissingFirewallViolation").getter(ResourceViolation.getter(ResourceViolation::networkFirewallMissingFirewallViolation)).setter(ResourceViolation.setter(Builder::networkFirewallMissingFirewallViolation)).constructor(NetworkFirewallMissingFirewallViolation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkFirewallMissingFirewallViolation").build()}).build();
    private static final SdkField<NetworkFirewallMissingSubnetViolation> NETWORK_FIREWALL_MISSING_SUBNET_VIOLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkFirewallMissingSubnetViolation").getter(ResourceViolation.getter(ResourceViolation::networkFirewallMissingSubnetViolation)).setter(ResourceViolation.setter(Builder::networkFirewallMissingSubnetViolation)).constructor(NetworkFirewallMissingSubnetViolation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkFirewallMissingSubnetViolation").build()}).build();
    private static final SdkField<NetworkFirewallMissingExpectedRTViolation> NETWORK_FIREWALL_MISSING_EXPECTED_RT_VIOLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkFirewallMissingExpectedRTViolation").getter(ResourceViolation.getter(ResourceViolation::networkFirewallMissingExpectedRTViolation)).setter(ResourceViolation.setter(Builder::networkFirewallMissingExpectedRTViolation)).constructor(NetworkFirewallMissingExpectedRTViolation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkFirewallMissingExpectedRTViolation").build()}).build();
    private static final SdkField<NetworkFirewallPolicyModifiedViolation> NETWORK_FIREWALL_POLICY_MODIFIED_VIOLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkFirewallPolicyModifiedViolation").getter(ResourceViolation.getter(ResourceViolation::networkFirewallPolicyModifiedViolation)).setter(ResourceViolation.setter(Builder::networkFirewallPolicyModifiedViolation)).constructor(NetworkFirewallPolicyModifiedViolation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkFirewallPolicyModifiedViolation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_VPC_SECURITY_GROUP_VIOLATION_FIELD, AWS_EC2_NETWORK_INTERFACE_VIOLATION_FIELD, AWS_EC2_INSTANCE_VIOLATION_FIELD, NETWORK_FIREWALL_MISSING_FIREWALL_VIOLATION_FIELD, NETWORK_FIREWALL_MISSING_SUBNET_VIOLATION_FIELD, NETWORK_FIREWALL_MISSING_EXPECTED_RT_VIOLATION_FIELD, NETWORK_FIREWALL_POLICY_MODIFIED_VIOLATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final AwsVPCSecurityGroupViolation awsVPCSecurityGroupViolation;
    private final AwsEc2NetworkInterfaceViolation awsEc2NetworkInterfaceViolation;
    private final AwsEc2InstanceViolation awsEc2InstanceViolation;
    private final NetworkFirewallMissingFirewallViolation networkFirewallMissingFirewallViolation;
    private final NetworkFirewallMissingSubnetViolation networkFirewallMissingSubnetViolation;
    private final NetworkFirewallMissingExpectedRTViolation networkFirewallMissingExpectedRTViolation;
    private final NetworkFirewallPolicyModifiedViolation networkFirewallPolicyModifiedViolation;

    private ResourceViolation(BuilderImpl builder) {
        this.awsVPCSecurityGroupViolation = builder.awsVPCSecurityGroupViolation;
        this.awsEc2NetworkInterfaceViolation = builder.awsEc2NetworkInterfaceViolation;
        this.awsEc2InstanceViolation = builder.awsEc2InstanceViolation;
        this.networkFirewallMissingFirewallViolation = builder.networkFirewallMissingFirewallViolation;
        this.networkFirewallMissingSubnetViolation = builder.networkFirewallMissingSubnetViolation;
        this.networkFirewallMissingExpectedRTViolation = builder.networkFirewallMissingExpectedRTViolation;
        this.networkFirewallPolicyModifiedViolation = builder.networkFirewallPolicyModifiedViolation;
    }

    public AwsVPCSecurityGroupViolation awsVPCSecurityGroupViolation() {
        return this.awsVPCSecurityGroupViolation;
    }

    public AwsEc2NetworkInterfaceViolation awsEc2NetworkInterfaceViolation() {
        return this.awsEc2NetworkInterfaceViolation;
    }

    public AwsEc2InstanceViolation awsEc2InstanceViolation() {
        return this.awsEc2InstanceViolation;
    }

    public NetworkFirewallMissingFirewallViolation networkFirewallMissingFirewallViolation() {
        return this.networkFirewallMissingFirewallViolation;
    }

    public NetworkFirewallMissingSubnetViolation networkFirewallMissingSubnetViolation() {
        return this.networkFirewallMissingSubnetViolation;
    }

    public NetworkFirewallMissingExpectedRTViolation networkFirewallMissingExpectedRTViolation() {
        return this.networkFirewallMissingExpectedRTViolation;
    }

    public NetworkFirewallPolicyModifiedViolation networkFirewallPolicyModifiedViolation() {
        return this.networkFirewallPolicyModifiedViolation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.awsVPCSecurityGroupViolation());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsEc2NetworkInterfaceViolation());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsEc2InstanceViolation());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkFirewallMissingFirewallViolation());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkFirewallMissingSubnetViolation());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkFirewallMissingExpectedRTViolation());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkFirewallPolicyModifiedViolation());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceViolation)) {
            return false;
        }
        ResourceViolation other = (ResourceViolation)obj;
        return Objects.equals(this.awsVPCSecurityGroupViolation(), other.awsVPCSecurityGroupViolation()) && Objects.equals(this.awsEc2NetworkInterfaceViolation(), other.awsEc2NetworkInterfaceViolation()) && Objects.equals(this.awsEc2InstanceViolation(), other.awsEc2InstanceViolation()) && Objects.equals(this.networkFirewallMissingFirewallViolation(), other.networkFirewallMissingFirewallViolation()) && Objects.equals(this.networkFirewallMissingSubnetViolation(), other.networkFirewallMissingSubnetViolation()) && Objects.equals(this.networkFirewallMissingExpectedRTViolation(), other.networkFirewallMissingExpectedRTViolation()) && Objects.equals(this.networkFirewallPolicyModifiedViolation(), other.networkFirewallPolicyModifiedViolation());
    }

    public String toString() {
        return ToString.builder((String)"ResourceViolation").add("AwsVPCSecurityGroupViolation", (Object)this.awsVPCSecurityGroupViolation()).add("AwsEc2NetworkInterfaceViolation", (Object)this.awsEc2NetworkInterfaceViolation()).add("AwsEc2InstanceViolation", (Object)this.awsEc2InstanceViolation()).add("NetworkFirewallMissingFirewallViolation", (Object)this.networkFirewallMissingFirewallViolation()).add("NetworkFirewallMissingSubnetViolation", (Object)this.networkFirewallMissingSubnetViolation()).add("NetworkFirewallMissingExpectedRTViolation", (Object)this.networkFirewallMissingExpectedRTViolation()).add("NetworkFirewallPolicyModifiedViolation", (Object)this.networkFirewallPolicyModifiedViolation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsVPCSecurityGroupViolation": {
                return Optional.ofNullable(clazz.cast(this.awsVPCSecurityGroupViolation()));
            }
            case "AwsEc2NetworkInterfaceViolation": {
                return Optional.ofNullable(clazz.cast(this.awsEc2NetworkInterfaceViolation()));
            }
            case "AwsEc2InstanceViolation": {
                return Optional.ofNullable(clazz.cast(this.awsEc2InstanceViolation()));
            }
            case "NetworkFirewallMissingFirewallViolation": {
                return Optional.ofNullable(clazz.cast(this.networkFirewallMissingFirewallViolation()));
            }
            case "NetworkFirewallMissingSubnetViolation": {
                return Optional.ofNullable(clazz.cast(this.networkFirewallMissingSubnetViolation()));
            }
            case "NetworkFirewallMissingExpectedRTViolation": {
                return Optional.ofNullable(clazz.cast(this.networkFirewallMissingExpectedRTViolation()));
            }
            case "NetworkFirewallPolicyModifiedViolation": {
                return Optional.ofNullable(clazz.cast(this.networkFirewallPolicyModifiedViolation()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceViolation, T> g) {
        return obj -> g.apply((ResourceViolation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AwsVPCSecurityGroupViolation awsVPCSecurityGroupViolation;
        private AwsEc2NetworkInterfaceViolation awsEc2NetworkInterfaceViolation;
        private AwsEc2InstanceViolation awsEc2InstanceViolation;
        private NetworkFirewallMissingFirewallViolation networkFirewallMissingFirewallViolation;
        private NetworkFirewallMissingSubnetViolation networkFirewallMissingSubnetViolation;
        private NetworkFirewallMissingExpectedRTViolation networkFirewallMissingExpectedRTViolation;
        private NetworkFirewallPolicyModifiedViolation networkFirewallPolicyModifiedViolation;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceViolation model) {
            this.awsVPCSecurityGroupViolation(model.awsVPCSecurityGroupViolation);
            this.awsEc2NetworkInterfaceViolation(model.awsEc2NetworkInterfaceViolation);
            this.awsEc2InstanceViolation(model.awsEc2InstanceViolation);
            this.networkFirewallMissingFirewallViolation(model.networkFirewallMissingFirewallViolation);
            this.networkFirewallMissingSubnetViolation(model.networkFirewallMissingSubnetViolation);
            this.networkFirewallMissingExpectedRTViolation(model.networkFirewallMissingExpectedRTViolation);
            this.networkFirewallPolicyModifiedViolation(model.networkFirewallPolicyModifiedViolation);
        }

        public final AwsVPCSecurityGroupViolation.Builder getAwsVPCSecurityGroupViolation() {
            return this.awsVPCSecurityGroupViolation != null ? this.awsVPCSecurityGroupViolation.toBuilder() : null;
        }

        @Override
        public final Builder awsVPCSecurityGroupViolation(AwsVPCSecurityGroupViolation awsVPCSecurityGroupViolation) {
            this.awsVPCSecurityGroupViolation = awsVPCSecurityGroupViolation;
            return this;
        }

        public final void setAwsVPCSecurityGroupViolation(AwsVPCSecurityGroupViolation.BuilderImpl awsVPCSecurityGroupViolation) {
            this.awsVPCSecurityGroupViolation = awsVPCSecurityGroupViolation != null ? awsVPCSecurityGroupViolation.build() : null;
        }

        public final AwsEc2NetworkInterfaceViolation.Builder getAwsEc2NetworkInterfaceViolation() {
            return this.awsEc2NetworkInterfaceViolation != null ? this.awsEc2NetworkInterfaceViolation.toBuilder() : null;
        }

        @Override
        public final Builder awsEc2NetworkInterfaceViolation(AwsEc2NetworkInterfaceViolation awsEc2NetworkInterfaceViolation) {
            this.awsEc2NetworkInterfaceViolation = awsEc2NetworkInterfaceViolation;
            return this;
        }

        public final void setAwsEc2NetworkInterfaceViolation(AwsEc2NetworkInterfaceViolation.BuilderImpl awsEc2NetworkInterfaceViolation) {
            this.awsEc2NetworkInterfaceViolation = awsEc2NetworkInterfaceViolation != null ? awsEc2NetworkInterfaceViolation.build() : null;
        }

        public final AwsEc2InstanceViolation.Builder getAwsEc2InstanceViolation() {
            return this.awsEc2InstanceViolation != null ? this.awsEc2InstanceViolation.toBuilder() : null;
        }

        @Override
        public final Builder awsEc2InstanceViolation(AwsEc2InstanceViolation awsEc2InstanceViolation) {
            this.awsEc2InstanceViolation = awsEc2InstanceViolation;
            return this;
        }

        public final void setAwsEc2InstanceViolation(AwsEc2InstanceViolation.BuilderImpl awsEc2InstanceViolation) {
            this.awsEc2InstanceViolation = awsEc2InstanceViolation != null ? awsEc2InstanceViolation.build() : null;
        }

        public final NetworkFirewallMissingFirewallViolation.Builder getNetworkFirewallMissingFirewallViolation() {
            return this.networkFirewallMissingFirewallViolation != null ? this.networkFirewallMissingFirewallViolation.toBuilder() : null;
        }

        @Override
        public final Builder networkFirewallMissingFirewallViolation(NetworkFirewallMissingFirewallViolation networkFirewallMissingFirewallViolation) {
            this.networkFirewallMissingFirewallViolation = networkFirewallMissingFirewallViolation;
            return this;
        }

        public final void setNetworkFirewallMissingFirewallViolation(NetworkFirewallMissingFirewallViolation.BuilderImpl networkFirewallMissingFirewallViolation) {
            this.networkFirewallMissingFirewallViolation = networkFirewallMissingFirewallViolation != null ? networkFirewallMissingFirewallViolation.build() : null;
        }

        public final NetworkFirewallMissingSubnetViolation.Builder getNetworkFirewallMissingSubnetViolation() {
            return this.networkFirewallMissingSubnetViolation != null ? this.networkFirewallMissingSubnetViolation.toBuilder() : null;
        }

        @Override
        public final Builder networkFirewallMissingSubnetViolation(NetworkFirewallMissingSubnetViolation networkFirewallMissingSubnetViolation) {
            this.networkFirewallMissingSubnetViolation = networkFirewallMissingSubnetViolation;
            return this;
        }

        public final void setNetworkFirewallMissingSubnetViolation(NetworkFirewallMissingSubnetViolation.BuilderImpl networkFirewallMissingSubnetViolation) {
            this.networkFirewallMissingSubnetViolation = networkFirewallMissingSubnetViolation != null ? networkFirewallMissingSubnetViolation.build() : null;
        }

        public final NetworkFirewallMissingExpectedRTViolation.Builder getNetworkFirewallMissingExpectedRTViolation() {
            return this.networkFirewallMissingExpectedRTViolation != null ? this.networkFirewallMissingExpectedRTViolation.toBuilder() : null;
        }

        @Override
        public final Builder networkFirewallMissingExpectedRTViolation(NetworkFirewallMissingExpectedRTViolation networkFirewallMissingExpectedRTViolation) {
            this.networkFirewallMissingExpectedRTViolation = networkFirewallMissingExpectedRTViolation;
            return this;
        }

        public final void setNetworkFirewallMissingExpectedRTViolation(NetworkFirewallMissingExpectedRTViolation.BuilderImpl networkFirewallMissingExpectedRTViolation) {
            this.networkFirewallMissingExpectedRTViolation = networkFirewallMissingExpectedRTViolation != null ? networkFirewallMissingExpectedRTViolation.build() : null;
        }

        public final NetworkFirewallPolicyModifiedViolation.Builder getNetworkFirewallPolicyModifiedViolation() {
            return this.networkFirewallPolicyModifiedViolation != null ? this.networkFirewallPolicyModifiedViolation.toBuilder() : null;
        }

        @Override
        public final Builder networkFirewallPolicyModifiedViolation(NetworkFirewallPolicyModifiedViolation networkFirewallPolicyModifiedViolation) {
            this.networkFirewallPolicyModifiedViolation = networkFirewallPolicyModifiedViolation;
            return this;
        }

        public final void setNetworkFirewallPolicyModifiedViolation(NetworkFirewallPolicyModifiedViolation.BuilderImpl networkFirewallPolicyModifiedViolation) {
            this.networkFirewallPolicyModifiedViolation = networkFirewallPolicyModifiedViolation != null ? networkFirewallPolicyModifiedViolation.build() : null;
        }

        public ResourceViolation build() {
            return new ResourceViolation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceViolation> {
        public Builder awsVPCSecurityGroupViolation(AwsVPCSecurityGroupViolation var1);

        default public Builder awsVPCSecurityGroupViolation(Consumer<AwsVPCSecurityGroupViolation.Builder> awsVPCSecurityGroupViolation) {
            return this.awsVPCSecurityGroupViolation((AwsVPCSecurityGroupViolation)((AwsVPCSecurityGroupViolation.Builder)AwsVPCSecurityGroupViolation.builder().applyMutation(awsVPCSecurityGroupViolation)).build());
        }

        public Builder awsEc2NetworkInterfaceViolation(AwsEc2NetworkInterfaceViolation var1);

        default public Builder awsEc2NetworkInterfaceViolation(Consumer<AwsEc2NetworkInterfaceViolation.Builder> awsEc2NetworkInterfaceViolation) {
            return this.awsEc2NetworkInterfaceViolation((AwsEc2NetworkInterfaceViolation)((AwsEc2NetworkInterfaceViolation.Builder)AwsEc2NetworkInterfaceViolation.builder().applyMutation(awsEc2NetworkInterfaceViolation)).build());
        }

        public Builder awsEc2InstanceViolation(AwsEc2InstanceViolation var1);

        default public Builder awsEc2InstanceViolation(Consumer<AwsEc2InstanceViolation.Builder> awsEc2InstanceViolation) {
            return this.awsEc2InstanceViolation((AwsEc2InstanceViolation)((AwsEc2InstanceViolation.Builder)AwsEc2InstanceViolation.builder().applyMutation(awsEc2InstanceViolation)).build());
        }

        public Builder networkFirewallMissingFirewallViolation(NetworkFirewallMissingFirewallViolation var1);

        default public Builder networkFirewallMissingFirewallViolation(Consumer<NetworkFirewallMissingFirewallViolation.Builder> networkFirewallMissingFirewallViolation) {
            return this.networkFirewallMissingFirewallViolation((NetworkFirewallMissingFirewallViolation)((NetworkFirewallMissingFirewallViolation.Builder)NetworkFirewallMissingFirewallViolation.builder().applyMutation(networkFirewallMissingFirewallViolation)).build());
        }

        public Builder networkFirewallMissingSubnetViolation(NetworkFirewallMissingSubnetViolation var1);

        default public Builder networkFirewallMissingSubnetViolation(Consumer<NetworkFirewallMissingSubnetViolation.Builder> networkFirewallMissingSubnetViolation) {
            return this.networkFirewallMissingSubnetViolation((NetworkFirewallMissingSubnetViolation)((NetworkFirewallMissingSubnetViolation.Builder)NetworkFirewallMissingSubnetViolation.builder().applyMutation(networkFirewallMissingSubnetViolation)).build());
        }

        public Builder networkFirewallMissingExpectedRTViolation(NetworkFirewallMissingExpectedRTViolation var1);

        default public Builder networkFirewallMissingExpectedRTViolation(Consumer<NetworkFirewallMissingExpectedRTViolation.Builder> networkFirewallMissingExpectedRTViolation) {
            return this.networkFirewallMissingExpectedRTViolation((NetworkFirewallMissingExpectedRTViolation)((NetworkFirewallMissingExpectedRTViolation.Builder)NetworkFirewallMissingExpectedRTViolation.builder().applyMutation(networkFirewallMissingExpectedRTViolation)).build());
        }

        public Builder networkFirewallPolicyModifiedViolation(NetworkFirewallPolicyModifiedViolation var1);

        default public Builder networkFirewallPolicyModifiedViolation(Consumer<NetworkFirewallPolicyModifiedViolation.Builder> networkFirewallPolicyModifiedViolation) {
            return this.networkFirewallPolicyModifiedViolation((NetworkFirewallPolicyModifiedViolation)((NetworkFirewallPolicyModifiedViolation.Builder)NetworkFirewallPolicyModifiedViolation.builder().applyMutation(networkFirewallPolicyModifiedViolation)).build());
        }
    }
}

