/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fms.model.FmsResponse;
import software.amazon.awssdk.services.fms.model.MemberAccountsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMemberAccountsResponse
extends FmsResponse
implements ToCopyableBuilder<Builder, ListMemberAccountsResponse> {
    private static final SdkField<List<String>> MEMBER_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MemberAccounts").getter(ListMemberAccountsResponse.getter(ListMemberAccountsResponse::memberAccounts)).setter(ListMemberAccountsResponse.setter(Builder::memberAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberAccounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListMemberAccountsResponse.getter(ListMemberAccountsResponse::nextToken)).setter(ListMemberAccountsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBER_ACCOUNTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> memberAccounts;
    private final String nextToken;

    private ListMemberAccountsResponse(BuilderImpl builder) {
        super(builder);
        this.memberAccounts = builder.memberAccounts;
        this.nextToken = builder.nextToken;
    }

    public boolean hasMemberAccounts() {
        return this.memberAccounts != null && !(this.memberAccounts instanceof SdkAutoConstructList);
    }

    public List<String> memberAccounts() {
        return this.memberAccounts;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMemberAccounts() ? this.memberAccounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMemberAccountsResponse)) {
            return false;
        }
        ListMemberAccountsResponse other = (ListMemberAccountsResponse)((Object)obj);
        return this.hasMemberAccounts() == other.hasMemberAccounts() && Objects.equals(this.memberAccounts(), other.memberAccounts()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListMemberAccountsResponse").add("MemberAccounts", this.hasMemberAccounts() ? this.memberAccounts() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MemberAccounts": {
                return Optional.ofNullable(clazz.cast(this.memberAccounts()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMemberAccountsResponse, T> g) {
        return obj -> g.apply((ListMemberAccountsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FmsResponse.BuilderImpl
    implements Builder {
        private List<String> memberAccounts = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMemberAccountsResponse model) {
            super(model);
            this.memberAccounts(model.memberAccounts);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getMemberAccounts() {
            if (this.memberAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.memberAccounts;
        }

        @Override
        public final Builder memberAccounts(Collection<String> memberAccounts) {
            this.memberAccounts = MemberAccountsCopier.copy(memberAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberAccounts(String ... memberAccounts) {
            this.memberAccounts(Arrays.asList(memberAccounts));
            return this;
        }

        public final void setMemberAccounts(Collection<String> memberAccounts) {
            this.memberAccounts = MemberAccountsCopier.copy(memberAccounts);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListMemberAccountsResponse build() {
            return new ListMemberAccountsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FmsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMemberAccountsResponse> {
        public Builder memberAccounts(Collection<String> var1);

        public Builder memberAccounts(String ... var1);

        public Builder nextToken(String var1);
    }
}

