/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.fms.model.AssociateAdminAccountRequest;
import software.amazon.awssdk.services.fms.model.AssociateAdminAccountResponse;
import software.amazon.awssdk.services.fms.model.DeleteNotificationChannelRequest;
import software.amazon.awssdk.services.fms.model.DeleteNotificationChannelResponse;
import software.amazon.awssdk.services.fms.model.DeletePolicyRequest;
import software.amazon.awssdk.services.fms.model.DeletePolicyResponse;
import software.amazon.awssdk.services.fms.model.DisassociateAdminAccountRequest;
import software.amazon.awssdk.services.fms.model.DisassociateAdminAccountResponse;
import software.amazon.awssdk.services.fms.model.FmsException;
import software.amazon.awssdk.services.fms.model.GetAdminAccountRequest;
import software.amazon.awssdk.services.fms.model.GetAdminAccountResponse;
import software.amazon.awssdk.services.fms.model.GetComplianceDetailRequest;
import software.amazon.awssdk.services.fms.model.GetComplianceDetailResponse;
import software.amazon.awssdk.services.fms.model.GetNotificationChannelRequest;
import software.amazon.awssdk.services.fms.model.GetNotificationChannelResponse;
import software.amazon.awssdk.services.fms.model.GetPolicyRequest;
import software.amazon.awssdk.services.fms.model.GetPolicyResponse;
import software.amazon.awssdk.services.fms.model.GetProtectionStatusRequest;
import software.amazon.awssdk.services.fms.model.GetProtectionStatusResponse;
import software.amazon.awssdk.services.fms.model.InternalErrorException;
import software.amazon.awssdk.services.fms.model.InvalidInputException;
import software.amazon.awssdk.services.fms.model.InvalidOperationException;
import software.amazon.awssdk.services.fms.model.InvalidTypeException;
import software.amazon.awssdk.services.fms.model.LimitExceededException;
import software.amazon.awssdk.services.fms.model.ListComplianceStatusRequest;
import software.amazon.awssdk.services.fms.model.ListComplianceStatusResponse;
import software.amazon.awssdk.services.fms.model.ListMemberAccountsRequest;
import software.amazon.awssdk.services.fms.model.ListMemberAccountsResponse;
import software.amazon.awssdk.services.fms.model.ListPoliciesRequest;
import software.amazon.awssdk.services.fms.model.ListPoliciesResponse;
import software.amazon.awssdk.services.fms.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.fms.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.fms.model.PutNotificationChannelRequest;
import software.amazon.awssdk.services.fms.model.PutNotificationChannelResponse;
import software.amazon.awssdk.services.fms.model.PutPolicyRequest;
import software.amazon.awssdk.services.fms.model.PutPolicyResponse;
import software.amazon.awssdk.services.fms.model.ResourceNotFoundException;
import software.amazon.awssdk.services.fms.model.TagResourceRequest;
import software.amazon.awssdk.services.fms.model.TagResourceResponse;
import software.amazon.awssdk.services.fms.model.UntagResourceRequest;
import software.amazon.awssdk.services.fms.model.UntagResourceResponse;
import software.amazon.awssdk.services.fms.paginators.ListComplianceStatusIterable;
import software.amazon.awssdk.services.fms.paginators.ListMemberAccountsIterable;
import software.amazon.awssdk.services.fms.paginators.ListPoliciesIterable;

/**
 * Service client for accessing FMS. This can be created using the static {@link #builder()} method.
 *
 * <fullname>AWS Firewall Manager</fullname>
 * <p>
 * This is the <i>AWS Firewall Manager API Reference</i>. This guide is for developers who need detailed information
 * about the AWS Firewall Manager API actions, data types, and errors. For detailed information about AWS Firewall
 * Manager features, see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-chapter.html">AWS
 * Firewall Manager Developer Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface FmsClient extends SdkClient {
    String SERVICE_NAME = "fms";

    /**
     * Create a {@link FmsClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static FmsClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link FmsClient}.
     */
    static FmsClientBuilder builder() {
        return new DefaultFmsClientBuilder();
    }

    /**
     * <p>
     * Sets the AWS Firewall Manager administrator account. AWS Firewall Manager must be associated with the master
     * account of your AWS organization or associated with a member account that has the appropriate permissions. If the
     * account ID that you submit is not an AWS Organizations master account, AWS Firewall Manager will set the
     * appropriate permissions for the given member account.
     * </p>
     * <p>
     * The account that you associate with AWS Firewall Manager is called the AWS Firewall Manager administrator
     * account.
     * </p>
     *
     * @param associateAdminAccountRequest
     * @return Result of the AssociateAdminAccount operation returned by the service.
     * @throws InvalidOperationException
     *         The operation failed because there was nothing to do. For example, you might have submitted an
     *         <code>AssociateAdminAccount</code> request, but the account ID that you submitted was already set as the
     *         AWS Firewall Manager administrator.
     * @throws InvalidInputException
     *         The parameters of the request were invalid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalErrorException
     *         The operation failed because of a system problem, even though the request was valid. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FmsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FmsClient.AssociateAdminAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/AssociateAdminAccount" target="_top">AWS API
     *      Documentation</a>
     */
    default AssociateAdminAccountResponse associateAdminAccount(AssociateAdminAccountRequest associateAdminAccountRequest)
            throws InvalidOperationException, InvalidInputException, ResourceNotFoundException, InternalErrorException,
            AwsServiceException, SdkClientException, FmsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the AWS Firewall Manager administrator account. AWS Firewall Manager must be associated with the master
     * account of your AWS organization or associated with a member account that has the appropriate permissions. If the
     * account ID that you submit is not an AWS Organizations master account, AWS Firewall Manager will set the
     * appropriate permissions for the given member account.
     * </p>
     * <p>
     * The account that you associate with AWS Firewall Manager is called the AWS Firewall Manager administrator
     * account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateAdminAccountRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateAdminAccountRequest#builder()}
     * </p>
     *
     * @param associateAdminAccountRequest
     *        A {@link Consumer} that will call methods on {@link AssociateAdminAccountRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateAdminAccount operation returned by the service.
     * @throws InvalidOperationException
     *         The operation failed because there was nothing to do. For example, you might have submitted an
     *         <code>AssociateAdminAccount</code> request, but the account ID that you submitted was already set as the
     *         AWS Firewall Manager administrator.
     * @throws InvalidInputException
     *         The parameters of the request were invalid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalErrorException
     *         The operation failed because of a system problem, even though the request was valid. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FmsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FmsClient.AssociateAdminAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/AssociateAdminAccount" target="_top">AWS API
     *      Documentation</a>
     */
    default AssociateAdminAccountResponse associateAdminAccount(
            Consumer<AssociateAdminAccountRequest.Builder> associateAdminAccountRequest) throws InvalidOperationException,
            InvalidInputException, ResourceNotFoundException, InternalErrorException, AwsServiceException, SdkClientException,
            FmsException {
        return associateAdminAccount(AssociateAdminAccountRequest.builder().applyMutation(associateAdminAccountRequest).build());
    }

    /**
     * <p>
     * Deletes an AWS Firewall Manager association with the IAM role and the Amazon Simple Notification Service (SNS)
     * topic that is used to record AWS Firewall Manager SNS logs.
     * </p>
     *
     * @param deleteNotificationChannelRequest
     * @return Result of the DeleteNotificationChannel operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidOperationException
     *         The operation failed because there was nothing to do. For example, you might have submitted an
     *         <code>AssociateAdminAccount</code> request, but the account ID that you submitted was already set as the
     *         AWS Firewall Manager administrator.
     * @throws InternalErrorException
     *         The operation failed because of a system problem, even though the request was valid. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FmsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FmsClient.DeleteNotificationChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/DeleteNotificationChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteNotificationChannelResponse deleteNotificationChannel(
            DeleteNotificationChannelRequest deleteNotificationChannelRequest) throws ResourceNotFoundException,
            InvalidOperationException, InternalErrorException, AwsServiceException, SdkClientException, FmsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an AWS Firewall Manager association with the IAM role and the Amazon Simple Notification Service (SNS)
     * topic that is used to record AWS Firewall Manager SNS logs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNotificationChannelRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteNotificationChannelRequest#builder()}
     * </p>
     *
     * @param deleteNotificationChannelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteNotificationChannelRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteNotificationChannel operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidOperationException
     *         The operation failed because there was nothing to do. For example, you might have submitted an
     *         <code>AssociateAdminAccount</code> request, but the account ID that you submitted was already set as the
     *         AWS Firewall Manager administrator.
     * @throws InternalErrorException
     *         The operation failed because of a system problem, even though the request was valid. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FmsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FmsClient.DeleteNotificationChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/DeleteNotificationChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteNotificationChannelResponse deleteNotificationChannel(
            Consumer<DeleteNotificationChannelRequest.Builder> deleteNotificationChannelRequest)
            throws ResourceNotFoundException, InvalidOperationException, InternalErrorException, AwsServiceException,
            SdkClientException, FmsException {
        return deleteNotificationChannel(DeleteNotificationChannelRequest.builder()
                .applyMutation(deleteNotificationChannelRequest).build());
    }

    /**
     * <p>
     * Permanently deletes an AWS Firewall Manager policy.
     * </p>
     *
     * @param deletePolicyRequest
     * @return Result of the DeletePolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidOperationException
     *         The operation failed because there was nothing to do. For example, you might have submitted an
     *         <code>AssociateAdminAccount</code> request, but the account ID that you submitted was already set as the
     *         AWS Firewall Manager administrator.
     * @throws InternalErrorException
     *         The operation failed because of a system problem, even though the request was valid. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FmsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FmsClient.DeletePolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/DeletePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePolicyResponse deletePolicy(DeletePolicyRequest deletePolicyRequest) throws ResourceNotFoundException,
            InvalidOperationException, InternalErrorException, AwsServiceException, SdkClientException, FmsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Permanently deletes an AWS Firewall Manager policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePolicyRequest.Builder} avoiding the need to
     * create one manually via {@link DeletePolicyRequest#builder()}
     * </p>
     *
     * @param deletePolicyRequest
     *        A {@link Consumer} that will call methods on {@link DeletePolicyRequest.Builder} to create a request.
     * @return Result of the DeletePolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidOperationException
     *         The operation failed because there was nothing to do. For example, you might have submitted an
     *         <code>AssociateAdminAccount</code> request, but the account ID that you submitted was already set as the
     *         AWS Firewall Manager administrator.
     * @throws InternalErrorException
     *         The operation failed because of a system problem, even though the request was valid. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FmsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FmsClient.DeletePolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/DeletePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePolicyResponse deletePolicy(Consumer<DeletePolicyRequest.Builder> deletePolicyRequest)
            throws ResourceNotFoundException, InvalidOperationException, InternalErrorException, AwsServiceException,
            SdkClientException, FmsException {
        return deletePolicy(DeletePolicyRequest.builder().applyMutation(deletePolicyRequest).build());
    }

    /**
     * <p>
     * Disassociates the account that has been set as the AWS Firewall Manager administrator account. To set a different
     * account as the administrator account, you must submit an <code>AssociateAdminAccount</code> request.
     * </p>
     *
     * @param disassociateAdminAccountRequest
     * @return Result of the DisassociateAdminAccount operation returned by the service.
     * @throws InvalidOperationException
     *         The operation failed because there was nothing to do. For example, you might have submitted an
     *         <code>AssociateAdminAccount</code> request, but the account ID that you submitted was already set as the
     *         AWS Firewall Manager administrator.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalErrorException
     *         The operation failed because of a system problem, even though the request was valid. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FmsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FmsClient.DisassociateAdminAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/DisassociateAdminAccount" target="_top">AWS
     *      API Documentation</a>
     */
    default DisassociateAdminAccountResponse disassociateAdminAccount(
            DisassociateAdminAccountRequest disassociateAdminAccountRequest) throws InvalidOperationException,
            ResourceNotFoundException, InternalErrorException, AwsServiceException, SdkClientException, FmsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the account that has been set as the AWS Firewall Manager administrator account. To set a different
     * account as the administrator account, you must submit an <code>AssociateAdminAccount</code> request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateAdminAccountRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateAdminAccountRequest#builder()}
     * </p>
     *
     * @param disassociateAdminAccountRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateAdminAccountRequest.Builder} to create a
     *        request.
     * @return Result of the DisassociateAdminAccount operation returned by the service.
     * @throws InvalidOperationException
     *         The operation failed because there was nothing to do. For example, you might have submitted an
     *         <code>AssociateAdminAccount</code> request, but the account ID that you submitted was already set as the
     *         AWS Firewall Manager administrator.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalErrorException
     *         The operation failed because of a system problem, even though the request was valid. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FmsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FmsClient.DisassociateAdminAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/DisassociateAdminAccount" target="_top">AWS
     *      API Documentation</a>
     */
    default DisassociateAdminAccountResponse disassociateAdminAccount(
            Consumer<DisassociateAdminAccountRequest.Builder> disassociateAdminAccountRequest) throws InvalidOperationException,
            ResourceNotFoundException, InternalErrorException, AwsServiceException, SdkClientException, FmsException {
        return disassociateAdminAccount(DisassociateAdminAccountRequest.builder().applyMutation(disassociateAdminAccountRequest)
                .build());
    }

    /**
     * <p>
     * Returns the AWS Organizations master account that is associated with AWS Firewall Manager as the AWS Firewall
     * Manager administrator.
     * </p>
     *
     * @param getAdminAccountRequest
     * @return Result of the GetAdminAccount operation returned by the service.
     * @throws InvalidOperationException
     *         The operation failed because there was nothing to do. For example, you might have submitted an
     *         <code>AssociateAdminAccount</code> request, but the account ID that you submitted was already set as the
     *         AWS Firewall Manager administrator.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalErrorException
     *         The operation failed because of a system problem, even though the request was valid. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FmsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FmsClient.GetAdminAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetAdminAccount" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAdminAccountResponse getAdminAccount(GetAdminAccountRequest getAdminAccountRequest)
            throws InvalidOperationException, ResourceNotFoundException, InternalErrorException, AwsServiceException,
            SdkClientException, FmsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the AWS Organizations master account that is associated with AWS Firewall Manager as the AWS Firewall
     * Manager administrator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAdminAccountRequest.Builder} avoiding the need
     * to create one manually via {@link GetAdminAccountRequest#builder()}
     * </p>
     *
     * @param getAdminAccountRequest
     *        A {@link Consumer} that will call methods on {@link GetAdminAccountRequest.Builder} to create a request.
     * @return Result of the GetAdminAccount operation returned by the service.
     * @throws InvalidOperationException
     *         The operation failed because there was nothing to do. For example, you might have submitted an
     *         <code>AssociateAdminAccount</code> request, but the account ID that you submitted was already set as the
     *         AWS Firewall Manager administrator.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalErrorException
     *         The operation failed because of a system problem, even though the request was valid. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FmsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FmsClient.GetAdminAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetAdminAccount" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAdminAccountResponse getAdminAccount(Consumer<GetAdminAccountRequest.Builder> getAdminAccountRequest)
            throws InvalidOperationException, ResourceNotFoundException, InternalErrorException, AwsServiceException,
            SdkClientException, FmsException {
        return getAdminAccount(GetAdminAccountRequest.builder().applyMutation(getAdminAccountRequest).build());
    }

    /**
     * <p>
     * Returns detailed compliance information about the specified member account. Details include resources that are in
     * and out of compliance with the specified policy. Resources are considered noncompliant for AWS WAF and Shield
     * Advanced policies if the specified policy has not been applied to them. Resources are considered noncompliant for
     * security group policies if they are in scope of the policy, they violate one or more of the policy rules, and
     * remediation is disabled or not possible.
     * </p>
     *
     * @param getComplianceDetailRequest
     * @return Result of the GetComplianceDetail operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalErrorException
     *         The operation failed because of a system problem, even though the request was valid. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FmsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FmsClient.GetComplianceDetail
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetComplianceDetail" target="_top">AWS API
     *      Documentation</a>
     */
    default GetComplianceDetailResponse getComplianceDetail(GetComplianceDetailRequest getComplianceDetailRequest)
            throws ResourceNotFoundException, InternalErrorException, AwsServiceException, SdkClientException, FmsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns detailed compliance information about the specified member account. Details include resources that are in
     * and out of compliance with the specified policy. Resources are considered noncompliant for AWS WAF and Shield
     * Advanced policies if the specified policy has not been applied to them. Resources are considered noncompliant for
     * security group policies if they are in scope of the policy, they violate one or more of the policy rules, and
     * remediation is disabled or not possible.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetComplianceDetailRequest.Builder} avoiding the
     * need to create one manually via {@link GetComplianceDetailRequest#builder()}
     * </p>
     *
     * @param getComplianceDetailRequest
     *        A {@link Consumer} that will call methods on {@link GetComplianceDetailRequest.Builder} to create a
     *        request.
     * @return Result of the GetComplianceDetail operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalErrorException
     *         The operation failed because of a system problem, even though the request was valid. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FmsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FmsClient.GetComplianceDetail
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetComplianceDetail" target="_top">AWS API
     *      Documentation</a>
     */
    default GetComplianceDetailResponse getComplianceDetail(
            Consumer<GetComplianceDetailRequest.Builder> getComplianceDetailRequest) throws ResourceNotFoundException,
            InternalErrorException, AwsServiceException, SdkClientException, FmsException {
        return getComplianceDetail(GetComplianceDetailRequest.builder().applyMutation(getComplianceDetailRequest).build());
    }

    /**
     * <p>
     * Information about the Amazon Simple Notification Service (SNS) topic that is used to record AWS Firewall Manager
     * SNS logs.
     * </p>
     *
     * @param getNotificationChannelRequest
     * @return Result of the GetNotificationChannel operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidOperationException
     *         The operation failed because there was nothing to do. For example, you might have submitted an
     *         <code>AssociateAdminAccount</code> request, but the account ID that you submitted was already set as the
     *         AWS Firewall Manager administrator.
     * @throws InternalErrorException
     *         The operation failed because of a system problem, even though the request was valid. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FmsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FmsClient.GetNotificationChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetNotificationChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default GetNotificationChannelResponse getNotificationChannel(GetNotificationChannelRequest getNotificationChannelRequest)
            throws ResourceNotFoundException, InvalidOperationException, InternalErrorException, AwsServiceException,
            SdkClientException, FmsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Information about the Amazon Simple Notification Service (SNS) topic that is used to record AWS Firewall Manager
     * SNS logs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNotificationChannelRequest.Builder} avoiding the
     * need to create one manually via {@link GetNotificationChannelRequest#builder()}
     * </p>
     *
     * @param getNotificationChannelRequest
     *        A {@link Consumer} that will call methods on {@link GetNotificationChannelRequest.Builder} to create a
     *        request.
     * @return Result of the GetNotificationChannel operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidOperationException
     *         The operation failed because there was nothing to do. For example, you might have submitted an
     *         <code>AssociateAdminAccount</code> request, but the account ID that you submitted was already set as the
     *         AWS Firewall Manager administrator.
     * @throws InternalErrorException
     *         The operation failed because of a system problem, even though the request was valid. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FmsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FmsClient.GetNotificationChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetNotificationChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default GetNotificationChannelResponse getNotificationChannel(
            Consumer<GetNotificationChannelRequest.Builder> getNotificationChannelRequest) throws ResourceNotFoundException,
            InvalidOperationException, InternalErrorException, AwsServiceException, SdkClientException, FmsException {
        return getNotificationChannel(GetNotificationChannelRequest.builder().applyMutation(getNotificationChannelRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about the specified AWS Firewall Manager policy.
     * </p>
     *
     * @param getPolicyRequest
     * @return Result of the GetPolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidOperationException
     *         The operation failed because there was nothing to do. For example, you might have submitted an
     *         <code>AssociateAdminAccount</code> request, but the account ID that you submitted was already set as the
     *         AWS Firewall Manager administrator.
     * @throws InternalErrorException
     *         The operation failed because of a system problem, even though the request was valid. Retry your request.
     * @throws InvalidTypeException
     *         The value of the <code>Type</code> parameter is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FmsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FmsClient.GetPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPolicyResponse getPolicy(GetPolicyRequest getPolicyRequest) throws ResourceNotFoundException,
            InvalidOperationException, InternalErrorException, InvalidTypeException, AwsServiceException, SdkClientException,
            FmsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the specified AWS Firewall Manager policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPolicyRequest.Builder} avoiding the need to
     * create one manually via {@link GetPolicyRequest#builder()}
     * </p>
     *
     * @param getPolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetPolicyRequest.Builder} to create a request.
     * @return Result of the GetPolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidOperationException
     *         The operation failed because there was nothing to do. For example, you might have submitted an
     *         <code>AssociateAdminAccount</code> request, but the account ID that you submitted was already set as the
     *         AWS Firewall Manager administrator.
     * @throws InternalErrorException
     *         The operation failed because of a system problem, even though the request was valid. Retry your request.
     * @throws InvalidTypeException
     *         The value of the <code>Type</code> parameter is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FmsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FmsClient.GetPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPolicyResponse getPolicy(Consumer<GetPolicyRequest.Builder> getPolicyRequest) throws ResourceNotFoundException,
            InvalidOperationException, InternalErrorException, InvalidTypeException, AwsServiceException, SdkClientException,
            FmsException {
        return getPolicy(GetPolicyRequest.builder().applyMutation(getPolicyRequest).build());
    }

    /**
     * <p>
     * If you created a Shield Advanced policy, returns policy-level attack summary information in the event of a
     * potential DDoS attack. Other policy types are currently unsupported.
     * </p>
     *
     * @param getProtectionStatusRequest
     * @return Result of the GetProtectionStatus operation returned by the service.
     * @throws InvalidInputException
     *         The parameters of the request were invalid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalErrorException
     *         The operation failed because of a system problem, even though the request was valid. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FmsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FmsClient.GetProtectionStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetProtectionStatus" target="_top">AWS API
     *      Documentation</a>
     */
    default GetProtectionStatusResponse getProtectionStatus(GetProtectionStatusRequest getProtectionStatusRequest)
            throws InvalidInputException, ResourceNotFoundException, InternalErrorException, AwsServiceException,
            SdkClientException, FmsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * If you created a Shield Advanced policy, returns policy-level attack summary information in the event of a
     * potential DDoS attack. Other policy types are currently unsupported.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetProtectionStatusRequest.Builder} avoiding the
     * need to create one manually via {@link GetProtectionStatusRequest#builder()}
     * </p>
     *
     * @param getProtectionStatusRequest
     *        A {@link Consumer} that will call methods on {@link GetProtectionStatusRequest.Builder} to create a
     *        request.
     * @return Result of the GetProtectionStatus operation returned by the service.
     * @throws InvalidInputException
     *         The parameters of the request were invalid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalErrorException
     *         The operation failed because of a system problem, even though the request was valid. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FmsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FmsClient.GetProtectionStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/GetProtectionStatus" target="_top">AWS API
     *      Documentation</a>
     */
    default GetProtectionStatusResponse getProtectionStatus(
            Consumer<GetProtectionStatusRequest.Builder> getProtectionStatusRequest) throws InvalidInputException,
            ResourceNotFoundException, InternalErrorException, AwsServiceException, SdkClientException, FmsException {
        return getProtectionStatus(GetProtectionStatusRequest.builder().applyMutation(getProtectionStatusRequest).build());
    }

    /**
     * <p>
     * Returns an array of <code>PolicyComplianceStatus</code> objects in the response. Use
     * <code>PolicyComplianceStatus</code> to get a summary of which member accounts are protected by the specified
     * policy.
     * </p>
     *
     * @param listComplianceStatusRequest
     * @return Result of the ListComplianceStatus operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalErrorException
     *         The operation failed because of a system problem, even though the request was valid. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FmsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FmsClient.ListComplianceStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListComplianceStatus" target="_top">AWS API
     *      Documentation</a>
     */
    default ListComplianceStatusResponse listComplianceStatus(ListComplianceStatusRequest listComplianceStatusRequest)
            throws ResourceNotFoundException, InternalErrorException, AwsServiceException, SdkClientException, FmsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of <code>PolicyComplianceStatus</code> objects in the response. Use
     * <code>PolicyComplianceStatus</code> to get a summary of which member accounts are protected by the specified
     * policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComplianceStatusRequest.Builder} avoiding the
     * need to create one manually via {@link ListComplianceStatusRequest#builder()}
     * </p>
     *
     * @param listComplianceStatusRequest
     *        A {@link Consumer} that will call methods on {@link ListComplianceStatusRequest.Builder} to create a
     *        request.
     * @return Result of the ListComplianceStatus operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalErrorException
     *         The operation failed because of a system problem, even though the request was valid. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FmsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FmsClient.ListComplianceStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListComplianceStatus" target="_top">AWS API
     *      Documentation</a>
     */
    default ListComplianceStatusResponse listComplianceStatus(
            Consumer<ListComplianceStatusRequest.Builder> listComplianceStatusRequest) throws ResourceNotFoundException,
            InternalErrorException, AwsServiceException, SdkClientException, FmsException {
        return listComplianceStatus(ListComplianceStatusRequest.builder().applyMutation(listComplianceStatusRequest).build());
    }

    /**
     * <p>
     * Returns an array of <code>PolicyComplianceStatus</code> objects in the response. Use
     * <code>PolicyComplianceStatus</code> to get a summary of which member accounts are protected by the specified
     * policy.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listComplianceStatus(software.amazon.awssdk.services.fms.model.ListComplianceStatusRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fms.paginators.ListComplianceStatusIterable responses = client.listComplianceStatusPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.fms.paginators.ListComplianceStatusIterable responses = client
     *             .listComplianceStatusPaginator(request);
     *     for (software.amazon.awssdk.services.fms.model.ListComplianceStatusResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fms.paginators.ListComplianceStatusIterable responses = client.listComplianceStatusPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComplianceStatus(software.amazon.awssdk.services.fms.model.ListComplianceStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param listComplianceStatusRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalErrorException
     *         The operation failed because of a system problem, even though the request was valid. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FmsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FmsClient.ListComplianceStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListComplianceStatus" target="_top">AWS API
     *      Documentation</a>
     */
    default ListComplianceStatusIterable listComplianceStatusPaginator(ListComplianceStatusRequest listComplianceStatusRequest)
            throws ResourceNotFoundException, InternalErrorException, AwsServiceException, SdkClientException, FmsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of <code>PolicyComplianceStatus</code> objects in the response. Use
     * <code>PolicyComplianceStatus</code> to get a summary of which member accounts are protected by the specified
     * policy.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listComplianceStatus(software.amazon.awssdk.services.fms.model.ListComplianceStatusRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fms.paginators.ListComplianceStatusIterable responses = client.listComplianceStatusPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.fms.paginators.ListComplianceStatusIterable responses = client
     *             .listComplianceStatusPaginator(request);
     *     for (software.amazon.awssdk.services.fms.model.ListComplianceStatusResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fms.paginators.ListComplianceStatusIterable responses = client.listComplianceStatusPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComplianceStatus(software.amazon.awssdk.services.fms.model.ListComplianceStatusRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComplianceStatusRequest.Builder} avoiding the
     * need to create one manually via {@link ListComplianceStatusRequest#builder()}
     * </p>
     *
     * @param listComplianceStatusRequest
     *        A {@link Consumer} that will call methods on {@link ListComplianceStatusRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalErrorException
     *         The operation failed because of a system problem, even though the request was valid. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FmsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FmsClient.ListComplianceStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListComplianceStatus" target="_top">AWS API
     *      Documentation</a>
     */
    default ListComplianceStatusIterable listComplianceStatusPaginator(
            Consumer<ListComplianceStatusRequest.Builder> listComplianceStatusRequest) throws ResourceNotFoundException,
            InternalErrorException, AwsServiceException, SdkClientException, FmsException {
        return listComplianceStatusPaginator(ListComplianceStatusRequest.builder().applyMutation(listComplianceStatusRequest)
                .build());
    }

    /**
     * <p>
     * Returns a <code>MemberAccounts</code> object that lists the member accounts in the administrator's AWS
     * organization.
     * </p>
     * <p>
     * The <code>ListMemberAccounts</code> must be submitted by the account that is set as the AWS Firewall Manager
     * administrator.
     * </p>
     *
     * @param listMemberAccountsRequest
     * @return Result of the ListMemberAccounts operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalErrorException
     *         The operation failed because of a system problem, even though the request was valid. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FmsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FmsClient.ListMemberAccounts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListMemberAccounts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMemberAccountsResponse listMemberAccounts(ListMemberAccountsRequest listMemberAccountsRequest)
            throws ResourceNotFoundException, InternalErrorException, AwsServiceException, SdkClientException, FmsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a <code>MemberAccounts</code> object that lists the member accounts in the administrator's AWS
     * organization.
     * </p>
     * <p>
     * The <code>ListMemberAccounts</code> must be submitted by the account that is set as the AWS Firewall Manager
     * administrator.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMemberAccountsRequest.Builder} avoiding the
     * need to create one manually via {@link ListMemberAccountsRequest#builder()}
     * </p>
     *
     * @param listMemberAccountsRequest
     *        A {@link Consumer} that will call methods on {@link ListMemberAccountsRequest.Builder} to create a
     *        request.
     * @return Result of the ListMemberAccounts operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalErrorException
     *         The operation failed because of a system problem, even though the request was valid. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FmsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FmsClient.ListMemberAccounts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListMemberAccounts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMemberAccountsResponse listMemberAccounts(Consumer<ListMemberAccountsRequest.Builder> listMemberAccountsRequest)
            throws ResourceNotFoundException, InternalErrorException, AwsServiceException, SdkClientException, FmsException {
        return listMemberAccounts(ListMemberAccountsRequest.builder().applyMutation(listMemberAccountsRequest).build());
    }

    /**
     * <p>
     * Returns a <code>MemberAccounts</code> object that lists the member accounts in the administrator's AWS
     * organization.
     * </p>
     * <p>
     * The <code>ListMemberAccounts</code> must be submitted by the account that is set as the AWS Firewall Manager
     * administrator.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMemberAccounts(software.amazon.awssdk.services.fms.model.ListMemberAccountsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fms.paginators.ListMemberAccountsIterable responses = client.listMemberAccountsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.fms.paginators.ListMemberAccountsIterable responses = client
     *             .listMemberAccountsPaginator(request);
     *     for (software.amazon.awssdk.services.fms.model.ListMemberAccountsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fms.paginators.ListMemberAccountsIterable responses = client.listMemberAccountsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMemberAccounts(software.amazon.awssdk.services.fms.model.ListMemberAccountsRequest)} operation.</b>
     * </p>
     *
     * @param listMemberAccountsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalErrorException
     *         The operation failed because of a system problem, even though the request was valid. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FmsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FmsClient.ListMemberAccounts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListMemberAccounts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMemberAccountsIterable listMemberAccountsPaginator(ListMemberAccountsRequest listMemberAccountsRequest)
            throws ResourceNotFoundException, InternalErrorException, AwsServiceException, SdkClientException, FmsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a <code>MemberAccounts</code> object that lists the member accounts in the administrator's AWS
     * organization.
     * </p>
     * <p>
     * The <code>ListMemberAccounts</code> must be submitted by the account that is set as the AWS Firewall Manager
     * administrator.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMemberAccounts(software.amazon.awssdk.services.fms.model.ListMemberAccountsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fms.paginators.ListMemberAccountsIterable responses = client.listMemberAccountsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.fms.paginators.ListMemberAccountsIterable responses = client
     *             .listMemberAccountsPaginator(request);
     *     for (software.amazon.awssdk.services.fms.model.ListMemberAccountsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fms.paginators.ListMemberAccountsIterable responses = client.listMemberAccountsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMemberAccounts(software.amazon.awssdk.services.fms.model.ListMemberAccountsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMemberAccountsRequest.Builder} avoiding the
     * need to create one manually via {@link ListMemberAccountsRequest#builder()}
     * </p>
     *
     * @param listMemberAccountsRequest
     *        A {@link Consumer} that will call methods on {@link ListMemberAccountsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalErrorException
     *         The operation failed because of a system problem, even though the request was valid. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FmsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FmsClient.ListMemberAccounts
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListMemberAccounts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMemberAccountsIterable listMemberAccountsPaginator(
            Consumer<ListMemberAccountsRequest.Builder> listMemberAccountsRequest) throws ResourceNotFoundException,
            InternalErrorException, AwsServiceException, SdkClientException, FmsException {
        return listMemberAccountsPaginator(ListMemberAccountsRequest.builder().applyMutation(listMemberAccountsRequest).build());
    }

    /**
     * <p>
     * Returns an array of <code>PolicySummary</code> objects in the response.
     * </p>
     *
     * @param listPoliciesRequest
     * @return Result of the ListPolicies operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidOperationException
     *         The operation failed because there was nothing to do. For example, you might have submitted an
     *         <code>AssociateAdminAccount</code> request, but the account ID that you submitted was already set as the
     *         AWS Firewall Manager administrator.
     * @throws LimitExceededException
     *         The operation exceeds a resource limit, for example, the maximum number of <code>policy</code> objects
     *         that you can create for an AWS account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html">Firewall Manager Limits</a>
     *         in the <i>AWS WAF Developer Guide</i>.
     * @throws InternalErrorException
     *         The operation failed because of a system problem, even though the request was valid. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FmsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FmsClient.ListPolicies
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPoliciesResponse listPolicies(ListPoliciesRequest listPoliciesRequest) throws ResourceNotFoundException,
            InvalidOperationException, LimitExceededException, InternalErrorException, AwsServiceException, SdkClientException,
            FmsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of <code>PolicySummary</code> objects in the response.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPoliciesRequest.Builder} avoiding the need to
     * create one manually via {@link ListPoliciesRequest#builder()}
     * </p>
     *
     * @param listPoliciesRequest
     *        A {@link Consumer} that will call methods on {@link ListPoliciesRequest.Builder} to create a request.
     * @return Result of the ListPolicies operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidOperationException
     *         The operation failed because there was nothing to do. For example, you might have submitted an
     *         <code>AssociateAdminAccount</code> request, but the account ID that you submitted was already set as the
     *         AWS Firewall Manager administrator.
     * @throws LimitExceededException
     *         The operation exceeds a resource limit, for example, the maximum number of <code>policy</code> objects
     *         that you can create for an AWS account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html">Firewall Manager Limits</a>
     *         in the <i>AWS WAF Developer Guide</i>.
     * @throws InternalErrorException
     *         The operation failed because of a system problem, even though the request was valid. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FmsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FmsClient.ListPolicies
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPoliciesResponse listPolicies(Consumer<ListPoliciesRequest.Builder> listPoliciesRequest)
            throws ResourceNotFoundException, InvalidOperationException, LimitExceededException, InternalErrorException,
            AwsServiceException, SdkClientException, FmsException {
        return listPolicies(ListPoliciesRequest.builder().applyMutation(listPoliciesRequest).build());
    }

    /**
     * <p>
     * Returns an array of <code>PolicySummary</code> objects in the response.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listPolicies(software.amazon.awssdk.services.fms.model.ListPoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fms.paginators.ListPoliciesIterable responses = client.listPoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.fms.paginators.ListPoliciesIterable responses = client.listPoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.fms.model.ListPoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fms.paginators.ListPoliciesIterable responses = client.listPoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPolicies(software.amazon.awssdk.services.fms.model.ListPoliciesRequest)} operation.</b>
     * </p>
     *
     * @param listPoliciesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidOperationException
     *         The operation failed because there was nothing to do. For example, you might have submitted an
     *         <code>AssociateAdminAccount</code> request, but the account ID that you submitted was already set as the
     *         AWS Firewall Manager administrator.
     * @throws LimitExceededException
     *         The operation exceeds a resource limit, for example, the maximum number of <code>policy</code> objects
     *         that you can create for an AWS account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html">Firewall Manager Limits</a>
     *         in the <i>AWS WAF Developer Guide</i>.
     * @throws InternalErrorException
     *         The operation failed because of a system problem, even though the request was valid. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FmsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FmsClient.ListPolicies
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPoliciesIterable listPoliciesPaginator(ListPoliciesRequest listPoliciesRequest) throws ResourceNotFoundException,
            InvalidOperationException, LimitExceededException, InternalErrorException, AwsServiceException, SdkClientException,
            FmsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an array of <code>PolicySummary</code> objects in the response.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listPolicies(software.amazon.awssdk.services.fms.model.ListPoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fms.paginators.ListPoliciesIterable responses = client.listPoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.fms.paginators.ListPoliciesIterable responses = client.listPoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.fms.model.ListPoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.fms.paginators.ListPoliciesIterable responses = client.listPoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPolicies(software.amazon.awssdk.services.fms.model.ListPoliciesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPoliciesRequest.Builder} avoiding the need to
     * create one manually via {@link ListPoliciesRequest#builder()}
     * </p>
     *
     * @param listPoliciesRequest
     *        A {@link Consumer} that will call methods on {@link ListPoliciesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidOperationException
     *         The operation failed because there was nothing to do. For example, you might have submitted an
     *         <code>AssociateAdminAccount</code> request, but the account ID that you submitted was already set as the
     *         AWS Firewall Manager administrator.
     * @throws LimitExceededException
     *         The operation exceeds a resource limit, for example, the maximum number of <code>policy</code> objects
     *         that you can create for an AWS account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html">Firewall Manager Limits</a>
     *         in the <i>AWS WAF Developer Guide</i>.
     * @throws InternalErrorException
     *         The operation failed because of a system problem, even though the request was valid. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FmsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FmsClient.ListPolicies
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPoliciesIterable listPoliciesPaginator(Consumer<ListPoliciesRequest.Builder> listPoliciesRequest)
            throws ResourceNotFoundException, InvalidOperationException, LimitExceededException, InternalErrorException,
            AwsServiceException, SdkClientException, FmsException {
        return listPoliciesPaginator(ListPoliciesRequest.builder().applyMutation(listPoliciesRequest).build());
    }

    /**
     * <p>
     * Retrieves the list of tags for the specified AWS resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidOperationException
     *         The operation failed because there was nothing to do. For example, you might have submitted an
     *         <code>AssociateAdminAccount</code> request, but the account ID that you submitted was already set as the
     *         AWS Firewall Manager administrator.
     * @throws InternalErrorException
     *         The operation failed because of a system problem, even though the request was valid. Retry your request.
     * @throws InvalidInputException
     *         The parameters of the request were invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FmsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FmsClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, InvalidOperationException, InternalErrorException, InvalidInputException,
            AwsServiceException, SdkClientException, FmsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the list of tags for the specified AWS resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidOperationException
     *         The operation failed because there was nothing to do. For example, you might have submitted an
     *         <code>AssociateAdminAccount</code> request, but the account ID that you submitted was already set as the
     *         AWS Firewall Manager administrator.
     * @throws InternalErrorException
     *         The operation failed because of a system problem, even though the request was valid. Retry your request.
     * @throws InvalidInputException
     *         The parameters of the request were invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FmsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FmsClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            InvalidOperationException, InternalErrorException, InvalidInputException, AwsServiceException, SdkClientException,
            FmsException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Designates the IAM role and Amazon Simple Notification Service (SNS) topic that AWS Firewall Manager uses to
     * record SNS logs.
     * </p>
     *
     * @param putNotificationChannelRequest
     * @return Result of the PutNotificationChannel operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidOperationException
     *         The operation failed because there was nothing to do. For example, you might have submitted an
     *         <code>AssociateAdminAccount</code> request, but the account ID that you submitted was already set as the
     *         AWS Firewall Manager administrator.
     * @throws InternalErrorException
     *         The operation failed because of a system problem, even though the request was valid. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FmsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FmsClient.PutNotificationChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/PutNotificationChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default PutNotificationChannelResponse putNotificationChannel(PutNotificationChannelRequest putNotificationChannelRequest)
            throws ResourceNotFoundException, InvalidOperationException, InternalErrorException, AwsServiceException,
            SdkClientException, FmsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Designates the IAM role and Amazon Simple Notification Service (SNS) topic that AWS Firewall Manager uses to
     * record SNS logs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutNotificationChannelRequest.Builder} avoiding the
     * need to create one manually via {@link PutNotificationChannelRequest#builder()}
     * </p>
     *
     * @param putNotificationChannelRequest
     *        A {@link Consumer} that will call methods on {@link PutNotificationChannelRequest.Builder} to create a
     *        request.
     * @return Result of the PutNotificationChannel operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidOperationException
     *         The operation failed because there was nothing to do. For example, you might have submitted an
     *         <code>AssociateAdminAccount</code> request, but the account ID that you submitted was already set as the
     *         AWS Firewall Manager administrator.
     * @throws InternalErrorException
     *         The operation failed because of a system problem, even though the request was valid. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FmsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FmsClient.PutNotificationChannel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/PutNotificationChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default PutNotificationChannelResponse putNotificationChannel(
            Consumer<PutNotificationChannelRequest.Builder> putNotificationChannelRequest) throws ResourceNotFoundException,
            InvalidOperationException, InternalErrorException, AwsServiceException, SdkClientException, FmsException {
        return putNotificationChannel(PutNotificationChannelRequest.builder().applyMutation(putNotificationChannelRequest)
                .build());
    }

    /**
     * <p>
     * Creates an AWS Firewall Manager policy.
     * </p>
     * <p>
     * Firewall Manager provides the following types of policies:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A Shield Advanced policy, which applies Shield Advanced protection to specified accounts and resources
     * </p>
     * </li>
     * <li>
     * <p>
     * An AWS WAF policy (type WAFV2), which defines rule groups to run first in the corresponding AWS WAF web ACL and
     * rule groups to run last in the web ACL.
     * </p>
     * </li>
     * <li>
     * <p>
     * An AWS WAF Classic policy (type WAF), which defines a rule group.
     * </p>
     * </li>
     * <li>
     * <p>
     * A security group policy, which manages VPC security groups across your AWS organization.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Each policy is specific to one of the types. If you want to enforce more than one policy type across accounts,
     * create multiple policies. You can create multiple policies for each type.
     * </p>
     * <p>
     * You must be subscribed to Shield Advanced to create a Shield Advanced policy. For more information about
     * subscribing to Shield Advanced, see <a
     * href="https://docs.aws.amazon.com/waf/latest/DDOSAPIReference/API_CreateSubscription.html"
     * >CreateSubscription</a>.
     * </p>
     *
     * @param putPolicyRequest
     * @return Result of the PutPolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidOperationException
     *         The operation failed because there was nothing to do. For example, you might have submitted an
     *         <code>AssociateAdminAccount</code> request, but the account ID that you submitted was already set as the
     *         AWS Firewall Manager administrator.
     * @throws InvalidInputException
     *         The parameters of the request were invalid.
     * @throws LimitExceededException
     *         The operation exceeds a resource limit, for example, the maximum number of <code>policy</code> objects
     *         that you can create for an AWS account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html">Firewall Manager Limits</a>
     *         in the <i>AWS WAF Developer Guide</i>.
     * @throws InternalErrorException
     *         The operation failed because of a system problem, even though the request was valid. Retry your request.
     * @throws InvalidTypeException
     *         The value of the <code>Type</code> parameter is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FmsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FmsClient.PutPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/PutPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default PutPolicyResponse putPolicy(PutPolicyRequest putPolicyRequest) throws ResourceNotFoundException,
            InvalidOperationException, InvalidInputException, LimitExceededException, InternalErrorException,
            InvalidTypeException, AwsServiceException, SdkClientException, FmsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an AWS Firewall Manager policy.
     * </p>
     * <p>
     * Firewall Manager provides the following types of policies:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A Shield Advanced policy, which applies Shield Advanced protection to specified accounts and resources
     * </p>
     * </li>
     * <li>
     * <p>
     * An AWS WAF policy (type WAFV2), which defines rule groups to run first in the corresponding AWS WAF web ACL and
     * rule groups to run last in the web ACL.
     * </p>
     * </li>
     * <li>
     * <p>
     * An AWS WAF Classic policy (type WAF), which defines a rule group.
     * </p>
     * </li>
     * <li>
     * <p>
     * A security group policy, which manages VPC security groups across your AWS organization.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Each policy is specific to one of the types. If you want to enforce more than one policy type across accounts,
     * create multiple policies. You can create multiple policies for each type.
     * </p>
     * <p>
     * You must be subscribed to Shield Advanced to create a Shield Advanced policy. For more information about
     * subscribing to Shield Advanced, see <a
     * href="https://docs.aws.amazon.com/waf/latest/DDOSAPIReference/API_CreateSubscription.html"
     * >CreateSubscription</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutPolicyRequest.Builder} avoiding the need to
     * create one manually via {@link PutPolicyRequest#builder()}
     * </p>
     *
     * @param putPolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutPolicyRequest.Builder} to create a request.
     * @return Result of the PutPolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidOperationException
     *         The operation failed because there was nothing to do. For example, you might have submitted an
     *         <code>AssociateAdminAccount</code> request, but the account ID that you submitted was already set as the
     *         AWS Firewall Manager administrator.
     * @throws InvalidInputException
     *         The parameters of the request were invalid.
     * @throws LimitExceededException
     *         The operation exceeds a resource limit, for example, the maximum number of <code>policy</code> objects
     *         that you can create for an AWS account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html">Firewall Manager Limits</a>
     *         in the <i>AWS WAF Developer Guide</i>.
     * @throws InternalErrorException
     *         The operation failed because of a system problem, even though the request was valid. Retry your request.
     * @throws InvalidTypeException
     *         The value of the <code>Type</code> parameter is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FmsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FmsClient.PutPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/PutPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default PutPolicyResponse putPolicy(Consumer<PutPolicyRequest.Builder> putPolicyRequest) throws ResourceNotFoundException,
            InvalidOperationException, InvalidInputException, LimitExceededException, InternalErrorException,
            InvalidTypeException, AwsServiceException, SdkClientException, FmsException {
        return putPolicy(PutPolicyRequest.builder().applyMutation(putPolicyRequest).build());
    }

    /**
     * <p>
     * Adds one or more tags to an AWS resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidOperationException
     *         The operation failed because there was nothing to do. For example, you might have submitted an
     *         <code>AssociateAdminAccount</code> request, but the account ID that you submitted was already set as the
     *         AWS Firewall Manager administrator.
     * @throws InternalErrorException
     *         The operation failed because of a system problem, even though the request was valid. Retry your request.
     * @throws InvalidInputException
     *         The parameters of the request were invalid.
     * @throws LimitExceededException
     *         The operation exceeds a resource limit, for example, the maximum number of <code>policy</code> objects
     *         that you can create for an AWS account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html">Firewall Manager Limits</a>
     *         in the <i>AWS WAF Developer Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FmsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FmsClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException,
            InvalidOperationException, InternalErrorException, InvalidInputException, LimitExceededException,
            AwsServiceException, SdkClientException, FmsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more tags to an AWS resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidOperationException
     *         The operation failed because there was nothing to do. For example, you might have submitted an
     *         <code>AssociateAdminAccount</code> request, but the account ID that you submitted was already set as the
     *         AWS Firewall Manager administrator.
     * @throws InternalErrorException
     *         The operation failed because of a system problem, even though the request was valid. Retry your request.
     * @throws InvalidInputException
     *         The parameters of the request were invalid.
     * @throws LimitExceededException
     *         The operation exceeds a resource limit, for example, the maximum number of <code>policy</code> objects
     *         that you can create for an AWS account. For more information, see <a
     *         href="https://docs.aws.amazon.com/waf/latest/developerguide/fms-limits.html">Firewall Manager Limits</a>
     *         in the <i>AWS WAF Developer Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FmsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FmsClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ResourceNotFoundException, InvalidOperationException, InternalErrorException, InvalidInputException,
            LimitExceededException, AwsServiceException, SdkClientException, FmsException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from an AWS resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidOperationException
     *         The operation failed because there was nothing to do. For example, you might have submitted an
     *         <code>AssociateAdminAccount</code> request, but the account ID that you submitted was already set as the
     *         AWS Firewall Manager administrator.
     * @throws InternalErrorException
     *         The operation failed because of a system problem, even though the request was valid. Retry your request.
     * @throws InvalidInputException
     *         The parameters of the request were invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FmsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FmsClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            InvalidOperationException, InternalErrorException, InvalidInputException, AwsServiceException, SdkClientException,
            FmsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from an AWS resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidOperationException
     *         The operation failed because there was nothing to do. For example, you might have submitted an
     *         <code>AssociateAdminAccount</code> request, but the account ID that you submitted was already set as the
     *         AWS Firewall Manager administrator.
     * @throws InternalErrorException
     *         The operation failed because of a system problem, even though the request was valid. Retry your request.
     * @throws InvalidInputException
     *         The parameters of the request were invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws FmsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample FmsClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ResourceNotFoundException, InvalidOperationException, InternalErrorException, InvalidInputException,
            AwsServiceException, SdkClientException, FmsException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("fms");
    }
}
