/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateExperimentTemplateRequest extends FisRequest implements
        ToCopyableBuilder<UpdateExperimentTemplateRequest.Builder, UpdateExperimentTemplateRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(UpdateExperimentTemplateRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateExperimentTemplateRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<UpdateExperimentTemplateStopConditionInput>> STOP_CONDITIONS_FIELD = SdkField
            .<List<UpdateExperimentTemplateStopConditionInput>> builder(MarshallingType.LIST)
            .memberName("stopConditions")
            .getter(getter(UpdateExperimentTemplateRequest::stopConditions))
            .setter(setter(Builder::stopConditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopConditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UpdateExperimentTemplateStopConditionInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(UpdateExperimentTemplateStopConditionInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, UpdateExperimentTemplateTargetInput>> TARGETS_FIELD = SdkField
            .<Map<String, UpdateExperimentTemplateTargetInput>> builder(MarshallingType.MAP)
            .memberName("targets")
            .getter(getter(UpdateExperimentTemplateRequest::targets))
            .setter(setter(Builder::targets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targets").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<UpdateExperimentTemplateTargetInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(UpdateExperimentTemplateTargetInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, UpdateExperimentTemplateActionInputItem>> ACTIONS_FIELD = SdkField
            .<Map<String, UpdateExperimentTemplateActionInputItem>> builder(MarshallingType.MAP)
            .memberName("actions")
            .getter(getter(UpdateExperimentTemplateRequest::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<UpdateExperimentTemplateActionInputItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(UpdateExperimentTemplateActionInputItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(UpdateExperimentTemplateRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<UpdateExperimentTemplateLogConfigurationInput> LOG_CONFIGURATION_FIELD = SdkField
            .<UpdateExperimentTemplateLogConfigurationInput> builder(MarshallingType.SDK_POJO).memberName("logConfiguration")
            .getter(getter(UpdateExperimentTemplateRequest::logConfiguration)).setter(setter(Builder::logConfiguration))
            .constructor(UpdateExperimentTemplateLogConfigurationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logConfiguration").build()).build();

    private static final SdkField<UpdateExperimentTemplateExperimentOptionsInput> EXPERIMENT_OPTIONS_FIELD = SdkField
            .<UpdateExperimentTemplateExperimentOptionsInput> builder(MarshallingType.SDK_POJO).memberName("experimentOptions")
            .getter(getter(UpdateExperimentTemplateRequest::experimentOptions)).setter(setter(Builder::experimentOptions))
            .constructor(UpdateExperimentTemplateExperimentOptionsInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("experimentOptions").build()).build();

    private static final SdkField<UpdateExperimentTemplateReportConfigurationInput> EXPERIMENT_REPORT_CONFIGURATION_FIELD = SdkField
            .<UpdateExperimentTemplateReportConfigurationInput> builder(MarshallingType.SDK_POJO)
            .memberName("experimentReportConfiguration")
            .getter(getter(UpdateExperimentTemplateRequest::experimentReportConfiguration))
            .setter(setter(Builder::experimentReportConfiguration))
            .constructor(UpdateExperimentTemplateReportConfigurationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("experimentReportConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, DESCRIPTION_FIELD,
            STOP_CONDITIONS_FIELD, TARGETS_FIELD, ACTIONS_FIELD, ROLE_ARN_FIELD, LOG_CONFIGURATION_FIELD,
            EXPERIMENT_OPTIONS_FIELD, EXPERIMENT_REPORT_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String description;

    private final List<UpdateExperimentTemplateStopConditionInput> stopConditions;

    private final Map<String, UpdateExperimentTemplateTargetInput> targets;

    private final Map<String, UpdateExperimentTemplateActionInputItem> actions;

    private final String roleArn;

    private final UpdateExperimentTemplateLogConfigurationInput logConfiguration;

    private final UpdateExperimentTemplateExperimentOptionsInput experimentOptions;

    private final UpdateExperimentTemplateReportConfigurationInput experimentReportConfiguration;

    private UpdateExperimentTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.description = builder.description;
        this.stopConditions = builder.stopConditions;
        this.targets = builder.targets;
        this.actions = builder.actions;
        this.roleArn = builder.roleArn;
        this.logConfiguration = builder.logConfiguration;
        this.experimentOptions = builder.experimentOptions;
        this.experimentReportConfiguration = builder.experimentReportConfiguration;
    }

    /**
     * <p>
     * The ID of the experiment template.
     * </p>
     * 
     * @return The ID of the experiment template.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * A description for the template.
     * </p>
     * 
     * @return A description for the template.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the StopConditions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStopConditions() {
        return stopConditions != null && !(stopConditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The stop conditions for the experiment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStopConditions} method.
     * </p>
     * 
     * @return The stop conditions for the experiment.
     */
    public final List<UpdateExperimentTemplateStopConditionInput> stopConditions() {
        return stopConditions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Targets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTargets() {
        return targets != null && !(targets instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The targets for the experiment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargets} method.
     * </p>
     * 
     * @return The targets for the experiment.
     */
    public final Map<String, UpdateExperimentTemplateTargetInput> targets() {
        return targets;
    }

    /**
     * For responses, this returns true if the service returned a value for the Actions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The actions for the experiment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActions} method.
     * </p>
     * 
     * @return The actions for the experiment.
     */
    public final Map<String, UpdateExperimentTemplateActionInputItem> actions() {
        return actions;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role that grants the FIS service permission to perform service actions
     * on your behalf.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role that grants the FIS service permission to perform service
     *         actions on your behalf.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The configuration for experiment logging.
     * </p>
     * 
     * @return The configuration for experiment logging.
     */
    public final UpdateExperimentTemplateLogConfigurationInput logConfiguration() {
        return logConfiguration;
    }

    /**
     * <p>
     * The experiment options for the experiment template.
     * </p>
     * 
     * @return The experiment options for the experiment template.
     */
    public final UpdateExperimentTemplateExperimentOptionsInput experimentOptions() {
        return experimentOptions;
    }

    /**
     * <p>
     * The experiment report configuration for the experiment template.
     * </p>
     * 
     * @return The experiment report configuration for the experiment template.
     */
    public final UpdateExperimentTemplateReportConfigurationInput experimentReportConfiguration() {
        return experimentReportConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasStopConditions() ? stopConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTargets() ? targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasActions() ? actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(logConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(experimentOptions());
        hashCode = 31 * hashCode + Objects.hashCode(experimentReportConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateExperimentTemplateRequest)) {
            return false;
        }
        UpdateExperimentTemplateRequest other = (UpdateExperimentTemplateRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(description(), other.description())
                && hasStopConditions() == other.hasStopConditions() && Objects.equals(stopConditions(), other.stopConditions())
                && hasTargets() == other.hasTargets() && Objects.equals(targets(), other.targets())
                && hasActions() == other.hasActions() && Objects.equals(actions(), other.actions())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(logConfiguration(), other.logConfiguration())
                && Objects.equals(experimentOptions(), other.experimentOptions())
                && Objects.equals(experimentReportConfiguration(), other.experimentReportConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateExperimentTemplateRequest").add("Id", id()).add("Description", description())
                .add("StopConditions", hasStopConditions() ? stopConditions() : null)
                .add("Targets", hasTargets() ? targets() : null).add("Actions", hasActions() ? actions() : null)
                .add("RoleArn", roleArn()).add("LogConfiguration", logConfiguration())
                .add("ExperimentOptions", experimentOptions())
                .add("ExperimentReportConfiguration", experimentReportConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "stopConditions":
            return Optional.ofNullable(clazz.cast(stopConditions()));
        case "targets":
            return Optional.ofNullable(clazz.cast(targets()));
        case "actions":
            return Optional.ofNullable(clazz.cast(actions()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "logConfiguration":
            return Optional.ofNullable(clazz.cast(logConfiguration()));
        case "experimentOptions":
            return Optional.ofNullable(clazz.cast(experimentOptions()));
        case "experimentReportConfiguration":
            return Optional.ofNullable(clazz.cast(experimentReportConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("stopConditions", STOP_CONDITIONS_FIELD);
        map.put("targets", TARGETS_FIELD);
        map.put("actions", ACTIONS_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("logConfiguration", LOG_CONFIGURATION_FIELD);
        map.put("experimentOptions", EXPERIMENT_OPTIONS_FIELD);
        map.put("experimentReportConfiguration", EXPERIMENT_REPORT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateExperimentTemplateRequest, T> g) {
        return obj -> g.apply((UpdateExperimentTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends FisRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateExperimentTemplateRequest> {
        /**
         * <p>
         * The ID of the experiment template.
         * </p>
         * 
         * @param id
         *        The ID of the experiment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A description for the template.
         * </p>
         * 
         * @param description
         *        A description for the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The stop conditions for the experiment.
         * </p>
         * 
         * @param stopConditions
         *        The stop conditions for the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopConditions(Collection<UpdateExperimentTemplateStopConditionInput> stopConditions);

        /**
         * <p>
         * The stop conditions for the experiment.
         * </p>
         * 
         * @param stopConditions
         *        The stop conditions for the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopConditions(UpdateExperimentTemplateStopConditionInput... stopConditions);

        /**
         * <p>
         * The stop conditions for the experiment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.fis.model.UpdateExperimentTemplateStopConditionInput.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.fis.model.UpdateExperimentTemplateStopConditionInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.fis.model.UpdateExperimentTemplateStopConditionInput.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #stopConditions(List<UpdateExperimentTemplateStopConditionInput>)}.
         * 
         * @param stopConditions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.fis.model.UpdateExperimentTemplateStopConditionInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stopConditions(java.util.Collection<UpdateExperimentTemplateStopConditionInput>)
         */
        Builder stopConditions(Consumer<UpdateExperimentTemplateStopConditionInput.Builder>... stopConditions);

        /**
         * <p>
         * The targets for the experiment.
         * </p>
         * 
         * @param targets
         *        The targets for the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Map<String, UpdateExperimentTemplateTargetInput> targets);

        /**
         * <p>
         * The actions for the experiment.
         * </p>
         * 
         * @param actions
         *        The actions for the experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Map<String, UpdateExperimentTemplateActionInputItem> actions);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role that grants the FIS service permission to perform service
         * actions on your behalf.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM role that grants the FIS service permission to perform
         *        service actions on your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The configuration for experiment logging.
         * </p>
         * 
         * @param logConfiguration
         *        The configuration for experiment logging.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logConfiguration(UpdateExperimentTemplateLogConfigurationInput logConfiguration);

        /**
         * <p>
         * The configuration for experiment logging.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UpdateExperimentTemplateLogConfigurationInput.Builder} avoiding the need to create one manually via
         * {@link UpdateExperimentTemplateLogConfigurationInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateExperimentTemplateLogConfigurationInput.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #logConfiguration(UpdateExperimentTemplateLogConfigurationInput)}.
         * 
         * @param logConfiguration
         *        a consumer that will call methods on {@link UpdateExperimentTemplateLogConfigurationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logConfiguration(UpdateExperimentTemplateLogConfigurationInput)
         */
        default Builder logConfiguration(Consumer<UpdateExperimentTemplateLogConfigurationInput.Builder> logConfiguration) {
            return logConfiguration(UpdateExperimentTemplateLogConfigurationInput.builder().applyMutation(logConfiguration)
                    .build());
        }

        /**
         * <p>
         * The experiment options for the experiment template.
         * </p>
         * 
         * @param experimentOptions
         *        The experiment options for the experiment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder experimentOptions(UpdateExperimentTemplateExperimentOptionsInput experimentOptions);

        /**
         * <p>
         * The experiment options for the experiment template.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UpdateExperimentTemplateExperimentOptionsInput.Builder} avoiding the need to create one manually via
         * {@link UpdateExperimentTemplateExperimentOptionsInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateExperimentTemplateExperimentOptionsInput.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #experimentOptions(UpdateExperimentTemplateExperimentOptionsInput)}.
         * 
         * @param experimentOptions
         *        a consumer that will call methods on {@link UpdateExperimentTemplateExperimentOptionsInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #experimentOptions(UpdateExperimentTemplateExperimentOptionsInput)
         */
        default Builder experimentOptions(Consumer<UpdateExperimentTemplateExperimentOptionsInput.Builder> experimentOptions) {
            return experimentOptions(UpdateExperimentTemplateExperimentOptionsInput.builder().applyMutation(experimentOptions)
                    .build());
        }

        /**
         * <p>
         * The experiment report configuration for the experiment template.
         * </p>
         * 
         * @param experimentReportConfiguration
         *        The experiment report configuration for the experiment template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder experimentReportConfiguration(UpdateExperimentTemplateReportConfigurationInput experimentReportConfiguration);

        /**
         * <p>
         * The experiment report configuration for the experiment template.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UpdateExperimentTemplateReportConfigurationInput.Builder} avoiding the need to create one manually via
         * {@link UpdateExperimentTemplateReportConfigurationInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateExperimentTemplateReportConfigurationInput.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #experimentReportConfiguration(UpdateExperimentTemplateReportConfigurationInput)}.
         * 
         * @param experimentReportConfiguration
         *        a consumer that will call methods on {@link UpdateExperimentTemplateReportConfigurationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #experimentReportConfiguration(UpdateExperimentTemplateReportConfigurationInput)
         */
        default Builder experimentReportConfiguration(
                Consumer<UpdateExperimentTemplateReportConfigurationInput.Builder> experimentReportConfiguration) {
            return experimentReportConfiguration(UpdateExperimentTemplateReportConfigurationInput.builder()
                    .applyMutation(experimentReportConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FisRequest.BuilderImpl implements Builder {
        private String id;

        private String description;

        private List<UpdateExperimentTemplateStopConditionInput> stopConditions = DefaultSdkAutoConstructList.getInstance();

        private Map<String, UpdateExperimentTemplateTargetInput> targets = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, UpdateExperimentTemplateActionInputItem> actions = DefaultSdkAutoConstructMap.getInstance();

        private String roleArn;

        private UpdateExperimentTemplateLogConfigurationInput logConfiguration;

        private UpdateExperimentTemplateExperimentOptionsInput experimentOptions;

        private UpdateExperimentTemplateReportConfigurationInput experimentReportConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateExperimentTemplateRequest model) {
            super(model);
            id(model.id);
            description(model.description);
            stopConditions(model.stopConditions);
            targets(model.targets);
            actions(model.actions);
            roleArn(model.roleArn);
            logConfiguration(model.logConfiguration);
            experimentOptions(model.experimentOptions);
            experimentReportConfiguration(model.experimentReportConfiguration);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<UpdateExperimentTemplateStopConditionInput.Builder> getStopConditions() {
            List<UpdateExperimentTemplateStopConditionInput.Builder> result = UpdateExperimentTemplateStopConditionInputListCopier
                    .copyToBuilder(this.stopConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStopConditions(Collection<UpdateExperimentTemplateStopConditionInput.BuilderImpl> stopConditions) {
            this.stopConditions = UpdateExperimentTemplateStopConditionInputListCopier.copyFromBuilder(stopConditions);
        }

        @Override
        public final Builder stopConditions(Collection<UpdateExperimentTemplateStopConditionInput> stopConditions) {
            this.stopConditions = UpdateExperimentTemplateStopConditionInputListCopier.copy(stopConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stopConditions(UpdateExperimentTemplateStopConditionInput... stopConditions) {
            stopConditions(Arrays.asList(stopConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stopConditions(Consumer<UpdateExperimentTemplateStopConditionInput.Builder>... stopConditions) {
            stopConditions(Stream.of(stopConditions)
                    .map(c -> UpdateExperimentTemplateStopConditionInput.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Map<String, UpdateExperimentTemplateTargetInput.Builder> getTargets() {
            Map<String, UpdateExperimentTemplateTargetInput.Builder> result = UpdateExperimentTemplateTargetInputMapCopier
                    .copyToBuilder(this.targets);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setTargets(Map<String, UpdateExperimentTemplateTargetInput.BuilderImpl> targets) {
            this.targets = UpdateExperimentTemplateTargetInputMapCopier.copyFromBuilder(targets);
        }

        @Override
        public final Builder targets(Map<String, UpdateExperimentTemplateTargetInput> targets) {
            this.targets = UpdateExperimentTemplateTargetInputMapCopier.copy(targets);
            return this;
        }

        public final Map<String, UpdateExperimentTemplateActionInputItem.Builder> getActions() {
            Map<String, UpdateExperimentTemplateActionInputItem.Builder> result = UpdateExperimentTemplateActionInputMapCopier
                    .copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setActions(Map<String, UpdateExperimentTemplateActionInputItem.BuilderImpl> actions) {
            this.actions = UpdateExperimentTemplateActionInputMapCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Map<String, UpdateExperimentTemplateActionInputItem> actions) {
            this.actions = UpdateExperimentTemplateActionInputMapCopier.copy(actions);
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final UpdateExperimentTemplateLogConfigurationInput.Builder getLogConfiguration() {
            return logConfiguration != null ? logConfiguration.toBuilder() : null;
        }

        public final void setLogConfiguration(UpdateExperimentTemplateLogConfigurationInput.BuilderImpl logConfiguration) {
            this.logConfiguration = logConfiguration != null ? logConfiguration.build() : null;
        }

        @Override
        public final Builder logConfiguration(UpdateExperimentTemplateLogConfigurationInput logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        public final UpdateExperimentTemplateExperimentOptionsInput.Builder getExperimentOptions() {
            return experimentOptions != null ? experimentOptions.toBuilder() : null;
        }

        public final void setExperimentOptions(UpdateExperimentTemplateExperimentOptionsInput.BuilderImpl experimentOptions) {
            this.experimentOptions = experimentOptions != null ? experimentOptions.build() : null;
        }

        @Override
        public final Builder experimentOptions(UpdateExperimentTemplateExperimentOptionsInput experimentOptions) {
            this.experimentOptions = experimentOptions;
            return this;
        }

        public final UpdateExperimentTemplateReportConfigurationInput.Builder getExperimentReportConfiguration() {
            return experimentReportConfiguration != null ? experimentReportConfiguration.toBuilder() : null;
        }

        public final void setExperimentReportConfiguration(
                UpdateExperimentTemplateReportConfigurationInput.BuilderImpl experimentReportConfiguration) {
            this.experimentReportConfiguration = experimentReportConfiguration != null ? experimentReportConfiguration.build()
                    : null;
        }

        @Override
        public final Builder experimentReportConfiguration(
                UpdateExperimentTemplateReportConfigurationInput experimentReportConfiguration) {
            this.experimentReportConfiguration = experimentReportConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateExperimentTemplateRequest build() {
            return new UpdateExperimentTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
