/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fis.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the experiment report.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExperimentReport implements SdkPojo, Serializable,
        ToCopyableBuilder<ExperimentReport.Builder, ExperimentReport> {
    private static final SdkField<ExperimentReportState> STATE_FIELD = SdkField
            .<ExperimentReportState> builder(MarshallingType.SDK_POJO).memberName("state")
            .getter(getter(ExperimentReport::state)).setter(setter(Builder::state)).constructor(ExperimentReportState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<List<ExperimentReportS3Report>> S3_REPORTS_FIELD = SdkField
            .<List<ExperimentReportS3Report>> builder(MarshallingType.LIST)
            .memberName("s3Reports")
            .getter(getter(ExperimentReport::s3Reports))
            .setter(setter(Builder::s3Reports))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Reports").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExperimentReportS3Report> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExperimentReportS3Report::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(STATE_FIELD, S3_REPORTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ExperimentReportState state;

    private final List<ExperimentReportS3Report> s3Reports;

    private ExperimentReport(BuilderImpl builder) {
        this.state = builder.state;
        this.s3Reports = builder.s3Reports;
    }

    /**
     * <p>
     * The state of the experiment report.
     * </p>
     * 
     * @return The state of the experiment report.
     */
    public final ExperimentReportState state() {
        return state;
    }

    /**
     * For responses, this returns true if the service returned a value for the S3Reports property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasS3Reports() {
        return s3Reports != null && !(s3Reports instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The S3 destination of the experiment report.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasS3Reports} method.
     * </p>
     * 
     * @return The S3 destination of the experiment report.
     */
    public final List<ExperimentReportS3Report> s3Reports() {
        return s3Reports;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(hasS3Reports() ? s3Reports() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExperimentReport)) {
            return false;
        }
        ExperimentReport other = (ExperimentReport) obj;
        return Objects.equals(state(), other.state()) && hasS3Reports() == other.hasS3Reports()
                && Objects.equals(s3Reports(), other.s3Reports());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExperimentReport").add("State", state()).add("S3Reports", hasS3Reports() ? s3Reports() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "state":
            return Optional.ofNullable(clazz.cast(state()));
        case "s3Reports":
            return Optional.ofNullable(clazz.cast(s3Reports()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("state", STATE_FIELD);
        map.put("s3Reports", S3_REPORTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExperimentReport, T> g) {
        return obj -> g.apply((ExperimentReport) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExperimentReport> {
        /**
         * <p>
         * The state of the experiment report.
         * </p>
         * 
         * @param state
         *        The state of the experiment report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(ExperimentReportState state);

        /**
         * <p>
         * The state of the experiment report.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExperimentReportState.Builder} avoiding
         * the need to create one manually via {@link ExperimentReportState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExperimentReportState.Builder#build()} is called immediately and
         * its result is passed to {@link #state(ExperimentReportState)}.
         * 
         * @param state
         *        a consumer that will call methods on {@link ExperimentReportState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #state(ExperimentReportState)
         */
        default Builder state(Consumer<ExperimentReportState.Builder> state) {
            return state(ExperimentReportState.builder().applyMutation(state).build());
        }

        /**
         * <p>
         * The S3 destination of the experiment report.
         * </p>
         * 
         * @param s3Reports
         *        The S3 destination of the experiment report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Reports(Collection<ExperimentReportS3Report> s3Reports);

        /**
         * <p>
         * The S3 destination of the experiment report.
         * </p>
         * 
         * @param s3Reports
         *        The S3 destination of the experiment report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Reports(ExperimentReportS3Report... s3Reports);

        /**
         * <p>
         * The S3 destination of the experiment report.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.fis.model.ExperimentReportS3Report.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.fis.model.ExperimentReportS3Report#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.fis.model.ExperimentReportS3Report.Builder#build()} is called
         * immediately and its result is passed to {@link #s3Reports(List<ExperimentReportS3Report>)}.
         * 
         * @param s3Reports
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.fis.model.ExperimentReportS3Report.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Reports(java.util.Collection<ExperimentReportS3Report>)
         */
        Builder s3Reports(Consumer<ExperimentReportS3Report.Builder>... s3Reports);
    }

    static final class BuilderImpl implements Builder {
        private ExperimentReportState state;

        private List<ExperimentReportS3Report> s3Reports = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExperimentReport model) {
            state(model.state);
            s3Reports(model.s3Reports);
        }

        public final ExperimentReportState.Builder getState() {
            return state != null ? state.toBuilder() : null;
        }

        public final void setState(ExperimentReportState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        public final Builder state(ExperimentReportState state) {
            this.state = state;
            return this;
        }

        public final List<ExperimentReportS3Report.Builder> getS3Reports() {
            List<ExperimentReportS3Report.Builder> result = ExperimentReportS3ReportListCopier.copyToBuilder(this.s3Reports);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setS3Reports(Collection<ExperimentReportS3Report.BuilderImpl> s3Reports) {
            this.s3Reports = ExperimentReportS3ReportListCopier.copyFromBuilder(s3Reports);
        }

        @Override
        public final Builder s3Reports(Collection<ExperimentReportS3Report> s3Reports) {
            this.s3Reports = ExperimentReportS3ReportListCopier.copy(s3Reports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3Reports(ExperimentReportS3Report... s3Reports) {
            s3Reports(Arrays.asList(s3Reports));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3Reports(Consumer<ExperimentReportS3Report.Builder>... s3Reports) {
            s3Reports(Stream.of(s3Reports).map(c -> ExperimentReportS3Report.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ExperimentReport build() {
            return new ExperimentReport(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
