/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fis.model.FisRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListExperimentTargetAccountConfigurationsRequest
extends FisRequest
implements ToCopyableBuilder<Builder, ListExperimentTargetAccountConfigurationsRequest> {
    private static final SdkField<String> EXPERIMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("experimentId").getter(ListExperimentTargetAccountConfigurationsRequest.getter(ListExperimentTargetAccountConfigurationsRequest::experimentId)).setter(ListExperimentTargetAccountConfigurationsRequest.setter(Builder::experimentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListExperimentTargetAccountConfigurationsRequest.getter(ListExperimentTargetAccountConfigurationsRequest::nextToken)).setter(ListExperimentTargetAccountConfigurationsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPERIMENT_ID_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("id", EXPERIMENT_ID_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final String experimentId;
    private final String nextToken;

    private ListExperimentTargetAccountConfigurationsRequest(BuilderImpl builder) {
        super(builder);
        this.experimentId = builder.experimentId;
        this.nextToken = builder.nextToken;
    }

    public final String experimentId() {
        return this.experimentId;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.experimentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListExperimentTargetAccountConfigurationsRequest)) {
            return false;
        }
        ListExperimentTargetAccountConfigurationsRequest other = (ListExperimentTargetAccountConfigurationsRequest)((Object)obj);
        return Objects.equals(this.experimentId(), other.experimentId()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListExperimentTargetAccountConfigurationsRequest").add("ExperimentId", (Object)this.experimentId()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "experimentId": {
                return Optional.ofNullable(clazz.cast(this.experimentId()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListExperimentTargetAccountConfigurationsRequest, T> g) {
        return obj -> g.apply((ListExperimentTargetAccountConfigurationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FisRequest.BuilderImpl
    implements Builder {
        private String experimentId;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListExperimentTargetAccountConfigurationsRequest model) {
            super(model);
            this.experimentId(model.experimentId);
            this.nextToken(model.nextToken);
        }

        public final String getExperimentId() {
            return this.experimentId;
        }

        public final void setExperimentId(String experimentId) {
            this.experimentId = experimentId;
        }

        @Override
        public final Builder experimentId(String experimentId) {
            this.experimentId = experimentId;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListExperimentTargetAccountConfigurationsRequest build() {
            return new ListExperimentTargetAccountConfigurationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FisRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListExperimentTargetAccountConfigurationsRequest> {
        public Builder experimentId(String var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

