/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Optionally configure a Snowflake role. Otherwise the default user role will be used.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SnowflakeRoleConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SnowflakeRoleConfiguration.Builder, SnowflakeRoleConfiguration> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(SnowflakeRoleConfiguration::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<String> SNOWFLAKE_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnowflakeRole").getter(getter(SnowflakeRoleConfiguration::snowflakeRole))
            .setter(setter(Builder::snowflakeRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnowflakeRole").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            SNOWFLAKE_ROLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final String snowflakeRole;

    private SnowflakeRoleConfiguration(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.snowflakeRole = builder.snowflakeRole;
    }

    /**
     * <p>
     * Enable Snowflake role
     * </p>
     * 
     * @return Enable Snowflake role
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The Snowflake role you wish to configure
     * </p>
     * 
     * @return The Snowflake role you wish to configure
     */
    public final String snowflakeRole() {
        return snowflakeRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(snowflakeRole());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnowflakeRoleConfiguration)) {
            return false;
        }
        SnowflakeRoleConfiguration other = (SnowflakeRoleConfiguration) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(snowflakeRole(), other.snowflakeRole());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SnowflakeRoleConfiguration").add("Enabled", enabled())
                .add("SnowflakeRole", snowflakeRole() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "SnowflakeRole":
            return Optional.ofNullable(clazz.cast(snowflakeRole()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Enabled", ENABLED_FIELD);
        map.put("SnowflakeRole", SNOWFLAKE_ROLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SnowflakeRoleConfiguration, T> g) {
        return obj -> g.apply((SnowflakeRoleConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SnowflakeRoleConfiguration> {
        /**
         * <p>
         * Enable Snowflake role
         * </p>
         * 
         * @param enabled
         *        Enable Snowflake role
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The Snowflake role you wish to configure
         * </p>
         * 
         * @param snowflakeRole
         *        The Snowflake role you wish to configure
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snowflakeRole(String snowflakeRole);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private String snowflakeRole;

        private BuilderImpl() {
        }

        private BuilderImpl(SnowflakeRoleConfiguration model) {
            enabled(model.enabled);
            snowflakeRole(model.snowflakeRole);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getSnowflakeRole() {
            return snowflakeRole;
        }

        public final void setSnowflakeRole(String snowflakeRole) {
            this.snowflakeRole = snowflakeRole;
        }

        @Override
        public final Builder snowflakeRole(String snowflakeRole) {
            this.snowflakeRole = snowflakeRole;
            return this;
        }

        @Override
        public SnowflakeRoleConfiguration build() {
            return new SnowflakeRoleConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
