/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Updates the specified HTTP endpoint destination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HttpEndpointDestinationUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<HttpEndpointDestinationUpdate.Builder, HttpEndpointDestinationUpdate> {
    private static final SdkField<HttpEndpointConfiguration> ENDPOINT_CONFIGURATION_FIELD = SdkField
            .<HttpEndpointConfiguration> builder(MarshallingType.SDK_POJO).memberName("EndpointConfiguration")
            .getter(getter(HttpEndpointDestinationUpdate::endpointConfiguration)).setter(setter(Builder::endpointConfiguration))
            .constructor(HttpEndpointConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointConfiguration").build())
            .build();

    private static final SdkField<HttpEndpointBufferingHints> BUFFERING_HINTS_FIELD = SdkField
            .<HttpEndpointBufferingHints> builder(MarshallingType.SDK_POJO).memberName("BufferingHints")
            .getter(getter(HttpEndpointDestinationUpdate::bufferingHints)).setter(setter(Builder::bufferingHints))
            .constructor(HttpEndpointBufferingHints::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BufferingHints").build()).build();

    private static final SdkField<CloudWatchLoggingOptions> CLOUD_WATCH_LOGGING_OPTIONS_FIELD = SdkField
            .<CloudWatchLoggingOptions> builder(MarshallingType.SDK_POJO).memberName("CloudWatchLoggingOptions")
            .getter(getter(HttpEndpointDestinationUpdate::cloudWatchLoggingOptions))
            .setter(setter(Builder::cloudWatchLoggingOptions)).constructor(CloudWatchLoggingOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLoggingOptions").build())
            .build();

    private static final SdkField<HttpEndpointRequestConfiguration> REQUEST_CONFIGURATION_FIELD = SdkField
            .<HttpEndpointRequestConfiguration> builder(MarshallingType.SDK_POJO).memberName("RequestConfiguration")
            .getter(getter(HttpEndpointDestinationUpdate::requestConfiguration)).setter(setter(Builder::requestConfiguration))
            .constructor(HttpEndpointRequestConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestConfiguration").build())
            .build();

    private static final SdkField<ProcessingConfiguration> PROCESSING_CONFIGURATION_FIELD = SdkField
            .<ProcessingConfiguration> builder(MarshallingType.SDK_POJO).memberName("ProcessingConfiguration")
            .getter(getter(HttpEndpointDestinationUpdate::processingConfiguration))
            .setter(setter(Builder::processingConfiguration)).constructor(ProcessingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingConfiguration").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleARN").getter(getter(HttpEndpointDestinationUpdate::roleARN)).setter(setter(Builder::roleARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()).build();

    private static final SdkField<HttpEndpointRetryOptions> RETRY_OPTIONS_FIELD = SdkField
            .<HttpEndpointRetryOptions> builder(MarshallingType.SDK_POJO).memberName("RetryOptions")
            .getter(getter(HttpEndpointDestinationUpdate::retryOptions)).setter(setter(Builder::retryOptions))
            .constructor(HttpEndpointRetryOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryOptions").build()).build();

    private static final SdkField<String> S3_BACKUP_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3BackupMode").getter(getter(HttpEndpointDestinationUpdate::s3BackupModeAsString))
            .setter(setter(Builder::s3BackupMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BackupMode").build()).build();

    private static final SdkField<S3DestinationUpdate> S3_UPDATE_FIELD = SdkField
            .<S3DestinationUpdate> builder(MarshallingType.SDK_POJO).memberName("S3Update")
            .getter(getter(HttpEndpointDestinationUpdate::s3Update)).setter(setter(Builder::s3Update))
            .constructor(S3DestinationUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Update").build()).build();

    private static final SdkField<SecretsManagerConfiguration> SECRETS_MANAGER_CONFIGURATION_FIELD = SdkField
            .<SecretsManagerConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("SecretsManagerConfiguration")
            .getter(getter(HttpEndpointDestinationUpdate::secretsManagerConfiguration))
            .setter(setter(Builder::secretsManagerConfiguration))
            .constructor(SecretsManagerConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManagerConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_CONFIGURATION_FIELD,
            BUFFERING_HINTS_FIELD, CLOUD_WATCH_LOGGING_OPTIONS_FIELD, REQUEST_CONFIGURATION_FIELD,
            PROCESSING_CONFIGURATION_FIELD, ROLE_ARN_FIELD, RETRY_OPTIONS_FIELD, S3_BACKUP_MODE_FIELD, S3_UPDATE_FIELD,
            SECRETS_MANAGER_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final HttpEndpointConfiguration endpointConfiguration;

    private final HttpEndpointBufferingHints bufferingHints;

    private final CloudWatchLoggingOptions cloudWatchLoggingOptions;

    private final HttpEndpointRequestConfiguration requestConfiguration;

    private final ProcessingConfiguration processingConfiguration;

    private final String roleARN;

    private final HttpEndpointRetryOptions retryOptions;

    private final String s3BackupMode;

    private final S3DestinationUpdate s3Update;

    private final SecretsManagerConfiguration secretsManagerConfiguration;

    private HttpEndpointDestinationUpdate(BuilderImpl builder) {
        this.endpointConfiguration = builder.endpointConfiguration;
        this.bufferingHints = builder.bufferingHints;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
        this.requestConfiguration = builder.requestConfiguration;
        this.processingConfiguration = builder.processingConfiguration;
        this.roleARN = builder.roleARN;
        this.retryOptions = builder.retryOptions;
        this.s3BackupMode = builder.s3BackupMode;
        this.s3Update = builder.s3Update;
        this.secretsManagerConfiguration = builder.secretsManagerConfiguration;
    }

    /**
     * <p>
     * Describes the configuration of the HTTP endpoint destination.
     * </p>
     * 
     * @return Describes the configuration of the HTTP endpoint destination.
     */
    public final HttpEndpointConfiguration endpointConfiguration() {
        return endpointConfiguration;
    }

    /**
     * <p>
     * Describes buffering options that can be applied to the data before it is delivered to the HTTPS endpoint
     * destination. Firehose teats these options as hints, and it might choose to use more optimal values. The
     * <code>SizeInMBs</code> and <code>IntervalInSeconds</code> parameters are optional. However, if specify a value
     * for one of them, you must also provide a value for the other.
     * </p>
     * 
     * @return Describes buffering options that can be applied to the data before it is delivered to the HTTPS endpoint
     *         destination. Firehose teats these options as hints, and it might choose to use more optimal values. The
     *         <code>SizeInMBs</code> and <code>IntervalInSeconds</code> parameters are optional. However, if specify a
     *         value for one of them, you must also provide a value for the other.
     */
    public final HttpEndpointBufferingHints bufferingHints() {
        return bufferingHints;
    }

    /**
     * Returns the value of the CloudWatchLoggingOptions property for this object.
     * 
     * @return The value of the CloudWatchLoggingOptions property for this object.
     */
    public final CloudWatchLoggingOptions cloudWatchLoggingOptions() {
        return cloudWatchLoggingOptions;
    }

    /**
     * <p>
     * The configuration of the request sent to the HTTP endpoint specified as the destination.
     * </p>
     * 
     * @return The configuration of the request sent to the HTTP endpoint specified as the destination.
     */
    public final HttpEndpointRequestConfiguration requestConfiguration() {
        return requestConfiguration;
    }

    /**
     * Returns the value of the ProcessingConfiguration property for this object.
     * 
     * @return The value of the ProcessingConfiguration property for this object.
     */
    public final ProcessingConfiguration processingConfiguration() {
        return processingConfiguration;
    }

    /**
     * <p>
     * Firehose uses this IAM role for all the permissions that the delivery stream needs.
     * </p>
     * 
     * @return Firehose uses this IAM role for all the permissions that the delivery stream needs.
     */
    public final String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * Describes the retry behavior in case Firehose is unable to deliver data to the specified HTTP endpoint
     * destination, or if it doesn't receive a valid acknowledgment of receipt from the specified HTTP endpoint
     * destination.
     * </p>
     * 
     * @return Describes the retry behavior in case Firehose is unable to deliver data to the specified HTTP endpoint
     *         destination, or if it doesn't receive a valid acknowledgment of receipt from the specified HTTP endpoint
     *         destination.
     */
    public final HttpEndpointRetryOptions retryOptions() {
        return retryOptions;
    }

    /**
     * <p>
     * Describes the S3 bucket backup options for the data that Kinesis Firehose delivers to the HTTP endpoint
     * destination. You can back up all documents (<code>AllData</code>) or only the documents that Firehose could not
     * deliver to the specified HTTP endpoint destination (<code>FailedDataOnly</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3BackupMode} will
     * return {@link HttpEndpointS3BackupMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #s3BackupModeAsString}.
     * </p>
     * 
     * @return Describes the S3 bucket backup options for the data that Kinesis Firehose delivers to the HTTP endpoint
     *         destination. You can back up all documents (<code>AllData</code>) or only the documents that Firehose
     *         could not deliver to the specified HTTP endpoint destination (<code>FailedDataOnly</code>).
     * @see HttpEndpointS3BackupMode
     */
    public final HttpEndpointS3BackupMode s3BackupMode() {
        return HttpEndpointS3BackupMode.fromValue(s3BackupMode);
    }

    /**
     * <p>
     * Describes the S3 bucket backup options for the data that Kinesis Firehose delivers to the HTTP endpoint
     * destination. You can back up all documents (<code>AllData</code>) or only the documents that Firehose could not
     * deliver to the specified HTTP endpoint destination (<code>FailedDataOnly</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3BackupMode} will
     * return {@link HttpEndpointS3BackupMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #s3BackupModeAsString}.
     * </p>
     * 
     * @return Describes the S3 bucket backup options for the data that Kinesis Firehose delivers to the HTTP endpoint
     *         destination. You can back up all documents (<code>AllData</code>) or only the documents that Firehose
     *         could not deliver to the specified HTTP endpoint destination (<code>FailedDataOnly</code>).
     * @see HttpEndpointS3BackupMode
     */
    public final String s3BackupModeAsString() {
        return s3BackupMode;
    }

    /**
     * Returns the value of the S3Update property for this object.
     * 
     * @return The value of the S3Update property for this object.
     */
    public final S3DestinationUpdate s3Update() {
        return s3Update;
    }

    /**
     * <p>
     * The configuration that defines how you access secrets for HTTP Endpoint destination.
     * </p>
     * 
     * @return The configuration that defines how you access secrets for HTTP Endpoint destination.
     */
    public final SecretsManagerConfiguration secretsManagerConfiguration() {
        return secretsManagerConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endpointConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(bufferingHints());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLoggingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(requestConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(processingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(retryOptions());
        hashCode = 31 * hashCode + Objects.hashCode(s3BackupModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3Update());
        hashCode = 31 * hashCode + Objects.hashCode(secretsManagerConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpEndpointDestinationUpdate)) {
            return false;
        }
        HttpEndpointDestinationUpdate other = (HttpEndpointDestinationUpdate) obj;
        return Objects.equals(endpointConfiguration(), other.endpointConfiguration())
                && Objects.equals(bufferingHints(), other.bufferingHints())
                && Objects.equals(cloudWatchLoggingOptions(), other.cloudWatchLoggingOptions())
                && Objects.equals(requestConfiguration(), other.requestConfiguration())
                && Objects.equals(processingConfiguration(), other.processingConfiguration())
                && Objects.equals(roleARN(), other.roleARN()) && Objects.equals(retryOptions(), other.retryOptions())
                && Objects.equals(s3BackupModeAsString(), other.s3BackupModeAsString())
                && Objects.equals(s3Update(), other.s3Update())
                && Objects.equals(secretsManagerConfiguration(), other.secretsManagerConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HttpEndpointDestinationUpdate").add("EndpointConfiguration", endpointConfiguration())
                .add("BufferingHints", bufferingHints()).add("CloudWatchLoggingOptions", cloudWatchLoggingOptions())
                .add("RequestConfiguration", requestConfiguration()).add("ProcessingConfiguration", processingConfiguration())
                .add("RoleARN", roleARN()).add("RetryOptions", retryOptions()).add("S3BackupMode", s3BackupModeAsString())
                .add("S3Update", s3Update()).add("SecretsManagerConfiguration", secretsManagerConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointConfiguration":
            return Optional.ofNullable(clazz.cast(endpointConfiguration()));
        case "BufferingHints":
            return Optional.ofNullable(clazz.cast(bufferingHints()));
        case "CloudWatchLoggingOptions":
            return Optional.ofNullable(clazz.cast(cloudWatchLoggingOptions()));
        case "RequestConfiguration":
            return Optional.ofNullable(clazz.cast(requestConfiguration()));
        case "ProcessingConfiguration":
            return Optional.ofNullable(clazz.cast(processingConfiguration()));
        case "RoleARN":
            return Optional.ofNullable(clazz.cast(roleARN()));
        case "RetryOptions":
            return Optional.ofNullable(clazz.cast(retryOptions()));
        case "S3BackupMode":
            return Optional.ofNullable(clazz.cast(s3BackupModeAsString()));
        case "S3Update":
            return Optional.ofNullable(clazz.cast(s3Update()));
        case "SecretsManagerConfiguration":
            return Optional.ofNullable(clazz.cast(secretsManagerConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EndpointConfiguration", ENDPOINT_CONFIGURATION_FIELD);
        map.put("BufferingHints", BUFFERING_HINTS_FIELD);
        map.put("CloudWatchLoggingOptions", CLOUD_WATCH_LOGGING_OPTIONS_FIELD);
        map.put("RequestConfiguration", REQUEST_CONFIGURATION_FIELD);
        map.put("ProcessingConfiguration", PROCESSING_CONFIGURATION_FIELD);
        map.put("RoleARN", ROLE_ARN_FIELD);
        map.put("RetryOptions", RETRY_OPTIONS_FIELD);
        map.put("S3BackupMode", S3_BACKUP_MODE_FIELD);
        map.put("S3Update", S3_UPDATE_FIELD);
        map.put("SecretsManagerConfiguration", SECRETS_MANAGER_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HttpEndpointDestinationUpdate, T> g) {
        return obj -> g.apply((HttpEndpointDestinationUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HttpEndpointDestinationUpdate> {
        /**
         * <p>
         * Describes the configuration of the HTTP endpoint destination.
         * </p>
         * 
         * @param endpointConfiguration
         *        Describes the configuration of the HTTP endpoint destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointConfiguration(HttpEndpointConfiguration endpointConfiguration);

        /**
         * <p>
         * Describes the configuration of the HTTP endpoint destination.
         * </p>
         * This is a convenience method that creates an instance of the {@link HttpEndpointConfiguration.Builder}
         * avoiding the need to create one manually via {@link HttpEndpointConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HttpEndpointConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #endpointConfiguration(HttpEndpointConfiguration)}.
         * 
         * @param endpointConfiguration
         *        a consumer that will call methods on {@link HttpEndpointConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointConfiguration(HttpEndpointConfiguration)
         */
        default Builder endpointConfiguration(Consumer<HttpEndpointConfiguration.Builder> endpointConfiguration) {
            return endpointConfiguration(HttpEndpointConfiguration.builder().applyMutation(endpointConfiguration).build());
        }

        /**
         * <p>
         * Describes buffering options that can be applied to the data before it is delivered to the HTTPS endpoint
         * destination. Firehose teats these options as hints, and it might choose to use more optimal values. The
         * <code>SizeInMBs</code> and <code>IntervalInSeconds</code> parameters are optional. However, if specify a
         * value for one of them, you must also provide a value for the other.
         * </p>
         * 
         * @param bufferingHints
         *        Describes buffering options that can be applied to the data before it is delivered to the HTTPS
         *        endpoint destination. Firehose teats these options as hints, and it might choose to use more optimal
         *        values. The <code>SizeInMBs</code> and <code>IntervalInSeconds</code> parameters are optional.
         *        However, if specify a value for one of them, you must also provide a value for the other.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bufferingHints(HttpEndpointBufferingHints bufferingHints);

        /**
         * <p>
         * Describes buffering options that can be applied to the data before it is delivered to the HTTPS endpoint
         * destination. Firehose teats these options as hints, and it might choose to use more optimal values. The
         * <code>SizeInMBs</code> and <code>IntervalInSeconds</code> parameters are optional. However, if specify a
         * value for one of them, you must also provide a value for the other.
         * </p>
         * This is a convenience method that creates an instance of the {@link HttpEndpointBufferingHints.Builder}
         * avoiding the need to create one manually via {@link HttpEndpointBufferingHints#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HttpEndpointBufferingHints.Builder#build()} is called immediately
         * and its result is passed to {@link #bufferingHints(HttpEndpointBufferingHints)}.
         * 
         * @param bufferingHints
         *        a consumer that will call methods on {@link HttpEndpointBufferingHints.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bufferingHints(HttpEndpointBufferingHints)
         */
        default Builder bufferingHints(Consumer<HttpEndpointBufferingHints.Builder> bufferingHints) {
            return bufferingHints(HttpEndpointBufferingHints.builder().applyMutation(bufferingHints).build());
        }

        /**
         * Sets the value of the CloudWatchLoggingOptions property for this object.
         *
         * @param cloudWatchLoggingOptions
         *        The new value for the CloudWatchLoggingOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions);

        /**
         * Sets the value of the CloudWatchLoggingOptions property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CloudWatchLoggingOptions.Builder}
         * avoiding the need to create one manually via {@link CloudWatchLoggingOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudWatchLoggingOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #cloudWatchLoggingOptions(CloudWatchLoggingOptions)}.
         * 
         * @param cloudWatchLoggingOptions
         *        a consumer that will call methods on {@link CloudWatchLoggingOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLoggingOptions(CloudWatchLoggingOptions)
         */
        default Builder cloudWatchLoggingOptions(Consumer<CloudWatchLoggingOptions.Builder> cloudWatchLoggingOptions) {
            return cloudWatchLoggingOptions(CloudWatchLoggingOptions.builder().applyMutation(cloudWatchLoggingOptions).build());
        }

        /**
         * <p>
         * The configuration of the request sent to the HTTP endpoint specified as the destination.
         * </p>
         * 
         * @param requestConfiguration
         *        The configuration of the request sent to the HTTP endpoint specified as the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestConfiguration(HttpEndpointRequestConfiguration requestConfiguration);

        /**
         * <p>
         * The configuration of the request sent to the HTTP endpoint specified as the destination.
         * </p>
         * This is a convenience method that creates an instance of the {@link HttpEndpointRequestConfiguration.Builder}
         * avoiding the need to create one manually via {@link HttpEndpointRequestConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HttpEndpointRequestConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #requestConfiguration(HttpEndpointRequestConfiguration)}.
         * 
         * @param requestConfiguration
         *        a consumer that will call methods on {@link HttpEndpointRequestConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #requestConfiguration(HttpEndpointRequestConfiguration)
         */
        default Builder requestConfiguration(Consumer<HttpEndpointRequestConfiguration.Builder> requestConfiguration) {
            return requestConfiguration(HttpEndpointRequestConfiguration.builder().applyMutation(requestConfiguration).build());
        }

        /**
         * Sets the value of the ProcessingConfiguration property for this object.
         *
         * @param processingConfiguration
         *        The new value for the ProcessingConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingConfiguration(ProcessingConfiguration processingConfiguration);

        /**
         * Sets the value of the ProcessingConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ProcessingConfiguration.Builder} avoiding
         * the need to create one manually via {@link ProcessingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProcessingConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #processingConfiguration(ProcessingConfiguration)}.
         * 
         * @param processingConfiguration
         *        a consumer that will call methods on {@link ProcessingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processingConfiguration(ProcessingConfiguration)
         */
        default Builder processingConfiguration(Consumer<ProcessingConfiguration.Builder> processingConfiguration) {
            return processingConfiguration(ProcessingConfiguration.builder().applyMutation(processingConfiguration).build());
        }

        /**
         * <p>
         * Firehose uses this IAM role for all the permissions that the delivery stream needs.
         * </p>
         * 
         * @param roleARN
         *        Firehose uses this IAM role for all the permissions that the delivery stream needs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * Describes the retry behavior in case Firehose is unable to deliver data to the specified HTTP endpoint
         * destination, or if it doesn't receive a valid acknowledgment of receipt from the specified HTTP endpoint
         * destination.
         * </p>
         * 
         * @param retryOptions
         *        Describes the retry behavior in case Firehose is unable to deliver data to the specified HTTP endpoint
         *        destination, or if it doesn't receive a valid acknowledgment of receipt from the specified HTTP
         *        endpoint destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryOptions(HttpEndpointRetryOptions retryOptions);

        /**
         * <p>
         * Describes the retry behavior in case Firehose is unable to deliver data to the specified HTTP endpoint
         * destination, or if it doesn't receive a valid acknowledgment of receipt from the specified HTTP endpoint
         * destination.
         * </p>
         * This is a convenience method that creates an instance of the {@link HttpEndpointRetryOptions.Builder}
         * avoiding the need to create one manually via {@link HttpEndpointRetryOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HttpEndpointRetryOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #retryOptions(HttpEndpointRetryOptions)}.
         * 
         * @param retryOptions
         *        a consumer that will call methods on {@link HttpEndpointRetryOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retryOptions(HttpEndpointRetryOptions)
         */
        default Builder retryOptions(Consumer<HttpEndpointRetryOptions.Builder> retryOptions) {
            return retryOptions(HttpEndpointRetryOptions.builder().applyMutation(retryOptions).build());
        }

        /**
         * <p>
         * Describes the S3 bucket backup options for the data that Kinesis Firehose delivers to the HTTP endpoint
         * destination. You can back up all documents (<code>AllData</code>) or only the documents that Firehose could
         * not deliver to the specified HTTP endpoint destination (<code>FailedDataOnly</code>).
         * </p>
         * 
         * @param s3BackupMode
         *        Describes the S3 bucket backup options for the data that Kinesis Firehose delivers to the HTTP
         *        endpoint destination. You can back up all documents (<code>AllData</code>) or only the documents that
         *        Firehose could not deliver to the specified HTTP endpoint destination (<code>FailedDataOnly</code>).
         * @see HttpEndpointS3BackupMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HttpEndpointS3BackupMode
         */
        Builder s3BackupMode(String s3BackupMode);

        /**
         * <p>
         * Describes the S3 bucket backup options for the data that Kinesis Firehose delivers to the HTTP endpoint
         * destination. You can back up all documents (<code>AllData</code>) or only the documents that Firehose could
         * not deliver to the specified HTTP endpoint destination (<code>FailedDataOnly</code>).
         * </p>
         * 
         * @param s3BackupMode
         *        Describes the S3 bucket backup options for the data that Kinesis Firehose delivers to the HTTP
         *        endpoint destination. You can back up all documents (<code>AllData</code>) or only the documents that
         *        Firehose could not deliver to the specified HTTP endpoint destination (<code>FailedDataOnly</code>).
         * @see HttpEndpointS3BackupMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HttpEndpointS3BackupMode
         */
        Builder s3BackupMode(HttpEndpointS3BackupMode s3BackupMode);

        /**
         * Sets the value of the S3Update property for this object.
         *
         * @param s3Update
         *        The new value for the S3Update property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Update(S3DestinationUpdate s3Update);

        /**
         * Sets the value of the S3Update property for this object.
         *
         * This is a convenience method that creates an instance of the {@link S3DestinationUpdate.Builder} avoiding the
         * need to create one manually via {@link S3DestinationUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3DestinationUpdate.Builder#build()} is called immediately and
         * its result is passed to {@link #s3Update(S3DestinationUpdate)}.
         * 
         * @param s3Update
         *        a consumer that will call methods on {@link S3DestinationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Update(S3DestinationUpdate)
         */
        default Builder s3Update(Consumer<S3DestinationUpdate.Builder> s3Update) {
            return s3Update(S3DestinationUpdate.builder().applyMutation(s3Update).build());
        }

        /**
         * <p>
         * The configuration that defines how you access secrets for HTTP Endpoint destination.
         * </p>
         * 
         * @param secretsManagerConfiguration
         *        The configuration that defines how you access secrets for HTTP Endpoint destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretsManagerConfiguration(SecretsManagerConfiguration secretsManagerConfiguration);

        /**
         * <p>
         * The configuration that defines how you access secrets for HTTP Endpoint destination.
         * </p>
         * This is a convenience method that creates an instance of the {@link SecretsManagerConfiguration.Builder}
         * avoiding the need to create one manually via {@link SecretsManagerConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SecretsManagerConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #secretsManagerConfiguration(SecretsManagerConfiguration)}.
         * 
         * @param secretsManagerConfiguration
         *        a consumer that will call methods on {@link SecretsManagerConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secretsManagerConfiguration(SecretsManagerConfiguration)
         */
        default Builder secretsManagerConfiguration(Consumer<SecretsManagerConfiguration.Builder> secretsManagerConfiguration) {
            return secretsManagerConfiguration(SecretsManagerConfiguration.builder().applyMutation(secretsManagerConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private HttpEndpointConfiguration endpointConfiguration;

        private HttpEndpointBufferingHints bufferingHints;

        private CloudWatchLoggingOptions cloudWatchLoggingOptions;

        private HttpEndpointRequestConfiguration requestConfiguration;

        private ProcessingConfiguration processingConfiguration;

        private String roleARN;

        private HttpEndpointRetryOptions retryOptions;

        private String s3BackupMode;

        private S3DestinationUpdate s3Update;

        private SecretsManagerConfiguration secretsManagerConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(HttpEndpointDestinationUpdate model) {
            endpointConfiguration(model.endpointConfiguration);
            bufferingHints(model.bufferingHints);
            cloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
            requestConfiguration(model.requestConfiguration);
            processingConfiguration(model.processingConfiguration);
            roleARN(model.roleARN);
            retryOptions(model.retryOptions);
            s3BackupMode(model.s3BackupMode);
            s3Update(model.s3Update);
            secretsManagerConfiguration(model.secretsManagerConfiguration);
        }

        public final HttpEndpointConfiguration.Builder getEndpointConfiguration() {
            return endpointConfiguration != null ? endpointConfiguration.toBuilder() : null;
        }

        public final void setEndpointConfiguration(HttpEndpointConfiguration.BuilderImpl endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration != null ? endpointConfiguration.build() : null;
        }

        @Override
        public final Builder endpointConfiguration(HttpEndpointConfiguration endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration;
            return this;
        }

        public final HttpEndpointBufferingHints.Builder getBufferingHints() {
            return bufferingHints != null ? bufferingHints.toBuilder() : null;
        }

        public final void setBufferingHints(HttpEndpointBufferingHints.BuilderImpl bufferingHints) {
            this.bufferingHints = bufferingHints != null ? bufferingHints.build() : null;
        }

        @Override
        public final Builder bufferingHints(HttpEndpointBufferingHints bufferingHints) {
            this.bufferingHints = bufferingHints;
            return this;
        }

        public final CloudWatchLoggingOptions.Builder getCloudWatchLoggingOptions() {
            return cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.toBuilder() : null;
        }

        public final void setCloudWatchLoggingOptions(CloudWatchLoggingOptions.BuilderImpl cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.build() : null;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
            return this;
        }

        public final HttpEndpointRequestConfiguration.Builder getRequestConfiguration() {
            return requestConfiguration != null ? requestConfiguration.toBuilder() : null;
        }

        public final void setRequestConfiguration(HttpEndpointRequestConfiguration.BuilderImpl requestConfiguration) {
            this.requestConfiguration = requestConfiguration != null ? requestConfiguration.build() : null;
        }

        @Override
        public final Builder requestConfiguration(HttpEndpointRequestConfiguration requestConfiguration) {
            this.requestConfiguration = requestConfiguration;
            return this;
        }

        public final ProcessingConfiguration.Builder getProcessingConfiguration() {
            return processingConfiguration != null ? processingConfiguration.toBuilder() : null;
        }

        public final void setProcessingConfiguration(ProcessingConfiguration.BuilderImpl processingConfiguration) {
            this.processingConfiguration = processingConfiguration != null ? processingConfiguration.build() : null;
        }

        @Override
        public final Builder processingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
            return this;
        }

        public final String getRoleARN() {
            return roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final HttpEndpointRetryOptions.Builder getRetryOptions() {
            return retryOptions != null ? retryOptions.toBuilder() : null;
        }

        public final void setRetryOptions(HttpEndpointRetryOptions.BuilderImpl retryOptions) {
            this.retryOptions = retryOptions != null ? retryOptions.build() : null;
        }

        @Override
        public final Builder retryOptions(HttpEndpointRetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public final String getS3BackupMode() {
            return s3BackupMode;
        }

        public final void setS3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
        }

        @Override
        public final Builder s3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
            return this;
        }

        @Override
        public final Builder s3BackupMode(HttpEndpointS3BackupMode s3BackupMode) {
            this.s3BackupMode(s3BackupMode == null ? null : s3BackupMode.toString());
            return this;
        }

        public final S3DestinationUpdate.Builder getS3Update() {
            return s3Update != null ? s3Update.toBuilder() : null;
        }

        public final void setS3Update(S3DestinationUpdate.BuilderImpl s3Update) {
            this.s3Update = s3Update != null ? s3Update.build() : null;
        }

        @Override
        public final Builder s3Update(S3DestinationUpdate s3Update) {
            this.s3Update = s3Update;
            return this;
        }

        public final SecretsManagerConfiguration.Builder getSecretsManagerConfiguration() {
            return secretsManagerConfiguration != null ? secretsManagerConfiguration.toBuilder() : null;
        }

        public final void setSecretsManagerConfiguration(SecretsManagerConfiguration.BuilderImpl secretsManagerConfiguration) {
            this.secretsManagerConfiguration = secretsManagerConfiguration != null ? secretsManagerConfiguration.build() : null;
        }

        @Override
        public final Builder secretsManagerConfiguration(SecretsManagerConfiguration secretsManagerConfiguration) {
            this.secretsManagerConfiguration = secretsManagerConfiguration;
            return this;
        }

        @Override
        public HttpEndpointDestinationUpdate build() {
            return new HttpEndpointDestinationUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
