/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDeliveryStreamResponse extends FirehoseResponse implements
        ToCopyableBuilder<DescribeDeliveryStreamResponse.Builder, DescribeDeliveryStreamResponse> {
    private static final SdkField<DeliveryStreamDescription> DELIVERY_STREAM_DESCRIPTION_FIELD = SdkField
            .<DeliveryStreamDescription> builder(MarshallingType.SDK_POJO).memberName("DeliveryStreamDescription")
            .getter(getter(DescribeDeliveryStreamResponse::deliveryStreamDescription))
            .setter(setter(Builder::deliveryStreamDescription)).constructor(DeliveryStreamDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryStreamDescription").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DELIVERY_STREAM_DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final DeliveryStreamDescription deliveryStreamDescription;

    private DescribeDeliveryStreamResponse(BuilderImpl builder) {
        super(builder);
        this.deliveryStreamDescription = builder.deliveryStreamDescription;
    }

    /**
     * <p>
     * Information about the Firehose stream.
     * </p>
     * 
     * @return Information about the Firehose stream.
     */
    public final DeliveryStreamDescription deliveryStreamDescription() {
        return deliveryStreamDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deliveryStreamDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeliveryStreamResponse)) {
            return false;
        }
        DescribeDeliveryStreamResponse other = (DescribeDeliveryStreamResponse) obj;
        return Objects.equals(deliveryStreamDescription(), other.deliveryStreamDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDeliveryStreamResponse").add("DeliveryStreamDescription", deliveryStreamDescription())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeliveryStreamDescription":
            return Optional.ofNullable(clazz.cast(deliveryStreamDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DeliveryStreamDescription", DELIVERY_STREAM_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDeliveryStreamResponse, T> g) {
        return obj -> g.apply((DescribeDeliveryStreamResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends FirehoseResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDeliveryStreamResponse> {
        /**
         * <p>
         * Information about the Firehose stream.
         * </p>
         * 
         * @param deliveryStreamDescription
         *        Information about the Firehose stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryStreamDescription(DeliveryStreamDescription deliveryStreamDescription);

        /**
         * <p>
         * Information about the Firehose stream.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeliveryStreamDescription.Builder}
         * avoiding the need to create one manually via {@link DeliveryStreamDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeliveryStreamDescription.Builder#build()} is called immediately
         * and its result is passed to {@link #deliveryStreamDescription(DeliveryStreamDescription)}.
         * 
         * @param deliveryStreamDescription
         *        a consumer that will call methods on {@link DeliveryStreamDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deliveryStreamDescription(DeliveryStreamDescription)
         */
        default Builder deliveryStreamDescription(Consumer<DeliveryStreamDescription.Builder> deliveryStreamDescription) {
            return deliveryStreamDescription(DeliveryStreamDescription.builder().applyMutation(deliveryStreamDescription).build());
        }
    }

    static final class BuilderImpl extends FirehoseResponse.BuilderImpl implements Builder {
        private DeliveryStreamDescription deliveryStreamDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeliveryStreamResponse model) {
            super(model);
            deliveryStreamDescription(model.deliveryStreamDescription);
        }

        public final DeliveryStreamDescription.Builder getDeliveryStreamDescription() {
            return deliveryStreamDescription != null ? deliveryStreamDescription.toBuilder() : null;
        }

        public final void setDeliveryStreamDescription(DeliveryStreamDescription.BuilderImpl deliveryStreamDescription) {
            this.deliveryStreamDescription = deliveryStreamDescription != null ? deliveryStreamDescription.build() : null;
        }

        @Override
        public final Builder deliveryStreamDescription(DeliveryStreamDescription deliveryStreamDescription) {
            this.deliveryStreamDescription = deliveryStreamDescription;
            return this;
        }

        @Override
        public DescribeDeliveryStreamResponse build() {
            return new DescribeDeliveryStreamResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
