/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.firehose.model.CloudWatchLoggingOptions;
import software.amazon.awssdk.services.firehose.model.HttpEndpointBufferingHints;
import software.amazon.awssdk.services.firehose.model.HttpEndpointConfiguration;
import software.amazon.awssdk.services.firehose.model.HttpEndpointRequestConfiguration;
import software.amazon.awssdk.services.firehose.model.HttpEndpointRetryOptions;
import software.amazon.awssdk.services.firehose.model.HttpEndpointS3BackupMode;
import software.amazon.awssdk.services.firehose.model.ProcessingConfiguration;
import software.amazon.awssdk.services.firehose.model.S3DestinationUpdate;
import software.amazon.awssdk.services.firehose.model.SecretsManagerConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HttpEndpointDestinationUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HttpEndpointDestinationUpdate> {
    private static final SdkField<HttpEndpointConfiguration> ENDPOINT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EndpointConfiguration").getter(HttpEndpointDestinationUpdate.getter(HttpEndpointDestinationUpdate::endpointConfiguration)).setter(HttpEndpointDestinationUpdate.setter(Builder::endpointConfiguration)).constructor(HttpEndpointConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointConfiguration").build()}).build();
    private static final SdkField<HttpEndpointBufferingHints> BUFFERING_HINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BufferingHints").getter(HttpEndpointDestinationUpdate.getter(HttpEndpointDestinationUpdate::bufferingHints)).setter(HttpEndpointDestinationUpdate.setter(Builder::bufferingHints)).constructor(HttpEndpointBufferingHints::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BufferingHints").build()}).build();
    private static final SdkField<CloudWatchLoggingOptions> CLOUD_WATCH_LOGGING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CloudWatchLoggingOptions").getter(HttpEndpointDestinationUpdate.getter(HttpEndpointDestinationUpdate::cloudWatchLoggingOptions)).setter(HttpEndpointDestinationUpdate.setter(Builder::cloudWatchLoggingOptions)).constructor(CloudWatchLoggingOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLoggingOptions").build()}).build();
    private static final SdkField<HttpEndpointRequestConfiguration> REQUEST_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RequestConfiguration").getter(HttpEndpointDestinationUpdate.getter(HttpEndpointDestinationUpdate::requestConfiguration)).setter(HttpEndpointDestinationUpdate.setter(Builder::requestConfiguration)).constructor(HttpEndpointRequestConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestConfiguration").build()}).build();
    private static final SdkField<ProcessingConfiguration> PROCESSING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProcessingConfiguration").getter(HttpEndpointDestinationUpdate.getter(HttpEndpointDestinationUpdate::processingConfiguration)).setter(HttpEndpointDestinationUpdate.setter(Builder::processingConfiguration)).constructor(ProcessingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingConfiguration").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleARN").getter(HttpEndpointDestinationUpdate.getter(HttpEndpointDestinationUpdate::roleARN)).setter(HttpEndpointDestinationUpdate.setter(Builder::roleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()}).build();
    private static final SdkField<HttpEndpointRetryOptions> RETRY_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RetryOptions").getter(HttpEndpointDestinationUpdate.getter(HttpEndpointDestinationUpdate::retryOptions)).setter(HttpEndpointDestinationUpdate.setter(Builder::retryOptions)).constructor(HttpEndpointRetryOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryOptions").build()}).build();
    private static final SdkField<String> S3_BACKUP_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3BackupMode").getter(HttpEndpointDestinationUpdate.getter(HttpEndpointDestinationUpdate::s3BackupModeAsString)).setter(HttpEndpointDestinationUpdate.setter(Builder::s3BackupMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BackupMode").build()}).build();
    private static final SdkField<S3DestinationUpdate> S3_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3Update").getter(HttpEndpointDestinationUpdate.getter(HttpEndpointDestinationUpdate::s3Update)).setter(HttpEndpointDestinationUpdate.setter(Builder::s3Update)).constructor(S3DestinationUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Update").build()}).build();
    private static final SdkField<SecretsManagerConfiguration> SECRETS_MANAGER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SecretsManagerConfiguration").getter(HttpEndpointDestinationUpdate.getter(HttpEndpointDestinationUpdate::secretsManagerConfiguration)).setter(HttpEndpointDestinationUpdate.setter(Builder::secretsManagerConfiguration)).constructor(SecretsManagerConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManagerConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_CONFIGURATION_FIELD, BUFFERING_HINTS_FIELD, CLOUD_WATCH_LOGGING_OPTIONS_FIELD, REQUEST_CONFIGURATION_FIELD, PROCESSING_CONFIGURATION_FIELD, ROLE_ARN_FIELD, RETRY_OPTIONS_FIELD, S3_BACKUP_MODE_FIELD, S3_UPDATE_FIELD, SECRETS_MANAGER_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = HttpEndpointDestinationUpdate.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final HttpEndpointConfiguration endpointConfiguration;
    private final HttpEndpointBufferingHints bufferingHints;
    private final CloudWatchLoggingOptions cloudWatchLoggingOptions;
    private final HttpEndpointRequestConfiguration requestConfiguration;
    private final ProcessingConfiguration processingConfiguration;
    private final String roleARN;
    private final HttpEndpointRetryOptions retryOptions;
    private final String s3BackupMode;
    private final S3DestinationUpdate s3Update;
    private final SecretsManagerConfiguration secretsManagerConfiguration;

    private HttpEndpointDestinationUpdate(BuilderImpl builder) {
        this.endpointConfiguration = builder.endpointConfiguration;
        this.bufferingHints = builder.bufferingHints;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
        this.requestConfiguration = builder.requestConfiguration;
        this.processingConfiguration = builder.processingConfiguration;
        this.roleARN = builder.roleARN;
        this.retryOptions = builder.retryOptions;
        this.s3BackupMode = builder.s3BackupMode;
        this.s3Update = builder.s3Update;
        this.secretsManagerConfiguration = builder.secretsManagerConfiguration;
    }

    public final HttpEndpointConfiguration endpointConfiguration() {
        return this.endpointConfiguration;
    }

    public final HttpEndpointBufferingHints bufferingHints() {
        return this.bufferingHints;
    }

    public final CloudWatchLoggingOptions cloudWatchLoggingOptions() {
        return this.cloudWatchLoggingOptions;
    }

    public final HttpEndpointRequestConfiguration requestConfiguration() {
        return this.requestConfiguration;
    }

    public final ProcessingConfiguration processingConfiguration() {
        return this.processingConfiguration;
    }

    public final String roleARN() {
        return this.roleARN;
    }

    public final HttpEndpointRetryOptions retryOptions() {
        return this.retryOptions;
    }

    public final HttpEndpointS3BackupMode s3BackupMode() {
        return HttpEndpointS3BackupMode.fromValue(this.s3BackupMode);
    }

    public final String s3BackupModeAsString() {
        return this.s3BackupMode;
    }

    public final S3DestinationUpdate s3Update() {
        return this.s3Update;
    }

    public final SecretsManagerConfiguration secretsManagerConfiguration() {
        return this.secretsManagerConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.bufferingHints());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLoggingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BackupModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Update());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretsManagerConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpEndpointDestinationUpdate)) {
            return false;
        }
        HttpEndpointDestinationUpdate other = (HttpEndpointDestinationUpdate)obj;
        return Objects.equals(this.endpointConfiguration(), other.endpointConfiguration()) && Objects.equals(this.bufferingHints(), other.bufferingHints()) && Objects.equals(this.cloudWatchLoggingOptions(), other.cloudWatchLoggingOptions()) && Objects.equals(this.requestConfiguration(), other.requestConfiguration()) && Objects.equals(this.processingConfiguration(), other.processingConfiguration()) && Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.retryOptions(), other.retryOptions()) && Objects.equals(this.s3BackupModeAsString(), other.s3BackupModeAsString()) && Objects.equals(this.s3Update(), other.s3Update()) && Objects.equals(this.secretsManagerConfiguration(), other.secretsManagerConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"HttpEndpointDestinationUpdate").add("EndpointConfiguration", (Object)this.endpointConfiguration()).add("BufferingHints", (Object)this.bufferingHints()).add("CloudWatchLoggingOptions", (Object)this.cloudWatchLoggingOptions()).add("RequestConfiguration", (Object)this.requestConfiguration()).add("ProcessingConfiguration", (Object)this.processingConfiguration()).add("RoleARN", (Object)this.roleARN()).add("RetryOptions", (Object)this.retryOptions()).add("S3BackupMode", (Object)this.s3BackupModeAsString()).add("S3Update", (Object)this.s3Update()).add("SecretsManagerConfiguration", (Object)this.secretsManagerConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointConfiguration": {
                return Optional.ofNullable(clazz.cast(this.endpointConfiguration()));
            }
            case "BufferingHints": {
                return Optional.ofNullable(clazz.cast(this.bufferingHints()));
            }
            case "CloudWatchLoggingOptions": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLoggingOptions()));
            }
            case "RequestConfiguration": {
                return Optional.ofNullable(clazz.cast(this.requestConfiguration()));
            }
            case "ProcessingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.processingConfiguration()));
            }
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
            case "RetryOptions": {
                return Optional.ofNullable(clazz.cast(this.retryOptions()));
            }
            case "S3BackupMode": {
                return Optional.ofNullable(clazz.cast(this.s3BackupModeAsString()));
            }
            case "S3Update": {
                return Optional.ofNullable(clazz.cast(this.s3Update()));
            }
            case "SecretsManagerConfiguration": {
                return Optional.ofNullable(clazz.cast(this.secretsManagerConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EndpointConfiguration", ENDPOINT_CONFIGURATION_FIELD);
        map.put("BufferingHints", BUFFERING_HINTS_FIELD);
        map.put("CloudWatchLoggingOptions", CLOUD_WATCH_LOGGING_OPTIONS_FIELD);
        map.put("RequestConfiguration", REQUEST_CONFIGURATION_FIELD);
        map.put("ProcessingConfiguration", PROCESSING_CONFIGURATION_FIELD);
        map.put("RoleARN", ROLE_ARN_FIELD);
        map.put("RetryOptions", RETRY_OPTIONS_FIELD);
        map.put("S3BackupMode", S3_BACKUP_MODE_FIELD);
        map.put("S3Update", S3_UPDATE_FIELD);
        map.put("SecretsManagerConfiguration", SECRETS_MANAGER_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HttpEndpointDestinationUpdate, T> g) {
        return obj -> g.apply((HttpEndpointDestinationUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private HttpEndpointConfiguration endpointConfiguration;
        private HttpEndpointBufferingHints bufferingHints;
        private CloudWatchLoggingOptions cloudWatchLoggingOptions;
        private HttpEndpointRequestConfiguration requestConfiguration;
        private ProcessingConfiguration processingConfiguration;
        private String roleARN;
        private HttpEndpointRetryOptions retryOptions;
        private String s3BackupMode;
        private S3DestinationUpdate s3Update;
        private SecretsManagerConfiguration secretsManagerConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(HttpEndpointDestinationUpdate model) {
            this.endpointConfiguration(model.endpointConfiguration);
            this.bufferingHints(model.bufferingHints);
            this.cloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
            this.requestConfiguration(model.requestConfiguration);
            this.processingConfiguration(model.processingConfiguration);
            this.roleARN(model.roleARN);
            this.retryOptions(model.retryOptions);
            this.s3BackupMode(model.s3BackupMode);
            this.s3Update(model.s3Update);
            this.secretsManagerConfiguration(model.secretsManagerConfiguration);
        }

        public final HttpEndpointConfiguration.Builder getEndpointConfiguration() {
            return this.endpointConfiguration != null ? this.endpointConfiguration.toBuilder() : null;
        }

        public final void setEndpointConfiguration(HttpEndpointConfiguration.BuilderImpl endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration != null ? endpointConfiguration.build() : null;
        }

        @Override
        public final Builder endpointConfiguration(HttpEndpointConfiguration endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration;
            return this;
        }

        public final HttpEndpointBufferingHints.Builder getBufferingHints() {
            return this.bufferingHints != null ? this.bufferingHints.toBuilder() : null;
        }

        public final void setBufferingHints(HttpEndpointBufferingHints.BuilderImpl bufferingHints) {
            this.bufferingHints = bufferingHints != null ? bufferingHints.build() : null;
        }

        @Override
        public final Builder bufferingHints(HttpEndpointBufferingHints bufferingHints) {
            this.bufferingHints = bufferingHints;
            return this;
        }

        public final CloudWatchLoggingOptions.Builder getCloudWatchLoggingOptions() {
            return this.cloudWatchLoggingOptions != null ? this.cloudWatchLoggingOptions.toBuilder() : null;
        }

        public final void setCloudWatchLoggingOptions(CloudWatchLoggingOptions.BuilderImpl cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.build() : null;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
            return this;
        }

        public final HttpEndpointRequestConfiguration.Builder getRequestConfiguration() {
            return this.requestConfiguration != null ? this.requestConfiguration.toBuilder() : null;
        }

        public final void setRequestConfiguration(HttpEndpointRequestConfiguration.BuilderImpl requestConfiguration) {
            this.requestConfiguration = requestConfiguration != null ? requestConfiguration.build() : null;
        }

        @Override
        public final Builder requestConfiguration(HttpEndpointRequestConfiguration requestConfiguration) {
            this.requestConfiguration = requestConfiguration;
            return this;
        }

        public final ProcessingConfiguration.Builder getProcessingConfiguration() {
            return this.processingConfiguration != null ? this.processingConfiguration.toBuilder() : null;
        }

        public final void setProcessingConfiguration(ProcessingConfiguration.BuilderImpl processingConfiguration) {
            this.processingConfiguration = processingConfiguration != null ? processingConfiguration.build() : null;
        }

        @Override
        public final Builder processingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
            return this;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final HttpEndpointRetryOptions.Builder getRetryOptions() {
            return this.retryOptions != null ? this.retryOptions.toBuilder() : null;
        }

        public final void setRetryOptions(HttpEndpointRetryOptions.BuilderImpl retryOptions) {
            this.retryOptions = retryOptions != null ? retryOptions.build() : null;
        }

        @Override
        public final Builder retryOptions(HttpEndpointRetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public final String getS3BackupMode() {
            return this.s3BackupMode;
        }

        public final void setS3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
        }

        @Override
        public final Builder s3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
            return this;
        }

        @Override
        public final Builder s3BackupMode(HttpEndpointS3BackupMode s3BackupMode) {
            this.s3BackupMode(s3BackupMode == null ? null : s3BackupMode.toString());
            return this;
        }

        public final S3DestinationUpdate.Builder getS3Update() {
            return this.s3Update != null ? this.s3Update.toBuilder() : null;
        }

        public final void setS3Update(S3DestinationUpdate.BuilderImpl s3Update) {
            this.s3Update = s3Update != null ? s3Update.build() : null;
        }

        @Override
        public final Builder s3Update(S3DestinationUpdate s3Update) {
            this.s3Update = s3Update;
            return this;
        }

        public final SecretsManagerConfiguration.Builder getSecretsManagerConfiguration() {
            return this.secretsManagerConfiguration != null ? this.secretsManagerConfiguration.toBuilder() : null;
        }

        public final void setSecretsManagerConfiguration(SecretsManagerConfiguration.BuilderImpl secretsManagerConfiguration) {
            this.secretsManagerConfiguration = secretsManagerConfiguration != null ? secretsManagerConfiguration.build() : null;
        }

        @Override
        public final Builder secretsManagerConfiguration(SecretsManagerConfiguration secretsManagerConfiguration) {
            this.secretsManagerConfiguration = secretsManagerConfiguration;
            return this;
        }

        public HttpEndpointDestinationUpdate build() {
            return new HttpEndpointDestinationUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HttpEndpointDestinationUpdate> {
        public Builder endpointConfiguration(HttpEndpointConfiguration var1);

        default public Builder endpointConfiguration(Consumer<HttpEndpointConfiguration.Builder> endpointConfiguration) {
            return this.endpointConfiguration((HttpEndpointConfiguration)((HttpEndpointConfiguration.Builder)HttpEndpointConfiguration.builder().applyMutation(endpointConfiguration)).build());
        }

        public Builder bufferingHints(HttpEndpointBufferingHints var1);

        default public Builder bufferingHints(Consumer<HttpEndpointBufferingHints.Builder> bufferingHints) {
            return this.bufferingHints((HttpEndpointBufferingHints)((HttpEndpointBufferingHints.Builder)HttpEndpointBufferingHints.builder().applyMutation(bufferingHints)).build());
        }

        public Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions var1);

        default public Builder cloudWatchLoggingOptions(Consumer<CloudWatchLoggingOptions.Builder> cloudWatchLoggingOptions) {
            return this.cloudWatchLoggingOptions((CloudWatchLoggingOptions)((CloudWatchLoggingOptions.Builder)CloudWatchLoggingOptions.builder().applyMutation(cloudWatchLoggingOptions)).build());
        }

        public Builder requestConfiguration(HttpEndpointRequestConfiguration var1);

        default public Builder requestConfiguration(Consumer<HttpEndpointRequestConfiguration.Builder> requestConfiguration) {
            return this.requestConfiguration((HttpEndpointRequestConfiguration)((HttpEndpointRequestConfiguration.Builder)HttpEndpointRequestConfiguration.builder().applyMutation(requestConfiguration)).build());
        }

        public Builder processingConfiguration(ProcessingConfiguration var1);

        default public Builder processingConfiguration(Consumer<ProcessingConfiguration.Builder> processingConfiguration) {
            return this.processingConfiguration((ProcessingConfiguration)((ProcessingConfiguration.Builder)ProcessingConfiguration.builder().applyMutation(processingConfiguration)).build());
        }

        public Builder roleARN(String var1);

        public Builder retryOptions(HttpEndpointRetryOptions var1);

        default public Builder retryOptions(Consumer<HttpEndpointRetryOptions.Builder> retryOptions) {
            return this.retryOptions((HttpEndpointRetryOptions)((HttpEndpointRetryOptions.Builder)HttpEndpointRetryOptions.builder().applyMutation(retryOptions)).build());
        }

        public Builder s3BackupMode(String var1);

        public Builder s3BackupMode(HttpEndpointS3BackupMode var1);

        public Builder s3Update(S3DestinationUpdate var1);

        default public Builder s3Update(Consumer<S3DestinationUpdate.Builder> s3Update) {
            return this.s3Update((S3DestinationUpdate)((S3DestinationUpdate.Builder)S3DestinationUpdate.builder().applyMutation(s3Update)).build());
        }

        public Builder secretsManagerConfiguration(SecretsManagerConfiguration var1);

        default public Builder secretsManagerConfiguration(Consumer<SecretsManagerConfiguration.Builder> secretsManagerConfiguration) {
            return this.secretsManagerConfiguration((SecretsManagerConfiguration)((SecretsManagerConfiguration.Builder)SecretsManagerConfiguration.builder().applyMutation(secretsManagerConfiguration)).build());
        }
    }
}

