/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.firehose.model.AuthenticationConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MSKSourceDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MSKSourceDescription> {
    private static final SdkField<String> MSK_CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MSKClusterARN").getter(MSKSourceDescription.getter(MSKSourceDescription::mskClusterARN)).setter(MSKSourceDescription.setter(Builder::mskClusterARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MSKClusterARN").build()}).build();
    private static final SdkField<String> TOPIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TopicName").getter(MSKSourceDescription.getter(MSKSourceDescription::topicName)).setter(MSKSourceDescription.setter(Builder::topicName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicName").build()}).build();
    private static final SdkField<AuthenticationConfiguration> AUTHENTICATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AuthenticationConfiguration").getter(MSKSourceDescription.getter(MSKSourceDescription::authenticationConfiguration)).setter(MSKSourceDescription.setter(Builder::authenticationConfiguration)).constructor(AuthenticationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationConfiguration").build()}).build();
    private static final SdkField<Instant> DELIVERY_START_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DeliveryStartTimestamp").getter(MSKSourceDescription.getter(MSKSourceDescription::deliveryStartTimestamp)).setter(MSKSourceDescription.setter(Builder::deliveryStartTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryStartTimestamp").build()}).build();
    private static final SdkField<Instant> READ_FROM_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ReadFromTimestamp").getter(MSKSourceDescription.getter(MSKSourceDescription::readFromTimestamp)).setter(MSKSourceDescription.setter(Builder::readFromTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadFromTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MSK_CLUSTER_ARN_FIELD, TOPIC_NAME_FIELD, AUTHENTICATION_CONFIGURATION_FIELD, DELIVERY_START_TIMESTAMP_FIELD, READ_FROM_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("MSKClusterARN", MSK_CLUSTER_ARN_FIELD);
            this.put("TopicName", TOPIC_NAME_FIELD);
            this.put("AuthenticationConfiguration", AUTHENTICATION_CONFIGURATION_FIELD);
            this.put("DeliveryStartTimestamp", DELIVERY_START_TIMESTAMP_FIELD);
            this.put("ReadFromTimestamp", READ_FROM_TIMESTAMP_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String mskClusterARN;
    private final String topicName;
    private final AuthenticationConfiguration authenticationConfiguration;
    private final Instant deliveryStartTimestamp;
    private final Instant readFromTimestamp;

    private MSKSourceDescription(BuilderImpl builder) {
        this.mskClusterARN = builder.mskClusterARN;
        this.topicName = builder.topicName;
        this.authenticationConfiguration = builder.authenticationConfiguration;
        this.deliveryStartTimestamp = builder.deliveryStartTimestamp;
        this.readFromTimestamp = builder.readFromTimestamp;
    }

    public final String mskClusterARN() {
        return this.mskClusterARN;
    }

    public final String topicName() {
        return this.topicName;
    }

    public final AuthenticationConfiguration authenticationConfiguration() {
        return this.authenticationConfiguration;
    }

    public final Instant deliveryStartTimestamp() {
        return this.deliveryStartTimestamp;
    }

    public final Instant readFromTimestamp() {
        return this.readFromTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mskClusterARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.topicName());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryStartTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.readFromTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MSKSourceDescription)) {
            return false;
        }
        MSKSourceDescription other = (MSKSourceDescription)obj;
        return Objects.equals(this.mskClusterARN(), other.mskClusterARN()) && Objects.equals(this.topicName(), other.topicName()) && Objects.equals(this.authenticationConfiguration(), other.authenticationConfiguration()) && Objects.equals(this.deliveryStartTimestamp(), other.deliveryStartTimestamp()) && Objects.equals(this.readFromTimestamp(), other.readFromTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"MSKSourceDescription").add("MSKClusterARN", (Object)this.mskClusterARN()).add("TopicName", (Object)this.topicName()).add("AuthenticationConfiguration", (Object)this.authenticationConfiguration()).add("DeliveryStartTimestamp", (Object)this.deliveryStartTimestamp()).add("ReadFromTimestamp", (Object)this.readFromTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MSKClusterARN": {
                return Optional.ofNullable(clazz.cast(this.mskClusterARN()));
            }
            case "TopicName": {
                return Optional.ofNullable(clazz.cast(this.topicName()));
            }
            case "AuthenticationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.authenticationConfiguration()));
            }
            case "DeliveryStartTimestamp": {
                return Optional.ofNullable(clazz.cast(this.deliveryStartTimestamp()));
            }
            case "ReadFromTimestamp": {
                return Optional.ofNullable(clazz.cast(this.readFromTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MSKSourceDescription, T> g) {
        return obj -> g.apply((MSKSourceDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mskClusterARN;
        private String topicName;
        private AuthenticationConfiguration authenticationConfiguration;
        private Instant deliveryStartTimestamp;
        private Instant readFromTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(MSKSourceDescription model) {
            this.mskClusterARN(model.mskClusterARN);
            this.topicName(model.topicName);
            this.authenticationConfiguration(model.authenticationConfiguration);
            this.deliveryStartTimestamp(model.deliveryStartTimestamp);
            this.readFromTimestamp(model.readFromTimestamp);
        }

        public final String getMskClusterARN() {
            return this.mskClusterARN;
        }

        public final void setMskClusterARN(String mskClusterARN) {
            this.mskClusterARN = mskClusterARN;
        }

        @Override
        public final Builder mskClusterARN(String mskClusterARN) {
            this.mskClusterARN = mskClusterARN;
            return this;
        }

        public final String getTopicName() {
            return this.topicName;
        }

        public final void setTopicName(String topicName) {
            this.topicName = topicName;
        }

        @Override
        public final Builder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public final AuthenticationConfiguration.Builder getAuthenticationConfiguration() {
            return this.authenticationConfiguration != null ? this.authenticationConfiguration.toBuilder() : null;
        }

        public final void setAuthenticationConfiguration(AuthenticationConfiguration.BuilderImpl authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration != null ? authenticationConfiguration.build() : null;
        }

        @Override
        public final Builder authenticationConfiguration(AuthenticationConfiguration authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration;
            return this;
        }

        public final Instant getDeliveryStartTimestamp() {
            return this.deliveryStartTimestamp;
        }

        public final void setDeliveryStartTimestamp(Instant deliveryStartTimestamp) {
            this.deliveryStartTimestamp = deliveryStartTimestamp;
        }

        @Override
        public final Builder deliveryStartTimestamp(Instant deliveryStartTimestamp) {
            this.deliveryStartTimestamp = deliveryStartTimestamp;
            return this;
        }

        public final Instant getReadFromTimestamp() {
            return this.readFromTimestamp;
        }

        public final void setReadFromTimestamp(Instant readFromTimestamp) {
            this.readFromTimestamp = readFromTimestamp;
        }

        @Override
        public final Builder readFromTimestamp(Instant readFromTimestamp) {
            this.readFromTimestamp = readFromTimestamp;
            return this;
        }

        public MSKSourceDescription build() {
            return new MSKSourceDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MSKSourceDescription> {
        public Builder mskClusterARN(String var1);

        public Builder topicName(String var1);

        public Builder authenticationConfiguration(AuthenticationConfiguration var1);

        default public Builder authenticationConfiguration(Consumer<AuthenticationConfiguration.Builder> authenticationConfiguration) {
            return this.authenticationConfiguration((AuthenticationConfiguration)((AuthenticationConfiguration.Builder)AuthenticationConfiguration.builder().applyMutation(authenticationConfiguration)).build());
        }

        public Builder deliveryStartTimestamp(Instant var1);

        public Builder readFromTimestamp(Instant var1);
    }
}

