/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.firehose.model.KMSEncryptionConfig;
import software.amazon.awssdk.services.firehose.model.NoEncryptionConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EncryptionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EncryptionConfiguration> {
    private static final SdkField<String> NO_ENCRYPTION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EncryptionConfiguration.getter(EncryptionConfiguration::noEncryptionConfigAsString)).setter(EncryptionConfiguration.setter(Builder::noEncryptionConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoEncryptionConfig").build()}).build();
    private static final SdkField<KMSEncryptionConfig> KMS_ENCRYPTION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(EncryptionConfiguration.getter(EncryptionConfiguration::kmsEncryptionConfig)).setter(EncryptionConfiguration.setter(Builder::kmsEncryptionConfig)).constructor(KMSEncryptionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSEncryptionConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NO_ENCRYPTION_CONFIG_FIELD, KMS_ENCRYPTION_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String noEncryptionConfig;
    private final KMSEncryptionConfig kmsEncryptionConfig;

    private EncryptionConfiguration(BuilderImpl builder) {
        this.noEncryptionConfig = builder.noEncryptionConfig;
        this.kmsEncryptionConfig = builder.kmsEncryptionConfig;
    }

    public NoEncryptionConfig noEncryptionConfig() {
        return NoEncryptionConfig.fromValue(this.noEncryptionConfig);
    }

    public String noEncryptionConfigAsString() {
        return this.noEncryptionConfig;
    }

    public KMSEncryptionConfig kmsEncryptionConfig() {
        return this.kmsEncryptionConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.noEncryptionConfigAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsEncryptionConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionConfiguration)) {
            return false;
        }
        EncryptionConfiguration other = (EncryptionConfiguration)obj;
        return Objects.equals(this.noEncryptionConfigAsString(), other.noEncryptionConfigAsString()) && Objects.equals(this.kmsEncryptionConfig(), other.kmsEncryptionConfig());
    }

    public String toString() {
        return ToString.builder((String)"EncryptionConfiguration").add("NoEncryptionConfig", (Object)this.noEncryptionConfigAsString()).add("KMSEncryptionConfig", (Object)this.kmsEncryptionConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NoEncryptionConfig": {
                return Optional.ofNullable(clazz.cast(this.noEncryptionConfigAsString()));
            }
            case "KMSEncryptionConfig": {
                return Optional.ofNullable(clazz.cast(this.kmsEncryptionConfig()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EncryptionConfiguration, T> g) {
        return obj -> g.apply((EncryptionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String noEncryptionConfig;
        private KMSEncryptionConfig kmsEncryptionConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionConfiguration model) {
            this.noEncryptionConfig(model.noEncryptionConfig);
            this.kmsEncryptionConfig(model.kmsEncryptionConfig);
        }

        public final String getNoEncryptionConfig() {
            return this.noEncryptionConfig;
        }

        @Override
        public final Builder noEncryptionConfig(String noEncryptionConfig) {
            this.noEncryptionConfig = noEncryptionConfig;
            return this;
        }

        @Override
        public final Builder noEncryptionConfig(NoEncryptionConfig noEncryptionConfig) {
            this.noEncryptionConfig(noEncryptionConfig.toString());
            return this;
        }

        public final void setNoEncryptionConfig(String noEncryptionConfig) {
            this.noEncryptionConfig = noEncryptionConfig;
        }

        public final KMSEncryptionConfig.Builder getKMSEncryptionConfig() {
            return this.kmsEncryptionConfig != null ? this.kmsEncryptionConfig.toBuilder() : null;
        }

        @Override
        public final Builder kmsEncryptionConfig(KMSEncryptionConfig kmsEncryptionConfig) {
            this.kmsEncryptionConfig = kmsEncryptionConfig;
            return this;
        }

        public final void setKMSEncryptionConfig(KMSEncryptionConfig.BuilderImpl kmsEncryptionConfig) {
            this.kmsEncryptionConfig = kmsEncryptionConfig != null ? kmsEncryptionConfig.build() : null;
        }

        public EncryptionConfiguration build() {
            return new EncryptionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EncryptionConfiguration> {
        public Builder noEncryptionConfig(String var1);

        public Builder noEncryptionConfig(NoEncryptionConfig var1);

        public Builder kmsEncryptionConfig(KMSEncryptionConfig var1);

        default public Builder kmsEncryptionConfig(Consumer<KMSEncryptionConfig.Builder> kmsEncryptionConfig) {
            return this.kmsEncryptionConfig((KMSEncryptionConfig)((KMSEncryptionConfig.Builder)KMSEncryptionConfig.builder().applyMutation(kmsEncryptionConfig)).build());
        }
    }
}

