/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.firehose.model.RetryOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DynamicPartitioningConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DynamicPartitioningConfiguration> {
    private static final SdkField<RetryOptions> RETRY_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RetryOptions").getter(DynamicPartitioningConfiguration.getter(DynamicPartitioningConfiguration::retryOptions)).setter(DynamicPartitioningConfiguration.setter(Builder::retryOptions)).constructor(RetryOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryOptions").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(DynamicPartitioningConfiguration.getter(DynamicPartitioningConfiguration::enabled)).setter(DynamicPartitioningConfiguration.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETRY_OPTIONS_FIELD, ENABLED_FIELD));
    private static final long serialVersionUID = 1L;
    private final RetryOptions retryOptions;
    private final Boolean enabled;

    private DynamicPartitioningConfiguration(BuilderImpl builder) {
        this.retryOptions = builder.retryOptions;
        this.enabled = builder.enabled;
    }

    public final RetryOptions retryOptions() {
        return this.retryOptions;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.retryOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DynamicPartitioningConfiguration)) {
            return false;
        }
        DynamicPartitioningConfiguration other = (DynamicPartitioningConfiguration)obj;
        return Objects.equals(this.retryOptions(), other.retryOptions()) && Objects.equals(this.enabled(), other.enabled());
    }

    public final String toString() {
        return ToString.builder((String)"DynamicPartitioningConfiguration").add("RetryOptions", (Object)this.retryOptions()).add("Enabled", (Object)this.enabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RetryOptions": {
                return Optional.ofNullable(clazz.cast(this.retryOptions()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DynamicPartitioningConfiguration, T> g) {
        return obj -> g.apply((DynamicPartitioningConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private RetryOptions retryOptions;
        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(DynamicPartitioningConfiguration model) {
            this.retryOptions(model.retryOptions);
            this.enabled(model.enabled);
        }

        public final RetryOptions.Builder getRetryOptions() {
            return this.retryOptions != null ? this.retryOptions.toBuilder() : null;
        }

        public final void setRetryOptions(RetryOptions.BuilderImpl retryOptions) {
            this.retryOptions = retryOptions != null ? retryOptions.build() : null;
        }

        @Override
        public final Builder retryOptions(RetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public DynamicPartitioningConfiguration build() {
            return new DynamicPartitioningConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DynamicPartitioningConfiguration> {
        public Builder retryOptions(RetryOptions var1);

        default public Builder retryOptions(Consumer<RetryOptions.Builder> retryOptions) {
            return this.retryOptions((RetryOptions)((RetryOptions.Builder)RetryOptions.builder().applyMutation(retryOptions)).build());
        }

        public Builder enabled(Boolean var1);
    }
}

