/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.firehose.model.DeliveryStreamEncryptionConfigurationInput;
import software.amazon.awssdk.services.firehose.model.FirehoseRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartDeliveryStreamEncryptionRequest
extends FirehoseRequest
implements ToCopyableBuilder<Builder, StartDeliveryStreamEncryptionRequest> {
    private static final SdkField<String> DELIVERY_STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartDeliveryStreamEncryptionRequest.getter(StartDeliveryStreamEncryptionRequest::deliveryStreamName)).setter(StartDeliveryStreamEncryptionRequest.setter(Builder::deliveryStreamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryStreamName").build()}).build();
    private static final SdkField<DeliveryStreamEncryptionConfigurationInput> DELIVERY_STREAM_ENCRYPTION_CONFIGURATION_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(StartDeliveryStreamEncryptionRequest.getter(StartDeliveryStreamEncryptionRequest::deliveryStreamEncryptionConfigurationInput)).setter(StartDeliveryStreamEncryptionRequest.setter(Builder::deliveryStreamEncryptionConfigurationInput)).constructor(DeliveryStreamEncryptionConfigurationInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryStreamEncryptionConfigurationInput").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_STREAM_NAME_FIELD, DELIVERY_STREAM_ENCRYPTION_CONFIGURATION_INPUT_FIELD));
    private final String deliveryStreamName;
    private final DeliveryStreamEncryptionConfigurationInput deliveryStreamEncryptionConfigurationInput;

    private StartDeliveryStreamEncryptionRequest(BuilderImpl builder) {
        super(builder);
        this.deliveryStreamName = builder.deliveryStreamName;
        this.deliveryStreamEncryptionConfigurationInput = builder.deliveryStreamEncryptionConfigurationInput;
    }

    public String deliveryStreamName() {
        return this.deliveryStreamName;
    }

    public DeliveryStreamEncryptionConfigurationInput deliveryStreamEncryptionConfigurationInput() {
        return this.deliveryStreamEncryptionConfigurationInput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryStreamEncryptionConfigurationInput());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDeliveryStreamEncryptionRequest)) {
            return false;
        }
        StartDeliveryStreamEncryptionRequest other = (StartDeliveryStreamEncryptionRequest)((Object)obj);
        return Objects.equals(this.deliveryStreamName(), other.deliveryStreamName()) && Objects.equals(this.deliveryStreamEncryptionConfigurationInput(), other.deliveryStreamEncryptionConfigurationInput());
    }

    public String toString() {
        return ToString.builder((String)"StartDeliveryStreamEncryptionRequest").add("DeliveryStreamName", (Object)this.deliveryStreamName()).add("DeliveryStreamEncryptionConfigurationInput", (Object)this.deliveryStreamEncryptionConfigurationInput()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeliveryStreamName": {
                return Optional.ofNullable(clazz.cast(this.deliveryStreamName()));
            }
            case "DeliveryStreamEncryptionConfigurationInput": {
                return Optional.ofNullable(clazz.cast(this.deliveryStreamEncryptionConfigurationInput()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartDeliveryStreamEncryptionRequest, T> g) {
        return obj -> g.apply((StartDeliveryStreamEncryptionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FirehoseRequest.BuilderImpl
    implements Builder {
        private String deliveryStreamName;
        private DeliveryStreamEncryptionConfigurationInput deliveryStreamEncryptionConfigurationInput;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDeliveryStreamEncryptionRequest model) {
            super(model);
            this.deliveryStreamName(model.deliveryStreamName);
            this.deliveryStreamEncryptionConfigurationInput(model.deliveryStreamEncryptionConfigurationInput);
        }

        public final String getDeliveryStreamName() {
            return this.deliveryStreamName;
        }

        @Override
        public final Builder deliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
            return this;
        }

        public final void setDeliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
        }

        public final DeliveryStreamEncryptionConfigurationInput.Builder getDeliveryStreamEncryptionConfigurationInput() {
            return this.deliveryStreamEncryptionConfigurationInput != null ? this.deliveryStreamEncryptionConfigurationInput.toBuilder() : null;
        }

        @Override
        public final Builder deliveryStreamEncryptionConfigurationInput(DeliveryStreamEncryptionConfigurationInput deliveryStreamEncryptionConfigurationInput) {
            this.deliveryStreamEncryptionConfigurationInput = deliveryStreamEncryptionConfigurationInput;
            return this;
        }

        public final void setDeliveryStreamEncryptionConfigurationInput(DeliveryStreamEncryptionConfigurationInput.BuilderImpl deliveryStreamEncryptionConfigurationInput) {
            this.deliveryStreamEncryptionConfigurationInput = deliveryStreamEncryptionConfigurationInput != null ? deliveryStreamEncryptionConfigurationInput.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartDeliveryStreamEncryptionRequest build() {
            return new StartDeliveryStreamEncryptionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FirehoseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartDeliveryStreamEncryptionRequest> {
        public Builder deliveryStreamName(String var1);

        public Builder deliveryStreamEncryptionConfigurationInput(DeliveryStreamEncryptionConfigurationInput var1);

        default public Builder deliveryStreamEncryptionConfigurationInput(Consumer<DeliveryStreamEncryptionConfigurationInput.Builder> deliveryStreamEncryptionConfigurationInput) {
            return this.deliveryStreamEncryptionConfigurationInput((DeliveryStreamEncryptionConfigurationInput)((DeliveryStreamEncryptionConfigurationInput.Builder)DeliveryStreamEncryptionConfigurationInput.builder().applyMutation(deliveryStreamEncryptionConfigurationInput)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

