/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.firehose.model.OrcSerDe;

public class OrcSerDeUnmarshaller
implements Unmarshaller<OrcSerDe, JsonUnmarshallerContext> {
    private static final OrcSerDeUnmarshaller INSTANCE = new OrcSerDeUnmarshaller();

    public OrcSerDe unmarshall(JsonUnmarshallerContext context) throws Exception {
        OrcSerDe.Builder orcSerDeBuilder = OrcSerDe.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("StripeSizeBytes", targetDepth)) {
                    context.nextToken();
                    orcSerDeBuilder.stripeSizeBytes((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("BlockSizeBytes", targetDepth)) {
                    context.nextToken();
                    orcSerDeBuilder.blockSizeBytes((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("RowIndexStride", targetDepth)) {
                    context.nextToken();
                    orcSerDeBuilder.rowIndexStride((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("EnablePadding", targetDepth)) {
                    context.nextToken();
                    orcSerDeBuilder.enablePadding((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("PaddingTolerance", targetDepth)) {
                    context.nextToken();
                    orcSerDeBuilder.paddingTolerance((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
                if (context.testExpression("Compression", targetDepth)) {
                    context.nextToken();
                    orcSerDeBuilder.compression((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("BloomFilterColumns", targetDepth)) {
                    context.nextToken();
                    orcSerDeBuilder.bloomFilterColumns(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("BloomFilterFalsePositiveProbability", targetDepth)) {
                    context.nextToken();
                    orcSerDeBuilder.bloomFilterFalsePositiveProbability((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
                if (context.testExpression("DictionaryKeyThreshold", targetDepth)) {
                    context.nextToken();
                    orcSerDeBuilder.dictionaryKeyThreshold((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
                if (context.testExpression("FormatVersion", targetDepth)) {
                    context.nextToken();
                    orcSerDeBuilder.formatVersion((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (OrcSerDe)orcSerDeBuilder.build();
    }

    public static OrcSerDeUnmarshaller getInstance() {
        return INSTANCE;
    }
}

