/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.firehose.model.HiveJsonSerDe;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class HiveJsonSerDeMarshaller {
    private static final MarshallingInfo<List> TIMESTAMPFORMATS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimestampFormats").isBinary(false).build();
    private static final HiveJsonSerDeMarshaller INSTANCE = new HiveJsonSerDeMarshaller();

    private HiveJsonSerDeMarshaller() {
    }

    public static HiveJsonSerDeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(HiveJsonSerDe hiveJsonSerDe, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)hiveJsonSerDe, (String)"hiveJsonSerDe");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(hiveJsonSerDe.timestampFormats(), TIMESTAMPFORMATS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

